/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import junit.framework.Assert;
import kafka.log.FileMessageSet;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.TestUtils$;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public abstract class BaseMessageSetTestCases$class {
    @Test
    public static void testWrittenEqualsRead(BaseMessageSetTestCases $this) {
        MessageSet messageSet = $this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages()));
        TestUtils$.MODULE$.checkEquals(Predef$.MODULE$.refArrayOps((Object[])$this.messages()).iterator(), ((IterableLike)messageSet.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).iterator());
    }

    @Test
    public static void testIteratorIsConsistent(BaseMessageSetTestCases $this) {
        MessageSet m = $this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages()));
        TestUtils$.MODULE$.checkEquals(m.iterator(), m.iterator());
    }

    @Test
    public static void testSizeInBytes(BaseMessageSetTestCases $this) {
        Assert.assertEquals((String)"Empty message set should have 0 bytes.", (int)0, (int)$this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))).sizeInBytes());
        Assert.assertEquals((String)"Predicted size should equal actual size.", (int)MessageSet$.MODULE$.messageSetSize((Iterable)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())), (int)$this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())).sizeInBytes());
    }

    @Test
    public static void testWriteTo(BaseMessageSetTestCases $this) {
        $this.testWriteToWithMessageSet($this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))));
        $this.testWriteToWithMessageSet($this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())));
    }

    public static void testWriteToWithMessageSet(BaseMessageSetTestCases $this, MessageSet set) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})).foreach((Function1)new Serializable($this, set){
            public static final long serialVersionUID = 0L;
            private final MessageSet set$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                File file = TestUtils$.MODULE$.tempFile();
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                int written = this.set$1.writeTo((GatheringByteChannel)channel, 0L, 1024);
                Assert.assertEquals((String)"Expect to write the number of bytes in the set.", (int)this.set$1.sizeInBytes(), (int)written);
                FileMessageSet newSet = new FileMessageSet(file, channel);
                TestUtils$.MODULE$.checkEquals(this.set$1.iterator(), newSet.iterator());
            }
            {
                this.set$1 = set$1;
            }
        });
    }

    public static void $init$(BaseMessageSetTestCases $this) {
        $this.kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq((Message[])((Object[])new Message[]{new Message("abcd".getBytes()), new Message("efgh".getBytes()), new Message("ijkl".getBytes())}));
    }
}

