/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u000f\ty1*\u00194lC\u000e{gNZ5h)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005-QUK\\5ugM+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012!\t;fgRdun\u001a*fi\u0016tG/[8o)&lW\rS8veN\u0004&o\u001c<jI\u0016$G#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003/\u0005\u0002\"A\t\u0013\u000e\u0003\rR!a\u0003\b\n\u0005\u0015\u001a#\u0001\u0002+fgRDQa\n\u0001\u0005\u0002e\t1\u0005^3ti2{wMU3uK:$\u0018n\u001c8US6,W*\u001b8vi\u0016\u001c\bK]8wS\u0012,G\r\u000b\u0002'C!)!\u0006\u0001C\u00013\u0005qB/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016l5\u000f\u0015:pm&$W\r\u001a\u0015\u0003S\u0005BQ!\f\u0001\u0005\u0002e\tA\u0005^3ti2{wMU3uK:$\u0018n\u001c8US6,gj\\\"p]\u001aLw\r\u0015:pm&$W\r\u001a\u0015\u0003Y\u0005BQ\u0001\r\u0001\u0005\u0002e\tq\u0006^3ti2{wMU3uK:$\u0018n\u001c8US6,'i\u001c;i\u001b&tW\u000f^3t\u0003:$\u0007j\\;sgB\u0013xN^5eK\u0012D#aL\u0011\t\u000bM\u0002A\u0011A\r\u0002YQ,7\u000f\u001e'pOJ+G/\u001a8uS>tG+[7f\u0005>$\b.T5okR,7/\u00118e\u001bN\u0004&o\u001c<jI\u0016$\u0007F\u0001\u001a\"\u0011\u00151\u0004\u0001\"\u0001\u001a\u0003U!Xm\u001d;BIZ,'\u000f^5tK\u0012+g-Y;miND#!N\u0011\t\u000be\u0002A\u0011A\r\u0002/Q,7\u000f^!em\u0016\u0014H/[:f\u0007>tg-[4ve\u0016$\u0007F\u0001\u001d\"\u0011\u0015a\u0004\u0001\"\u0001\u001a\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8EK\u001a\fW\u000f\u001c;)\u0005m\n\u0003\"B \u0001\t\u0003I\u0012a\u0007;fgR,fn\u00197fC:,E.Z2uS>tG)[:bE2,G\r\u000b\u0002?C!)!\t\u0001C\u00013\u0005QB/Z:u+:\u001cG.Z1o\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\u0012\u0011)\t\u0005\u0006\u000b\u0002!\t!G\u0001\u001bi\u0016\u001cH/\u00168dY\u0016\fg.\u00127fGRLwN\\%om\u0006d\u0017\u000e\u001a\u0015\u0003\t\u0006BQ\u0001\u0013\u0001\u0005\u0002e\t\u0011\u0004^3ti2{wMU8mYRKW.Z't!J|g/\u001b3fI\"\u0012q)\t\u0005\u0006\u0017\u0002!\t!G\u0001&i\u0016\u001cH\u000fT8h%>dG\u000eV5nK\n{G\u000f['t\u0003:$\u0007j\\;sgB\u0013xN^5eK\u0012D#AS\u0011\t\u000b9\u0003A\u0011A\r\u0002?Q,7\u000f\u001e'pOJ{G\u000e\u001c+j[\u0016tunQ8oM&<\u0007K]8wS\u0012,G\r\u000b\u0002NC\u0001")
public class KafkaConfigTest
extends JUnit3Suite {
    @Test
    public void testLogRetentionTimeHoursProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.retention.hours", "1");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)3600000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMinutesProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.retention.minutes", "30");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMsProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.retention.ms", "1800000");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeNoConfigProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndHoursProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.retention.minutes", "30");
        props.put("log.retention.hours", "1");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndMsProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.retention.ms", "1800000");
        props.put("log.retention.minutes", "10");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testAdvertiseDefaults() {
        int port = 9999;
        String hostName = "fake-host";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, port, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("host.name", hostName);
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((String)serverConfig.advertisedHostName(), (String)hostName);
        Assert.assertEquals((int)serverConfig.advertisedPort(), (int)port);
    }

    @Test
    public void testAdvertiseConfigured() {
        int port = 9999;
        String advertisedHostName = "routable-host";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, port, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("advertised.host.name", advertisedHostName);
        props.put("advertised.port", ((Object)BoxesRunTime.boxToInteger((int)advertisedPort)).toString());
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((String)serverConfig.advertisedHostName(), (String)advertisedHostName);
        Assert.assertEquals((int)serverConfig.advertisedPort(), (int)advertisedPort);
    }

    @Test
    public void testUncleanLeaderElectionDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((boolean)serverConfig.uncleanLeaderElectionEnable(), (boolean)true);
    }

    @Test
    public void testUncleanElectionDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("unclean.leader.election.enable", String.valueOf(false));
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((boolean)serverConfig.uncleanLeaderElectionEnable(), (boolean)false);
    }

    @Test
    public void testUncleanElectionEnabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("unclean.leader.election.enable", String.valueOf(true));
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((boolean)serverConfig.uncleanLeaderElectionEnable(), (boolean)true);
    }

    @Test
    public void testUncleanElectionInvalid() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final KafkaConfig apply() {
                return new KafkaConfig(this.props$1);
            }
            {
                this.props$1 = props$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testLogRollTimeMsProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.roll.ms", "1800000");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeBothMsAndHoursProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.roll.ms", "1800000");
        props.put("log.roll.hours", "1");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeNoConfigProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181, TestUtils$.MODULE$.createBrokerConfig$default$3());
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRollTimeMillis());
    }
}

