/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminTest$;
import kafka.admin.AdminUtils$;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentStatus;
import kafka.api.PartitionStateInfo;
import kafka.api.RequestKeys$;
import kafka.common.InvalidTopicException;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.controller.KafkaController;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.metrics.Quota;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\"\u00113nS:$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\n\u0019!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u0015!\u0003\u0001\"\u0001&\u0003U!Xm\u001d;SKBd\u0017nY1BgNLwM\\7f]R$\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005+:LG\u000f\u000b\u0002$[A\u0011a\u0006M\u0007\u0002_)\u00111BD\u0005\u0003c=\u0012A\u0001V3ti\")1\u0007\u0001C\u0001K\u0005YB/Z:u\u001b\u0006tW/\u00197SKBd\u0017nY1BgNLwM\\7f]RD#AM\u0017\t\u000bY\u0002A\u0011A\u0013\u0002+Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00138[\u0017\"\u0012Q'\f\u0005\u0006s\u0001!\t!J\u0001\u001fi\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0007>dG.[:j_:D#\u0001O\u0017\t\u000bq\u0002A\u0011B\u001f\u00025\u001d,GO\u0011:pW\u0016\u00148oV5uQB\u000b'\u000f^5uS>tG)\u001b:\u0015\tyBE,\u0019\t\u0004\u007f\t+eBA\u0014A\u0013\t\t\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u00131aU3u\u0015\t\t\u0005\u0006\u0005\u0002(\r&\u0011q\t\u000b\u0002\u0004\u0013:$\b\"B%<\u0001\u0004Q\u0015aB:feZ,'o\u001d\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tye!\u0001\u0004=e>|GOP\u0005\u0002S%\u0011!\u000bK\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0011\u0006\u0006\u0005\u0002X56\t\u0001L\u0003\u0002Z\t\u000511/\u001a:wKJL!a\u0017-\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\u0006;n\u0002\rAX\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u007f}K!\u0001\u0019#\u0003\rM#(/\u001b8h\u0011\u0015\u00117\b1\u0001F\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000b\u0011\u0004A\u0011A\u0013\u0002aQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^,ji\"dU-\u00193fe&sg*Z<SKBd\u0017nY1tQ\t\u0019W\u0006C\u0003h\u0001\u0011\u0005Q%A\u001auKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$x+\u001b;i\u0019\u0016\fG-\u001a:O_RLeNT3x%\u0016\u0004H.[2bg\"\u0012a-\f\u0005\u0006U\u0002!\t!J\u00010i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGOT8o\u001fZ,'\u000f\\1qa&twMU3qY&\u001c\u0017m\u001d\u0015\u0003S6BQ!\u001c\u0001\u0005\u0002\u0015\n1\u0005^3tiJ+\u0017m]:jO:Lgn\u001a(p]\u0016C\u0018n\u001d;j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002m[!)\u0001\u000f\u0001C\u0001K\u0005yC/Z:u%\u0016\u001cX/\\3QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;UQ\u0006$x+Y:D_6\u0004H.\u001a;fI\"\u0012q.\f\u0005\u0006g\u0002!\t!J\u0001\u001di\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1Kg>tG)\u0019;bQ\t\u0011X\u0006C\u0003w\u0001\u0011\u0005Q%A\u0011uKN$()Y:jGB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fW\t\\3di&|g\u000e\u000b\u0002v[!)\u0011\u0010\u0001C\u0001K\u0005\u0011B/Z:u'\",H\u000fZ8x]\n\u0013xn[3sQ\tAX\u0006C\u0003}\u0001\u0011\u0005Q%A\u000buKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3)\u0005ml\u0003\"B@\u0001\t\u0003)\u0013a\u0007;fgR\u0014un\u001c;tiJ\f\u0007o\u00117jK:$\u0018\nZ\"p]\u001aLw\r\u000b\u0002\u007f[\u0001")
public class AdminTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminTest adminTest = this;
        synchronized (adminTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void testReplicaAssignment() {
        List brokerList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        this.intercept((Function0)new Serializable(this, brokerList){
            public static final long serialVersionUID = 0L;
            private final List brokerList$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerList$1, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerList$1 = brokerList$1;
            }
        }, ManifestFactory$.MODULE$.classType(AdminOperationException.class));
        this.intercept((Function0)new Serializable(this, brokerList){
            public static final long serialVersionUID = 0L;
            private final List brokerList$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerList$1, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerList$1 = brokerList$1;
            }
        }, ManifestFactory$.MODULE$.classType(AdminOperationException.class));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerList, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        List list = expectedAssignment.toList();
        List list2 = actualAssignment.toList();
        boolean e = !(list != null ? !list.equals(list2) : list2 != null);
        List list3 = expectedAssignment.toList();
        List list4 = actualAssignment.toList();
        Assert.assertTrue((!(list3 != null ? !list3.equals(list4) : list4 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkUtils(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$1;

            public final Tuple2<Object, Seq<Object>> apply(int p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p)), (Object)this.$outer.zkUtils().getReplicasForPartition(this.topic$1, p));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((int)expectedReplicaAssignment.size(), (int)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)new Serializable(this, expectedReplicaAssignment, actualReplicaList){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicaAssignment$1;
            private final scala.collection.immutable.Map actualReplicaList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)this.expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)this.actualReplicaList$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.actualReplicaList$1 = actualReplicaList$1;
            }
        });
        this.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Map expectedReplicaAssignment$1;
            private final String topic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), this.topic$1, this.expectedReplicaAssignment$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
            }
        }, ManifestFactory$.MODULE$.classType(TopicExistsException.class));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5());
        this.intercept((Function0)new Serializable(this, collidingTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String collidingTopic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createTopic(this.$outer.zkUtils(), this.collidingTopic$1, 3, 1, AdminUtils$.MODULE$.createTopic$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.collidingTopic$1 = collidingTopic$1;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidTopicException.class));
    }

    public scala.collection.immutable.Set<Object> kafka$admin$AdminTest$$getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1)new Serializable(this, topic, partitionId){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final int partitionId$1;

            public final boolean apply(KafkaServer server) {
                return new File((String)server.config().logDirs().head(), new StringBuilder().append((Object)this.topic$2).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1)).toString()).exists();
            }
            {
                this.topic$2 = topic$2;
                this.partitionId$1 = partitionId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$1) {
                return x$1.config().brokerId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$1;
            private final TopicAndPartition topicAndPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$2) {
                        return x$2.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$1, this.newReplicas$1, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$1), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$1 = newReplicas$1;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$3;
            private final Seq servers$1;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$1, this.topic$3, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$1.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.servers$1 = servers$1;
                this.newReplicas$1 = newReplicas$1;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$2;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                        return x$4.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$2, this.newReplicas$2, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$2), (Object)this.newReplicas$2)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$2 = newReplicas$2;
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$4;
            private final Seq servers$2;
            private final Seq newReplicas$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$2, this.topic$4, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$2.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.servers$2 = servers$2;
                this.newReplicas$2 = newReplicas$2;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$3;
            private final TopicAndPartition topicAndPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$6) {
                        return x$6.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$3, this.newReplicas$3, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$3), (Object)this.newReplicas$3)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newReplicas$3 = newReplicas$3;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$5;
            private final Seq servers$3;
            private final Seq newReplicas$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$3, this.topic$5, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$3.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
                this.servers$3 = servers$3;
                this.newReplicas$3 = newReplicas$3;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$7) {
                x$7.shutdown();
            }
        });
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        Map reassignedPartitions = this.zkUtils().getPartitionsBeingReassigned();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$8) {
                x$8.shutdown();
            }
        });
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        reassignPartitionsCommand.reassignPartitions();
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !TestUtils$.MODULE$.checkIfReassignPartitionPathExists(this.$outer.zkUtils());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas, servers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$6;
            private final Seq newReplicas$4;
            private final Seq servers$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$4, this.topic$6, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$4.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$6 = topic$6;
                this.newReplicas$4 = newReplicas$4;
                this.servers$4 = servers$4;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$9) {
                x$9.shutdown();
            }
        });
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test", 1), new TopicAndPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkUtils(), (Set)partitionsForPreferredReplicaElection);
        String preferredReplicaElectionZkData = (String)this.zkUtils().readData(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath())._1();
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(preferredReplicaElectionZkData);
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq servers = (Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$17 = this.zkUtils();
        String x$18 = topic;
        int x$19 = partition;
        None$ x$20 = None$.MODULE$;
        long x$21 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$22 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$17, x$18, x$19, x$21, (Option<Object>)x$20, x$22).get());
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkUtils(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        ZkUtils x$23 = this.zkUtils();
        String x$24 = topic;
        int x$25 = partition;
        Some x$26 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$27 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, x$24, x$25, x$27, (Option<Object>)x$26, x$28).get());
        Assert.assertEquals((String)"Preferred replica election failed", (int)preferredReplica, (int)newLeader);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$10) {
                x$10.shutdown();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShutdownBroker() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq servers = (Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        int controllerId = this.zkUtils().getController();
        KafkaController controller = ((KafkaServer)servers.find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        }).get()).kafkaController();
        Set partitionsRemaining = controller.shutdownBroker(2);
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
                public static final long serialVersionUID = 0L;
                public final String topic$7;
                public final int partition$1;
                private final ObjectRef activeServers$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return ((Seq)this.activeServers$1.elem).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testShutdownBroker$1 $outer;

                        public final boolean apply(KafkaServer x$11) {
                            return ((PartitionStateInfo)x$11.apis().metadataCache().getPartitionInfo(this.$outer.topic$7, this.$outer.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().isr().size() != 3;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                    this.activeServers$1 = activeServers$1;
                }
            }, "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
            Assert.assertEquals((int)0, (int)partitionsRemaining.size());
            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            int leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((int)0, (int)leaderAfterShutdown);
            Assert.assertEquals((int)2, (int)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr().size());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr());
            partitionsRemaining = controller.shutdownBroker(1);
            Assert.assertEquals((int)0, (int)partitionsRemaining.size());
            activeServers.elem = (Seq)servers.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer s) {
                    return s.config().brokerId() == 0;
                }
            });
            partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((int)0, (int)leaderAfterShutdown);
            Assert.assertTrue((boolean)servers.forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(KafkaServer x$12) {
                    return ((PartitionStateInfo)x$12.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            }));
            partitionsRemaining = controller.shutdownBroker(0);
            Assert.assertEquals((int)1, (int)partitionsRemaining.size());
            Assert.assertTrue((boolean)servers.forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(KafkaServer x$13) {
                    return ((PartitionStateInfo)x$13.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            }));
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$14) {
                    x$14.shutdown();
                }
            });
            throw throwable;
        }
        servers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14())), TestUtils$.MODULE$.createServer$default$2());
        try {
            int maxMessageSize = 1024;
            int retentionMs = 1000000;
            AdminUtils$.MODULE$.createTopic(server.zkUtils(), topic, partitions, 1, this.makeConfig$1(maxMessageSize, retentionMs));
            this.checkConfig$1(maxMessageSize, retentionMs, partitions, topic, server);
            Properties newConfig = this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs));
            this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, partitions, topic, server);
            Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
            Assert.assertEquals((Object)newConfig, (Object)configInZk);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.shutdown();
            var3_3.config().logDirs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$15) {
                    CoreUtils$.MODULE$.rm(x$15);
                }
            });
            throw throwable;
        }
        server.shutdown();
        server.config().logDirs().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        Map configMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)"2000")}));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)configMap)}));
        ZkUtils qual$1 = this.zkUtils();
        String x$29 = ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Client(), clientId);
        String x$30 = Json$.MODULE$.encode((Object)map);
        java.util.List x$31 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$29, x$30, x$31);
        Map configInZk = AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overriden client config", (int)1, (int)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14())), TestUtils$.MODULE$.createServer$default$2());
        try {
            Assert.assertEquals((Object)new Quota(1000.0, true), (Object)((ClientQuotaManager)server.apis().quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)RequestKeys$.MODULE$.ProduceKey()))).quota(clientId));
            Assert.assertEquals((Object)new Quota(2000.0, true), (Object)((ClientQuotaManager)server.apis().quotaManagers().apply((Object)BoxesRunTime.boxToShort((short)RequestKeys$.MODULE$.FetchKey()))).quota(clientId));
        }
        catch (Throwable throwable) {
            void var10_10;
            var10_10.shutdown();
            var10_10.config().logDirs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$16) {
                    CoreUtils$.MODULE$.rm(x$16);
                }
            });
            throw throwable;
        }
        server.shutdown();
        server.config().logDirs().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        return props;
    }

    private final void checkConfig$1(int messageSize, long retentionMs, int partitions$1, String topic$8, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$8, server$1, messageSize, retentionMs){
            public static final long serialVersionUID = 0L;
            private final int partitions$1;
            public final String topic$8;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        Option logOpt = this.$outer.server$1.logManager().getLog(new TopicAndPartition(this.$outer.topic$8, part));
                        Assert.assertTrue((boolean)logOpt.isDefined());
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.$outer.retentionMs$1), (Object)((Log)logOpt.get()).config().retentionMs());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.$outer.messageSize$1), (Object)((Log)logOpt.get()).config().maxMessageSize());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.partitions$1 = partitions$1;
                this.topic$8 = topic$8;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
            }
        });
    }

    public AdminTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
    }
}

