/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import javax.security.auth.login.Configuration;
import kafka.api.SaslTestHarness;
import kafka.utils.TestUtils$;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.kafka.common.security.kerberos.LoginManager;
import org.junit.After;
import org.junit.Before;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.io.BufferedSource;
import scala.io.Source$;

public abstract class SaslTestHarness$class {
    @Before
    public static void setUp(SaslTestHarness $this) {
        LoginManager.closeAll();
        File keytabFile = $this.createKeytabAndSetConfiguration("kafka_jaas.conf");
        $this.kafka$api$SaslTestHarness$$kdc().start();
        $this.kafka$api$SaslTestHarness$$kdc().createPrincipal(keytabFile, new String[]{"client", "kafka/localhost"});
        $this.kafka$api$SaslTestHarness$$super$setUp();
    }

    public static File createKeytabAndSetConfiguration(SaslTestHarness $this, String jaasResourceName) {
        Tuple2 tuple2 = SaslTestHarness$class.createKeytabAndJaasFiles($this, jaasResourceName);
        if (tuple2 != null) {
            Tuple2 tuple22;
            File keytabFile = (File)tuple2._1();
            File jaasFile = (File)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keytabFile, (Object)jaasFile);
            File keytabFile2 = (File)tuple23._1();
            File jaasFile2 = (File)tuple23._2();
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", jaasFile2.getAbsolutePath());
            return keytabFile2;
        }
        throw new MatchError((Object)tuple2);
    }

    private static Tuple2 createKeytabAndJaasFiles(SaslTestHarness $this, String jaasResourceName) {
        File keytabFile = TestUtils$.MODULE$.tempFile();
        File jaasFile = TestUtils$.MODULE$.tempFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(jaasFile));
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jaasResourceName);
        if (inputStream == null) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find `", "`, make sure it is in the classpath"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jaasResourceName})));
        }
        BufferedSource source = Source$.MODULE$.fromInputStream(inputStream, "UTF-8");
        source.getLines().foreach((Function1)new Serializable($this, keytabFile, writer){
            public static final long serialVersionUID = 0L;
            private final File keytabFile$1;
            private final BufferedWriter writer$1;

            public final void apply(String line) {
                String replaced = line.replaceAll("\\$keytab-location", this.keytabFile$1.getAbsolutePath());
                this.writer$1.write(replaced);
                this.writer$1.newLine();
            }
            {
                this.keytabFile$1 = keytabFile$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
        source.close();
        return new Tuple2((Object)keytabFile, (Object)jaasFile);
    }

    @After
    public static void tearDown(SaslTestHarness $this) {
        $this.kafka$api$SaslTestHarness$$super$tearDown();
        $this.kafka$api$SaslTestHarness$$kdc().stop();
        LoginManager.closeAll();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
    }

    public static void $init$(SaslTestHarness $this) {
        $this.kafka$api$SaslTestHarness$_setter_$kafka$api$SaslTestHarness$$workDir_$eq(new File(System.getProperty("test.dir", "target")));
        $this.kafka$api$SaslTestHarness$_setter_$kafka$api$SaslTestHarness$$kdcConf_$eq(MiniKdc.createConf());
        $this.kafka$api$SaslTestHarness$_setter_$kafka$api$SaslTestHarness$$kdc_$eq(new MiniKdc($this.kafka$api$SaslTestHarness$$kdcConf(), $this.kafka$api$SaslTestHarness$$workDir()));
    }
}

