/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u000f\t!B)\u001a7bs\u0016$w\n]3sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\t\u0011\u0002];sO\u0006$xN]=\u0016\u0003Y\u00012AE\f\u001a\u0013\tA\"AA\rEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B+(oZ1u_JL\bC\u0001\u000e\u001c\u001b\u0005\u0001a\u0001\u0002\u000f\u0001\u0001u\u0011A#T8dW\u0012+G.Y=fI>\u0003XM]1uS>t7CA\u000e\u001f!\t\u0011r$\u0003\u0002!\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\tEm\u0011\t\u0011)A\u0005G\u00059A-\u001a7bs6\u001b\bCA\u0005%\u0013\t)#B\u0001\u0003M_:<\u0007\"B\b\u001c\t\u00039CCA\r)\u0011\u0015\u0011c\u00051\u0001$\u0011\u001dQ3\u00041A\u0005\u0002-\n1bY8na2,G/\u00192mKV\tA\u0006\u0005\u0002\n[%\u0011aF\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\u00014\u00041A\u0005\u0002E\nqbY8na2,G/\u00192mK~#S-\u001d\u000b\u0003eU\u0002\"!C\u001a\n\u0005QR!\u0001B+oSRDqAN\u0018\u0002\u0002\u0003\u0007A&A\u0002yIEBa\u0001O\u000e!B\u0013a\u0013\u0001D2p[BdW\r^1cY\u0016\u0004\u0003\"\u0002\u001e\u001c\t\u0003Y\u0014aD1xC&$X\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0003IBQ!P\u000e\u0005By\n1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\tA\u0006C\u0003A7\u0011\u00053(\u0001\u0007p]\u0016C\b/\u001b:bi&|g\u000eC\u0003C7\u0011\u00053(\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016Dq\u0001\u0012\u0001A\u0002\u0013\u0005Q)A\u0007qkJ<\u0017\r^8ss~#S-\u001d\u000b\u0003e\u0019CqAN\"\u0002\u0002\u0003\u0007a\u0003\u0003\u0004I\u0001\u0001\u0006KAF\u0001\u000baV\u0014x-\u0019;pef\u0004\u0003\"\u0002&\u0001\t\u0003Y\u0014!B:fiV\u0003\bFA%M!\ti%+D\u0001O\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003':\u0013aAQ3g_J,\u0007\"B+\u0001\t\u0003Y\u0014\u0001\u0003;fCJ$un\u001e8)\u0005Q;\u0006CA'Y\u0013\tIfJA\u0003BMR,'\u000fC\u0003\\\u0001\u0011\u00051(A\fuKN$(+Z9vKN$8+\u0019;jg\u001a\f7\r^5p]\"\u0012!,\u0018\t\u0003\u001bzK!a\u0018(\u0003\tQ+7\u000f\u001e\u0005\u0006C\u0002!\taO\u0001\u0012i\u0016\u001cHOU3rk\u0016\u001cH/\u0012=qSJL\bF\u00011^\u0011\u0015!\u0007\u0001\"\u0001<\u0003A!Xm\u001d;SKF,Xm\u001d;QkJ<W\r\u000b\u0002d;\u0002")
public class DelayedOperationTest {
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)new DelayedOperationPurgatory("mock", DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$2(), DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = System.currentTimeMillis();
        MockDelayedOperation r1 = new MockDelayedOperation(expiration);
        MockDelayedOperation r2 = new MockDelayedOperation(200000L);
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Time for expiration %d should at least %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(100000L);
        MockDelayedOperation r2 = new MockDelayedOperation(100000L);
        MockDelayedOperation r3 = new MockDelayedOperation(100000L);
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().delayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)2L, (long)this.purgatory().delayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)1L, (long)this.purgatory().delayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 4 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)1L, (long)this.purgatory().watched());
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private boolean completable;

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            ((Object)((Object)this)).wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public synchronized void onComplete() {
            ((Object)((Object)this)).notify();
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return DelayedOperationTest.this;
        }

        public MockDelayedOperation(long delayMs) {
            if (DelayedOperationTest.this == null) {
                throw null;
            }
            super(delayMs);
            this.completable = false;
        }
    }
}

