/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0013\tIA+[7feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001^5nKJT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\u0007\tY\u0001Aa\u0006\u0002\t)\u0016\u001cH\u000fV1tWN\u0019Q\u0003\u0007\u0011\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t1qJ\u00196fGR\u0004\"\u0001F\u0011\n\u0005\t\u0012!!\u0003+j[\u0016\u0014H+Y:l\u0011!!SC!b\u0001\n\u0003*\u0013\u0001D3ya&\u0014\u0018\r^5p]6\u001bX#\u0001\u0014\u0011\u0005-9\u0013B\u0001\u0015\r\u0005\u0011auN\\4\t\u0011)*\"\u0011!Q\u0001\n\u0019\nQ\"\u001a=qSJ\fG/[8o\u001bN\u0004\u0003\u0002\u0003\u0017\u0016\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0005%$\u0007CA\u0006/\u0013\tyCBA\u0002J]RD\u0001\"M\u000b\u0003\u0002\u0003\u0006IAM\u0001\u0006Y\u0006$8\r\u001b\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n!bY8oGV\u0014(/\u001a8u\u0015\t9D$\u0001\u0003vi&d\u0017BA\u001d5\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001bO\u000b\u0003\u0002\u0003\u0006I\u0001P\u0001\u0007_V$\b/\u001e;\u0011\u0007u\u0012U&D\u0001?\u0015\ty\u0004)A\u0004nkR\f'\r\\3\u000b\u0005\u0005c\u0011AC2pY2,7\r^5p]&\u00111I\u0010\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0003\u0012+\u0011\u0005Q\tF\u0003G\u0011&S5\n\u0005\u0002H+5\t\u0001\u0001C\u0003%\t\u0002\u0007a\u0005C\u0003-\t\u0002\u0007Q\u0006C\u00032\t\u0002\u0007!\u0007C\u0003<\t\u0002\u0007A\b\u0003\u0004N+\u0001\u0006IAT\u0001\nG>l\u0007\u000f\\3uK\u0012\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u001b\u0002\r\u0005$x.\\5d\u0013\t\u0019\u0006KA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0006+V!\tAV\u0001\u0004eVtG#A,\u0011\u0005-A\u0016BA-\r\u0005\u0011)f.\u001b;\t\rm\u0003\u0001\u0015)\u0003]\u0003!)\u00070Z2vi>\u0014\bCA\u001a^\u0013\tqFGA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0015\u0001\u0007\u0001\"\u0001W\u0003\u0015\u0019X\r^;qQ\ty&\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006)!.\u001e8ji*\tq-A\u0002pe\u001eL!!\u001b3\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0001W\u0003!!X-\u0019:e_^t\u0007F\u00016n!\t\u0019g.\u0003\u0002pI\n)\u0011I\u001a;fe\")\u0011\u000f\u0001C\u0001-\u00061B/Z:u\u00032\u0014X-\u00193z\u000bb\u0004\u0018N]3e)\u0006\u001c8\u000e\u000b\u0002qgB\u00111\r^\u0005\u0003k\u0012\u0014A\u0001V3ti\")q\u000f\u0001C\u0001-\u0006\u0011B/Z:u)\u0006\u001c8.\u0012=qSJ\fG/[8oQ\t18\u000f")
public class TimerTest {
    private ExecutorService executor = null;

    @Before
    public void setup() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void teardown() {
        this.executor.shutdown();
        this.executor = null;
    }

    @Test
    public void testAlreadyExpiredTask() {
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer(this.executor, 1L, 3, startTime);
        ArrayBuffer output = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(-5), 0).map((Function1)new Serializable(this, startTime, timer, output){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final long startTime$1;
            private final Timer timer$1;
            private final ArrayBuffer output$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.timer$1.add((TimerTask)new TestTask(this.$outer, this.startTime$1 + (long)i, i, latch, (ArrayBuffer<Object>)this.output$1));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startTime$1 = startTime$1;
                this.timer$1 = timer$1;
                this.output$1 = output$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)latches.take(5)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountDownLatch latch) {
                Assert.assertEquals((String)"already expired tasks should run immediately", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)latch.await(3L, TimeUnit.SECONDS)));
            }
        });
        Assert.assertEquals((String)"output of already expired tasks", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-5, -4, -3, -2, -1})), (Object)output.toSet());
    }

    @Test
    public void testTaskExpiration() {
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer(this.executor, 1L, 3, startTime);
        ArrayBuffer output = new ArrayBuffer();
        ArrayBuffer tasks = new ArrayBuffer();
        ArrayBuffer ids = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this, startTime, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final long startTime$2;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, this.startTime$2 + (long)i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startTime$2 = startTime$2;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 100).map((Function1)new Serializable(this, startTime, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final long startTime$2;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(2);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, this.startTime$2 + (long)i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, this.startTime$2 + (long)i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startTime$2 = startTime$2;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(100), 500).map((Function1)new Serializable(this, startTime, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final long startTime$2;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, this.startTime$2 + (long)i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startTime$2 = startTime$2;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)tasks.toSeq(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, timer){
            public static final long serialVersionUID = 0L;
            private final Timer timer$2;

            public final void apply(TestTask task) {
                this.timer$2.add((TimerTask)task);
            }
            {
                this.timer$2 = timer$2;
            }
        });
        while (timer.advanceClock(1000L)) {
        }
        latches.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountDownLatch latch) {
                latch.await();
            }
        });
        Assert.assertEquals((String)"output should match", (Object)ids.sorted((Ordering)Ordering.Int$.MODULE$), (Object)output.toSeq());
    }

    public class TestTask
    implements TimerTask {
        private final long expirationMs;
        private final int id;
        private final CountDownLatch latch;
        private final ArrayBuffer<Object> output;
        private final AtomicBoolean completed;
        public final /* synthetic */ TimerTest $outer;
        private TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry;

        public TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry() {
            return this.kafka$utils$timer$TimerTask$$timerTaskEntry;
        }

        public void kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(TimerTaskEntry x$1) {
            this.kafka$utils$timer$TimerTask$$timerTaskEntry = x$1;
        }

        public void cancel() {
            TimerTask.class.cancel((TimerTask)this);
        }

        public void setTimerTaskEntry(TimerTaskEntry entry) {
            TimerTask.class.setTimerTaskEntry((TimerTask)this, (TimerTaskEntry)entry);
        }

        public TimerTaskEntry getTimerTaskEntry() {
            return TimerTask.class.getTimerTaskEntry((TimerTask)this);
        }

        public long expirationMs() {
            return this.expirationMs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (!this.completed.compareAndSet(false, true)) return;
            ArrayBuffer<Object> arrayBuffer = this.output;
            synchronized (arrayBuffer) {
                this.output.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.id));
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : arrayBuffer
                this.latch.countDown();
                return;
            }
        }

        public /* synthetic */ TimerTest kafka$utils$timer$TimerTest$TestTask$$$outer() {
            return this.$outer;
        }

        public TestTask(TimerTest $outer, long expirationMs, int id, CountDownLatch latch, ArrayBuffer<Object> output) {
            this.expirationMs = expirationMs;
            this.id = id;
            this.latch = latch;
            this.output = output;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TimerTask.class.$init$((TimerTask)this);
            this.completed = new AtomicBoolean(false);
        }
    }
}

