/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.integration.ProducerConsumerTestHarness$class;
import kafka.log.Log;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.StaticPartitioner;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\u0001\u0002K]5nSRLg/Z!qSR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001AA\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\u001c!J|G-^2fe\u000e{gn];nKJ$Vm\u001d;ICJtWm]:\t\u000bA\u0001A\u0011A\t\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\u0005\u0001\u0011\u001d!\u0002A1A\u0005\u0002U\tAC]3rk\u0016\u001cH\u000fS1oI2,'\u000fT8hO\u0016\u0014X#\u0001\f\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012!\u00027pORR'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001eL!a\b\r\u0003\r1{wmZ3s\u0011\u0019\t\u0003\u0001)A\u0005-\u0005)\"/Z9vKN$\b*\u00198eY\u0016\u0014Hj\\4hKJ\u0004\u0003\"B\u0012\u0001\t\u0003!\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0015\u00022AJ\u00170\u001b\u00059#B\u0001\u0015*\u0003%IW.\\;uC\ndWM\u0003\u0002+W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00031\nQa]2bY\u0006L!AL\u0014\u0003\t1K7\u000f\u001e\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001b2\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000bY\u0002A\u0011A\u001c\u0002IQ,7\u000f\u001e$fi\u000eD'+Z9vKN$8)\u00198Qe>\u0004XM\u001d7z'\u0016\u0014\u0018.\u00197ju\u0016$\u0012\u0001\u000f\t\u0003sij\u0011aK\u0005\u0003w-\u0012A!\u00168ji\"\u0012Q'\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001r\tQA[;oSRL!AQ \u0003\tQ+7\u000f\u001e\u0005\u0006\t\u0002!\taN\u0001\u0016i\u0016\u001cH/R7qif4U\r^2i%\u0016\fX/Z:uQ\t\u0019U\bC\u0003H\u0001\u0011\u0005q'\u0001\u0012uKN$H)\u001a4bk2$XI\\2pI\u0016\u0014\bK]8ek\u000e,'/\u00118e\r\u0016$8\r\u001b\u0015\u0003\rvBQA\u0013\u0001\u0005\u0002]\n\u0011\u0007^3ti\u0012+g-Y;mi\u0016s7m\u001c3feB\u0013x\u000eZ;dKJ\fe\u000e\u001a$fi\u000eDw+\u001b;i\u0007>l\u0007O]3tg&|g\u000e\u000b\u0002J{!)Q\n\u0001C\u0005\u001d\u0006!\u0002O]8ek\u000e,\u0017I\u001c3Nk2$\u0018NR3uG\"$\"\u0001O(\t\u000bAc\u0005\u0019A)\u0002\u0011A\u0014x\u000eZ;dKJ\u0004BA\u0015+W-6\t1K\u0003\u0002Q\t%\u0011Qk\u0015\u0002\t!J|G-^2feB\u0011qK\u0017\b\u0003saK!!W\u0016\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033.BQA\u0018\u0001\u0005\u0002]\n\u0001\u0004^3tiB\u0013x\u000eZ;dK\u0006sG-T;mi&4U\r^2iQ\tiV\bC\u0003b\u0001\u0011%!-\u0001\u0007nk2$\u0018\u000e\u0015:pIV\u001cW\r\u0006\u00029G\")\u0001\u000b\u0019a\u0001#\")Q\r\u0001C\u0001o\u0005\u0001B/Z:u\u001bVdG/\u001b)s_\u0012,8-\u001a\u0015\u0003IvBQ\u0001\u001b\u0001\u0005\u0002]\na\u0003^3ti\u000e{gn];nKJ,U\u000e\u001d;z)>\u0004\u0018n\u0019\u0015\u0003OvBQa\u001b\u0001\u0005\u0002]\nA\u0004^3tiBK\u0007/\u001a7j]\u0016$\u0007K]8ek\u000e,'+Z9vKN$8\u000f\u000b\u0002k{!\"\u0001A\\9t!\tIt.\u0003\u0002qW\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003I\f\u0001\n\u00165jg\u0002\"Xm\u001d;!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004\u0013\u000e\u001e\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007%\u0019\u0011gkR,(/\u001a\u0011sK2,\u0017m]3\"\u0003Q\f\u0001\u0002\r\u00182a9\u0002d\u0006\r")
public class PrimitiveApiTest
extends KafkaServerTestHarness
implements ProducerConsumerTestHarness {
    private final Logger requestHandlerLogger;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ProducerConsumerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ProducerConsumerTestHarness$class.tearDown(this);
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()))}));
    }

    @Test
    public void testFetchRequestCanProperlySerialize() {
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").maxWait(10001).minBytes(4444).addFetch("topic1", 0, 0L, 10000).addFetch("topic2", 1, 1024L, 9999).addFetch("topic1", 1, 256L, 444).build();
        ByteBuffer serializedBuffer = ByteBuffer.allocate(request.sizeInBytes());
        request.writeTo(serializedBuffer);
        serializedBuffer.rewind();
        FetchRequest deserializedRequest = FetchRequest$.MODULE$.readFrom(serializedBuffer);
        Assert.assertEquals((Object)request, (Object)deserializedRequest);
    }

    @Test
    public void testEmptyFetchRequest() {
        scala.collection.immutable.Map partitionRequests = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Vector x$12 = partitionRequests.toVector();
        short x$13 = FetchRequest$.MODULE$.$lessinit$greater$default$1();
        int x$14 = FetchRequest$.MODULE$.$lessinit$greater$default$2();
        String x$15 = FetchRequest$.MODULE$.$lessinit$greater$default$3();
        int x$16 = FetchRequest$.MODULE$.$lessinit$greater$default$4();
        int x$17 = FetchRequest$.MODULE$.$lessinit$greater$default$5();
        int x$18 = FetchRequest$.MODULE$.$lessinit$greater$default$6();
        int x$19 = FetchRequest$.MODULE$.$lessinit$greater$default$7();
        FetchRequest request = new FetchRequest(x$13, x$14, x$15, x$16, x$17, x$18, x$19, (Seq)x$12);
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertTrue((!fetched.hasError() && fetched.data().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultEncoderProducerAndFetch() {
        String topic = "test-topic";
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        Replica replica = (Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition(topic, 0)).get();
        Assert.assertTrue((String)"HighWatermark should equal logEndOffset with just 1 replica", (replica.logEndOffset().messageOffset() > 0L && replica.logEndOffset().equals((Object)replica.highWatermark()) ? 1 : 0) != 0);
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").addFetch(topic, 0, 0L, 10000).build();
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertEquals((String)"Returned correlationId doesn't match that in request.", (long)0L, (long)fetched.correlationId());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    @Test
    public void testDefaultEncoderProducerAndFetchWithCompression() {
        String topic = "test-topic";
        Properties props = new Properties();
        props.put("compression.codec", "gzip");
        Producer stringProducer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    private void produceAndMultiFetch(Producer<String, String> producer) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Object> apply(String topic) {
                ZkUtils x$20 = this.$outer.zkUtils();
                String x$21 = topic;
                Buffer<KafkaServer> x$22 = this.$outer.servers();
                int x$23 = TestUtils$.MODULE$.createTopic$default$3();
                int x$24 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$25 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$20, x$21, x$23, x$24, (Seq<KafkaServer>)x$22, x$25);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$1;
            private final HashMap messages$1;
            private final FetchRequestBuilder builder$1;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final KeyedMessage<String, String> apply(String x$1) {
                            return new KeyedMessage(this.topic$1, (Object)this.topic$1, (Object)x$1);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$1.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$1 = producer$1;
                this.messages$1 = messages$1;
                this.builder$1 = builder$1;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$1;
            private final FetchResponse response$1;

            public final void apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$1.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$1.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$1 = messages$1;
                this.response$1 = response$1;
            }
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$3) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$2;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$2.addFetch(topic, partition, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(((FetchResponsePartitionData)pdata._2()).error().code());
                }
            });
            throw this.fail("Expected exception when fetching message with invalid offset", new Position("PrimitiveApiTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$4) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, builder3){
                public static final long serialVersionUID = 0L;
                private final FetchRequestBuilder builder$3;

                public final FetchRequestBuilder apply(Tuple2<String, Object> x$5) {
                    Tuple2<String, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        FetchRequestBuilder fetchRequestBuilder = this.builder$3.addFetch(topic, -1, 0L, 10000);
                        return fetchRequestBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$3 = builder$3;
                }
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> pdata) {
                        ErrorMapping$.MODULE$.maybeThrowException(((FetchResponsePartitionData)pdata._2()).error().code());
                    }
                });
                throw this.fail("Expected exception when fetching message with invalid partition", new Position("PrimitiveApiTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    @Test
    public void testProduceAndMultiFetch() {
        this.produceAndMultiFetch(this.producer());
    }

    private void multiProduce(Producer<String, String> producer) {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Object> apply(String topic) {
                ZkUtils x$26 = this.$outer.zkUtils();
                String x$27 = topic;
                Buffer<KafkaServer> x$28 = this.$outer.servers();
                int x$29 = TestUtils$.MODULE$.createTopic$default$3();
                int x$30 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$31 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$26, x$27, x$29, x$30, (Seq<KafkaServer>)x$28, x$31);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$5) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$2;
            private final HashMap messages$2;
            private final FetchRequestBuilder builder$4;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$7) {
                Tuple2<String, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final KeyedMessage<String, String> apply(String x$6) {
                            return new KeyedMessage(this.topic$2, (Object)this.topic$2, (Object)x$6);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$2.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$4.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$2 = producer$2;
                this.messages$2 = messages$2;
                this.builder$4 = builder$4;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$6) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$6;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchResponse response$2;

            public final void apply(Tuple2<String, Object> x$8) {
                Tuple2<String, Object> tuple2 = x$8;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$2.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$2.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$2 = messages$2;
                this.response$2 = response$2;
            }
        });
    }

    @Test
    public void testMultiProduce() {
        this.multiProduce(this.producer());
    }

    @Test
    public void testConsumerEmptyTopic() {
        String newTopic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), newTopic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        FetchResponse fetchResponse = this.consumer().fetch(new FetchRequestBuilder().addFetch(newTopic, 0, 0L, 10000).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(newTopic, 0).iterator().hasNext());
    }

    @Test
    public void testPipelinedProduceRequests() {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Object> apply(String topic) {
                ZkUtils x$32 = this.$outer.zkUtils();
                String x$33 = topic;
                Buffer<KafkaServer> x$34 = this.$outer.servers();
                int x$35 = TestUtils$.MODULE$.createTopic$default$3();
                int x$36 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$37 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$32, x$33, x$35, x$36, (Seq<KafkaServer>)x$34, x$37);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("request.required.acks", "0");
        Producer pipelinedProducer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$7) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$7;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, pipelinedProducer, messages, builder){
            public static final long serialVersionUID = 0L;
            private final Producer pipelinedProducer$1;
            private final HashMap messages$3;
            private final FetchRequestBuilder builder$5;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$10) {
                Tuple2<String, Object> tuple2 = x$10;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final KeyedMessage<String, String> apply(String x$9) {
                            return new KeyedMessage(this.topic$3, (Object)this.topic$3, (Object)x$9);
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.pipelinedProducer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$5.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pipelinedProducer$1 = pipelinedProducer$1;
                this.messages$3 = messages$3;
                this.builder$5 = builder$5;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicPartition("test1", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Published messages should be in the log";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicPartition("test2", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Published messages should be in the log";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicPartition("test3", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Published messages should be in the log";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicPartition("test4", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Published messages should be in the log";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int replicaId = ((KafkaServer)this.servers().head()).config().brokerId();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica(new TopicPartition("test1", 0), this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "High watermark should equal to log end offset";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica(new TopicPartition("test2", 0), this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "High watermark should equal to log end offset";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica(new TopicPartition("test3", 0), this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "High watermark should equal to log end offset";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica(new TopicPartition("test4", 0), this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "High watermark should equal to log end offset";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$8) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$8;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchResponse response$3;

            public final void apply(Tuple2<String, Object> x$11) {
                Tuple2<String, Object> tuple2 = x$11;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$3.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$3.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$3 = messages$3;
                this.response$3 = response$3;
            }
        });
    }

    public PrimitiveApiTest() {
        ProducerConsumerTestHarness$class.$init$(this);
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

