/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import kafka.log.Log;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u000f\tq\u0012\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\t\n\u0002\u00159,XN\u0011:pW\u0016\u00148/F\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\rIe\u000e\u001e\u0005\u00065\u0001!\tEE\u0001\fY><G)\u001b:D_VtG\u000fC\u0004\u001d\u0001\t\u0007I\u0011A\u000f\u0002\u000bQ|\u0007/[2\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0010\u0002\rQ|\u0007/[2!\u0011\u0015I\u0003\u0001\"\u0001+\u0003E\"Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cHOQ3g_J,Gk\u001c9jG\u000e\u0013X-\u0019;j_:$\u0012a\u000b\t\u0003)1J!!L\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003Q=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u000b),h.\u001b;\u000b\u0003Q\n1a\u001c:h\u0013\t1\u0014G\u0001\u0003UKN$\b\"\u0002\u001d\u0001\t\u0003Q\u0013a\n;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\fX/Z:u\u000bJ\u0014xN]\"pI\u0016D#aN\u0018\t\u000bm\u0002A\u0011\u0002\u001f\u0002=M,g\u000eZ!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c(+Z9vKN$HcA\u001fI/B\u0011aHR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\te\u0016\fX/Z:ug*\u0011!iQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!%BA#4\u0003\u0019\t\u0007/Y2iK&\u0011qi\u0010\u0002\u001c\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fgB|gn]3\t\u000b%S\u0004\u0019\u0001&\u0002\u001bA\f'\u000f^5uS>tG)\u001b:t!\u0011Ye*U+\u000f\u0005Qa\u0015BA'\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0004\u001b\u0006\u0004(BA'\u0016!\t\u00116+D\u0001B\u0013\t!\u0016I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005-3\u0016BA\u0013Q\u0011\u001dA&\b%AA\u0002e\u000bAb]8dW\u0016$8+\u001a:wKJ\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\u000f9,Go^8sW&\u0011al\u0017\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\bA\u0002\t\n\u0011\"\u0003b\u0003!\u001aXM\u001c3BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0011'FA-dW\u0005!\u0007CA3k\u001b\u00051'BA4i\u0003%)hn\u00195fG.,GM\u0003\u0002j+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005-4'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final String topic;

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public int logDirCount() {
        return 5;
    }

    public String topic() {
        return this.topic;
    }

    @Test
    public void testAlterReplicaLogDirsRequestBeforeTopicCreation() {
        int partitionNum = 5;
        String logDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        Map partitionDirs = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1)new Serializable(this, logDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterReplicaLogDirsRequestTest $outer;
            private final String logDir$1;

            public final Tuple2<TopicPartition, String> apply(int partition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.topic(), partition)), (Object)this.logDir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logDir$1 = logDir$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaDirResponse = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)new Serializable(this, alterReplicaDirResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterReplicaLogDirsRequestTest $outer;
            private final AlterReplicaLogDirsResponse alterReplicaDirResponse$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.$outer.topic(), partition);
                Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, this.alterReplicaDirResponse$1.responses().get(tp));
                Assert.assertTrue((boolean)((KafkaServer)this.$outer.servers().head()).logManager().getLog(tp).isEmpty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.alterReplicaDirResponse$1 = alterReplicaDirResponse$1;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), partitionNum, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)new Serializable(this, logDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterReplicaLogDirsRequestTest $outer;
            private final String logDir$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                Assert.assertEquals((Object)this.logDir$1, (Object)((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicPartition(this.$outer.topic(), partition)).get()).dir().getParent());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logDir$1 = logDir$1;
            }
        });
    }

    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String validDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, new IOException());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 3, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        scala.collection.mutable.Map partitionDirs = Map$.MODULE$.empty();
        partitionDirs.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir);
        partitionDirs.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.NONE, alterReplicaDirResponse.responses().get(new TopicPartition(this.topic(), 1)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse.responses().get(new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, SocketServer socketServer) {
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionDirs).asJava()).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ALTER_REPLICA_LOG_DIRS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AlterReplicaLogDirsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendAlterReplicaLogDirsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.topic = "topic";
    }
}

