/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.LinkedHashMap;
import kafka.admin.AdminUtils$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"I1\u0005\u0001B\u0001B\u0003%AEK\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqa\u00197vgR,'/\u0003\u0002*M\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018BA\u0012\u000b\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005/\u0013\ty#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002\ng%\u0011AG\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!1\u0004A!A!\u0002\u00139\u0014aB7fiJL7m\u001d\t\u0003q\u0005k\u0011!\u000f\u0006\u0003miR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t)QH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\":\u0005\u001diU\r\u001e:jGND\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0005i&lW\r\u0005\u0002G\u00116\tqI\u0003\u0002\u001du%\u0011\u0011j\u0012\u0002\u0005)&lW\r\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003\u0015\tXo\u001c;b!\tIQ*\u0003\u0002O\u0005\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\t!\u0002\u0011\t\u0011)A\u0005#\u0006QB.Z1eKJ,e\u000e\u001a9pS:$(\t\\8dW&twmU3oIB\u0019\u0001C\u0015+\n\u0005M\u000b\"AB(qi&|g\u000e\u0005\u0002\n+&\u0011aK\u0001\u0002\r\u00052|7m[5oON+g\u000e\u001a\u0005\u00061\u0002!\t!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015i[F,\u00180`A\u0006\u00147\r\u0005\u0002\n\u0001!)Qb\u0016a\u0001\u001d!)ad\u0016a\u0001?!)1e\u0016a\u0001I!)Af\u0016a\u0001[!)\u0011g\u0016a\u0001e!)ag\u0016a\u0001o!)Ai\u0016a\u0001\u000b\")1j\u0016a\u0001\u0019\"9\u0001k\u0016I\u0001\u0002\u0004\tV\u0001B3\u0001\u0001\u0019\u00141AU#R!\t9\u0017P\u0004\u0002i_:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\r!q!\u00029\u0003\u0011\u0003\t\u0018\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002\ne\u001a)\u0011A\u0001E\u0001gN\u0011!\u000f\u001e\t\u0003!UL!A^\t\u0003\r\u0005s\u0017PU3g\u0011\u0015A&\u000f\"\u0001y)\u0005\th!\u0002>s\u0001\tY(\u0001\u0004$fi\u000eD'+Z9vKN$8cA=uyB\u0019Q0!\u0001\u000f\u0005%q\u0018BA@\u0003\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012L1A_A\u0002\u0015\ty(\u0001\u0003\u0006\u0002\be\u0014)\u0019!C\u0001\u0003\u0013\t!\"\u001e8eKJd\u00170\u001b8h+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005ea\u0002BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M!(\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t9\"!\u0005\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005m\u0011Q\u0004\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\t9\"!\u0005\t\u0015\u0005\u0005\u0012P!A!\u0002\u0013\tY!A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003B\u0002-z\t\u0003\t)\u0003\u0006\u0003\u0002(\u0005-\u0002cAA\u0015s6\t!\u000f\u0003\u0005\u0002\b\u0005\r\u0002\u0019AA\u0006\u0011\u001d\ty#\u001fC\u0001\u0003c\tq![:F[B$\u00180\u0006\u0002\u00024A\u0019\u0001#!\u000e\n\u0007\u0005]\u0012CA\u0004C_>dW-\u00198\t\u000f\u0005m\u0012\u0010\"\u0001\u0002>\u00051qN\u001a4tKR$B!a\u0010\u0002FA\u0019\u0001#!\u0011\n\u0007\u0005\r\u0013C\u0001\u0003M_:<\u0007\u0002CA$\u0003s\u0001\r!!\u0013\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111JA'\u001b\u0005Q\u0014bAA(u\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA*s\u0012\u0005\u0013QK\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006L1AFA.\r\u001d\t9G\u001d\u0001\u0003\u0003S\u0012Q\u0002U1si&$\u0018n\u001c8ECR\f7#BA3i\u0006-\u0004cA?\u0002n%!\u0011qMA\u0002\u0011-\t9!!\u001a\u0003\u0006\u0004%\t!!\u001d\u0016\u0005\u0005M\u0004\u0003BA;\u0003wrA!a\u0004\u0002x%!\u0011\u0011PA\t\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&!\u0011qMA?\u0015\u0011\tI(!\u0005\t\u0017\u0005\u0005\u0012Q\rB\u0001B\u0003%\u00111\u000f\u0005\b1\u0006\u0015D\u0011AAB)\u0011\t))a\"\u0011\t\u0005%\u0012Q\r\u0005\t\u0003\u000f\t\t\t1\u0001\u0002t!A\u00111RA3\t\u0003\ti)A\u0003feJ|'/\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016j\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00033\u000b\u0019J\u0001\u0004FeJ|'o\u001d\u0005\t\u0003;\u000b)\u0007\"\u0001\u0002 \u0006IAo\u001c*fG>\u0014Hm]\u000b\u0003\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003OS\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0002,\u0006\u0015&!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u00020\u0006\u0015D\u0011AAY\u00035A\u0017n\u001a5XCR,'/\\1sWV\u0011\u0011q\b\u0005\t\u0003k\u000b)\u0007\"\u0001\u00022\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CA]\u0003K\"\t!a/\u0002\u0013\u0015D8-\u001a9uS>tWCAA_!\u0011\u0001\"+a0\u0011\t\u0005\u0005\u00171\u001a\b\u0005\u0003\u0007\f9MD\u0002k\u0003\u000bL\u0011AE\u0005\u0004\u0003\u0013\f\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\fyMA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011Z\t\t\u0011\u0005M\u0013Q\rC!\u0003+B\u0011\"!6s#\u0003%\t!a6\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\tINK\u0002R\u00037\\#!!8\u0011\t\u0005}\u0017\u0011^\u0007\u0003\u0003CTA!a9\u0002f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\f\u0012AC1o]>$\u0018\r^5p]&!\u00111^Aq\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0003\u0007\u0003_\u0004\u0001!!=\u0003\u0005A#\u0005cA4\u0002f!I\u0011Q\u001f\u0001C\u0002\u0013%\u0011q_\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012a\b\u0005\b\u0003w\u0004\u0001\u0015!\u0003 \u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\n\u0003\u007f\u0004!\u0019!C\u0005\u0005\u0003\t!\u0002\\8h\u0007>tG/\u001a=u+\t\u0011\u0019\u0001E\u0002G\u0005\u000bI1Aa\u0002H\u0005)aunZ\"p]R,\u0007\u0010\u001e\u0005\t\u0005\u0017\u0001\u0001\u0015!\u0003\u0003\u0004\u0005YAn\\4D_:$X\r\u001f;!\u0011%\u0011y\u0001\u0001b\u0001\n\u0013\u0011\t\"\u0001\bmK\u0006$WM]#oIB|\u0017N\u001c;\u0016\u0003QCqA!\u0006\u0001A\u0003%A+A\bmK\u0006$WM]#oIB|\u0017N\u001c;!\u0011%\u0011I\u0002\u0001b\u0001\n\u0013\u0011Y\"A\ngKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g.\u0006\u0002\u0003\u001eA\u0019\u0001Ca\b\n\u0007\t\u0005\u0012CA\u0003TQ>\u0014H\u000f\u0003\u0005\u0003&\u0001\u0001\u000b\u0011\u0002B\u000f\u0003Q1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8oA!I!\u0011\u0006\u0001C\u0002\u0013%!1F\u0001\b[\u0006Dx+Y5u+\t\u0011i\u0003\u0005\u0003\u0002Z\t=\u0012\u0002\u0002B\u0019\u00037\u0012q!\u00138uK\u001e,'\u000f\u0003\u0005\u00036\u0001\u0001\u000b\u0011\u0002B\u0017\u0003!i\u0017\r_,bSR\u0004\u0003\"\u0003B\u001d\u0001\t\u0007I\u0011\u0002B\u0016\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\u0002\u0003B\u001f\u0001\u0001\u0006IA!\f\u0002\u00135LgNQ=uKN\u0004\u0003\"\u0003B!\u0001\t\u0007I\u0011\u0002B\u0016\u0003!i\u0017\r\u001f\"zi\u0016\u001c\b\u0002\u0003B#\u0001\u0001\u0006IA!\f\u0002\u00135\f\u0007PQ=uKN\u0004\u0003\"\u0003B%\u0001\t\u0007I\u0011\u0002B\u0016\u0003%1W\r^2i'&TX\r\u0003\u0005\u0003N\u0001\u0001\u000b\u0011\u0002B\u0017\u0003)1W\r^2i'&TX\r\t\u0005\n\u0005#\u0002!\u0019!C\u0005\u0003c\tAd\u001d5pk2$7+\u001a8e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0005\u0003V\u0001\u0001\u000b\u0011BA\u001a\u0003u\u0019\bn\\;mIN+g\u000e\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgR\u0004\u0003b\u0002B-\u0001\u0011%!1L\u0001\u000eKB|7\r[\"bG\",w\n\u001d;\u0015\t\tu#1\u000e\t\u0005!I\u0013y\u0006\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)GA\u0001\u0006KB|7\r[\u0005\u0005\u0005S\u0012\u0019G\u0001\tMK\u0006$WM]#q_\u000eD7)Y2iK\"A!Q\u000eB,\u0001\u0004\tI%\u0001\u0002ua\"9!\u0011\u000f\u0001\u0005B\tM\u0014\u0001C:ikR$wn\u001e8\u0015\u0005\tU\u0004c\u0001\t\u0003x%\u0019!\u0011P\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005{\u0002A\u0011\u0001B@\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!Q\u000fBA\u0005\u0007\u00139\t\u0003\u0005\u0002H\tm\u0004\u0019AA%\u0011!\u0011)Ia\u001fA\u0002\u0005}\u0012a\u00034fi\u000eDwJ\u001a4tKRD\u0001B!#\u0003|\u0001\u0007\u0011\u0011_\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\u0006YR.Y=cK^\u000b'O\\%g\u001fZ,'o]5{K\u0012\u0014VmY8sIN$bA!\u001e\u0003\u0012\nU\u0005\u0002\u0003BJ\u0005\u0017\u0003\r!!)\u0002\u000fI,7m\u001c:eg\"A\u0011q\tBF\u0001\u0004\tI\u0005C\u0004\u0003\u001a\u0002!\tAa'\u0002-!\fg\u000e\u001a7f\u001f\u001a47/\u001a;PkR|eMU1oO\u0016$B!a\u0010\u0003\u001e\"A\u0011q\tBL\u0001\u0004\tI\u0005C\u0004\u0003\"\u0002!\tAa)\u00025!\fg\u000e\u001a7f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000bJ\u0014xN]:\u0015\t\tU$Q\u0015\u0005\t\u0005O\u0013y\n1\u0001\u0003*\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005\u0005'1VA%\u0013\u0011\u0011i+a4\u0003\u0011%#XM]1cY\u0016DqA!-\u0001\t#\u0011\u0019,A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u00036\n\u0005\u0007CBAa\u0005o\u0013Y,\u0003\u0003\u0003:\u0006='aA*fcB9\u0001C!0\u0002J\u0005E\u0018b\u0001B`#\t1A+\u001e9mKJBqAa1\u00030\u0002\u0007a-\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0004\u0003H\u0002!IA!3\u0002-\u0015\f'\u000f\\5fgR|%\u000fT1uKN$xJ\u001a4tKR$b!a\u0010\u0003L\n5\u0007\u0002CA$\u0005\u000b\u0004\r!!\u0013\t\u0011\t='Q\u0019a\u0001\u0003\u007f\t\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\t\u000f\tM\u0007\u0001\"\u0011\u0003V\u0006\t\"-^5mI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\t]'Q\u001c\t\u0005{\neg-\u0003\u0003\u0003\\\u0006\r!\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7\u000f\u0003\u0005\u0003`\nE\u0007\u0019\u0001Bq\u00031\u0001\u0018M\u001d;ji&|g.T1q!\u0019\t\tMa.\u0003dB9\u0001C!0\u0002J\t\u0015\bcA\u0005\u0003h&\u0019!\u0011\u001e\u0002\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\t5\b\u0001\"\u0011\u0003p\u0006iQ.Y=cKR\u0013XO\\2bi\u0016$BA!=\u0003\u0000B)QP!7\u0003tBA!Q\u001fB~\u0003\u0013\ny$\u0004\u0002\u0003x*\u0019!\u0011`\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003~\n](aA'ba\"A1\u0011\u0001Bv\u0001\u0004\u0019\u0019!A\u0007gKR\u001c\u0007.\u001a3Fa>\u001c\u0007n\u001d\t\t\u0005k\u0014Y0!\u0013\u0004\u0006A!\u0011qBB\u0004\u0013\u0011\u0019I!!\u0005\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"91Q\u0002\u0001\u0005B\r=\u0011a\u00062vS2$G*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u)\u0011\u0019\tb!\u0006\u0011\u000bu\u0014Ina\u0005\u0011\u000f\tU(1`A%?!A1qCB\u0006\u0001\u0004\u0011\t/A\u0007bY2\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u00077\u0001A\u0011IB\u000f\u0003U1W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$Baa\u0001\u0004 !A!qUB\r\u0001\u0004\u0019\u0019\u0002C\u0004\u0004$\u0001!Ia!\n\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\r\u0005}2qEB\u0019\u0011!\u0019Ic!\tA\u0002\r-\u0012a\u0002:fa2L7-\u0019\t\u0004K\r5\u0012bAB\u0018M\t9!+\u001a9mS\u000e\f\u0007\u0002CB\u001a\u0007C\u0001\ra!\u0002\u0002\u0017\u0015\u0004xn\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003_\u0003A\u0011BB\u001c)\u0019\tyd!\u000f\u0004<!A1\u0011FB\u001b\u0001\u0004\u0019Y\u0003\u0003\u0005\u00044\rU\u0002\u0019AB\u0003\u0011\u001d\u0019y\u0004\u0001C\u0005\u0007\u0003\nac\u001d5pk2$gi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u000b\u0007\u0003g\u0019\u0019ea\u0013\t\u000f-\u001bi\u00041\u0001\u0004FA\u0019\u0011ba\u0012\n\u0007\r%#A\u0001\u0007SKBd\u0017nY1Rk>$\u0018\r\u0003\u0005\u0002H\ru\u0002\u0019AA%\u00115\u0019y\u0005\u0001I\u0001\u0004\u0003\u0005I\u0011BB)U\u0005\u00112/\u001e9fe\u0012\u001ax.\u001e:dK\n\u0013xn[3s+\u0005!\u0003")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final int kafka$server$ReplicaFetcherThread$$fetcherId;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    public final ReplicaManager kafka$server$ReplicaFetcherThread$$replicaMgr;
    public final Metrics kafka$server$ReplicaFetcherThread$$metrics;
    public final Time kafka$server$ReplicaFetcherThread$$time;
    public final ReplicationQuotaManager kafka$server$ReplicaFetcherThread$$quota;
    private final int kafka$server$ReplicaFetcherThread$$replicaId;
    private final LogContext kafka$server$ReplicaFetcherThread$$logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final boolean shouldSendLeaderEpochRequest;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    public /* synthetic */ BrokerEndPoint kafka$server$ReplicaFetcherThread$$super$sourceBroker() {
        return super.sourceBroker();
    }

    public int kafka$server$ReplicaFetcherThread$$replicaId() {
        return this.kafka$server$ReplicaFetcherThread$$replicaId;
    }

    public LogContext kafka$server$ReplicaFetcherThread$$logContext() {
        return this.kafka$server$ReplicaFetcherThread$$logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private boolean shouldSendLeaderEpochRequest() {
        return this.shouldSendLeaderEpochRequest;
    }

    public Option<LeaderEpochCache> kafka$server$ReplicaFetcherThread$$epochCacheOpt(TopicPartition tp) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplica(tp).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderEpochCache apply(Replica x$1) {
                return (LeaderEpochCache)x$1.epochs().get();
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.leaderEndpoint().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition);
        MemoryRecords records = partitionData.toRecords();
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset().messageOffset()) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
        }
        if (this.logger().isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, partitionData, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final PartitionData partitionData$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.highWatermark())}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        ((Log)replica.log().get()).appendAsFollower(records);
        if (this.logger().isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
        long leaderLogStartOffset = partitionData.logStartOffset();
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.logger().isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            });
        }
        if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
            this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
        }
        this.kafka$server$ReplicaFetcherThread$$replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition);
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L);
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            if (Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.kafka$server$ReplicaFetcherThread$$replicaMgr.zkUtils(), ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable())) {
                this.warn((Function0<String>)new Serializable(this, topicPartition, replica, leaderEndOffset){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$3;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's latest offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.leaderEndOffset$1)}))).toString();
                    }
                    {
                        this.topicPartition$3 = topicPartition$3;
                        this.replica$2 = replica$2;
                        this.leaderEndOffset$1 = leaderEndOffset$1;
                    }
                });
                this.kafka$server$ReplicaFetcherThread$$replicaMgr.logManager().truncateTo((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)leaderEndOffset))}))));
                l = leaderEndOffset;
                return l;
            }
            this.fatal((Function0<String>)new Serializable(this, topicPartition, replica, leaderEndOffset){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exiting because log truncation is not allowed for partition ", ", current leader's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " is less than replica's latest offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.leaderEndOffset$1), BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset())}))).toString();
                }
                {
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderEndOffset$1 = leaderEndOffset$1;
                }
            });
            throw new FatalExitError();
        }
        long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L);
        this.warn((Function0<String>)new Serializable(this, topicPartition, replica, leaderStartOffset){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;
            private final Replica replica$2;
            private final long leaderStartOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's start offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.leaderStartOffset$1)}))).toString();
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.replica$2 = replica$2;
                this.leaderStartOffset$1 = leaderStartOffset$1;
            }
        });
        long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
        if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
            this.kafka$server$ReplicaFetcherThread$$replicaMgr.logManager().truncateFullyAndStartAt(topicPartition, leaderStartOffset);
        }
        l = offsetToFetch;
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        if (partitions.nonEmpty()) {
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.kafka$server$ReplicaFetcherThread$$brokerConfig.replicaFetchBackoffMs()));
        }
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest.underlying());
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        return (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData> x0$1) {
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition key = (TopicPartition)tuple2._1();
                    FetchResponse.PartitionData value2 = (FetchResponse.PartitionData)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData(value2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest) {
        ListOffsetRequest.Builder builder;
        if (this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = ListOffsetRequest.Builder.forReplica((short)1, (int)this.kafka$server$ReplicaFetcherThread$$replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        } else {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = ListOffsetRequest.Builder.forReplica((short)0, (int)this.kafka$server$ReplicaFetcherThread$$replicaId()).setOffsetData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        }
        ListOffsetRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = partitionData.error;
        if (Errors.NONE.equals(errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long((Long)partitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        LinkedHashMap requestMap = new LinkedHashMap();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionMap.foreach((Function1)new Serializable(this, requestMap, partitionsWithError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final LinkedHashMap requestMap$1;
            private final scala.collection.mutable.Set partitionsWithError$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$2) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                if (partitionFetchState.isReadyForFetch() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, topicPartition)) {
                    try {
                        long logStartOffset2 = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition).logStartOffset();
                        boxedUnit = this.requestMap$1.put(topicPartition, new FetchRequest.PartitionData(partitionFetchState.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize())));
                        return boxedUnit;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                    }
                    return boxedUnit;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestMap$1 = requestMap$1;
                this.partitionsWithError$1 = partitionsWithError$1;
            }
        });
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap truncationPoints = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1)new Serializable(this, truncationPoints, partitionsWithError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final HashMap truncationPoints$1;
            private final scala.collection.mutable.Set partitionsWithError$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<TopicPartition, EpochEndOffset> x0$3) {
                SetLike setLike;
                Tuple2<TopicPartition, EpochEndOffset> tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica replica = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(tp);
                    if (epochOffset.hasError()) {
                        this.$outer.info((Function0<String>)new Serializable(this, epochOffset, replica){
                            public static final long serialVersionUID = 0L;
                            private final EpochEndOffset epochOffset$1;
                            private final Replica replica$3;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the leader reported an error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replica$3.topicPartition(), this.epochOffset$1.error()}));
                            }
                            {
                                this.epochOffset$1 = epochOffset$1;
                                this.replica$3 = replica$3;
                            }
                        });
                        setLike = this.partitionsWithError$2.$plus$eq((Object)tp);
                        return setLike;
                    } else {
                        long truncationOffset = epochOffset.endOffset() == -1L ? this.$outer.kafka$server$ReplicaFetcherThread$$highWatermark(replica, epochOffset) : (epochOffset.endOffset() >= replica.logEndOffset().messageOffset() ? this.$outer.kafka$server$ReplicaFetcherThread$$logEndOffset(replica, epochOffset) : epochOffset.endOffset());
                        this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.logManager().truncateTo((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)truncationOffset))}))));
                        setLike = this.truncationPoints$1.put((Object)tp, (Object)BoxesRunTime.boxToLong((long)truncationOffset));
                    }
                    return setLike;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    this.$outer.info((Function0<String>)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                        public static final long serialVersionUID = 0L;
                        private final KafkaStorageException e$1;

                        public final KafkaStorageException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    setLike = this.partitionsWithError$2.$plus$eq((Object)tp);
                }
                return setLike;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.truncationPoints$1 = truncationPoints$1;
                this.partitionsWithError$2 = partitionsWithError$2;
            }
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(truncationPoints, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$4) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$4;
                if (tuple2 != null) {
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    boolean bl = state.isTruncatingLog();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final Tuple2<TopicPartition, Option<LeaderEpochCache>> apply(Tuple2<TopicPartition, PartitionFetchState> x0$5) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), this.$outer.kafka$server$ReplicaFetcherThread$$epochCacheOpt(tp));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$6) {
                Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$6;
                if (tuple2 != null) {
                    Option epochCacheOpt2 = (Option)tuple2._2();
                    boolean bl = epochCacheOpt2.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
            scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
            this.debug((Function0<String>)new Serializable(this, partitionsWithEpoch2){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map partitionsWithEpoch$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Build leaderEpoch request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsWithEpoch$1}));
                }
                {
                    this.partitionsWithEpoch$1 = partitionsWithEpoch$1;
                }
            });
            scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$7) {
                    Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Option epochCacheOpt2 = (Option)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochCache)epochCacheOpt2.get()).latestEpoch()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new AbstractFetcherThread.ResultWithPartitions<scala.collection.immutable.Map>(result, (Set<TopicPartition>)partitionsWithoutEpoch2.keys().toSet());
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        ObjectRef result = ObjectRef.create(null);
        if (!this.shouldSendLeaderEpochRequest()) {
            result.elem = (Map)partitions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$10) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$10;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            return (Map)result.elem;
        }
        java.util.Map partitionsAsJava = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Integer> apply(Tuple2<TopicPartition, Object> x0$8) {
                Tuple2<TopicPartition, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    int epoch = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)epoch));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(partitionsAsJava);
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            result.elem = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
            this.debug((Function0<String>)new Serializable(this, result){
                public static final long serialVersionUID = 0L;
                private final ObjectRef result$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receive leaderEpoch response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Map)this.result$1.elem}));
                }
                {
                    this.result$1 = result$1;
                }
            });
            return (Map)result.elem;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Map partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
            result.elem = (Map)partitions.map((Function1)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$9) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$9;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)this.t$1), -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.t$1 = t$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        return (Map)result.elem;
    }

    /*
     * WARNING - void declaration
     */
    public long kafka$server$ReplicaFetcherThread$$logEndOffset(Replica replica, EpochEndOffset epochOffset) {
        void var3_3;
        long logEndOffset2 = replica.logEndOffset().messageOffset();
        this.info((Function0<String>)new Serializable(this, replica, epochOffset, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final Replica replica$5;
            private final EpochEndOffset epochOffset$2;
            private final long logEndOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an offset ", " >= the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.epochOffset$2.endOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"follower's log end offset ", " in ", ". No truncation needed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logEndOffset$1), this.replica$5.topicPartition()}))).toString();
            }
            {
                this.replica$5 = replica$5;
                this.epochOffset$2 = epochOffset$2;
                this.logEndOffset$1 = logEndOffset$1;
            }
        });
        return (long)var3_3;
    }

    public long kafka$server$ReplicaFetcherThread$$highWatermark(Replica replica, EpochEndOffset epochOffset) {
        this.warn((Function0<String>)new Serializable(this, replica){
            public static final long serialVersionUID = 0L;
            private final Replica replica$4;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an unknown offset in ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replica$4.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"High watermark ", " will be used for truncation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$4.highWatermark().messageOffset())}))).toString();
            }
            {
                this.replica$4 = replica$4;
            }
        });
        return replica.highWatermark().messageOffset();
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.kafka$server$ReplicaFetcherThread$$fetcherId = fetcherId;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.kafka$server$ReplicaFetcherThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaFetcherThread$$metrics = metrics;
        this.kafka$server$ReplicaFetcherThread$$time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.kafka$server$ReplicaFetcherThread$$replicaId = brokerConfig.brokerId();
        this.kafka$server$ReplicaFetcherThread$$logContext = new LogContext(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)super.sourceBroker().id())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId)}))).toString());
        this.logIdent_$eq(this.kafka$server$ReplicaFetcherThread$$logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final ReplicaFetcherBlockingSend apply() {
                return new ReplicaFetcherBlockingSend(this.$outer.kafka$server$ReplicaFetcherThread$$super$sourceBroker(), this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig, this.$outer.kafka$server$ReplicaFetcherThread$$metrics, this.$outer.kafka$server$ReplicaFetcherThread$$time, this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId)})), this.$outer.kafka$server$ReplicaFetcherThread$$logContext());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.shouldSendLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

