/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.admin.TestAdminUtils;
import kafka.common.InvalidConfigException;
import kafka.server.ConfigEntityName$;
import kafka.utils.ZkUtils;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u000f\t\t2i\u001c8gS\u001e\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001)g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u001cE.[3oiN,e\u000e^5usRK\b/\u001a\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5uQ\tI2\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)!.\u001e8ji*\t\u0001&A\u0002pe\u001eL!AK\u0013\u0003\tQ+7\u000f\u001e\u0005\u0006Y\u0001!\taG\u0001(g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002,G!)q\u0006\u0001C\u00017\u0005A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u0012af\t\u0005\u0006e\u0001!\taM\u0001\u0012i\u0016\u001cH/\u0011:hk6,g\u000e\u001e)beN,GC\u0001\u000f5\u0011\u0015)\u0014\u00071\u00017\u0003))g\u000e^5usRK\b/\u001a\t\u0003oir!!\b\u001d\n\u0005er\u0012A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u0010\t\u000by\u0002A\u0011A\u000e\u0002EMDw.\u001e7e\r\u0006LG.\u00134V]J,7m\\4oSN,G-\u00128uSRLH+\u001f9fQ\u0011i4\u0005Q!\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\u0011\t\u0003\u0007.s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\tQe$A\u0004qC\u000e\\\u0017mZ3\n\u00051k%\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011!J\b\u0005\u0006\u001f\u0002!\taG\u0001\u0016g\"|W\u000f\u001c3BI\u0012\u001cE.[3oi\u000e{gNZ5hQ\tq5\u0005C\u0003S\u0001\u0011\u00051$\u0001\u000btQ>,H\u000eZ!eIR{\u0007/[2D_:4\u0017n\u001a\u0015\u0003#\u000eBQ!\u0016\u0001\u0005\u0002m\tQc\u001d5pk2$\u0017\t\u001a3Ce>\\WM]\"p]\u001aLw\r\u000b\u0002UG!)\u0001\f\u0001C\u00017\u0005\t3\u000f[8vY\u0012\u001cV\u000f\u001d9peR\u001cu.\\7b'\u0016\u0004\u0018M]1uK\u00124\u0016\r\\;fg\"\u0012qk\t\u0005\u00067\u0002!\taG\u00011g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$WI\u001c;jift\u0015-\\3)\ti\u001b\u0003)\u0011\u0005\u0006=\u0002!\taG\u0001-g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$7i\u001c8gS\u001eDC!X\u0012A\u0003\")\u0011\r\u0001C\u00017\u0005\u00194\u000f[8vY\u0012tu\u000e^+qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eLe-T1mM>\u0014X.\u001a3Ce\u0006\u001c7.\u001a;D_:4\u0017n\u001a\u0015\u0005A\u000e\u0002\u0015\tC\u0003e\u0001\u0011\u00051$A\u001ctQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001d>tW\t_5ti&twmQ8oM&<\u0017j\u001d#fY\u0016$X\r\u001a\u0015\u0005G\u000e\u0002emI\u0001h!\tA7.D\u0001j\u0015\tQG!\u0001\u0004d_6lwN\\\u0005\u0003Y&\u0014a#\u00138wC2LGmQ8oM&<W\t_2faRLwN\u001c\u0005\u0006]\u0002!\taG\u0001\u0019g\"|W\u000f\u001c3EK2,G/\u001a\"s_.,'oQ8oM&<\u0007FA7$\u0011\u0015\t\b\u0001\"\u0001\u001c\u0003Q!Xm\u001d;TGJ\fWn\u0011:fI\u0016tG/[1mg\"\u0012\u0001o\t\u0005\u0006i\u0002!\taG\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u0016sG/\u001b;zQ\t\u00198\u0005C\u0003x\u0001\u0011\u00051$A\fuKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018m\u00149ug\"\u0012ao\t\u0005\u0006u\u0002!\taG\u0001\u001ai\u0016\u001cH/U;pi\u0006$Um]2sS\n,WI\u001c;ji&,7\u000f\u000b\u0002zG\u0001")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigCommandTest$CredentialChange$4$ CredentialChange$2$lzycompute(Map x$1, VolatileObjectRef x$2) {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (x$2.elem != null) return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
            x$2.elem = new ConfigCommandTest$CredentialChange$4$(this, x$1);
            return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
        }
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "a=b"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=InvalidConfigException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return properties;
            }

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void testScramCredentials() {
        VolatileObjectRef CredentialChange$module = VolatileObjectRef.zero();
        Map credentials = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends TestAdminUtils
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            public final /* synthetic */ ConfigCommandTest $outer;
            public final Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Properties apply() {
                        return new Properties();
                    }
                });
            }

            public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1)new Serializable(this, configChange){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Kafka_admin_ConfigCommandTest$CredentialChange$3 $outer;
                    private final Properties configChange$1;

                    public final Object apply(String mechanism) {
                        String value = this.configChange$1.getProperty(mechanism);
                        Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                        ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                        Assert.assertEquals((long)this.$outer.iterations(), (long)scramCredential.iterations());
                        return this.configChange$1 == null ? BoxedUnit.UNIT : this.$outer.credentials$1.put((Object)this.$outer.user(), (Object)this.configChange$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.configChange$1 = configChange$1;
                    }
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.kafka$admin$ConfigCommandTest$CredentialChange$$$outer(), user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 0: {
                        object = this.user();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)x$1;
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$CredentialChange$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                Product.class.$init$((Product)this);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, clientId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String clientId$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)this.clientId$1), this.clientId$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientId$1 = clientId$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, principal, sanitizedPrincipal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String principal$1;
            private final String sanitizedPrincipal$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.sanitizedPrincipal$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String[] describeOpts$1;
            private final String clientId$1;
            private final String principal$1;
            private final String sanitizedPrincipal$1;
            private final String userClient$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.userClient$1, (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), new StringBuilder().append((Object)this.sanitizedPrincipal$1).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)this.clientId$1).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])this.describeOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
                this.clientId$1 = clientId$1;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
                this.userClient$1 = userClient$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients").toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])describeOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.kafka$admin$ConfigCommandTest$$clientIdOpts$1(clientId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/").append((Object)Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    @Test
    public void testQuotaDescribeEntities() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/<default>").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-4").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        this.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-2").toString()})), zkUtils);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final ConfigCommandTest$CredentialChange$4$ CredentialChange$2(Map credentials$1, VolatileObjectRef CredentialChange$module$1) {
        return CredentialChange$module$1.elem == null ? this.CredentialChange$2$lzycompute(credentials$1, CredentialChange$module$1) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.elem);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        Option option;
        block4: {
            String[] stringArray;
            String[] optArray;
            block3: {
                block2: {
                    optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
                    option = entityName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    stringArray = (String[])((Object[])new String[]{"--entity-name", name});
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            String[] nameArray = stringArray;
            return new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optArray).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nameArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        throw new MatchError((Object)option);
    }

    public final void kafka$admin$ConfigCommandTest$$checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final String[] kafka$admin$ConfigCommandTest$$clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, ZkUtils zkUtils$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])opts).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1)new Serializable(this, zkUtils$1){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final IExpectationSetters<Seq<String>> apply(Tuple2<String, Seq<String>> x0$1) {
                Tuple2<String, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.zkUtils$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
                    return iExpectationSetters;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{zkUtils$1});
        Seq entities = entity.getAllEntities(zkUtils$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigCommand.ConfigEntity e) {
                return e.fullSanitizedName();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkUtils$1});
    }
}

