/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.controller.AsyncRequest;
import kafka.controller.AsyncResponse;
import kafka.controller.CreateRequest;
import kafka.controller.DeleteRequest;
import kafka.controller.DeleteResponse;
import kafka.controller.ExistsRequest;
import kafka.controller.ExistsResponse;
import kafka.controller.GetACLRequest;
import kafka.controller.GetACLResponse;
import kafka.controller.GetChildrenRequest;
import kafka.controller.GetChildrenResponse;
import kafka.controller.GetDataRequest;
import kafka.controller.GetDataResponse;
import kafka.controller.SetACLRequest;
import kafka.controller.SetACLResponse;
import kafka.controller.SetDataRequest;
import kafka.controller.SetDataResponse;
import kafka.controller.StateChangeHandler;
import kafka.controller.ZNodeChangeHandler;
import kafka.controller.ZNodeChildChangeHandler;
import kafka.controller.ZookeeperClient;
import kafka.controller.ZookeeperClientTimeoutException;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001\u001d\u00111CW8pW\u0016,\u0007/\u001a:DY&,g\u000e\u001e+fgRT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#\u0001\u0005n_\u000e\\\u0007+\u0019;i+\u00051\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0001\u0001\u0015!\u0003\u0017\u0003%iwnY6QCRD\u0007\u0005C\u0003\"\u0001\u0011\u0005#%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B+oSRD#\u0001\t\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013!\u00026v]&$(\"A\u0018\u0002\u0007=\u0014x-\u0003\u00022Y\t)\u0011I\u001a;fe\")1\u0007\u0001C\u0001E\u0005iB/Z:u+:\u0014Xm]8mm\u0006\u0014G.Z\"p]:,7\r^*ue&tw\r\u000b\u00033kaJ\u0004CA\u00167\u0013\t9DF\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u000e\u0002\u00079,G/\u0003\u0002@y\t!RK\\6o_^t\u0007j\\:u\u000bb\u001cW\r\u001d;j_:DQ!\u0011\u0001\u0005\u0002\t\nQ\u0003^3ti\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\u000b\u0003Aka\u001a5%\u0001#\u0011\u0005I)\u0015B\u0001$\u0003\u0005}Qvn\\6fKB,'o\u00117jK:$H+[7f_V$X\t_2faRLwN\u001c\u0005\u0006\u0011\u0002!\tAI\u0001\u000fi\u0016\u001cHoQ8o]\u0016\u001cG/[8oQ\t9U\u0007C\u0003L\u0001\u0011\u0005!%\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002Kk!)a\n\u0001C\u0001E\u00059B/Z:u\t\u0016dW\r^3Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0003\u001bVBQ!\u0015\u0001\u0005\u0002\t\n!\u0004^3ti\u0016C\u0018n\u001d;t\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D#\u0001U\u001b\t\u000bQ\u0003A\u0011\u0001\u0012\u0002/Q,7\u000f^#ySN$8/\u0012=jgRLgn\u001a.O_\u0012,\u0007FA*6\u0011\u00159\u0006\u0001\"\u0001#\u0003m!Xm\u001d;HKR$\u0015\r^1O_:,\u00050[:uK:$(LT8eK\"\u0012a+\u000e\u0005\u00065\u0002!\tAI\u0001\u0019i\u0016\u001cHoR3u\t\u0006$\u0018-\u0012=jgRLgn\u001a.O_\u0012,\u0007FA-6\u0011\u0015i\u0006\u0001\"\u0001#\u0003m!Xm\u001d;TKR$\u0015\r^1O_:,\u00050[:uK:$(LT8eK\"\u0012A,\u000e\u0005\u0006A\u0002!\tAI\u0001\u0019i\u0016\u001cHoU3u\t\u0006$\u0018-\u0012=jgRLgn\u001a.O_\u0012,\u0007FA06\u0011\u0015\u0019\u0007\u0001\"\u0001#\u0003i!Xm\u001d;HKR\f5\t\u0014(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\t\u0011W\u0007C\u0003g\u0001\u0011\u0005!%A\fuKN$x)\u001a;B\u00072+\u00050[:uS:<'LT8eK\"\u0012Q-\u000e\u0005\u0006S\u0002!\tAI\u0001\u001bi\u0016\u001cHoU3u\u0003\u000ecej\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0003QVBQ\u0001\u001c\u0001\u0005\u0002\t\nq\u0004^3ti\u001e+Go\u00115jY\u0012\u0014XM\u001c(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\tYW\u0007C\u0003p\u0001\u0011\u0005!%\u0001\u000fuKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3)\u00059,\u0004\"\u0002:\u0001\t\u0003\u0011\u0013\u0001\u000b;fgR<U\r^\"iS2$'/\u001a8Fq&\u001cH/\u001b8h5:{G-Z,ji\"\u001c\u0005.\u001b7ee\u0016t\u0007FA96\u0011\u0015)\b\u0001\"\u0001#\u0003Q!Xm\u001d;QSB,G.\u001b8fI\u001e+G\u000fR1uC\"\u0012A/\u000e\u0005\u0006q\u0002!\tAI\u0001\u0012i\u0016\u001cH/T5yK\u0012\u0004\u0016\u000e]3mS:,\u0007FA<6\u0011\u0015Y\b\u0001\"\u0001#\u0003\u0005\"Xm\u001d;[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:De\u0016\fG/[8oQ\tQX\u0007C\u0003\u007f\u0001\u0011\u0005!%A\u0011uKN$(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u0014H)\u001a7fi&|g\u000e\u000b\u0002~k!1\u00111\u0001\u0001\u0005\u0002\t\n1\u0005^3tijsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0012\u000bG/Y\"iC:<W\rK\u0002\u0002\u0002UBa!!\u0003\u0001\t\u0003\u0011\u0013!\u000b;fgRTfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'OR8s\u0007\"LG\u000eZ\"iC:<W\rK\u0002\u0002\bUBa!a\u0004\u0001\t\u0003\u0011\u0013\u0001\n;fgR\u001cF/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:G_J\fU\u000f\u001e5GC&dWO]3)\u0007\u00055Q\u0007C\u0004\u0002\u0016\u0001!I!a\u0006\u0002\u000b\tLH/Z:\u0016\u0005\u0005e\u0001#\u0002\u0013\u0002\u001c\u0005}\u0011bAA\u000fK\t)\u0011I\u001d:bsB\u0019A%!\t\n\u0007\u0005\rRE\u0001\u0003CsR,\u0007")
public class ZookeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$controller$ZookeeperClientTest$$mockPath;

    public String kafka$controller$ZookeeperClientTest$$mockPath() {
        return this.kafka$controller$ZookeeperClientTest$$mockPath;
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
    }

    @Test(expected=UnknownHostException.class)
    public void testUnresolvableConnectString() {
        new ZookeeperClient("some.invalid.hostname.foo.bar.local", -1, -1, null);
    }

    @Test(expected=ZookeeperClientTimeoutException.class)
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), 100, null);
    }

    @Test
    public void testConnection() {
        new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
    }

    @Test
    public void testDeleteNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        DeleteResponse deleteResponse = (DeleteResponse)zookeeperClient.handle((AsyncRequest)new DeleteRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), -1, null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)deleteResponse.rc()));
    }

    @Test
    public void testDeleteExistingZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        DeleteResponse deleteResponse = (DeleteResponse)zookeeperClient.handle((AsyncRequest)new DeleteRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), -1, null));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)deleteResponse.rc()));
    }

    @Test
    public void testExistsNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        ExistsResponse existsResponse = (ExistsResponse)zookeeperClient.handle((AsyncRequest)new ExistsRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)existsResponse.rc()));
    }

    @Test
    public void testExistsExistingZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        ExistsResponse existsResponse = (ExistsResponse)zookeeperClient.handle((AsyncRequest)new ExistsRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)existsResponse.rc()));
    }

    @Test
    public void testGetDataNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        GetDataResponse getDataResponse = (GetDataResponse)zookeeperClient.handle((AsyncRequest)new GetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)getDataResponse.rc()));
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), data, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        GetDataResponse getDataResponse = (GetDataResponse)zookeeperClient.handle((AsyncRequest)new GetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getDataResponse.rc()));
        Assert.assertArrayEquals((String)"Data for getData should match created znode data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testSetDataNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        SetDataResponse setDataResponse = (SetDataResponse)zookeeperClient.handle((AsyncRequest)new SetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)setDataResponse.rc()));
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        SetDataResponse setDataResponse = (SetDataResponse)zookeeperClient.handle((AsyncRequest)new SetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), data, -1, null));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)setDataResponse.rc()));
        GetDataResponse getDataResponse = (GetDataResponse)zookeeperClient.handle((AsyncRequest)new GetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getDataResponse.rc()));
        Assert.assertArrayEquals((String)"Data for getData should match setData's data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testGetACLNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        GetACLResponse getACLResponse = (GetACLResponse)zookeeperClient.handle((AsyncRequest)new GetACLRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)getACLResponse.rc()));
    }

    @Test
    public void testGetACLExistingZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        GetACLResponse getACLResponse = (GetACLResponse)zookeeperClient.handle((AsyncRequest)new GetACLRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for getACL should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getACLResponse.rc()));
        Assert.assertEquals((String)new StringBuilder().append((Object)"ACL should be ").append(JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getACLResponse.acl());
    }

    @Test
    public void testSetACLNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        SetACLResponse setACLResponse = (SetACLResponse)zookeeperClient.handle((AsyncRequest)new SetACLRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)setACLResponse.rc()));
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)zookeeperClient.handle((AsyncRequest)new GetChildrenRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)getChildrenResponse.rc()));
    }

    @Test
    public void testGetChildrenExistingZNode() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)zookeeperClient.handle((AsyncRequest)new GetChildrenRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getChildrenResponse.rc()));
        Assert.assertEquals((String)"getChildren should return no children", (Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children());
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder().append((Object)this.kafka$controller$ZookeeperClientTest$$mockPath()).append((Object)"/").append((Object)child1).toString();
        String child2Path = new StringBuilder().append((Object)this.kafka$controller$ZookeeperClientTest$$mockPath()).append((Object)"/").append((Object)child2).toString();
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        AsyncResponse createResponseChild1 = zookeeperClient.handle((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponseChild1.rc()));
        AsyncResponse createResponseChild2 = zookeeperClient.handle((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create child2 should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponseChild2.rc()));
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)zookeeperClient.handle((AsyncRequest)new GetChildrenRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getChildrenResponse.rc()));
        Assert.assertEquals((String)"getChildren should return two children", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{child1, child2})), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPipelinedGetData() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        IndexedSeq createRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CreateRequest apply(int x) {
                return new CreateRequest(new StringBuilder().append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)x)).toString(), ((Object)BoxesRunTime.boxToInteger((int)(x * 2))).toString().getBytes(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq createResponses = (IndexedSeq)createRequests.map((Function1)new Serializable(this, zookeeperClient){
            public static final long serialVersionUID = 0L;
            private final ZookeeperClient zookeeperClient$1;

            public final AsyncResponse apply(AsyncRequest request) {
                return this.zookeeperClient$1.handle(request);
            }
            {
                this.zookeeperClient$1 = zookeeperClient$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        createResponses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AsyncResponse createResponse) {
                Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
            }
        });
        IndexedSeq getDataRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GetDataRequest apply(int x) {
                return new GetDataRequest(new StringBuilder().append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)x)).toString(), null);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Seq getDataResponses = zookeeperClient.handle((Seq)getDataRequests);
        getDataResponses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AsyncResponse getDataResponse) {
                Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getDataResponse.rc()));
            }
        });
        ((IterableLike)getDataResponses.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<AsyncResponse, Object> x0$1) {
                Tuple2<AsyncResponse, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    AsyncResponse getDataResponse = (AsyncResponse)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)getDataResponse.rc()));
                    Assert.assertEquals((String)"Data for getData should match", (Object)BoxesRunTime.boxToInteger((int)((i + 1) * 2)), (Object)Integer.valueOf(new String(((GetDataResponse)getDataResponse).data())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testMixedPipeline() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), null);
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, null);
        Seq responses = zookeeperClient.handle((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{getDataRequest, setDataRequest})));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)((AsyncResponse)responses.head()).rc()));
        Assert.assertArrayEquals((String)"Data for getData should be empty", (byte[])((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data());
        Assert.assertEquals((String)"Response code for setData should be NONODE", (Object)KeeperException.Code.NONODE, (Object)KeeperException.Code.get((int)((AsyncResponse)responses.last()).rc()));
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public void handleDeletion() {
            }

            public void handleDataChange() {
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$controller$ZookeeperClientTest$$mockPath();
            }
        };
        zookeeperClient.registerZNodeChangeHandler(zNodeChangeHandler);
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public void handleDataChange() {
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$controller$ZookeeperClientTest$$mockPath();
            }
        };
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        zookeeperClient.registerZNodeChangeHandler(zNodeChangeHandler);
        DeleteResponse deleteResponse = (DeleteResponse)zookeeperClient.handle((AsyncRequest)new DeleteRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), -1, null));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)deleteResponse.rc()));
        Assert.assertTrue((String)"Failed to receive delete notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
            }

            public void handleDeletion() {
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                this.path = $outer.kafka$controller$ZookeeperClientTest$$mockPath();
            }
        };
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        zookeeperClient.registerZNodeChangeHandler(zNodeChangeHandler);
        SetDataResponse setDataResponse = (SetDataResponse)zookeeperClient.handle((AsyncRequest)new SetDataRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, null));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)setDataResponse.rc()));
        Assert.assertTrue((String)"Failed to receive data change notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        ZookeeperClient zookeeperClient = new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), null);
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$controller$ZookeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder().append((Object)this.kafka$controller$ZookeeperClientTest$$mockPath()).append((Object)"/").append((Object)child1).toString();
        AsyncResponse createResponse = zookeeperClient.handle((AsyncRequest)new CreateRequest(this.kafka$controller$ZookeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponse.rc()));
        zookeeperClient.registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        AsyncResponse createResponseChild1 = zookeeperClient.handle((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, null));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)KeeperException.Code.get((int)createResponseChild1.rc()));
        Assert.assertTrue((String)"Failed to receive child change notification", (boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(this, stateChangeHandlerCountDownLatch){
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
            }

            public void afterInitializingSession() {
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }

            public void onConnectionTimeout() {
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
            }
        };
        new ZookeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), stateChangeHandler);
        Assert.assertTrue((String)"Failed to receive auth failed notification", (boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public ZookeeperClientTest() {
        this.kafka$controller$ZookeeperClientTest$$mockPath = "/foo";
    }
}

