/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig;
import kafka.producer.SyncProducerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU=oGB\u0013x\u000eZ;dKJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001D7fgN\fw-\u001a\"zi\u0016\u001cX#\u0001\f\u0011\u0007]QB$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0015\t%O]1z!\t9R$\u0003\u0002\u001f1\t!!)\u001f;f\u0011\u0019\u0001\u0003\u0001)A\u0005-\u0005iQ.Z:tC\u001e,')\u001f;fg\u0002BQA\t\u0001\u0005\u0002\r\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002IA\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0013%lW.\u001e;bE2,'BA\u0015\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u0019\u0012A\u0001T5tiB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Er#aC&bM.\f7i\u001c8gS\u001eDQa\r\u0001\u0005\nQ\na\u0002\u001d:pIV\u001cWMU3rk\u0016\u001cH\u000f\u0006\u00056w\u0011K\u0005K\u0015+W!\t1\u0014(D\u00018\u0015\tAD!A\u0002ba&L!AO\u001c\u0003\u001fA\u0013x\u000eZ;dKJ\u0014V-];fgRDQ\u0001\u0010\u001aA\u0002u\nQ\u0001^8qS\u000e\u0004\"AP!\u000f\u0005]y\u0014B\u0001!\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001C\u0002\"B#3\u0001\u00041\u0015!\u00039beRLG/[8o!\t9r)\u0003\u0002I1\t\u0019\u0011J\u001c;\t\u000b)\u0013\u0004\u0019A&\u0002\u000f5,7o]1hKB\u0011AJT\u0007\u0002\u001b*\u0011!\nB\u0005\u0003\u001f6\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\b\"B)3\u0001\u00041\u0015\u0001B1dWNDqa\u0015\u001a\u0011\u0002\u0003\u0007a)A\u0004uS6,w.\u001e;\t\u000fU\u0013\u0004\u0013!a\u0001\r\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012Dqa\u0016\u001a\u0011\u0002\u0003\u0007Q(\u0001\u0005dY&,g\u000e^%e\u0011\u0015I\u0006\u0001\"\u0001[\u0003M!Xm\u001d;SK\u0006\u001c\u0007.\u00192mKN+'O^3s)\u0005Y\u0006CA\f]\u0013\ti\u0006D\u0001\u0003V]&$\bF\u0001-`!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0003kk:LGOC\u0001e\u0003\ry'oZ\u0005\u0003M\u0006\u0014A\u0001V3ti\")\u0001\u000e\u0001C\u00015\u00069B/Z:u\u000b6\u0004H/\u001f)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u0015\u0003O~CQa\u001b\u0001\u0005\u0002i\u000bq\u0003^3ti6+7o]1hKNK'0\u001a+p_2\u000b'oZ3)\u0005)|\u0006\"\u00028\u0001\t\u0003Q\u0016A\t;fgRlUm]:bO\u0016\u001c\u0016N_3U_>d\u0015M]4f/&$\b.Q2l5\u0016\u0014x\u000e\u000b\u0002n?\")\u0011\u000f\u0001C\u00015\u0006!C/Z:u!J|G-^2f\u0007>\u0014(/Z2uYf\u0014VmY3jm\u0016\u001c(+Z:q_:\u001cX\r\u000b\u0002q?\")A\u000f\u0001C\u00015\u00061B/Z:u!J|G-^2fe\u000e\u000bg\u000eV5nK>,H\u000f\u000b\u0002t?\")q\u000f\u0001C\u00015\u0006\u0001C/Z:u!J|G-^2f%\u0016\fX/Z:u/&$\bNT8SKN\u0004xN\\:fQ\t1x\fC\u0003{\u0001\u0011\u0005!,A\u000buKN$hj\u001c;F]>,x\r\u001b*fa2L7-Y:)\u0005e|\u0006bB?\u0001#\u0003%IA`\u0001\u0019aJ|G-^2f%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012*T#A@+\u0007\u0019\u000b\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\ti\u0001G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011!\t)\u0002AI\u0001\n\u0013q\u0018\u0001\u00079s_\u0012,8-\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%m!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013%\u00111D\u0001\u0019aJ|G-^2f%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012:TCAA\u000fU\ri\u0014\u0011\u0001\u0015\b\u0001\u0005\u0005\u0012qEA\u0016!\r9\u00121E\u0005\u0004\u0003KA\"A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011F\u0001I)\"L7\u000f\t;fgR\u0004\u0003.Y:!E\u0016,g\u000e\t3faJ,7-\u0019;fI\u0002\ng\u000e\u001a\u0011ji\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016\f#!!\f\u0002\u0011Ar\u0013\u0007\r\u00181]A\u0002")
public class SyncProducerTest
extends KafkaServerTestHarness {
    private final byte[] messageBytes = new byte[2];

    private byte[] messageBytes() {
        return this.messageBytes;
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).head())}));
    }

    private ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return TestUtils$.MODULE$.produceRequest(topic, partition, message, acks, timeout, correlationId, clientId);
    }

    private int produceRequest$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    private int produceRequest$default$6() {
        return 0;
    }

    private String produceRequest$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    @Test
    public void testReachableServer() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        long firstStart = Time.SYSTEM.milliseconds();
        ProducerResponse response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((Time.SYSTEM.milliseconds() - firstStart < 12000L ? 1 : 0) != 0);
        long secondStart = Time.SYSTEM.milliseconds();
        response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((Time.SYSTEM.milliseconds() - secondStart < 12000L ? 1 : 0) != 0);
        response = producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testEmptyProduceRequest() {
        int ackTimeoutMs;
        short ack;
        String clientId;
        int correlationId;
        ProducerRequest emptyRequest;
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ProducerResponse response = producer.send(emptyRequest = new ProducerRequest(correlationId = 0, clientId = SyncProducerConfig$.MODULE$.DefaultClientId(), ack = 1, ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs(), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertTrue((response != null ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasError() && response.status().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testMessageSizeTooLarge() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "test", 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Message message1 = new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1]);
        ByteBufferMessageSet messageSet1 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message1}));
        ProducerResponse response1 = producer.send(this.produceRequest("test", 0, messageSet1, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((long)1L, (long)response1.status().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> x$1) {
                Errors errors = ((ProducerResponseStatus)x$1._2()).error();
                Errors errors2 = Errors.NONE;
                return errors != null ? !errors.equals(errors2) : errors2 != null;
            }
        }));
        Assert.assertEquals((Object)Errors.MESSAGE_TOO_LARGE, (Object)((ProducerResponseStatus)response1.status().apply((Object)new TopicAndPartition("test", 0))).error());
        Assert.assertEquals((long)-1L, (long)((ProducerResponseStatus)response1.status().apply((Object)new TopicAndPartition("test", 0))).offset());
        int safeSize = Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) - 61 - 21;
        Message message2 = new Message(new byte[safeSize]);
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message2}));
        ProducerResponse response2 = producer.send(this.produceRequest("test", 0, messageSet2, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((long)1L, (long)response1.status().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> x$2) {
                Errors errors = ((ProducerResponseStatus)x$2._2()).error();
                Errors errors2 = Errors.NONE;
                return errors != null ? !errors.equals(errors2) : errors2 != null;
            }
        }));
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("test", 0))).error());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("test", 0))).offset());
    }

    @Test
    public void testMessageSizeTooLargeWithAckZero() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        props.put("request.required.acks", "0");
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "test", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "test", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1])})), 0, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        try {
            producer.send(this.produceRequest("test", 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(new byte[Predef$.MODULE$.Integer2int(((KafkaConfig)this.configs().head()).messageMaxBytes()) + 1])})), 0, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        }
        catch (IOException iOException) {}
    }

    @Test
    public void testProduceCorrectlyReceivesResponse() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())}));
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2", "topic3"});
        WrappedArray x$4 = Predef$.MODULE$.wrapIntArray(new int[]{0});
        ByteBufferMessageSet x$5 = messages;
        int x$6 = 1;
        int x$7 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$8 = SyncProducerConfig$.MODULE$.DefaultClientId();
        int x$9 = TestUtils$.MODULE$.produceRequestWithAcks$default$6();
        ProducerRequest request = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$3, (Seq<Object>)x$4, x$5, x$6, x$7, x$9, x$8);
        ProducerResponse response = producer.send(request);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)request.correlationId(), (long)response.correlationId());
        Assert.assertEquals((long)3L, (long)response.status().size());
        response.status().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ProducerResponseStatus x0$1) {
                ProducerResponseStatus producerResponseStatus = x0$1;
                if (producerResponseStatus != null) {
                    Errors error = producerResponseStatus.error();
                    long nextOffset = producerResponseStatus.offset();
                    long timestamp = producerResponseStatus.timestamp();
                    Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)error);
                    Assert.assertEquals((long)-1L, (long)nextOffset);
                    Assert.assertEquals((long)Message$.MODULE$.NoTimestamp(), (long)timestamp);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)producerResponseStatus);
            }
        });
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "topic1", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), "topic3", 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "topic3", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ProducerResponse response2 = producer.send(request);
        Assert.assertNotNull((Object)response2);
        Assert.assertEquals((long)request.correlationId(), (long)response2.correlationId());
        Assert.assertEquals((long)3L, (long)response2.status().size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic1", 0))).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic3", 0))).error());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic1", 0))).offset());
        Assert.assertEquals((long)0L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic3", 0))).offset());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic2", 0))).error());
        Assert.assertEquals((long)-1L, (long)((ProducerResponseStatus)response2.status().apply((Object)new TopicAndPartition("topic2", 0))).offset());
    }

    @Test
    public void testProducerCanTimeout() {
        int timeoutMs = 500;
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())}));
        ProducerRequest request = this.produceRequest("topic1", 0, messages, 1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7());
        server.requestHandlerPool().shutdown();
        long t1 = Time.SYSTEM.milliseconds();
        try {
            producer.send(request);
            throw this.fail("Should have received timeout exception since request handling is stopped.", new Position("SyncProducerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            long t2 = Time.SYSTEM.milliseconds();
            Assert.assertTrue((t2 - t1 >= (long)timeoutMs ? 1 : 0) != 0);
            return;
        }
    }

    @Test
    public void testProduceRequestWithNoResponse() {
        int ackTimeoutMs;
        short ack;
        String clientId;
        int correlationId;
        ProducerRequest emptyRequest;
        KafkaServer server = (KafkaServer)this.servers().head();
        int port = TestUtils$.MODULE$.boundPort(server, TestUtils$.MODULE$.boundPort$default$2());
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(port);
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        ProducerResponse response = producer.send(emptyRequest = new ProducerRequest(correlationId = 0, clientId = SyncProducerConfig$.MODULE$.DefaultClientId(), ack = 0, ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs(), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertTrue((response == null ? 1 : 0) != 0);
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties props = TestUtils$.MODULE$.getSyncProducerConfig(this.boundPort(server));
        props.put("request.required.acks", "-1");
        SyncProducer producer = new SyncProducer(new SyncProducerConfig(props));
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", "2");
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, 1, topicProps, AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topicName, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ProducerResponse response = producer.send(this.produceRequest(topicName, 0, new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(this.messageBytes())})), -1, this.produceRequest$default$5(), this.produceRequest$default$6(), this.produceRequest$default$7()));
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)((ProducerResponseStatus)response.status().apply((Object)new TopicAndPartition(topicName, 0))).error());
    }
}

