/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0011%\u00112tiJ\f7\r\u001e'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRD\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"aD\u000b\u000f\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0002\rA\u0013X\rZ3g\u0013\t1rC\u0001\u0004TiJLgn\u001a\u0006\u0003)EAQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtDCA\u000e\u001d!\tI\u0001\u0001C\u0003\u000e1\u0001\u0007a\u0002C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u000b\r|G-Z2\u0016\u0003\u0001\u0002\"!I\u0016\u000e\u0003\tR!a\t\u0013\u0002\rI,7m\u001c:e\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011AF\t\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"1a\u0006\u0001Q\u0001\n\u0001\naaY8eK\u000e\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t!M\u0001\u0005i&lW-F\u00013!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\tAQj\\2l)&lW\r\u0003\u0004:\u0001\u0001\u0006IAM\u0001\u0006i&lW\r\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u001d\u0019w.\u001e8uKJ,\u0012!\u0010\t\u0003!yJ!aP\t\u0003\u0007%sG\u000fC\u0004B\u0001\u0001\u0007I\u0011\u0001\"\u0002\u0017\r|WO\u001c;fe~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"\u0001\u0005#\n\u0005\u0015\u000b\"\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007Q(A\u0002yIEBa!\u0013\u0001!B\u0013i\u0014\u0001C2pk:$XM\u001d\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001N!\r\u0001b\nU\u0005\u0003\u001fF\u0011Q!\u0011:sCf\u0004\"!\u0015*\u000e\u0003\u0011J!a\u0015\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1Q\u000b\u0001Q\u0001\n5\u000b\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000b]\u0003A\u0011\u0001-\u0002\u0017\rdW-\u00198feR+7\u000f\u001e\u000b\u0002\u0007\"\u0012aK\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;&\nQA[;oSRL!a\u0018/\u0003\tQ+7\u000f\u001e\u0005\u0006C\u0002!\t\u0001W\u0001(i\u0016\u001cHo\u00117fC:\u001c8i\\7cS:,GmQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3U_BL7\r\u000b\u0002a5\")A\r\u0001C\u0005K\u0006Y2M]3bi\u0016d\u0015M]4f'&tw\r\\3NKN\u001c\u0018mZ3TKR$2A\u001a7o!\u0011\u0001rMD5\n\u0005!\f\"A\u0002+va2,'\u0007\u0005\u0002\"U&\u00111N\t\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000b5\u001c\u0007\u0019A\u001f\u0002\u0007-,\u0017\u0010C\u0003pG\u0002\u0007\u0001/\u0001\u000bnKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,feNLwN\u001c\t\u0003!EL!A]\t\u0003\t\tKH/\u001a\u0005\u0006i\u0002!\t\u0001W\u0001\u001fi\u0016\u001cHo\u00117fC:,'oV5uQ6+7o]1hK\u001a{'/\\1u-BB#a\u001d.\t\u000b]\u0004A\u0011\u0001-\u0002]Q,7\u000f^\"mK\u0006t\u0017N\\4OKN$X\rZ'fgN\fw-Z:XSRDW*\u001e7uSBdWMV3sg&|gn\u001d\u0015\u0003mjCQA\u001f\u0001\u0005\nm\f\u0001c\u00195fG.d\u0015m\u001d;DY\u0016\fg.\u001a3\u0015\u000b\rch0!\u0001\t\u000buL\b\u0019\u0001\b\u0002\u000bQ|\u0007/[2\t\u000b}L\b\u0019A\u001f\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003\u0007I\b\u0019AA\u0003\u0003)1\u0017N]:u\t&\u0014H/\u001f\t\u0004!\u0005\u001d\u0011bAA\u0005#\t!Aj\u001c8h\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\t!d\u00195fG.dunZ!gi\u0016\u0014\u0018\t\u001d9f]\u0012Lgn\u001a#vaN$raQA\t\u00033\ti\u0002C\u0004\u0004\u0003\u0017\u0001\r!a\u0005\u0011\u0007%\t)\"C\u0002\u0002\u0018\t\u00111\u0001T8h\u0011!\tY\"a\u0003A\u0002\u0005\u0015\u0011!C:uCJ$8+\u001b>f\u0011!\ty\"a\u0003A\u0002\u0005\u0005\u0012aB1qa\u0016tGm\u001d\t\u0007\u0003G\t\u0019$!\u000f\u000f\t\u0005\u0015\u0012q\u0006\b\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u0019#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001b\u0003o\u00111aU3r\u0015\r\t\t$\u0005\t\b!\u0005mRHDA\u0003\u0013\r\ti$\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005)Ao\\'baR!\u0011QIA*!\u001d\t9%!\u0014>\u0003#j!!!\u0013\u000b\u0007\u0005-\u0013#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0014\u0002J\t\u0019Q*\u00199\u0011\u000bA9g\"!\u0002\t\u0011\u0005U\u0013q\ba\u0001\u0003/\n\u0001\"\\3tg\u0006<Wm\u001d\t\u0007\u0003\u000f\nI&!\u000f\n\t\u0005m\u0013\u0011\n\u0002\t\u0013R,'/\u00192mK\"9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014a\u0003:fC\u00124%o\\7M_\u001e$B!a\u0016\u0002d!91!!\u0018A\u0002\u0005M\u0001bBA4\u0001\u0011%\u0011\u0011N\u0001\noJLG/\u001a#vaN$b\"!\t\u0002l\u0005=\u00141OA;\u0003o\nY\bC\u0004\u0002n\u0005\u0015\u0004\u0019A\u001f\u0002\u000f9,XnS3zg\"9\u0011\u0011OA3\u0001\u0004i\u0014a\u00028v[\u0012+\bo\u001d\u0005\b\u0007\u0005\u0015\u0004\u0019AA\n\u0011\u0019q\u0012Q\ra\u0001A!I\u0011\u0011PA3!\u0003\u0005\r!P\u0001\tgR\f'\u000f^&fs\"I\u0011QPA3!\u0003\u0005\r\u0001]\u0001\u000b[\u0006<\u0017n\u0019,bYV,\u0007bBAA\u0001\u0011%\u00111Q\u0001\u001aoJLG/\u001a#vaN\u001c\u0016N\\4mK6+7o]1hKN+G\u000f\u0006\b\u0002\"\u0005\u0015\u0015qQAE\u0003\u0017\u000bi)a$\t\u000f\u00055\u0014q\u0010a\u0001{!9\u0011\u0011OA@\u0001\u0004i\u0004bB\u0002\u0002\u0000\u0001\u0007\u00111\u0003\u0005\u0007=\u0005}\u0004\u0019\u0001\u0011\t\u0013\u0005e\u0014q\u0010I\u0001\u0002\u0004i\u0004bBA?\u0003\u007f\u0002\r\u0001\u001d\u0005\n\u0003'\u0003\u0011\u0013!C\u0005\u0003+\u000b1c\u001e:ji\u0016$U\u000f]:%I\u00164\u0017-\u001e7uIU*\"!a&+\u0007u\nIj\u000b\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016!C;oG\",7m[3e\u0015\r\t)+E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAU\u0003?\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ti\u000bAI\u0001\n\u0013\ty+A\nxe&$X\rR;qg\u0012\"WMZ1vYR$c'\u0006\u0002\u00022*\u001a\u0001/!'\t\u0013\u0005U\u0006!%A\u0005\n\u0005U\u0015aI<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$C-\u001a4bk2$H%\u000e\u0015\b\u0001\u0005e\u0016QYAd!\u0011\tY,!1\u000e\u0005\u0005u&bAA`9\u00061!/\u001e8oKJLA!a1\u0002>\n9!+\u001e8XSRD\u0017!\u0002<bYV,7EAAe!\u0011\tY-!5\u000e\u0005\u00055'bAAh9\u00069!/\u001e8oKJ\u001c\u0018\u0002BAj\u0003\u001b\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$waBAl\u0005!\u0005\u0011\u0011\\\u0001\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\n\u000374a!\u0001\u0002\t\u0002\u0005u7\u0003BAn\u0003?\u00042\u0001EAq\u0013\r\t\u0019/\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000fe\tY\u000e\"\u0001\u0002hR\u0011\u0011\u0011\u001c\u0005\t\u0003W\fY\u000e\"\u0001\u0002n\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0005\u0005=\bCBAy\u0003w\fy0\u0004\u0002\u0002t*!\u0011Q_A|\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0018\u0001\u00026bm\u0006LA!!@\u0002t\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007Aqe\u0002\u000b\u0003\u0002j\n\r\u0001\u0003\u0002B\u0003\u0005/qAAa\u0002\u0003\u00149!!\u0011\u0002B\t\u001d\u0011\u0011YAa\u0004\u000f\t\u0005\u001d\"QB\u0005\u0002U%\u0011Q,K\u0005\u0004\u0003\u001fd\u0016\u0002\u0002B\u000b\u0003\u001b\fQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002\u0002B\r\u00057\u0011!\u0002U1sC6,G/\u001a:t\u0015\u0011\u0011)\"!4")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private int counter;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$10 = maxMessageSize;
            float x$11 = this.makeCleaner$default$2();
            int x$12 = this.makeCleaner$default$3();
            long x$13 = this.makeCleaner$default$4();
            long x$14 = this.makeCleaner$default$6();
            int x$15 = this.makeCleaner$default$7();
            int x$16 = this.makeCleaner$default$8();
            Properties x$17 = this.makeCleaner$default$9();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$9, x$11, x$12, x$13, x$10, x$14, x$15, x$16, x$17));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3());
            long largeMessageOffset = appendInfo.firstOffset();
            int x$18 = largeMessageKey + 1;
            int x$19 = 100;
            int x$20 = 3;
            Log x$21 = log2;
            CompressionType x$22 = this.codec();
            byte x$23 = this.writeDups$default$6();
            Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$19, x$20, x$21, x$22, x$18, x$23);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            Log log2;
            Log log3;
            Log log4 = log3 = (log2 = (Log)tuple2._1());
            log4.logSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final Path apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log4){
                public static final long serialVersionUID = 0L;
                private final Log log$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$2.numberOfSegments() == 1;
                }
                {
                    this.log$2 = log$2;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There should only be 1 segment remaining";
                }
            }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log4.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                Log log22 = (Log)tuple22._1();
                Seq messages = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages);
                Log log23 = (Log)tuple24._1();
                Seq messages2 = (Seq)tuple24._2();
                Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = this.messageValue$1(128);
        byte[] x$33 = value.getBytes();
        CompressionType x$34 = this.codec();
        byte[] x$35 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$36 = messageFormatVersion;
        long x$37 = TestUtils$.MODULE$.singletonRecords$default$4();
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$33, x$35, x$34, x$37, x$36);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            CompressionType compressionType = this.codec();
            int n = CompressionType.NONE.equals(compressionType) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            WrappedArray x$38 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$39 = maxMessageSize;
            float x$40 = this.makeCleaner$default$2();
            int x$41 = this.makeCleaner$default$3();
            long x$42 = this.makeCleaner$default$4();
            long x$43 = this.makeCleaner$default$6();
            int x$44 = this.makeCleaner$default$7();
            int x$45 = this.makeCleaner$default$8();
            Properties x$46 = this.makeCleaner$default$9();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$38, x$40, x$41, x$42, x$39, x$43, x$44, x$45, x$46));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            int x$47 = maxMessageSize;
            Properties x$48 = this.logConfigProperties$default$1();
            float x$49 = this.logConfigProperties$default$3();
            long x$50 = this.logConfigProperties$default$4();
            int x$51 = this.logConfigProperties$default$5();
            int x$52 = this.logConfigProperties$default$6();
            Properties props = this.logConfigProperties(x$48, x$47, x$49, x$50, x$51, x$52);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props));
            int x$53 = 100;
            int x$54 = 3;
            Log x$55 = log2;
            CompressionType x$56 = this.codec();
            byte x$57 = 0;
            int x$58 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$53, x$54, x$55, x$56, x$58, x$57);
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$7) {
                    return x$7.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            int x$59 = 40;
            int x$60 = 3;
            Log x$61 = log2;
            CompressionType x$62 = this.codec();
            byte x$63 = 0;
            int x$64 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$59, x$60, x$61, x$62, x$64, x$63);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3());
            long largeMessageOffset = appendInfo.firstOffset();
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props));
            int x$65 = 30;
            int x$66 = 40;
            int x$67 = 3;
            Log x$68 = log2;
            CompressionType x$69 = this.codec();
            byte x$70 = 1;
            Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$66, x$67, x$68, x$69, x$65, x$70);
            int x$71 = 15;
            int x$72 = 5;
            int x$73 = 3;
            Log x$74 = log2;
            CompressionType x$75 = this.codec();
            byte x$76 = 2;
            Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$72, x$73, x$74, x$75, x$71, x$76);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        int maxMessageSize = 192;
        WrappedArray x$77 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$78 = maxMessageSize;
        float x$79 = this.makeCleaner$default$2();
        int x$80 = this.makeCleaner$default$3();
        long x$81 = this.makeCleaner$default$4();
        long x$82 = this.makeCleaner$default$6();
        int x$83 = this.makeCleaner$default$7();
        int x$84 = this.makeCleaner$default$8();
        Properties x$85 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$77, x$79, x$80, x$81, x$78, x$82, x$83, x$84, x$85));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$86 = maxMessageSize;
        Properties x$87 = this.logConfigProperties$default$1();
        float x$88 = this.logConfigProperties$default$3();
        long x$89 = this.logConfigProperties$default$4();
        int x$90 = this.logConfigProperties$default$5();
        int x$91 = this.logConfigProperties$default$6();
        Properties props = this.logConfigProperties(x$87, x$86, x$88, x$89, x$90, x$91);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props));
        int x$92 = 2;
        int x$93 = 3;
        Log x$94 = log2;
        CompressionType x$95 = this.codec();
        byte x$96 = 0;
        int x$97 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$92, x$93, x$94, x$95, x$97, x$96);
        int x$98 = 2;
        int x$99 = 3;
        int x$100 = 2;
        Log x$101 = log2;
        CompressionType x$102 = this.codec();
        byte x$103 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$98, x$100, x$101, x$102, x$99, x$103), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props));
        int x$104 = 4;
        int x$105 = 2;
        int x$106 = 2;
        Log x$107 = log2;
        CompressionType x$108 = this.codec();
        byte x$109 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$105, x$106, x$107, x$108, x$104, x$109);
        int x$110 = 4;
        int x$111 = 2;
        int x$112 = 2;
        Log x$113 = log2;
        CompressionType x$114 = this.codec();
        byte x$115 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$111, x$112, x$113, x$114, x$110, x$115), Seq$.MODULE$.canBuildFrom());
        int x$116 = 6;
        int x$117 = 2;
        int x$118 = 2;
        Log x$119 = log2;
        CompressionType x$120 = this.codec();
        byte x$121 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$117, x$118, x$119, x$120, x$116, x$121), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log2.size();
        this.cleaner().startup();
        long firstDirty = log2.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$122 = topicPartition;
        long x$123 = firstDirty;
        long x$124 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$122, x$123, x$124);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log2, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log2.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, Object>> apply(Tuple3<Object, String, Object> x0$1) {
                Tuple3<Object, String, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String value = (String)tuple3._2();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, String, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, String, Object> apply(Record deepLogEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, Log log2, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, startKey, magicValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            private final int startKey$1;
            public final byte magicValue$1;

            public final IndexedSeq<Tuple3<Object, String, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple3<Object, String, Object> apply(int key) {
                        String value = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        byte[] x$125 = value.toString().getBytes();
                        CompressionType x$126 = this.$outer.codec$1;
                        byte[] x$127 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        byte x$128 = this.$outer.magicValue$1;
                        long x$129 = TestUtils$.MODULE$.singletonRecords$default$4();
                        LogAppendInfo appendInfo = this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$125, x$127, x$126, x$129, x$128), 0, this.$outer.log$1.appendAsLeader$default$3());
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.startKey$1 = startKey$1;
                this.magicValue$1 = magicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return 2;
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log2, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$2;
            private final int startKey$2;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$2), this.startKey$2 + this.numKeys$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$2 = numKeys$2;
                this.startKey$2 = startKey$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records2 = (IndexedSeq)kvs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log2.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log2.appendAsLeader$default$3());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(Tuple2<Tuple2<Object, String>, Object> x0$3) {
                Tuple2<Tuple2<Object, String>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 kv = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$24 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()).take(1));
        Properties x$25 = logProps$1;
        long x$26 = 100L;
        float x$27 = this.makeCleaner$default$2();
        int x$28 = this.makeCleaner$default$3();
        int x$29 = this.makeCleaner$default$5();
        long x$30 = this.makeCleaner$default$6();
        int x$31 = this.makeCleaner$default$7();
        int x$32 = this.makeCleaner$default$8();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$24, x$27, x$28, x$26, x$29, x$30, x$31, x$32, x$25));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log2.size();
        log2.onHighWatermarkIncremented(log2.logEndOffset());
        long firstDirty = log2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log2, messages);
    }

    private final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.counter = 0;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

