/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001\u001d\u0011!dU3sm\u0016\u0014x)\u001a8fe\u0006$XM\u0011:pW\u0016\u0014\u0018\n\u001a+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0005i\\\u0017BA\u0007\u000b\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003\u0019\u0001(o\u001c9tcU\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!Q\u000f^5m\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004 \u0001\u0001\u0007I\u0011\u0001\u0011\u0002\u0015A\u0014x\u000e]:2?\u0012*\u0017\u000f\u0006\u0002\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t!QK\\5u\u0011\u001dAc$!AA\u0002Y\t1\u0001\u001f\u00132\u0011\u0019Q\u0003\u0001)Q\u0005-\u00059\u0001O]8qgF\u0002\u0003b\u0002\u0017\u0001\u0001\u0004%\t!L\u0001\bG>tg-[42+\u0005q\u0003C\u0001\n0\u0013\t\u0001$AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002\u001a\u0001\u0001\u0004%\taM\u0001\fG>tg-[42?\u0012*\u0017\u000f\u0006\u0002\"i!9\u0001&MA\u0001\u0002\u0004q\u0003B\u0002\u001c\u0001A\u0003&a&\u0001\u0005d_:4\u0017nZ\u0019!\u0011\u001dA\u0004\u00011A\u0005\u0002U\ta\u0001\u001d:paN\u0014\u0004b\u0002\u001e\u0001\u0001\u0004%\taO\u0001\u000baJ|\u0007o\u001d\u001a`I\u0015\fHCA\u0011=\u0011\u001dA\u0013(!AA\u0002YAaA\u0010\u0001!B\u00131\u0012a\u00029s_B\u001c(\u0007\t\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001.\u0003\u001d\u0019wN\u001c4jOJBqA\u0011\u0001A\u0002\u0013\u00051)A\u0006d_:4\u0017n\u001a\u001a`I\u0015\fHCA\u0011E\u0011\u001dA\u0013)!AA\u00029BaA\u0012\u0001!B\u0013q\u0013\u0001C2p]\u001aLwM\r\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006\u0019\"M]8lKJlU\r^1Qe>\u00048OR5mKV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N5\u0005!A.\u00198h\u0013\tyEJ\u0001\u0004TiJLgn\u001a\u0005\u0007#\u0002\u0001\u000b\u0011\u0002&\u0002)\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3!\u0011\u001d\u0019\u0006\u00011A\u0005\u0002Q\u000bqa]3sm\u0016\u00148/F\u0001V!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013BA/$\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^GA\u0011!CY\u0005\u0003G\n\u00111bS1gW\u0006\u001cVM\u001d<fe\"9Q\r\u0001a\u0001\n\u00031\u0017aC:feZ,'o]0%KF$\"!I4\t\u000f!\"\u0017\u0011!a\u0001+\"1\u0011\u000e\u0001Q!\nU\u000b\u0001b]3sm\u0016\u00148\u000f\t\u0005\u0006W\u0002!\t\u0005\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002C!\u0012!N\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fQA[;oSRT\u0011a]\u0001\u0004_J<\u0017BA;q\u0005\u0019\u0011UMZ8sK\")q\u000f\u0001C!Y\u0006AA/Z1s\t><h\u000e\u000b\u0002wsB\u0011qN_\u0005\u0003wB\u0014Q!\u00114uKJDQ! \u0001\u0005\u00021\f\u0001\u0004^3ti\u0006+Ho\\$f]\u0016\u0014\u0018\r^3Ce>\\WM]%eQ\tax\u0010E\u0002p\u0003\u0003I1!a\u0001q\u0005\u0011!Vm\u001d;\t\r\u0005\u001d\u0001\u0001\"\u0001m\u0003\t\"Xm\u001d;Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u001a\u0011QA@\t\r\u00055\u0001\u0001\"\u0001m\u0003q!Xm\u001d;ESN\f'\r\\3HK:,'/\u0019;fI\n\u0013xn[3s\u0013\u0012D3!a\u0003\u0000\u0011\u0019\t\u0019\u0002\u0001C\u0001Y\u0006aB/Z:u\u001bVdG/\u001b9mK2{w\rR5sg6+G/\u0019)s_B\u001c\bfAA\t\u007f\"1\u0011\u0011\u0004\u0001\u0005\u00021\f\u0001\u0007^3ti\u000e{gn]5ti\u0016tGO\u0011:pW\u0016\u0014\u0018\n\u001a$s_6,6/\u001a:D_:4\u0017nZ!oI6+G/\u0019)s_B\u001c\bfAA\f\u007f\"1\u0011q\u0004\u0001\u0005\u00021\fq\u0004^3ti\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC>s\u0017\nZ\"pY2L7/[8oQ\r\tib \u0005\b\u0003K\u0001A\u0011AA\u0014\u0003Q1XM]5gs\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR1\u0011\u0011FA\u0018\u0003\u0003\u00022AIA\u0016\u0013\r\tic\t\u0002\b\u0005>|G.Z1o\u0011!\t\t$a\tA\u0002\u0005M\u0012a\u00027pO\u0012K'o\u001d\t\u0005-z\u000b)\u0004\u0005\u0003\u00028\u0005ubb\u0001\u0012\u0002:%\u0019\u00111H\u0012\u0002\rA\u0013X\rZ3g\u0013\ry\u0015q\b\u0006\u0004\u0003w\u0019\u0003\u0002CA\"\u0003G\u0001\r!!\u0012\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042AIA$\u0013\r\tIe\t\u0002\u0004\u0013:$\bBBA'\u0001\u0011\u0005A.A\fuKN$x)\u001a;TKF,XM\\2f\u0013\u0012lU\r\u001e5pI\"\u001a\u00111J@")
public class ServerGenerateBrokerIdTest
extends ZooKeeperTestHarness {
    private Properties props1 = null;
    private KafkaConfig config1 = null;
    private Properties props2 = null;
    private KafkaConfig config2 = null;
    private final String brokerMetaPropsFile;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateBrokerId() {
        KafkaConfig x$2 = this.config1();
        Option x$3 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$5 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$2, x$4, x$3, x$5);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server1.shutdown();
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$6 = this.config1();
        Option x$7 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$9 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$6, x$8, x$7, x$9);
        KafkaConfig x$10 = this.config2();
        Option x$11 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$12 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$13 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server2 = new KafkaServer(x$10, x$12, x$11, x$13);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaServer server3 = new KafkaServer(KafkaConfig$.MODULE$.fromProps(props3), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server1.startup();
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server2.startup();
        Assert.assertEquals((long)server2.config().brokerId(), (long)0L);
        server3.startup();
        Assert.assertEquals((long)server3.config().brokerId(), (long)1002L);
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3}))));
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void testDisableGeneratedBrokerId() {
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = TestUtils$.MODULE$.createServer(config3, TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server3}))));
        Assert.assertEquals((long)server3.config().brokerId(), (long)3L);
        server3.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder().append((Object)this.props1().getProperty("log.dir")).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$14 = this.config1();
        Option x$15 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$16 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$17 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$14, x$16, x$15, x$17);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder().append((Object)this.props1().getProperty("log.dir")).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$18 = this.config1();
        Option x$19 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$20 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$21 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$18, x$20, x$19, x$21);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$22 = this.config1();
        Option x$23 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$24 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$25 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$22, x$24, x$23, x$25);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        KafkaConfig x$26 = this.config2();
        Option x$27 = Option$.MODULE$.apply((Object)((Object)((Object)this)).getClass().getName());
        Time x$28 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$29 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$26, x$28, x$27, x$29);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    @Test
    public void testBrokerMetadataOnIdCollision() {
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        KafkaServer serverA = TestUtils$.MODULE$.createServer(configA, TestUtils$.MODULE$.createServer$default$2());
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer serverB = new KafkaServer(configB, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        this.intercept((Function0)new Serializable(this, serverB){
            public static final long serialVersionUID = 0L;
            private final KafkaServer serverB$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.serverB$1.startup();
            }
            {
                this.serverB$1 = serverB$1;
            }
        }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ServerGenerateBrokerIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{serverA}))));
        serverB.config().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerGenerateBrokerIdTest $outer;

            public final void apply(String logDir) {
                File brokerMetaFile = new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.$outer.brokerMetaPropsFile()).toString());
                Assert.assertFalse((boolean)brokerMetaFile.exists());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer newServerB = TestUtils$.MODULE$.createServer(newConfigB, TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{serverA, newServerB}))));
        serverA.shutdown();
        newServerB.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(((Object)((Object)this)).getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                logDirs.foreach((Function1)new Serializable(this, brokerId, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ServerGenerateBrokerIdTest $outer;
                    private final int brokerId$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String logDir) {
                        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.$outer.brokerMetaPropsFile()).toString())).read();
                        Option option = brokerMetadataOpt;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            BrokerMetadata brokerMetadata = (BrokerMetadata)some.x();
                            if (brokerMetadata.brokerId() != this.brokerId$1) {
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.brokerId$1 = brokerId$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    @Test
    public void testGetSequenceIdMethod() {
        String path = "/test/seqid";
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerGenerateBrokerIdTest $outer;
            private final String path$1;

            public final void apply(int seqid) {
                this.apply$mcVI$sp(seqid);
            }

            public void apply$mcVI$sp(int seqid) {
                ZkUtils qual$1 = this.$outer.zkUtils();
                String x$30 = this.path$1;
                List x$31 = qual$1.getSequenceId$default$2();
                Assert.assertEquals((long)seqid, (long)qual$1.getSequenceId(x$30, x$31));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        });
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

