/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.File;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001\u0013\tiB*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$h)\u001b7f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y1\r[3dWB|\u0017N\u001c;t\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b)A\u00111BE\u0007\u0002\u0019)\u0011QBD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001fA\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003E\t1a\u001c:h\u0013\t\u0019BB\u0001\u0006K+:LGoU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAQ\u0001\t\u0001\u0005\u0002\u0005\nae\u001d5pk2$\u0007+\u001a:tSN$\u0018I\u001c3Pm\u0016\u0014xO]5uK\u0006sGMU3m_\u0006$g)\u001b7f)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#aH\u0015\u0011\u0005)bS\"A\u0016\u000b\u00055\u0001\u0012BA\u0017,\u0005\u0011!Vm\u001d;\t\u000b=\u0002A\u0011A\u0011\u0002[MDw.\u001e7e%\u0016$\u0018-\u001b8WC2,Xm]#wK:Lem\u00115fG.\u0004x.\u001b8u\u0013N\u0014Vm\u0019:fCR,G\r\u000b\u0002/S\u0001")
public class LeaderEpochCheckpointFileTest
extends JUnitSuite
implements Logging {
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LeaderEpochCheckpointFileTest leaderEpochCheckpointFileTest = this;
        synchronized (leaderEpochCheckpointFileTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        File file = File.createTempFile("temp-checkpoint-file", ((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString());
        file.deleteOnExit();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Seq epochs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 1L), new EpochEntry(1, 2L), new EpochEntry(2, 3L)}));
        checkpoint.write(epochs);
        Assert.assertEquals((Object)epochs, (Object)checkpoint.read());
        Seq epochs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 4L), new EpochEntry(4, 5L)}));
        checkpoint.write(epochs2);
        Assert.assertEquals((Object)epochs2, (Object)checkpoint.read());
    }

    @Test
    public void shouldRetainValuesEvenIfCheckpointIsRecreated() {
        File file = File.createTempFile("temp-checkpoint-file", ((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString());
        file.deleteOnExit();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Seq epochs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 1L), new EpochEntry(1, 2L), new EpochEntry(2, 3L)}));
        checkpoint.write(epochs);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)epochs, (Object)checkpoint2.read());
    }

    public LeaderEpochCheckpointFileTest() {
        Logging.class.$init$((Logging)this);
    }
}

