/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.StateChangeLogger;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011!Q\u0002A!A!\u0002\u0013Y\u0012!E:uCR,7\t[1oO\u0016dunZ4feB\u0011a\u0003H\u0005\u0003;\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011EI\u0012\u0011\u0005Y\u0001\u0001\"B\u0002\u001f\u0001\u0004)\u0002\"\u0002\u000e\u001f\u0001\u0004Y\u0002bB\u0013\u0001\u0005\u0004%IAJ\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\u0014\u0011\u0005YA\u0013BA\u0015\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007W\u0001\u0001\u000b\u0011B\u0014\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u00031\u0019wN\u001c;s_2dWM]%e+\u0005y\u0003CA\u00051\u0013\t\t$BA\u0002J]RDaa\r\u0001!\u0002\u0013y\u0013!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u000fi\\W\u000b^5mgV\tq\u0007\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\b5.,F/\u001b7t\u0011\u0019Y\u0004\u0001)A\u0005o\u0005A!p[+uS2\u001c\b\u0005C\u0004>\u0001\t\u0007I\u0011\u0002 \u0002\u0019I,\u0007\u000f\\5dCN#\u0018\r^3\u0016\u0003}\u0002B\u0001Q#H\u00156\t\u0011I\u0003\u0002C\u0007\u00069Q.\u001e;bE2,'B\u0001#\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u0006\u00131!T1q!\t1\u0002*\u0003\u0002J\u0005\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dCB\u0011acS\u0005\u0003\u0019\n\u0011ABU3qY&\u001c\u0017m\u0015;bi\u0016DaA\u0014\u0001!\u0002\u0013y\u0014!\u0004:fa2L7-Y*uCR,\u0007\u0005C\u0004Q\u0001\t\u0007I\u0011B)\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002%B\u0011acU\u0005\u0003)\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004W\u0001\u0001\u0006IAU\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\u00061\u0002!\t!W\u0001\bgR\f'\u000f^;q)\u0005Q\u0006CA\u0005\\\u0013\ta&B\u0001\u0003V]&$\b\"\u00020\u0001\t\u0003I\u0016\u0001C:ikR$wn\u001e8\t\u000b\u0001\u0004A\u0011A1\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u00055\nD'\u000eC\u0003d?\u0002\u0007A-\u0001\u0005sKBd\u0017nY1t!\r)gmR\u0007\u0002\u0007&\u0011qm\u0011\u0002\u0004'\u0016$\b\"B5`\u0001\u0004Q\u0015a\u0003;be\u001e,Go\u0015;bi\u0016Dqa[0\u0011\u0002\u0003\u0007A.A\u0005dC2d'-Y2lgB\u0011a#\\\u0005\u0003]\n\u0011\u0011bQ1mY\n\f7m[:\t\u000bA\u0004A\u0011A9\u0002#!\fg\u000e\u001a7f'R\fG/Z\"iC:<W\r\u0006\u0003[eR,\b\"B:p\u0001\u00049\u0015a\u00059beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007\"B5p\u0001\u0004Q\u0005\"B6p\u0001\u0004a\u0007\"B<\u0001\t\u0003A\u0018!H1sK\u0006cGNU3qY&\u001c\u0017m\u001d$peR{\u0007/[2EK2,G/\u001a3\u0015\u0005ed\bCA\u0005{\u0013\tY(BA\u0004C_>dW-\u00198\t\u000bu4\b\u0019\u0001@\u0002\u000bQ|\u0007/[2\u0011\u0007}\f)AD\u0002\n\u0003\u0003I1!a\u0001\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0001\u0006\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u0005I\u0013n]!u\u0019\u0016\f7\u000f^(oKJ+\u0007\u000f\\5dC&sG)\u001a7fi&|gn\u0015;beR,Gm\u0015;bi\u0016$2!_A\t\u0011\u0019i\u00181\u0002a\u0001}\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011a\u0004:fa2L7-Y:J]N#\u0018\r^3\u0015\u000b\u0011\fI\"a\u0007\t\ru\f\u0019\u00021\u0001\u007f\u0011\u001d\ti\"a\u0005A\u0002)\u000bQa\u001d;bi\u0016Dq!!\t\u0001\t\u0003\t\u0019#A\njg\u0006s\u0017PU3qY&\u001c\u0017-\u00138Ti\u0006$X\rF\u0003z\u0003K\t9\u0003\u0003\u0004~\u0003?\u0001\rA \u0005\b\u0003;\ty\u00021\u0001K\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\t\u0001D]3qY&\u001c\u0017m]%o\t\u0016dW\r^5p]N#\u0018\r^3t)\r!\u0017q\u0006\u0005\u0007{\u0006%\u0002\u0019\u0001@\t\u000f\u0005M\u0002\u0001\"\u0003\u00026\u0005)\u0012m]:feR4\u0016\r\\5e)J\fgn]5uS>tG#\u0002.\u00028\u0005e\u0002BB:\u00022\u0001\u0007q\t\u0003\u0004j\u0003c\u0001\rA\u0013\u0005\u0007\u0003{\u0001A\u0011B-\u0002-%t\u0017\u000e^5bY&TXMU3qY&\u001c\u0017m\u0015;bi\u0016Dq!!\u0011\u0001\t\u0003\t\u0019%\u0001\u000eqCJ$\u0018\u000e^5p]N\f5o]5h]\u0016$Gk\u001c\"s_.,'\u000f\u0006\u0004\u0002F\u0005]\u0013Q\f\t\u0006K\u0006\u001d\u00131J\u0005\u0004\u0003\u0013\u001a%aA*fcB!\u0011QJA*\u001b\t\tyEC\u0002\u0002R\u0011\taaY8n[>t\u0017\u0002BA+\u0003\u001f\u0012\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\tI&a\u0010A\u0002\u0005m\u0013A\u0002;pa&\u001c7\u000f\u0005\u0003f\u0003\u000fr\bbBA0\u0003\u007f\u0001\raL\u0001\tEJ|7.\u001a:JI\"I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011QM\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9GK\u0002m\u0003SZ#!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003kR\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011PA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplicaStateMachine
implements Logging {
    private final KafkaController controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<PartitionAndReplica, ReplicaState> kafka$controller$ReplicaStateMachine$$replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Map<PartitionAndReplica, ReplicaState> kafka$controller$ReplicaStateMachine$$replicaState() {
        return this.kafka$controller$ReplicaStateMachine$$replicaState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public void startup() {
        this.initializeReplicaState();
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$replicaState().clear();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped replica state machine";
            }
        });
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, replicas, targetState){
                public static final long serialVersionUID = 0L;
                private final Set replicas$1;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
                }
                {
                    this.replicas$1 = replicas$1;
                    this.targetState$1 = targetState$1;
                }
            });
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1)new Serializable(this, targetState, callbacks){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final ReplicaState targetState$1;
                    private final Callbacks callbacks$1;

                    public final void apply(PartitionAndReplica r) {
                        this.$outer.handleStateChange(r, this.targetState$1, this.callbacks$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$1 = targetState$1;
                        this.callbacks$1 = callbacks$1;
                    }
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, targetState){
                    public static final long serialVersionUID = 0L;
                    private final ReplicaState targetState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                    }
                    {
                        this.targetState$1 = targetState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block15: {
            String topic = partitionAndReplica.topic();
            int partition = partitionAndReplica.partition();
            int replicaId = partitionAndReplica.replica();
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            ReplicaState currState = (ReplicaState)this.kafka$controller$ReplicaStateMachine$$replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final NonExistentReplica$ apply() {
                    return NonExistentReplica$.MODULE$;
                }
            });
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controller.epoch());
            try {
                ReplicaState replicaState;
                block26: {
                    Option option;
                    block32: {
                        boolean bl;
                        block31: {
                            block27: {
                                Option<LeaderIsrAndControllerEpoch> option2;
                                block30: {
                                    boolean bl2;
                                    block29: {
                                        block28: {
                                            Seq replicaAssignment;
                                            block20: {
                                                Option option3;
                                                block25: {
                                                    block22: {
                                                        block24: {
                                                            block23: {
                                                                block21: {
                                                                    block16: {
                                                                        Option<LeaderIsrAndControllerEpoch> option4;
                                                                        block19: {
                                                                            block18: {
                                                                                block17: {
                                                                                    replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                                    this.assertValidTransition(partitionAndReplica, targetState);
                                                                                    replicaState = targetState;
                                                                                    if (!NewReplica$.MODULE$.equals(replicaState)) break block16;
                                                                                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
                                                                                    option4 = leaderIsrAndControllerEpochOpt;
                                                                                    if (!(option4 instanceof Some)) break block17;
                                                                                    Some some = (Some)option4;
                                                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                                                                                        throw new StateChangeFailedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " for partition ", " cannot "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be moved to NewReplica state as it is being requested to become leader"})).s((Seq)Nil$.MODULE$)).toString());
                                                                                    }
                                                                                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, true);
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    break block18;
                                                                                }
                                                                                if (!None$.MODULE$.equals(option4)) break block19;
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            }
                                                                            this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                            this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block15;
                                                                        }
                                                                        throw new MatchError(option4);
                                                                    }
                                                                    if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                        this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                                                                        this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                        this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                        this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (NonExistentReplica$.MODULE$.equals(replicaState)) {
                                                                        Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final int replicaId$1;

                                                                            public final boolean apply(int x$1) {
                                                                                return this.apply$mcZI$sp(x$1);
                                                                            }

                                                                            public boolean apply$mcZI$sp(int x$1) {
                                                                                return x$1 == this.replicaId$1;
                                                                            }
                                                                            {
                                                                                this.replicaId$1 = replicaId$1;
                                                                            }
                                                                        }));
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().remove((Object)partitionAndReplica);
                                                                        this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (!OnlineReplica$.MODULE$.equals(replicaState)) break block20;
                                                                    ReplicaState replicaState2 = (ReplicaState)this.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)partitionAndReplica);
                                                                    if (!NewReplica$.MODULE$.equals(replicaState2)) break block21;
                                                                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                    Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom()));
                                                                    this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block22;
                                                                }
                                                                option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                                if (!(option3 instanceof Some)) break block23;
                                                                Some some = (Some)option3;
                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                                this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block24;
                                                            }
                                                            if (!None$.MODULE$.equals(option3)) break block25;
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block15;
                                                }
                                                throw new MatchError((Object)option3);
                                            }
                                            if (!OfflineReplica$.MODULE$.equals(replicaState)) break block26;
                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                            option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                            if (!(option instanceof Some)) break block27;
                                            option2 = this.controller.removeReplicaFromIsr(topic, partition, replicaId);
                                            if (!(option2 instanceof Some)) break block28;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                            if (!this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int replicaId$1;

                                                    public final boolean apply(int x$2) {
                                                        return this.apply$mcZI$sp(x$2);
                                                    }

                                                    public boolean apply$mcZI$sp(int x$2) {
                                                        return x$2 == this.replicaId$1;
                                                    }
                                                    {
                                                        this.replicaId$1 = replicaId$1;
                                                    }
                                                })), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                            }
                                            this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                            this.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                                            bl2 = false;
                                            break block29;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block30;
                                        bl2 = true;
                                    }
                                    bl = bl2;
                                    break block31;
                                }
                                throw new MatchError(option2);
                            }
                            if (!None$.MODULE$.equals(option)) break block32;
                            bl = true;
                        }
                        boolean leaderAndIsrIsEmpty = bl;
                        if (leaderAndIsrIsEmpty && !this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                            throw new StateChangeFailedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change state of replica ", " for partition ", " since the leader "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and isr path in zookeeper is empty"})).s((Seq)Nil$.MODULE$)).toString());
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block15;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)replicaState);
            }
            catch (Throwable throwable) {
                stateChangeLog.error((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                    public static final long serialVersionUID = 0L;
                    private final ReplicaState targetState$2;
                    private final int replicaId$1;
                    private final TopicAndPartition topicAndPartition$1;
                    private final ReplicaState currState$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initiated state change of replica ", " for partition ", " from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currState$1, this.targetState$2}))).toString();
                    }
                    {
                        this.targetState$2 = targetState$2;
                        this.replicaId$1 = replicaId$1;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)new Serializable(this, topic, replicaStatesForTopic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final scala.collection.immutable.Map replicaStatesForTopic$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are all replicas for topic ", " deleted ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.replicaStatesForTopic$1}));
            }
            {
                this.topic$1 = topic$1;
                this.replicaStatesForTopic$1 = replicaStatesForTopic$1;
            }
        });
        return replicaStatesForTopic.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> x$3) {
                Object object = x$3._2();
                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
            }
        });
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (deletionState) return true;
                Object object = r._2();
                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionStarted$)) return false;
                    return true;
                }
                if (replicaDeletionStarted$ == null) return true;
                return false;
            }
        }));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$replicaState().filter((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final ReplicaState state$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$2)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$1;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$2 = topic$2;
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.kafka$controller$ReplicaStateMachine$$replicaState().exists((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final ReplicaState state$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$3)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$2;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$3 = topic$3;
                this.state$2 = state$2;
            }
        });
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaState[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$replicaState().filter((Function1)new Serializable(this, topic, deletionStates){
            public static final long serialVersionUID = 0L;
            private final String topic$4;
            private final Set deletionStates$1;

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                return ((PartitionAndReplica)r._1()).topic().equals(this.topic$4) && this.deletionStates$1.contains(r._2());
            }
            {
                this.topic$4 = topic$4;
                this.deletionStates$1 = deletionStates$1;
            }
        })).keySet();
    }

    private void assertValidTransition(PartitionAndReplica partitionAndReplica, ReplicaState targetState) {
        Predef$.MODULE$.assert(targetState.validPreviousStates().contains(this.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)partitionAndReplica)), (Function0)new Serializable(this, partitionAndReplica, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final PartitionAndReplica partitionAndReplica$1;
            private final ReplicaState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndReplica$1, this.targetState$3.validPreviousStates().mkString(","), this.targetState$3}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)this.partitionAndReplica$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionAndReplica$1 = partitionAndReplica$1;
                this.targetState$3 = targetState$3;
            }
        });
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> x$4) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x$4;
                if (tuple2 != null) {
                    TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                    Seq assignedReplicas = (Seq)tuple2._2();
                    String topic = topicPartition.topic();
                    int partition = topicPartition.partition();
                    assignedReplicas.foreach((Function1)new Serializable(this, topicPartition, topic, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeReplicaState$2 $outer;
                        private final TopicAndPartition topicPartition$1;
                        private final String topic$5;
                        private final int partition$1;

                        public final Option<ReplicaState> apply(int replicaId) {
                            PartitionAndReplica partitionAndReplica = new PartitionAndReplica(this.topic$5, this.partition$1, replicaId);
                            return this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().isReplicaOnline(replicaId, this.topicPartition$1, this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().isReplicaOnline$default$3()) ? this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topicPartition$1 = topicPartition$1;
                            this.topic$5 = topic$5;
                            this.partition$1 = partition$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x$5) {
                return ((SeqLike)x$5._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).keySet().toSeq();
    }

    private final void logStateChange$1(ReplicaState targetState$2, int replicaId$1, TopicAndPartition topicAndPartition$1, ReplicaState currState$1, StateChangeLogger stateChangeLog$1) {
        stateChangeLog$1.trace((Function0<String>)new Serializable(this, targetState$2, replicaId$1, topicAndPartition$1, currState$1){
            public static final long serialVersionUID = 0L;
            private final ReplicaState targetState$2;
            private final int replicaId$1;
            private final TopicAndPartition topicAndPartition$1;
            private final ReplicaState currState$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed state of replica ", " for partition ", " from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currState$1, this.targetState$2}))).toString();
            }
            {
                this.targetState$2 = targetState$2;
                this.replicaId$1 = replicaId$1;
                this.topicAndPartition$1 = topicAndPartition$1;
                this.currState$1 = currState$1;
            }
        });
    }

    public ReplicaStateMachine(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkUtils();
        this.kafka$controller$ReplicaStateMachine$$replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller, stateChangeLogger);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})));
    }
}

