/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUw!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u00014G\u0004\u0002\u000ec%\u0011!GD\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023\u001d!1q'\u0003C\u0001\u0005a\n1\u0002\u001d:j]RDU-\u00193feR\u0019q%\u000f \t\u000bi2\u0004\u0019A\u001e\u0002#MDwn\u001e#fi\u0006LG.\u001a3Ti\u0006$8\u000f\u0005\u0002\u000ey%\u0011QH\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015yd\u00071\u0001<\u00039)8/Z(mI\u000e{gn];nKJDQ!Q\u0005\u0005\u0002\t\u000bqaY8ogVlW\r\u0006\b(\u0007F{FM\u001aB\u0001\u0005+\u0011IB!\b\t\u000b\u0011\u0003\u0005\u0019A#\u0002\u0011\r|gn];nKJ\u0004BAR&N\u001b6\tqI\u0003\u0002E\u0011*\u0011\u0011JS\u0001\bG2LWM\u001c;t\u0015\t)A$\u0003\u0002M\u000f\ni1*\u00194lC\u000e{gn];nKJ\u00042!D\u0017O!\tiq*\u0003\u0002Q\u001d\t!!)\u001f;f\u0011\u0015\u0011\u0006\t1\u0001T\u0003\u0019!x\u000e]5dgB\u0019A\u000bX\u0018\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\\\u001d\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\u0011a\u0015n\u001d;\u000b\u0005ms\u0001\"\u00021A\u0001\u0004\t\u0017!B2pk:$\bCA\u0007c\u0013\t\u0019gB\u0001\u0003M_:<\u0007\"B3A\u0001\u0004\t\u0017a\u0002;j[\u0016|W\u000f\u001e\u0005\u0006O\u0002\u0003\r\u0001[\u0001\u0007G>tg-[4\u0011\u0005%TW\"A\u0005\u0007\t-L\u0001\u0001\u001c\u0002\u0013\u0007>t7/^7feB+'OZ\"p]\u001aLwm\u0005\u0002k[B\u0011\u0001B\\\u0005\u0003_\n\u0011!\u0002U3sM\u000e{gNZ5h\u0011!Y#N!A!\u0002\u0013a\u0003\"B\nk\t\u0003\u0011HC\u00015t\u0011\u0015Y\u0013\u000f1\u0001-\u0011\u001d)(N1A\u0005\u0002Y\fAB_6D_:tWm\u0019;PaR,\u0012a\u001e\t\u0004qn|S\"A=\u000b\u0003i\f!B[8qiNLW\u000e\u001d7f\u0013\ta\u0018PA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003Xm\u0019\u0005\u0007}*\u0004\u000b\u0011B<\u0002\u001bi\\7i\u001c8oK\u000e$x\n\u001d;!\u0011!\t\tA\u001bb\u0001\n\u00031\u0018a\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t\u001fB$\bbBA\u0003U\u0002\u0006Ia^\u0001\u0015E>|Go\u001d;sCB\u001cVM\u001d<feN|\u0005\u000f\u001e\u0011\t\u0011\u0005%!N1A\u0005\u0002Y\f\u0001\u0002^8qS\u000e|\u0005\u000f\u001e\u0005\b\u0003\u001bQ\u0007\u0015!\u0003x\u0003%!x\u000e]5d\u001fB$\b\u0005\u0003\u0005\u0002\u0012)\u0014\r\u0011\"\u0001w\u0003)9'o\\;q\u0013\u0012|\u0005\u000f\u001e\u0005\b\u0003+Q\u0007\u0015!\u0003x\u0003-9'o\\;q\u0013\u0012|\u0005\u000f\u001e\u0011\t\u0013\u0005e!N1A\u0005\u0002\u0005m\u0011\u0001\u00044fi\u000eD7+\u001b>f\u001fB$XCAA\u000f!\u0011A80a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005!A.\u00198h\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u0011q!\u00138uK\u001e,'\u000f\u0003\u0005\u00022)\u0004\u000b\u0011BA\u000f\u000351W\r^2i'&TXm\u00149uA!I\u0011Q\u00076C\u0002\u0013\u0005\u0011qG\u0001\u0018e\u0016\u001cX\r\u001e\"fO&tg.\u001b8h\u001f\u001a47/\u001a;PaR,\"!!\u000f\u0011\u0007a\fY$C\u0002\u0002>e\u0014\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011!\t\tE\u001bQ\u0001\n\u0005e\u0012\u0001\u0007:fg\u0016$()Z4j]:LgnZ(gMN,Go\u00149uA!I\u0011Q\t6C\u0002\u0013\u0005\u00111D\u0001\u0014g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0005\t\u0003\u0013R\u0007\u0015!\u0003\u0002\u001e\u0005!2o\\2lKR\u0014UO\u001a4feNK'0Z(qi\u0002B\u0011\"!\u0014k\u0005\u0004%\t!a\u0007\u0002\u001b9,X\u000e\u00165sK\u0006$7o\u00149u\u0011!\t\tF\u001bQ\u0001\n\u0005u\u0011A\u00048v[RC'/Z1eg>\u0003H\u000f\t\u0005\n\u0003+R'\u0019!C\u0001\u00037\taB\\;n\r\u0016$8\r[3sg>\u0003H\u000f\u0003\u0005\u0002Z)\u0004\u000b\u0011BA\u000f\u0003=qW/\u001c$fi\u000eDWM]:PaR\u0004\u0003\"CA/U\n\u0007I\u0011AA\u001c\u00039qWm^\"p]N,X.\u001a:PaRD\u0001\"!\u0019kA\u0003%\u0011\u0011H\u0001\u0010]\u0016<8i\u001c8tk6,'o\u00149uA!A\u0011Q\r6C\u0002\u0013\u0005a/A\td_:\u001cX/\\3s\u0007>tg-[4PaRDq!!\u001bkA\u0003%q/\u0001\nd_:\u001cX/\\3s\u0007>tg-[4PaR\u0004\u0003\"CA7U\n\u0007I\u0011AA\u001c\u0003=\u0001(/\u001b8u\u001b\u0016$(/[2t\u001fB$\b\u0002CA9U\u0002\u0006I!!\u000f\u0002!A\u0014\u0018N\u001c;NKR\u0014\u0018nY:PaR\u0004\u0003\"CA;U\n\u0007I\u0011AA\u001c\u0003Q\u0019\bn\\<EKR\f\u0017\u000e\\3e'R\fGo](qi\"A\u0011\u0011\u00106!\u0002\u0013\tI$A\u000btQ><H)\u001a;bS2,Gm\u0015;biN|\u0005\u000f\u001e\u0011\t\u0013\u0005u$N1A\u0005\u0002\u0005}\u0014aB8qi&|gn]\u000b\u0003\u0003\u0003\u00032\u0001_AB\u0013\r\t))\u001f\u0002\n\u001fB$\u0018n\u001c8TKRD\u0001\"!#kA\u0003%\u0011\u0011Q\u0001\t_B$\u0018n\u001c8tA!AqH\u001bb\u0001\n\u0003\ti)F\u0001<\u0011\u001d\t\tJ\u001bQ\u0001\nm\nq\"^:f\u001f2$7i\u001c8tk6,'\u000f\t\u0005\n\u0003+S'\u0019!C\u0001\u0003\u001b\u000bA\u0002\u001d:j]RlU\r\u001e:jGNDq!!'kA\u0003%1(A\u0007qe&tG/T3ue&\u001c7\u000f\t\u0005\n\u0003;S'\u0019!C\u0001\u0003?\u000bQ\u0001\u001d:paN,\"!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!a*\u0002(\u0005!Q\u000f^5m\u0013\u0011\tY+!*\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005\u00020*\u0004\u000b\u0011BAQ\u0003\u0019\u0001(o\u001c9tA!I\u00111\u00176C\u0002\u0013\u0005\u0011QW\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001cXCAA\\!\ri\u0011\u0011X\u0005\u0004\u0003ws!aA%oi\"A\u0011q\u00186!\u0002\u0013\t9,A\u0006ok6$\u0006N]3bIN\u0004\u0003\"CAbU\n\u0007I\u0011AAc\u0003\u0015!x\u000e]5d+\u0005y\u0003bBAeU\u0002\u0006IaL\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0013\u00055'N1A\u0005\u0002\u0005=\u0017a\u00038v[6+7o]1hKN,\u0012!\u0019\u0005\b\u0003'T\u0007\u0015!\u0003b\u00031qW/\\'fgN\fw-Z:!\u0011%\t9N\u001bb\u0001\n\u0003\t),A\tsKB|'\u000f^5oO&sG/\u001a:wC2D\u0001\"a7kA\u0003%\u0011qW\u0001\u0013e\u0016\u0004xN\u001d;j]\u001eLe\u000e^3sm\u0006d\u0007\u0005\u0003\u0005;U\n\u0007I\u0011AAG\u0011\u001d\t\tO\u001bQ\u0001\nm\n!c\u001d5po\u0012+G/Y5mK\u0012\u001cF/\u0019;tA!I\u0011Q\u001d6C\u0002\u0013\u0005\u0011q]\u0001\u000bI\u0006$XMR8s[\u0006$XCAAu!\u0011\tY/!=\u000e\u0005\u00055(\u0002BAx\u0003O\tA\u0001^3yi&!\u00111_Aw\u0005A\u0019\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG\u000f\u0003\u0005\u0002x*\u0004\u000b\u0011BAu\u0003-!\u0017\r^3G_Jl\u0017\r\u001e\u0011\t\u0013\u0005m(N1A\u0005\u0002\u00055\u0015A\u00035jI\u0016DU-\u00193fe\"9\u0011q 6!\u0002\u0013Y\u0014a\u00035jI\u0016DU-\u00193fe\u0002BqAa\u0001A\u0001\u0004\u0011)!A\tu_R\fG.T3tg\u0006<Wm\u001d*fC\u0012\u0004BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005\u001f\t)+\u0001\u0006d_:\u001cWO\u001d:f]RLAAa\u0005\u0003\n\tQ\u0011\t^8nS\u000eduN\\4\t\u000f\t]\u0001\t1\u0001\u0003\u0006\u0005qAo\u001c;bY\nKH/Z:SK\u0006$\u0007b\u0002B\u000e\u0001\u0002\u0007!QA\u0001\tU>Lg\u000eV5nK\"1!q\u0004!A\u0002\u0005\fQ\u0002^3tiN#\u0018M\u001d;US6,\u0007b\u0002B\u0012\u0013\u0011\u0005!QE\u0001\u0019aJLg\u000e^(mI\u000e{gn];nKJ\u0004&o\\4sKN\u001cH#E\u0014\u0003(\t-\"q\u0006B\u001a\u0005o\u0011YDa\u0010\u0003D!A!\u0011\u0006B\u0011\u0001\u0004\t9,\u0001\u0002jI\"9!Q\u0006B\u0011\u0001\u0004\t\u0017!\u00032zi\u0016\u001c(+Z1e\u0011\u001d\u0011\tD!\tA\u0002\u0005\fQ\u0002\\1ti\nKH/Z:SK\u0006$\u0007b\u0002B\u001b\u0005C\u0001\r!Y\u0001\r[\u0016\u001c8/Y4fgJ+\u0017\r\u001a\u0005\b\u0005s\u0011\t\u00031\u0001b\u0003Aa\u0017m\u001d;NKN\u001c\u0018mZ3t%\u0016\fG\rC\u0004\u0003>\t\u0005\u0002\u0019A1\u0002\u000fM$\u0018M\u001d;Ng\"9!\u0011\tB\u0011\u0001\u0004\t\u0017!B3oI6\u001b\b\u0002CAs\u0005C\u0001\r!!;\t\u000f\t\u001d\u0013\u0002\"\u0001\u0003J\u0005A\u0002O]5oi:+woQ8ogVlWM\u001d)s_\u001e\u0014Xm]:\u0015'\u001d\u0012YE!\u0014\u0003P\tE#1\u000bB+\u0005/\u0012IFa\u0017\t\u0011\t%\"Q\ta\u0001\u0003oCqA!\f\u0003F\u0001\u0007\u0011\rC\u0004\u00032\t\u0015\u0003\u0019A1\t\u000f\tU\"Q\ta\u0001C\"9!\u0011\bB#\u0001\u0004\t\u0007b\u0002B\u001f\u0005\u000b\u0002\r!\u0019\u0005\b\u0005\u0003\u0012)\u00051\u0001b\u0011!\t)O!\u0012A\u0002\u0005%\bb\u0002B/\u0005\u000b\u0002\r!Y\u0001\u0015a\u0016\u0014\u0018n\u001c3jG*{\u0017N\u001c+j[\u0016Le.T:\t\u000f\t\u0005\u0014\u0002\"\u0003\u0003d\u0005\u0011\u0002O]5oi\n\u000b7/[2Qe><'/Z:t)E9#Q\rB4\u0005S\u0012YG!\u001c\u0003p\tE$1\u000f\u0005\t\u0005S\u0011y\u00061\u0001\u00028\"9!Q\u0006B0\u0001\u0004\t\u0007b\u0002B\u0019\u0005?\u0002\r!\u0019\u0005\b\u0005k\u0011y\u00061\u0001b\u0011\u001d\u0011IDa\u0018A\u0002\u0005DqA!\u0010\u0003`\u0001\u0007\u0011\rC\u0004\u0003B\t}\u0003\u0019A1\t\u0011\u0005\u0015(q\fa\u0001\u0003SDqAa\u001e\n\t\u0013\u0011I(A\u000bqe&tG/\u0012=uK:$W\r\u001a)s_\u001e\u0014Xm]:\u0015\u001f\u001d\u0012YH! \u0003\u0000\t\u0005%1\u0011BC\u0005\u000fCqA!\f\u0003v\u0001\u0007\u0011\rC\u0004\u00032\tU\u0004\u0019A1\t\u000f\tU\"Q\u000fa\u0001C\"9!\u0011\bB;\u0001\u0004\t\u0007b\u0002B\u001f\u0005k\u0002\r!\u0019\u0005\b\u0005\u0003\u0012)\b1\u0001b\u0011\u001d\u0011iF!\u001eA\u0002\u00054aAa#\n\u0001\t5%AE\"p]N,X.\u001a:QKJ4G\u000b\u001b:fC\u0012\u001cBA!#\u0003\u0010B!\u0011\u0011\u0005BI\u0013\u0011\u0011\u0019*a\t\u0003\rQC'/Z1e\u0011-\u00119J!#\u0003\u0002\u0003\u0006I!a.\u0002\u0011QD'/Z1e\u0013\u0012D!Ba'\u0003\n\n\u0005\t\u0015!\u00030\u0003\u0011q\u0017-\\3\t\u0017\t}%\u0011\u0012B\u0001B\u0003%!\u0011U\u0001\u0007gR\u0014X-Y7\u0011\r\t\r&qU'N\u001b\t\u0011)K\u0003\u0002E\t%!!\u0011\u0016BS\u0005-Y\u0015MZ6b'R\u0014X-Y7\t\u0013\u001d\u0014II!A!\u0002\u0013A\u0007b\u0003B\u0002\u0005\u0013\u0013\t\u0011)A\u0005\u0005\u000bA1Ba\u0006\u0003\n\n\u0005\t\u0015!\u0003\u0003\u0006!Y!1\u0017BE\u0005\u0003\u0005\u000b\u0011\u0002B[\u0003=\u0019wN\\:v[\u0016\u0014H+[7f_V$\b\u0003\u0002B\u0004\u0005oKAA!/\u0003\n\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:Dqa\u0005BE\t\u0003\u0011i\f\u0006\t\u0003@\n\u0005'1\u0019Bc\u0005\u000f\u0014IMa3\u0003NB\u0019\u0011N!#\t\u0011\t]%1\u0018a\u0001\u0003oCqAa'\u0003<\u0002\u0007q\u0006\u0003\u0005\u0003 \nm\u0006\u0019\u0001BQ\u0011\u00199'1\u0018a\u0001Q\"A!1\u0001B^\u0001\u0004\u0011)\u0001\u0003\u0005\u0003\u0018\tm\u0006\u0019\u0001B\u0003\u0011!\u0011\u0019La/A\u0002\tU\u0006\u0002\u0003Bi\u0005\u0013#\tEa5\u0002\u0007I,h\u000eF\u0001(\u0001")
public final class ConsumerPerformance {
    public static void printNewConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat, long l7) {
        ConsumerPerformance$.MODULE$.printNewConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat, l7);
    }

    public static void printOldConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printOldConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2, AtomicLong atomicLong3, long l3) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2, atomicLong3, l3);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default, so this option is deprecated and will be removed in a future release.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder printMetricsOpt = this.parser().accepts("print-metrics", "Print out the metrics. This only applies to new consumer.");
        private final OptionSpecBuilder showDetailedStatsOpt = this.parser().accepts("show-detailed-stats", "If set, stats are reported for each reporting interval as configured by reporting-interval");
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final boolean printMetrics;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSpecBuilder printMetricsOpt() {
            return this.printMetricsOpt;
        }

        public OptionSpecBuilder showDetailedStatsOpt() {
            return this.showDetailedStatsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public boolean printMetrics() {
            return this.printMetrics;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            this.printMetrics = this.options().has((OptionSpec)this.printMetricsOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.consumerConfigOpt()))) : new Properties();
            if (this.useOldConsumer()) {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            } else {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    Console$.MODULE$.err().println("The --new-consumer option is deprecated and will be removed in a future major release.The new consumer is used by default if the --bootstrap-server option is provided.");
                }
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter = this.stream.iterator();
                while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = iter.next();
                    ++messagesRead;
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                    if (this.config.showDetailedStats()) {
                        ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                    }
                    lastReportTime = currentTimeMillis;
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
                this.consumerTimeout.set(true);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

