/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.Json$;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015u!B\u0001\u0003\u0011\u00039\u0011a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000bYIA\u0011A\f\u0002\t5\f\u0017N\u001c\u000b\u00031m\u0001\"!D\r\n\u0005iq!\u0001B+oSRDQ\u0001H\u000bA\u0002u\tA!\u0019:hgB\u0019QB\b\u0011\n\u0005}q!!B!se\u0006L\bCA\u0011%\u001d\ti!%\u0003\u0002$\u001d\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019c\u0002C\u0003)\u0013\u0011%\u0011&\u0001\u0007ek6\u0004H\u000b\u001f8J]\u0012,\u0007\u0010\u0006\u0002\u0019U!)1f\na\u0001Y\u0005!a-\u001b7f!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0002j_*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\u00111\u0015\u000e\\3\t\u000bUJA\u0011\u0002\u001c\u0002-\u0011,X\u000e\u001d)s_\u0012,8-\u001a:JINs\u0017\r]:i_R$\"\u0001G\u001c\t\u000b-\"\u0004\u0019\u0001\u0017\t\u000beJA\u0011\u0002\u001e\u0002\u0013\u0011,X\u000e]%oI\u0016DHC\u0002\r<y\u0005\u001bu\fC\u0003,q\u0001\u0007A\u0006C\u0003>q\u0001\u0007a(A\bj]\u0012,\u0007pU1oSRLxJ\u001c7z!\tiq(\u0003\u0002A\u001d\t9!i\\8mK\u0006t\u0007\"\u0002\"9\u0001\u0004q\u0014A\u0003<fe&4\u0017p\u00148ms\")A\t\u000fa\u0001\u000b\u0006QR.[:NCR\u001c\u0007.Z:G_JLe\u000eZ3y\r&dWm]'baB!ai\u0013\u0011N\u001b\u00059%B\u0001%J\u0003\u001diW\u000f^1cY\u0016T!A\u0013\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002M\u000f\n9\u0001*Y:i\u001b\u0006\u0004\bc\u0001(W3:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%\u001a\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005Us\u0011a\u00029bG.\fw-Z\u0005\u0003/b\u0013A\u0001T5ti*\u0011QK\u0004\t\u0005\u001bicF,\u0003\u0002\\\u001d\t1A+\u001e9mKJ\u0002\"!D/\n\u0005ys!\u0001\u0002'p]\u001eDQ\u0001\u0019\u001dA\u0002\u0005\fa\"\\1y\u001b\u0016\u001c8/Y4f'&TX\r\u0005\u0002\u000eE&\u00111M\u0004\u0002\u0004\u0013:$\b\"B3\n\t\u00131\u0017!\u00043v[B$\u0016.\\3J]\u0012,\u0007\u0010F\u0004\u0019O\"L'.!\u0010\t\u000b-\"\u0007\u0019\u0001\u0017\t\u000bu\"\u0007\u0019\u0001 \t\u000b\t#\u0007\u0019\u0001 \t\u000b-$\u0007\u0019\u00017\u0002'QLW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0011\u00055tW\"A\u0005\u0007\t=L\u0001\u0001\u001d\u0002\u0014)&lW-\u00138eKb$U/\u001c9FeJ|'o]\n\u0003]2AQa\u00058\u0005\u0002I$\u0012\u0001\u001c\u0005\bi:\u0014\r\u0011\"\u0001v\u0003yi\u0017n]'bi\u000eDWm\u001d$peRKW.Z%oI\u0016Dh)\u001b7fg6\u000b\u0007/F\u0001w!\u001115\nI<\u0011\u0007\u0019C\u0018,\u0003\u0002z\u000f\nY\u0011I\u001d:bs\n+hMZ3s\u0011\u0019Yh\u000e)A\u0005m\u0006yR.[:NCR\u001c\u0007.Z:G_J$\u0016.\\3J]\u0012,\u0007PR5mKNl\u0015\r\u001d\u0011\t\u000fut'\u0019!C\u0001k\u0006\u0019r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\"1qP\u001cQ\u0001\nY\fAc\\;u\u001f\u001a|%\u000fZ3s)&lWm\u001d;b[B\u0004\u0003\u0002CA\u0002]\n\u0007I\u0011A;\u0002+MD\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oI\"9\u0011q\u00018!\u0002\u00131\u0018AF:iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u0011\t\u000f\u0005-a\u000e\"\u0001\u0002\u000e\u00059\"/Z2pe\u0012l\u0015n]7bi\u000eDG+[7f\u0013:$W\r\u001f\u000b\b1\u0005=\u0011\u0011CA\u000b\u0011\u0019Y\u0013\u0011\u0002a\u0001Y!9\u00111CA\u0005\u0001\u0004a\u0016AD5oI\u0016DH+[7fgR\fW\u000e\u001d\u0005\b\u0003/\tI\u00011\u0001]\u00031awn\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\tYB\u001cC\u0001\u0003;\taD]3d_J$w*\u001e;PM>\u0013H-\u001a:J]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u000fa\ty\"!\t\u0002$!11&!\u0007A\u00021Bq!a\u0005\u0002\u001a\u0001\u0007A\fC\u0004\u0002&\u0005e\u0001\u0019\u0001/\u0002%A\u0014XM^%oI\u0016DH+[7fgR\fW\u000e\u001d\u0005\b\u0003SqG\u0011AA\u0016\u0003m\u0011XmY8sINC\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oIR9\u0001$!\f\u00020\u0005M\u0002BB\u0016\u0002(\u0001\u0007A\u0006C\u0004\u00022\u0005\u001d\u0002\u0019\u0001/\u0002\u0017%tG-\u001a=PM\u001a\u001cX\r\u001e\u0005\b\u0003k\t9\u00031\u0001]\u0003%awnZ(gMN,G\u000fC\u0004\u0002:9$\t!a\u000f\u0002\u0017A\u0014\u0018N\u001c;FeJ|'o\u001d\u000b\u00021!)\u0001\r\u001aa\u0001C\u001aI\u0011\u0011I\u0005\u0011\u0002G%\u00111\t\u0002\u000e\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\u0005\u0015\u0013\u0011LA8'\r\ty\u0004\u0004\u0005\t\u0003\u0013\nyD\"\u0001\u0002L\u0005)\u0001/\u0019:tKR!\u0011QJA:!\u0019i!,a\u0014\u0002lA)Q\"!\u0015\u0002V%\u0019\u00111\u000b\b\u0003\r=\u0003H/[8o!\u0011\t9&!\u0017\r\u0001\u0011A\u00111LA \u0005\u0004\tiFA\u0001L#\u0011\ty&!\u001a\u0011\u00075\t\t'C\u0002\u0002d9\u0011qAT8uQ&tw\rE\u0002\u000e\u0003OJ1!!\u001b\u000f\u0005\r\te.\u001f\t\u0006\u001b\u0005E\u0013Q\u000e\t\u0005\u0003/\ny\u0007\u0002\u0005\u0002r\u0005}\"\u0019AA/\u0005\u00051\u0006\u0002CA;\u0003\u000f\u0002\r!a\u001e\u0002\rI,7m\u001c:e!\u0011\tI(a#\u000e\u0005\u0005m$\u0002BA;\u0003{RA!a \u0002\u0002\u000611m\\7n_:T1!BAB\u0015\u0011\t))a\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI)A\u0002pe\u001eLA!!$\u0002|\t1!+Z2pe\u00124a!!%\n\t\u0005M%\u0001\u0006#fG>$WM]'fgN\fw-\u001a)beN,'/\u0006\u0004\u0002\u0016\u0006m\u0015qT\n\u0006\u0003\u001fc\u0011q\u0013\t\b[\u0006}\u0012\u0011TAO!\u0011\t9&a'\u0005\u0011\u0005m\u0013q\u0012b\u0001\u0003;\u0002B!a\u0016\u0002 \u0012A\u0011\u0011OAH\u0005\u0004\ti\u0006C\u0006\u0002$\u0006=%\u0011!Q\u0001\n\u0005\u0015\u0016AC6fs\u0012+7m\u001c3feB1\u0011qUAW\u00033k!!!+\u000b\u0007\u0005-F!\u0001\u0006tKJL\u0017\r\\5{KJLA!a,\u0002*\n9A)Z2pI\u0016\u0014\bbCAZ\u0003\u001f\u0013\t\u0011)A\u0005\u0003k\u000bAB^1mk\u0016$UmY8eKJ\u0004b!a*\u0002.\u0006u\u0005bB\n\u0002\u0010\u0012\u0005\u0011\u0011\u0018\u000b\u0007\u0003w\u000bi,a0\u0011\u000f5\fy)!'\u0002\u001e\"A\u00111UA\\\u0001\u0004\t)\u000b\u0003\u0005\u00024\u0006]\u0006\u0019AA[\u0011!\tI%a$\u0005B\u0005\rG\u0003BAc\u0003\u0017\u0004b!\u0004.\u0002H\u0006%\u0007#B\u0007\u0002R\u0005e\u0005#B\u0007\u0002R\u0005u\u0005\u0002CA;\u0003\u0003\u0004\r!a\u001e\u0007\r\u0005=\u0017\u0002BAi\u0005m!&/\u00198tC\u000e$\u0018n\u001c8M_\u001elUm]:bO\u0016\u0004\u0016M]:feN)\u0011Q\u001a\u0007\u0002TB)Q.a\u0010!A!91#!4\u0005\u0002\u0005]GCAAm!\ri\u0017Q\u001a\u0005\t\u0003\u0013\ni\r\"\u0011\u0002^R!\u0011q\\Ar!\u0019i!,!9\u0002bB!Q\"!\u0015!\u0011!\t)(a7A\u0002\u0005]dABAt\u0013\u0011\tIO\u0001\u000bPM\u001a\u001cX\r^:NKN\u001c\u0018mZ3QCJ\u001cXM]\n\u0006\u0003Kd\u00111\u001b\u0005\b'\u0005\u0015H\u0011AAw)\t\ty\u000fE\u0002n\u0003KD\u0001\"a=\u0002f\u0012%\u0011Q_\u0001\u0004Q\u0016DHc\u0001\u0011\u0002x\"A\u0011\u0011`Ay\u0001\u0004\tY0A\u0003csR,7\u000f\u0005\u0003\u000e=\u0005u\bcA\u0007\u0002\u0000&\u0019!\u0011\u0001\b\u0003\t\tKH/\u001a\u0005\t\u0005\u000b\t)\u000f\"\u0003\u0003\b\u0005a\u0001/\u0019:tK>3gm]3ugR1!\u0011\u0002B\u000f\u0005c\u0001b!\u0004.\u0003\f\tE\u0001\u0003B\u0007\u0003\u000e\u0001J1Aa\u0004\u000f\u0005\u0011\u0019v.\\3\u0011\u000b5\u0011iAa\u0005\u0011\t\tU!1D\u0007\u0003\u0005/Q1A!\u00071\u0003\u0011a\u0017M\\4\n\u0007\u0015\u00129\u0002\u0003\u0005\u0003 \t\r\u0001\u0019\u0001B\u0011\u0003%ygMZ:fi.+\u0017\u0010\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\t-B!A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002\u0002B\u0018\u0005K\u0011\u0011b\u00144gg\u0016$8*Z=\t\u0011\tM\"1\u0001a\u0001\u0005k\tq\u0001]1zY>\fG\r\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\r\u0011Y\u0004M\u0001\u0004]&|\u0017\u0002\u0002B \u0005s\u0011!BQ=uK\n+hMZ3s\u0011!\u0011\u0019%!:\u0005\n\t\u0015\u0013A\u00059beN,wI]8va6+G/\u00193bi\u0006$bAa\u0012\u0003J\tM\u0003CB\u0007[\u0005\u0017\u0011Y\u0001\u0003\u0005\u0003L\t\u0005\u0003\u0019\u0001B'\u0003A9'o\\;q\u001b\u0016$\u0018\rZ1uC.+\u0017\u0010\u0005\u0003\u0003$\t=\u0013\u0002\u0002B)\u0005K\u0011\u0001c\u0012:pkBlU\r^1eCR\f7*Z=\t\u0011\tM\"\u0011\ta\u0001\u0005kA\u0001\"!\u0013\u0002f\u0012\u0005#q\u000b\u000b\u0005\u0003?\u0014I\u0006\u0003\u0005\u0002v\tU\u0003\u0019AA<\u0011\u001d\u0011i&\u0003C\u0005\u0005?\nq\u0001Z;na2{w\rF\u0007\u0019\u0005C\u0012\u0019Ga\u001a\u0003l\t=$\u0011\u000f\u0005\u0007W\tm\u0003\u0019\u0001\u0017\t\u000f\t\u0015$1\fa\u0001}\u0005i\u0001O]5oi\u000e{g\u000e^3oiNDqA!\u001b\u0003\\\u0001\u0007Q)A\u0011o_:\u001cuN\\:fGV$\u0018N^3QC&\u00148OR8s\u0019><g)\u001b7fg6\u000b\u0007\u000fC\u0004\u0003n\tm\u0003\u0019\u0001 \u0002\u001f%\u001cH)Z3q\u0013R,'/\u0019;j_:Da\u0001\u0019B.\u0001\u0004\t\u0007\u0002\u0003B:\u00057\u0002\rA!\u001e\u0002\rA\f'o]3sa\u0019\u00119Ha\u001f\u0003\u0002B9Q.a\u0010\u0003z\t}\u0004\u0003BA,\u0005w\"AB! \u0003r\u0005\u0005\t\u0011!B\u0001\u0003;\u00121a\u0018\u00136!\u0011\t9F!!\u0005\u0019\t\r%\u0011OA\u0001\u0002\u0003\u0015\t!!\u0018\u0003\u0007}#c\u0007")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class TimeIndexDumpErrors {
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = new HashMap();

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$3) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found timestamp mismatch in :").append((Object)fileName).toString());
                        listOfMismatches.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.outOfOrderTimestamp().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$4) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found out of order timestamp in :").append((Object)fileName).toString());
                        outOfOrderTimestamps.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.shallowOffsetNotFound().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ArrayBuffer<Tuple2<Object, Object>> listOfShallowOffsetNotFound) {
                    System.err.println("The following indexed offsets are not found in the log.");
                    listOfShallowOffsetNotFound.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$5) {
                            Tuple2<Object, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                long indexedOffset = tuple2._1$mcJ$sp();
                                long logOffset = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexed offset: ", ", found log offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexedOffset), BoxesRunTime.boxToLong((long)logOffset)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
            });
        }
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record2) {
            Tuple2 tuple2;
            if (record2.hasValue()) {
                None$ key = record2.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.key()))) : None$.MODULE$;
                Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.value())));
                tuple2 = new Tuple2((Object)key, (Object)payload);
            } else {
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        public String kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(byte[] bytes) {
            return Predef$.MODULE$.byteArrayOps(bytes).isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString("%X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
        }

        private Tuple2<Some<String>, Some<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
            String group = offsetKey.key().group();
            TopicPartition topicPartition = offsetKey.key().topicPartition();
            OffsetAndMetadata offset2 = GroupMetadataManager$.MODULE$.readOffsetMessageValue(payload);
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset::", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition())}));
            String valueString = offset2.metadata().isEmpty() ? String.valueOf(offset2.offset()) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2.offset()), offset2.metadata()}));
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        private Tuple2<Some<String>, Some<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
            String groupId = groupMetadataKey.key();
            GroupMetadata group = GroupMetadataManager$.MODULE$.readGroupMessageValue(groupId, payload);
            String protocolType = (String)group.protocolType().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1)new Serializable(this, protocolType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetsMessageParser $outer;
                private final String protocolType$1;

                public final String apply(MemberMetadata member) {
                    PartitionAssignor.Assignment partitionAssignment;
                    String userData;
                    String string = this.protocolType$1;
                    String string2 = "consumer";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(Utils.toArray((ByteBuffer)(partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()))).userData()))).isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions(), userData}))) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(member.assignment())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.protocolType$1 = protocolType$1;
                }
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            String keyString = Json$.MODULE$.encode(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)groupId)})));
            String valueString = Json$.MODULE$.encode(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)group.protocolOrNull()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)})));
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            Tuple2<Some<String>, Some<String>> tuple2;
            if (record2.hasValue()) {
                Tuple2<Some<String>, Some<String>> tuple22;
                if (!record2.hasKey()) throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
                BaseKey baseKey = GroupMetadataManager$.MODULE$.readMessageKey(record2.key());
                if (baseKey instanceof OffsetKey) {
                    OffsetKey offsetKey = (OffsetKey)baseKey;
                    tuple22 = this.parseOffsets(offsetKey, record2.value());
                } else {
                    if (!(baseKey instanceof GroupMetadataKey)) throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
                    GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
                    tuple22 = this.parseGroupMetadata(groupMetadataKey, record2.value());
                }
                tuple2 = tuple22;
                return tuple2;
            } else {
                tuple2 = new Tuple2<Some<String>, Some<String>>((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record2.key());
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(txnKey.transactionalId(), record2.value());
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnKey.transactionalId()}));
            String valueString = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.state()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.topicPartitions()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs())}))).toString();
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
    }
}

