/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.MetricsTest$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005%i\u0011B\u0001\b\u0003\u0005%\u0019\u0016m\u001d7TKR,\b\u000fC\u0003\u0011\u0001\u0011\u0005\u0011#\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011\u0011\u0002\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0011\u0016\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\b?\u0001\u0011\r\u0011\"\u0011\u0016\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"1\u0011\u0005\u0001Q\u0001\nY\tabY8ogVlWM]\"pk:$\b\u0005C\u0004$\u0001\t\u0007I\u0011I\u000b\u0002\u0017M,'O^3s\u0007>,h\u000e\u001e\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\f\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\t\u000b\u001d\u0002A\u0011\u000b\u0015\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003%\u0002\"A\u000b\u001b\u000e\u0003-R!\u0001L\u0017\u0002\u000f9,Go^8sW*\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!N\u0016\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f]\u0002!\u0019!C\u0005q\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001d\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000e\t\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\u0019\u00032a\u0012':\u001b\u0005A%BA%K\u0003%IW.\\;uC\ndWM\u0003\u0002L1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055C%\u0001\u0002'jgRDaa\u0014\u0001!\u0002\u00131\u0015AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0003bB)\u0001\u0005\u0004%IAU\u0001\u0019W\u000647.Y*feZ,'OS1bg\u0016sGO]=OC6,W#A*\u0011\u0005Q;fBA\fV\u0013\t1\u0006$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001bS!A\u0016\r\t\ri\u0003\u0001\u0015!\u0003T\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.\u001a\u0011\t\u000bq\u0003A\u0011K/\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001B1vi\"T!aY\u0017\u0002\u0011M,7-\u001e:jifL!!\u001a1\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007bB4\u0001\u0005\u0004%\t\u0006[\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0003%\u00042a\u00066m\u0013\tY\u0007D\u0001\u0003T_6,\u0007CA7q\u001b\u0005q'BA8>\u0003\u0011)H/\u001b7\n\u0005Et'A\u0003)s_B,'\u000f^5fg\"11\u000f\u0001Q\u0001\n%\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b\u0005C\u0004v\u0001\t\u0007I\u0011\u000b5\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u00199\b\u0001)A\u0005S\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0003\"B=\u0001\t\u0003R\u0018!B:fiV\u0003H#A>\u0011\u0005]a\u0018BA?\u0019\u0005\u0011)f.\u001b;)\u0005a|\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015!'A\u0003kk:LG/\u0003\u0003\u0002\n\u0005\r!A\u0002\"fM>\u0014X\r\u0003\u0004\u0002\u000e\u0001!\tE_\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111BA\t!\u0011\t\t!a\u0005\n\t\u0005U\u00111\u0001\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u00033\u0001A\u0011\u0001>\u0002\u0017Q,7\u000f^'fiJL7m\u001d\u0015\u0005\u0003/\ti\u0002\u0005\u0003\u0002\u0002\u0005}\u0011\u0002BA\u0011\u0003\u0007\u0011A\u0001V3ti\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012aC:f]\u0012\u0014VmY8sIN$\u0012b_A\u0015\u0003\u000f\nY%a\u0014\t\u0011\u0005-\u00121\u0005a\u0001\u0003[\t\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003_\t9$a\u000f\u0002<5\u0011\u0011\u0011\u0007\u0006\u0005\u0003W\t\u0019DC\u0002\u00026=\nqa\u00197jK:$8/\u0003\u0003\u0002:\u0005E\"!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003\u0018\u0003{\t\t%C\u0002\u0002@a\u0011Q!\u0011:sCf\u00042aFA\"\u0013\r\t)\u0005\u0007\u0002\u0005\u0005f$X\rC\u0004\u0002J\u0005\r\u0002\u0019\u0001\f\u0002\u00159,XNU3d_J$7\u000fC\u0004\u0002N\u0005\r\u0002\u0019\u0001\f\u0002\u0015I,7m\u001c:e'&TX\r\u0003\u0005\u0002R\u0005\r\u0002\u0019AA*\u0003\t!\b\u000f\u0005\u0003\u0002V\u0005]S\"A\u0017\n\u0007\u0005eSF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005ir-\u001a8fe\u0006$X-Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rF\u0002|\u0003CB\u0001\"!\u0015\u0002\\\u0001\u0007\u00111\u000b\u0005\u0007\u0003K\u0002A\u0011\u0002>\u0002SY,'/\u001b4z\u0017\u000647.\u0019*bi\u0016lU\r\u001e:jGND\u0015M^3Dk6,H.\u0019;jm\u0016\u001cu.\u001e8u\u0011\u001d\tI\u0007\u0001C\u0005\u0003W\n!D^3sS\u001aL8\t\\5f]R4VM]:j_:lU\r\u001e:jGN$Ra_A7\u0003+C\u0001\"a\u001c\u0002h\u0001\u0007\u0011\u0011O\u0001\b[\u0016$(/[2ta\u0011\t\u0019(a!\u0011\u000f5\f)(!\u001f\u0002\u0000%\u0019\u0011q\u000f8\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002V\u0005m\u0014bAA?[\tQQ*\u001a;sS\u000et\u0015-\\3\u0011\t\u0005\u0005\u00151\u0011\u0007\u0001\t1\t))!\u001c\u0002\u0002\u0003\u0005)\u0011AAD\u0005\ryF%M\t\u0005\u0003\u0013\u000by\tE\u0002\u0018\u0003\u0017K1!!$\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0016\u0002\u0012&\u0019\u00111S\u0017\u0003\r5+GO]5d\u0011\u001d\t9*a\u001aA\u0002M\u000ba!\u001a8uSRL\bbBAN\u0001\u0011%\u0011QT\u0001\"m\u0016\u0014\u0018NZ=Ce>\\WM]!vi\",g\u000e^5dCRLwN\\'fiJL7m\u001d\u000b\u0004w\u0006}\u0005\u0002CAQ\u00033\u0003\r!a)\u0002\rM,'O^3s!\u0011\t)+!+\u000e\u0005\u0005\u001d&bAAQ\t%!\u00111VAT\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\u0006!c/\u001a:jMf\u0014%o\\6fe6+7o]1hK\u000e{gN^3sg&|g.T3ue&\u001c7\u000fF\u0004|\u0003g\u000b),a.\t\u0011\u0005\u0005\u0016Q\u0016a\u0001\u0003GCq!!\u0014\u0002.\u0002\u0007a\u0003\u0003\u0005\u0002R\u00055\u0006\u0019AA*\u0011\u001d\tY\f\u0001C\u0005\u0003{\u000bQC^3sS\u001aL(I]8lKJT6.T3ue&\u001c7\u000fF\u0003|\u0003\u007f\u000b\t\r\u0003\u0005\u0002\"\u0006e\u0006\u0019AAR\u0011\u001d\t\u0019-!/A\u0002M\u000bQ\u0001^8qS\u000eDq!a2\u0001\t\u0013\tI-\u0001\rwKJLg-\u001f\"s_.,'/\u0012:s_JlU\r\u001e:jGN$2a_Af\u0011!\t\t+!2A\u0002\u0005\r\u0006bBAh\u0001\u0011%\u0011\u0011[\u0001\u0012m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cW\u0003BAj\u00033$\"\"!6\u0003\b\t-!q\u0003B\r)\u0011\t9.!:\u0011\t\u0005\u0005\u0015\u0011\u001c\u0003\t\u00037\fiM1\u0001\u0002^\n\tA+\u0005\u0003\u0002\n\u0006}\u0007cA\f\u0002b&\u0019\u00111\u001d\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002h\u00065\u0007\u0019AAu\u0003\u00191XM]5gsB9q#a;\u0002p\u0006]\u0017bAAw1\tIa)\u001e8di&|g.\r\t\u0007\u0003c\u0014\t!a$\u000f\t\u0005M\u0018Q \b\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011 \u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012bAA\u00001\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0002\u0005\u000b\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u007fD\u0002b\u0002B\u0005\u0003\u001b\u0004\raU\u0001\u0005]\u0006lW\r\u0003\u0005\u0002p\u00055\u0007\u0019\u0001B\u0007a\u0011\u0011yAa\u0005\u0011\u000f5\f)(!\u001f\u0003\u0012A!\u0011\u0011\u0011B\n\t1\u0011)Ba\u0003\u0002\u0002\u0003\u0005)\u0011AAD\u0005\ryFE\r\u0005\b\u0003/\u000bi\r1\u0001T\u0011)\u0011Y\"!4\u0011\u0002\u0003\u0007!QD\u0001\u0006OJ|W\u000f\u001d\t\u0005/\t}1+C\u0002\u0003\"a\u0011aa\u00149uS>t\u0007b\u0002B\u0013\u0001\u0011%!qE\u0001\u0014[\u0006D8*\u00194lC6+GO]5d-\u0006dW/\u001a\u000b\u000b\u0005S\u0011yC!\r\u0003>\t}\u0002cA\f\u0003,%\u0019!Q\u0006\r\u0003\r\u0011{WO\u00197f\u0011\u001d\u0011IAa\tA\u0002MC\u0001\"a\u001c\u0003$\u0001\u0007!1\u0007\u0019\u0005\u0005k\u0011I\u0004E\u0004n\u0003k\nIHa\u000e\u0011\t\u0005\u0005%\u0011\b\u0003\r\u0005w\u0011\t$!A\u0001\u0002\u000b\u0005\u0011q\u0011\u0002\u0004?\u0012\u001a\u0004bBAL\u0005G\u0001\ra\u0015\u0005\t\u00057\u0011\u0019\u00031\u0001\u0003\u001e!9!1\t\u0001\u0005\n\t\u0015\u0013!\u0007<fe&4\u0017pS1gW\u0006lU\r\u001e:jGJ+7m\u001c:eK\u0012$\u0012b\u001fB$\u0005\u0013\u0012)Fa\u0016\t\u000f\t%!\u0011\ta\u0001'\"A\u0011q\u000eB!\u0001\u0004\u0011Y\u0005\r\u0003\u0003N\tE\u0003cB7\u0002v\u0005e$q\n\t\u0005\u0003\u0003\u0013\t\u0006\u0002\u0007\u0003T\t%\u0013\u0011!A\u0001\u0006\u0003\t9IA\u0002`IQBq!a&\u0003B\u0001\u00071\u000b\u0003\u0006\u0003\u001c\t\u0005\u0003\u0013!a\u0001\u0005;AqAa\u0017\u0001\t\u0013\u0011i&A\tzC6lWM]'fiJL7MV1mk\u0016$B!a8\u0003`!9!\u0011\u0002B-\u0001\u0004\u0019\u0006b\u0002B2\u0001\u0011%!QM\u0001\u0015s\u0006lW.\u001a:ISN$xn\u001a:b[\u000e{WO\u001c;\u0015\t\t\u001d$Q\u000e\t\u0004/\t%\u0014b\u0001B61\t!Aj\u001c8h\u0011\u001d\u0011IA!\u0019A\u0002MCqA!\u001d\u0001\t\u0013\u0011\u0019(\u0001\u000ewKJLg-_-b[6,'/T3ue&\u001c'+Z2pe\u0012,G\r\u0006\u0004\u0003*\tU$q\u000f\u0005\b\u0005\u0013\u0011y\u00071\u0001T\u0011)\t9Oa\u001c\u0011\u0002\u0003\u0007!\u0011\u0010\t\b/\u0005-(\u0011\u0006B>!\r9\"QP\u0005\u0004\u0005\u007fB\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0003Y1XM]5gs:{'+Z9vKN$X*\u001a;sS\u000e\u001cHcA>\u0003\b\"9!\u0011\u0012BA\u0001\u0004\u0019\u0016\u0001D3se>\u0014X*Z:tC\u001e,\u0007\"\u0003BG\u0001E\u0005I\u0011\u0002BH\u0003\r2XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uIQ*\"A!%+\t\tu!1S\u0016\u0003\u0005+\u0003BAa&\u0003\"6\u0011!\u0011\u0014\u0006\u0005\u00057\u0013i*A\u0005v]\u000eDWmY6fI*\u0019!q\u0014\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003$\ne%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u0015\u0001\u0012\u0002\u0013%!\u0011V\u0001\u001cm\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\t\t=%1\u0016\u0003\t\u00037\u0014)K1\u0001\u0002^\"I!q\u0016\u0001\u0012\u0002\u0013%!\u0011W\u0001%m\u0016\u0014\u0018NZ=ZC6lWM]'fiJL7MU3d_J$W\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0017\u0016\u0005\u0005s\u0012\u0019\n")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        this.kafka$api$MetricsTest$$sendRecords((KafkaProducer<byte[], byte[]>)producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount();
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(((KafkaProducer)this.producers().head()).metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    public void kafka$api$MetricsTest$$sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp, bytes){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;
            private final byte[] bytes$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)this.bytes$1));
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
                this.bytes$1 = bytes$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties producerProps = new Properties();
        Properties saslProps = new Properties();
        saslProps.put("request.timeout.ms", "1000");
        saslProps.put("max.block.ms", "1000");
        saslProps.put("sasl.mechanism", "SCRAM-SHA-256");
        saslProps.put("acks", "0");
        String x$9 = this.brokerList();
        SecurityProtocol x$10 = this.securityProtocol();
        Option<File> x$11 = this.trustStoreFile();
        Some x$12 = new Some((Object)saslProps);
        Some x$13 = new Some((Object)producerProps);
        int x$14 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$16 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$17 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$18 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$19 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$20 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$21 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$9, x$14, x$15, x$16, x$17, x$18, x$19, x$10, x$11, (Option<Properties>)x$12, x$20, x$21, (Option<Properties>)x$13);
        try {
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
        finally {
            producer.close();
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        Set consumerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$1) {
                return x$1.name().endsWith("-rate");
            }
        })).foreach((Function1)new Serializable(this, consumerMetricNames){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Set consumerMetricNames$1;

            public final void apply(MetricName x$2) {
                this.$outer.kafka$api$MetricsTest$$verify$1(x$2, this.consumerMetricNames$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerMetricNames$1 = consumerMetricNames$1;
            }
        });
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        Set producerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$3) {
                return x$3.name().endsWith("-rate");
            }
        })).filterNot((Function1)new Serializable(this, producerExclusions){
            public static final long serialVersionUID = 0L;
            private final Set producerExclusions$1;

            public final boolean apply(MetricName metricName) {
                return this.producerExclusions$1.contains((Object)metricName.name());
            }
            {
                this.producerExclusions$1 = producerExclusions$1;
            }
        })).foreach((Function1)new Serializable(this, producerMetricNames){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Set producerMetricNames$1;

            public final void apply(MetricName x$4) {
                this.$outer.kafka$api$MetricsTest$$verify$1(x$4, this.producerMetricNames$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerMetricNames$1 = producerMetricNames$1;
            }
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"commit-id", "version"}))).foreach((Function1)new Serializable(this, metrics, entity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Map metrics$1;
            public final String entity$1;

            public final void apply(String name) {
                this.$outer.kafka$api$MetricsTest$$verifyKafkaMetric(name, this.metrics$1, this.entity$1, this.$outer.kafka$api$MetricsTest$$verifyKafkaMetric$default$4(), new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$verifyClientVersionMetrics$1 $outer;
                    private final String name$4;

                    public final void apply(Iterable<org.apache.kafka.common.Metric> matchingMetrics) {
                        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
                        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
                        Object value = metric.metricValue();
                        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.entity$1, this.name$4})), (Object)value);
                        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric ", " should be a non-empty String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.entity$1, this.name$4})), (Object)BoxesRunTime.boxToBoolean((value instanceof String && !((String)value).isEmpty() ? 1 : 0) != 0));
                        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$4 = name$4;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metrics$1 = metrics$1;
                this.entity$1 = entity$1;
            }
        });
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, metrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Map metrics$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$MetricsTest$$maxKafkaMetricValue("failed-authentication-total", this.metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metrics$2 = metrics$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed-authentication-total not updated";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected temporary memory size requestBytes ", " tempBytes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)requestBytes), BoxesRunTime.boxToDouble((double)tempBytes)})), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec"})).s((Seq)Nil$.MODULE$), this.verifyYammerMetricRecorded$default$2());
        IntRef iteration = IntRef.create((int)0);
        TestUtils$.MODULE$.retry(5000L, (Function0<BoxedUnit>)new Serializable(this, tp, requestMetricsPrefix, iteration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final TopicPartition tp$2;
            private final String requestMetricsPrefix$1;
            private final IntRef iteration$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String[] stringArray = new String[]{"", ",name=MessageConversionsTimeMs,request=Produce"};
                Object[] objectArray = new Object[]{this.requestMetricsPrefix$1};
                double conversionTimeMs = BoxesRunTime.unboxToDouble((Object)this.$outer.kafka$api$MetricsTest$$yammerMetricValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray)).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray))));
                if (conversionTimeMs <= 0.0) {
                    ++this.iteration$1.elem;
                    this.$outer.kafka$api$MetricsTest$$sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.$outer.producers().head()), 1000 * this.iteration$1.elem, 100, this.tp$2);
                }
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message conversion time not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)conversionTimeMs)})), (conversionTimeMs > 0.0 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.requestMetricsPrefix$1 = requestMetricsPrefix$1;
                this.iteration$1 = iteration$1;
            }
        });
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double value) {
                return this.apply$mcZD$sp(value);
            }

            public boolean apply$mcZD$sp(double value) {
                return value == 0.0;
            }
        });
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        long initialCount = this.yammerHistogramCount("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        long newCount = this.yammerHistogramCount("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (newCount > initialCount ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ZK state"})).s((Seq)Nil$.MODULE$), (Object)"CONNECTED", (Object)this.kafka$api$MetricsTest$$yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        Object object;
        int startErrorMetricCount = this.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=NONE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        try {
            object = ((KafkaConsumer)this.consumers().head()).partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {
            object = BoxedUnit.UNIT;
        }
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=INVALID_TOPIC_EXCEPTION"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = this.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many error metrics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentErrorMetricCount)})), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        this.kafka$api$MetricsTest$$sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=LEADER_NOT_AVAILABLE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    public <T> T kafka$api$MetricsTest$$verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify2) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1)new Serializable(this, name, group){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Option group$1;

            public final boolean apply(Tuple2<MetricName, org.apache.kafka.common.Metric> x0$1) {
                Tuple2<MetricName, org.apache.kafka.common.Metric> tuple2 = x0$1;
                if (tuple2 != null) {
                    MetricName metricName = (MetricName)tuple2._1();
                    String string = metricName.name();
                    String string2 = this.name$1;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.group$1.forall((Function1)new Serializable(this, metricName){
                        public static final long serialVersionUID = 0L;
                        private final MetricName metricName$1;

                        public final boolean apply(String x$6) {
                            String string = x$6;
                            String string2 = this.metricName$1.group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.metricName$1 = metricName$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.name$1 = name$1;
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (matchingMetrics.size() > 0 ? 1 : 0) != 0);
        return (T)verify2.apply((Object)matchingMetrics.values());
    }

    public <T> Option<String> kafka$api$MetricsTest$$verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    public double kafka$api$MetricsTest$$maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        return BoxesRunTime.unboxToDouble(this.kafka$api$MetricsTest$$verifyKafkaMetric(name, metrics, entity, group, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<org.apache.kafka.common.Metric> matchingMetrics) {
                return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double max, org.apache.kafka.common.Metric metric) {
                        return Math.max(max, metric.value());
                    }
                }));
            }
        }));
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.kafka$api$MetricsTest$$maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, name, BoxesRunTime.boxToDouble((double)value)})), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    public Object kafka$api$MetricsTest$$yammerMetricValue(String name) {
        Tuple2 tuple2;
        block2: {
            Metric metric;
            block6: {
                Object object;
                block4: {
                    block5: {
                        block3: {
                            scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
                            tuple2 = (Tuple2)allMetrics.find((Function1)new Serializable(this, name){
                                public static final long serialVersionUID = 0L;
                                private final String name$2;

                                public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$2) {
                                    Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                                        boolean bl = n.getMBeanName().endsWith(this.name$2);
                                        return bl;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.name$2 = name$2;
                                }
                            }).getOrElse((Function0)new Serializable(this, name, allMetrics){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MetricsTest $outer;
                                private final String name$2;
                                private final scala.collection.mutable.Map allMetrics$1;

                                public final Nothing$ apply() {
                                    return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find broker metric ", ": allMetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.allMetrics$1.keySet().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(com.yammer.metrics.core.MetricName x$7) {
                                            return x$7.getMBeanName();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.name$2 = name$2;
                                    this.allMetrics$1 = allMetrics$1;
                                }
                            });
                            if (tuple2 == null) break block2;
                            Metric metric2 = (Metric)tuple2._2();
                            Metric metric3 = metric2;
                            Metric metric4 = metric3;
                            metric = metric4;
                            if (!(metric instanceof Meter)) break block3;
                            Meter meter = (Meter)metric;
                            object = BoxesRunTime.boxToDouble((double)meter.count());
                            break block4;
                        }
                        if (!(metric instanceof Histogram)) break block5;
                        Histogram histogram = (Histogram)metric;
                        object = BoxesRunTime.boxToDouble((double)histogram.max());
                        break block4;
                    }
                    if (!(metric instanceof Gauge)) break block6;
                    Gauge gauge = (Gauge)metric;
                    object = gauge.value();
                }
                return object;
            }
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker metric of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.getClass()})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        }
        throw new MatchError((Object)tuple2);
    }

    private long yammerHistogramCount(String name) {
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$3;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$3) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$3;
                if (tuple2 != null) {
                    com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                    boolean bl = n.getMBeanName().endsWith(this.name$3);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.name$3 = name$3;
            }
        }).getOrElse((Function0)new Serializable(this, name, allMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String name$3;
            private final scala.collection.mutable.Map allMetrics$2;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find broker metric ", ": allMetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$3, this.allMetrics$2.keySet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(com.yammer.metrics.core.MetricName x$8) {
                        return x$8.getMBeanName();
                    }
                }, Set$.MODULE$.canBuildFrom())})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$3 = name$3;
                this.allMetrics$2 = allMetrics$2;
            }
        });
        if (tuple2 != null) {
            Metric metric = (Metric)tuple2._2();
            Metric metric2 = metric;
            Metric metric3 = metric2;
            Metric metric4 = metric3;
            if (metric4 instanceof Histogram) {
                Histogram histogram = (Histogram)metric4;
                long l = histogram.count();
                return l;
            }
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker metric of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric4.getClass()})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify2) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.kafka$api$MetricsTest$$yammerMetricValue(name));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToDouble((double)metricValue)})), (boolean)verify2.apply$mcZD$sp(metricValue));
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double d) {
                return this.apply$mcZD$sp(d);
            }

            public boolean apply$mcZD$sp(double d) {
                return d > 0.0;
            }
        };
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$4) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$4;
                if (tuple2 != null) {
                    com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                    boolean bl = n.getMBeanName().startsWith("kafka.network:type=RequestMetrics");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, metrics.keys()})), (boolean)metrics.isEmpty());
    }

    private final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    public final void kafka$api$MetricsTest$$verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = this.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = this.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No cumulative count/time metric for rate metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rateMetricName})), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    private final int errorMetricCount$1() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName x$5) {
                String string = x$5.getName();
                String string2 = "ErrorsPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).size();
    }

    public MetricsTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.kafkaServerJaasEntryName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value().toLowerCase(Locale.ROOT), JaasTestUtils$.MODULE$.KafkaServerContextName()}));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("batch.size", "1000000");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

