/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.api.PlaintextConsumerTest$;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012a\u0003;fgRDU-\u00193feN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgRDQa\t\u0001\u0005\u0002I\t\u0011\u0006^3ti\"+\u0017\rZ3sg\u0016CH/\u001a8eK\u0012\u001cVM]5bY&TXM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bF\u0001\u0012\u001b\u0011\u00151\u0003\u0001\"\u0001\u0013\u0003I!Xm\u001d;NCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:)\u0005\u0015R\u0002\"B\u0015\u0001\t\u0003\u0011\u0012!\u0006;fgRl\u0015\r\u001f)pY2Le\u000e^3sm\u0006dWj\u001d\u0015\u0003QiAQ\u0001\f\u0001\u0005\u0002I\ta\u0005^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5\u000fR3mCfLeNU3w_\u000e\fG/[8oQ\tY#\u0004C\u00030\u0001\u0011\u0005!#\u0001\u0014uKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:EK2\f\u00170\u00138BgNLwM\\7f]RD#A\f\u000e\t\u000bI\u0002A\u0011\u0001\n\u0002+Q,7\u000f^!vi>\u001cu.\\7ji>s7\t\\8tK\"\u0012\u0011G\u0007\u0005\u0006k\u0001!\tAE\u0001!i\u0016\u001cH/Q;u_\u000e{W.\\5u\u001f:\u001cEn\\:f\u0003\u001a$XM],bW\u0016,\b\u000f\u000b\u000255!)\u0001\b\u0001C\u0001%\u0005\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fi\"\u0012qG\u0007\u0005\u0006w\u0001!\tAE\u0001\u0015i\u0016\u001cHo\u0012:pkB\u001cuN\\:v[B$\u0018n\u001c8)\u0005iR\u0002\"\u0002 \u0001\t\u0003\u0011\u0012a\u0006;fgR\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8oQ\ti$\u0004C\u0003B\u0001\u0011\u0005!#A\u0011uKN$8+\u001e2tKF,XM\u001c;QCR$XM\u001d8Tk\n\u001c8M]5qi&|g\u000e\u000b\u0002A5!)A\t\u0001C\u0001%\u0005IB/Z:u!\u0006$H/\u001a:o+:\u001cXOY:de&\u0004H/[8oQ\t\u0019%\u0004C\u0003H\u0001\u0011\u0005!#\u0001\nuKN$8i\\7nSRlU\r^1eCR\f\u0007F\u0001$\u001b\u0011\u0015Q\u0005\u0001\"\u0001\u0013\u0003=!Xm\u001d;Bgft7mQ8n[&$\bFA%\u001b\u0011\u0015i\u0005\u0001\"\u0001\u0013\u0003}!Xm\u001d;FqB\fg\u000eZ5oOR{\u0007/[2Tk\n\u001c8M]5qi&|gn\u001d\u0015\u0003\u0019jAQ\u0001\u0015\u0001\u0005\u0002I\tq\u0004^3tiNC'/\u001b8lS:<Gk\u001c9jGN+(m]2sSB$\u0018n\u001c8tQ\ty%\u0004C\u0003T\u0001\u0011\u0005!#A\tuKN$\b+\u0019:uSRLwN\\:G_JD#A\u0015\u000e\t\u000bY\u0003A\u0011\u0001\n\u00027Q,7\u000f\u001e)beRLG/[8og\u001a{'/Q;u_\u000e\u0013X-\u0019;fQ\t)&\u0004C\u0003Z\u0001\u0011\u0005!#A\u000fuKN$\b+\u0019:uSRLwN\\:G_JLeN^1mS\u0012$v\u000e]5dQ\u0011A&d\u0017/\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u0018\t\u0003=\u001al\u0011a\u0018\u0006\u0003A\u0006\fa!\u001a:s_J\u001c(B\u00012d\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u001a\u0006\u0003Kz\ta!\u00199bG\",\u0017BA4`\u0005UIeN^1mS\u0012$v\u000e]5d\u000bb\u001cW\r\u001d;j_:DQ!\u001b\u0001\u0005\u0002I\t\u0001\u0002^3tiN+Wm\u001b\u0015\u0003QjAQ\u0001\u001c\u0001\u0005\n5\fac]3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<Wm\u001d\u000b\u0004'9\u001c\b\"B8l\u0001\u0004\u0001\u0018A\u00038v[J+7m\u001c:egB\u0011A#]\u0005\u0003eV\u00111!\u00138u\u0011\u0015!8\u000e1\u0001v\u0003\t!\b\u000f\u0005\u0002wo6\t\u0011-\u0003\u0002yC\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u0002>\u0001\t\u0003\u0011\u0012!\u0006;fgR\u0004vn]5uS>t\u0017I\u001c3D_6l\u0017\u000e\u001e\u0015\u0003sjAQ! \u0001\u0005\u0002I\t1\u0004^3tiB\u000b'\u000f^5uS>t\u0007+Y;tK\u0006sGMU3tk6,\u0007F\u0001?\u001b\u0011\u0019\t\t\u0001\u0001C\u0001%\u00051B/Z:u\r\u0016$8\r[%om\u0006d\u0017\u000eZ(gMN,G\u000f\u000b\u0002\u00005!1\u0011q\u0001\u0001\u0005\u0002I\ta\u0005^3ti\u001a+Go\u00195SK\u000e|'\u000f\u001a'be\u001e,'\u000f\u00165b]\u001a+Go\u00195NCb\u0014\u0015\u0010^3tQ\r\t)A\u0007\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003A\u0019\u0007.Z2l\u0019\u0006\u0014x-\u001a*fG>\u0014H\rF\u0002\u0014\u0003#Aq!a\u0005\u0002\f\u0001\u0007\u0001/\u0001\nqe>$WoY3s%\u0016\u001cwN\u001d3TSj,\u0007BBA\f\u0001\u0011\u0005!#\u0001\u0018uKN$h)\u001a;dQ\"{gn\\;sg\u001a+Go\u00195TSj,\u0017J\u001a'be\u001e,'+Z2pe\u0012tu\u000e\u001e$jeN$\bfAA\u000b5!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011AK2iK\u000e\\g)\u001a;dQ\"{gn\\;sgNK'0Z%g\u0019\u0006\u0014x-\u001a*fG>\u0014HMT8u\r&\u00148\u000f\u001e\u000b\u0004'\u0005\u0005\u0002bBA\u0012\u00037\u0001\r\u0001]\u0001\u0018Y\u0006\u0014x-\u001a)s_\u0012,8-\u001a:SK\u000e|'\u000fZ*ju\u0016Da!a\n\u0001\t\u0003\u0011\u0012a\u000f;fgR4U\r^2i\u0011>tw.\u001e:t\u001b\u0006D\b+\u0019:uSRLwN\u001c$fi\u000eD')\u001f;fg&3G*\u0019:hKJ+7m\u001c:e\u001d>$h)\u001b:ti\"\u001a\u0011Q\u0005\u000e\t\r\u00055\u0002\u0001\"\u0001\u0013\u0003=\"Xm\u001d;GKR\u001c\u0007NU3d_J$G*\u0019:hKJ$\u0006.\u00198NCb\u0004\u0016M\u001d;ji&|gNR3uG\"\u0014\u0015\u0010^3tQ\r\tYC\u0007\u0005\u0007\u0003g\u0001A\u0011\u0001\n\u0002SQ,7\u000f\u001e'po6\u000b\u0007PR3uG\"\u001c\u0016N_3G_J\u0014V-];fgR\fe\u000e\u001a)beRLG/[8oQ\r\t\tD\u0007\u0005\u0007\u0003s\u0001A\u0011\u0001\n\u00021Q,7\u000f\u001e*pk:$'k\u001c2j]\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u00028iAa!a\u0010\u0001\t\u0003\u0011\u0012!\n;fgRlU\u000f\u001c;j\u0007>t7/^7feJ{WO\u001c3S_\nLg.Q:tS\u001etW.\u001a8uQ\r\tiD\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003\u001d\u0011XM^3sg\u0016$B!!\u0013\u0002`A9\u00111JA+k\u0006eSBAA'\u0015\u0011\ty%!\u0015\u0002\u0013%lW.\u001e;bE2,'bAA*+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0004\u001b\u0006\u0004\bc\u0001\u000b\u0002\\%\u0019\u0011QL\u000b\u0003\t1{gn\u001a\u0005\t\u0003C\n\u0019\u00051\u0001\u0002d\u0005\tQ\u000e\u0005\u0005\u0002f\u0005-\u0014\u0011LA8\u001d\r!\u0012qM\u0005\u0004\u0003S*\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002X\u00055$bAA5+A)\u0011QMA9k&!\u00111OA7\u0005\r\u0019V\r\u001e\u0005\u0007\u0003o\u0002A\u0011\u0001\n\u0002CQ,7\u000f^'vYRL7i\u001c8tk6,'o\u0015;jG.L\u0018i]:jO:lWM\u001c;)\u0007\u0005U$\u0004\u0003\u0004\u0002~\u0001!\tAE\u0001#i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014H)\u001a4bk2$\u0018i]:jO:lWM\u001c;)\u0007\u0005m$\u0004\u0003\u0004\u0002\u0004\u0002!\tAE\u0001-i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$xJ\\*u_B\u0004v\u000e\u001c7j]\u001eD3!!!\u001b\u0011\u0019\tI\t\u0001C\u0001%\u00051C/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]\u000ecwn]3)\u0007\u0005\u001d%\u0004\u0003\u0004\u0002\u0010\u0002!\tAE\u0001\u0011i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peND3!!$\u001b\u0011\u0019\t)\n\u0001C\u0001%\u00059B/Z:u\u0003V$xnQ8n[&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0015\u0004\u0003'S\u0002BBAN\u0001\u0011\u0005!#A\u0011uKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8sg^KG\u000f[,s_:<7*Z=WC2,X\rK\u0002\u0002\u001ajAa!!)\u0001\t\u0003\u0011\u0012!\t;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0007J,\u0017\r^3US6,\u0007fAAP5!1\u0011q\u0015\u0001\u0005\u0002I\tA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0004\u0003KS\u0002BBAW\u0001\u0011\u0005!#\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007\u0005-&\u0004\u0003\u0004\u00024\u0002!\tAE\u0001\u0014i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm\u001d\u0015\u0004\u0003cS\u0002BBA]\u0001\u0011\u0005!#A\u000euKN$X)\u0019:mS\u0016\u001cHo\u0014:MCR,7\u000f^(gMN,Go\u001d\u0015\u0004\u0003oS\u0002BBA`\u0001\u0011\u0005!#\u0001\u000buKN$XK\\:vEN\u001c'/\u001b2f)>\u0004\u0018n\u0019\u0015\u0004\u0003{S\u0002BBAc\u0001\u0011\u0005!#A\u0013uKN$\b+Y;tKN#\u0018\r^3O_R\u0004&/Z:feZ,GMQ=SK\n\fG.\u00198dK\"\u001a\u00111\u0019\u000e\t\r\u0005-\u0007\u0001\"\u0001\u0013\u0003i!Xm\u001d;D_6l\u0017\u000e^*qK\u000eLg-[3e\u001f\u001a47/\u001a;tQ\r\tIM\u0007\u0005\u0007\u0003#\u0004A\u0011\u0001\n\u00023Q,7\u000f^!vi>\u001cu.\\7ji>s'+\u001a2bY\u0006t7-\u001a\u0015\u0004\u0003\u001fT\u0002BBAl\u0001\u0011\u0005!#\u0001\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bw-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,\u0007fAAk5!1\u0011Q\u001c\u0001\u0005\u0002I\t1\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MC\u001elU\r\u001e:jGN\u001cE.Z1o+B<\u0016\u000e\u001e5BgNLwM\u001c\u0015\u0004\u00037T\u0002BBAr\u0001\u0011\u0005!#A\u0013uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bwmV5uQ6\u000b\u0007\u0010U8mYJ+7m\u001c:eg\"\u001a\u0011\u0011\u001d\u000e\t\r\u0005%\b\u0001\"\u0001\u0013\u00039\"Xm\u001d;Rk>$\u0018-T3ue&\u001c7OT8u\u0007J,\u0017\r^3e\u0013\u001atu.U;pi\u0006\u001c8i\u001c8gS\u001e,(/\u001a3)\u0007\u0005\u001d(\u0004C\u0004\u0002p\u0002!\t!!=\u0002EI,h.T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$H+Z:u)\r\u0019\u00121\u001f\u0005\t\u0003k\fi\u000f1\u0001\u0002x\u0006i1\r\\8tK\u000e{gn];nKJ\u00042\u0001FA}\u0013\r\tY0\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\t\u0011d\u0019:fCR,Gk\u001c9jG\u0006sGmU3oIJ+7m\u001c:egRA\u0011q\u000eB\u0002\u0005\u001b\u0011\t\u0002\u0003\u0005\u0003\u0006\u0005u\b\u0019\u0001B\u0004\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0002f\t%\u0011\u0002\u0002B\u0006\u0003[\u0012aa\u0015;sS:<\u0007b\u0002B\b\u0003{\u0004\r\u0001]\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\tM\u0011Q a\u0001a\u0006\u0019\"/Z2pe\u0012\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"9!q\u0003\u0001\u0005\u0002\te\u0011\u0001I:vEN\u001c'/\u001b2f\u0007>t7/^7fe\u0006sGm\u0015;beR\u0004v\u000e\u001c7j]\u001e$bAa\u0007\u0003$\t\u0005\u0003\u0003\u0002B\u000f\u0005?i\u0011\u0001A\u0005\u0004\u0005CQ!\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7fe\"A!Q\u0005B\u000b\u0001\u0004\u00119#\u0001\u0005d_:\u001cX/\\3s!!\u0011IC!\r\u00036\tURB\u0001B\u0016\u0015\u0011\u0011)C!\f\u000b\u0007\t=2-A\u0004dY&,g\u000e^:\n\t\tM\"1\u0006\u0002\t\u0007>t7/^7feB)ACa\u000e\u0003<%\u0019!\u0011H\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Q\u0011i$C\u0002\u0003@U\u0011AAQ=uK\"A!1\tB\u000b\u0001\u0004\u0011)%A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004bAa\u0012\u0003X\t\u001da\u0002\u0002B%\u0005'rAAa\u0013\u0003R5\u0011!Q\n\u0006\u0004\u0005\u001f2\u0011A\u0002\u001fs_>$h(C\u0001\u0017\u0013\r\u0011)&F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IFa\u0017\u0003\t1K7\u000f\u001e\u0006\u0004\u0005+*\u0002b\u0002B0\u0001\u0011\u0005!\u0011M\u0001\u0013gV\u00147o\u0019:jE\u0016\u001cuN\\:v[\u0016\u00148\u000f\u0006\u0004\u0003d\t=$1\u0010\t\u0007\u0005K\u0012YGa\u0007\u000e\u0005\t\u001d$\u0002\u0002B5\u0003#\nq!\\;uC\ndW-\u0003\u0003\u0003n\t\u001d$A\u0002\"vM\u001a,'\u000f\u0003\u0005\u0003r\tu\u0003\u0019\u0001B:\u00035\u0019wN\\:v[\u0016\u0014xI]8vaB1!Q\rB6\u0005k\u0002\u0002B!\u000b\u0003x\tU\"QG\u0005\u0005\u0005s\u0012YCA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\u0005\t\u0005\u0007\u0012i\u00061\u0001\u0003F!9!q\u0010\u0001\u0005\u0002\t\u0005\u0015aJ2sK\u0006$XmQ8ogVlWM]$s_V\u0004\u0018I\u001c3XC&$hi\u001c:BgNLwM\\7f]R$\u0002Ba!\u0003\n\n5%q\u0012\t\b)\t\u0015%1\u000fB2\u0013\r\u00119)\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t-%Q\u0010a\u0001a\u0006i1m\u001c8tk6,'oQ8v]RD\u0001Ba\u0011\u0003~\u0001\u0007!Q\t\u0005\t\u0005#\u0013i\b1\u0001\u0002p\u0005i1/\u001e2tGJL\u0007\u000f^5p]NDqA!&\u0001\t\u0003\u00119*\u0001\u0017bI\u0012\u001cuN\\:v[\u0016\u00148\u000fV8He>,\b/\u00118e/\u0006LGOR8s\u000fJ|W\u000f]!tg&<g.\\3oiRY1C!'\u0003\u001e\n}%1\u0015BS\u0011\u001d\u0011YJa%A\u0002A\f1C\\;n\u001f\u001a\u001cuN\\:v[\u0016\u00148\u000fV8BI\u0012D\u0001B!\u001d\u0003\u0014\u0002\u0007!1\u000f\u0005\t\u0005C\u0013\u0019\n1\u0001\u0003d\u0005y1m\u001c8tk6,'\u000fU8mY\u0016\u00148\u000f\u0003\u0005\u0003D\tM\u0005\u0019\u0001B#\u0011!\u0011\tJa%A\u0002\u0005=\u0004b\u0002BU\u0001\u0011\u0005!1V\u0001\u0018m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$\u0012b\u0005BW\u0005_\u0013\tL!.\t\u0011\t\u0005&q\u0015a\u0001\u0005GB\u0001B!%\u0003(\u0002\u0007\u0011q\u000e\u0005\t\u0005g\u00139\u000b1\u0001\u0003\b\u0005\u0019Qn]4\t\u0015\t]&q\u0015I\u0001\u0002\u0004\tI&\u0001\u0005xC&$H+[7f\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{\u000bAg\u00195b]\u001e,7i\u001c8tk6,'o\u0012:pkB\u001cVOY:de&\u0004H/[8o\u0003:$g+\u00197jI\u0006$X-Q:tS\u001etW.\u001a8u)\u001d\u0019\"q\u0018Ba\u0005\u0007D\u0001B!)\u0003:\u0002\u0007!1\r\u0005\t\u0005\u0007\u0012I\f1\u0001\u0003F!A!\u0011\u0013B]\u0001\u0004\ty\u0007C\u0004\u0003H\u0002!\tA!3\u0002_\rD\u0017M\\4f\u0007>t7/^7feN+(m]2sSB$\u0018n\u001c8B]\u00124\u0016\r\\5eCR,\u0017i]:jO:lWM\u001c;\u0016\r\t-'Q\u001bBu)%\u0019\"Q\u001aBw\u0005_\u0014\t\u0010\u0003\u0005\u0003&\t\u0015\u0007\u0019\u0001Bh!!\u0011IC!\r\u0003R\n\u001d\b\u0003\u0002Bj\u0005+d\u0001\u0001\u0002\u0005\u0003X\n\u0015'\u0019\u0001Bm\u0005\u0005Y\u0015\u0003\u0002Bn\u0005C\u00042\u0001\u0006Bo\u0013\r\u0011y.\u0006\u0002\b\u001d>$\b.\u001b8h!\r!\"1]\u0005\u0004\u0005K,\"aA!osB!!1\u001bBu\t!\u0011YO!2C\u0002\te'!\u0001,\t\u0011\t\r#Q\u0019a\u0001\u0005\u000bB\u0001B!%\u0003F\u0002\u0007\u0011q\u000e\u0005\t\u0005g\u0014)\r1\u0001\u0003v\u0006\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0011\t\t%\"q_\u0005\u0005\u0005s\u0014YCA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\b\"\u0003B\u007f\u0001E\u0005I\u0011\u0001B\u0000\u0003\u00052\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tA\u000b\u0003\u0002Z\r\r1FAB\u0003!\u0011\u00199a!\u0005\u000e\u0005\r%!\u0002BB\u0006\u0007\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r=Q#\u0001\u0006b]:|G/\u0019;j_:LAaa\u0005\u0004\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        ((KafkaProducer)this.producers().head()).send(record);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords((Consumer)this.consumers().head(), numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                Header header = record.headers().lastHeader("headerKey");
                Assert.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
            }
            {
                this.records$1 = records$1;
            }
        });
    }

    @Test
    public void testHeadersExtendedSerializerDeserializer() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ExtendedSerializer<byte[]> extendedSerializer = new ExtendedSerializer<byte[]>(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                headers.add("content-type", "application/octet-stream".getBytes());
                return this.serializer().serialize(topic, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                this.serializer().configure(configs, isKey);
            }

            public void close() {
                this.serializer().close();
            }

            public byte[] serialize(String topic, byte[] data) {
                throw this.$outer.fail("method should not be invoked", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serializer = new ByteArraySerializer();
            }
        };
        ExtendedDeserializer<byte[]> extendedDeserializer = new ExtendedDeserializer<byte[]>(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                Header header = headers.lastHeader("content-type");
                Assert.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
                return this.deserializer().deserialize(topic, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                this.deserializer().configure(configs, isKey);
            }

            public void close() {
                this.deserializer().close();
            }

            public byte[] deserialize(String topic, byte[] data) {
                throw this.$outer.fail("method should not be invoked", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deserializer = new ByteArrayDeserializer();
            }
        };
        KafkaProducer producer0 = new KafkaProducer(this.producerConfig(), (Serializer)new ByteArraySerializer(), (Serializer)extendedSerializer);
        this.producers().$plus$eq((Object)producer0);
        producer0.send(record);
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)extendedDeserializer);
        this.consumers().$plus$eq((Object)consumer0);
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer0.assignment().size());
        consumer0.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(consumer0, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        this.sendRecords(numRecords);
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        KafkaConsumer x$19 = consumer0;
        int x$20 = numRecords;
        int x$21 = 0;
        int x$22 = maxPollRecords;
        int x$23 = this.consumeAndVerifyRecords$default$4();
        long x$24 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$25 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$26 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$19, x$20, x$21, x$23, x$24, x$25, x$26, x$22);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)3000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)2000)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener();
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
        Thread.sleep(3500L);
        consumer0.poll(0L);
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)2L, (long)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this, consumer0, commitCompleted, committedPosition){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer0$1;
            private final BooleanRef commitCompleted$1;
            private final LongRef committedPosition$1;

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (this.callsToRevoked() > 0) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer0$1.position(this.$outer.tp());
                    this.consumer0$1.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer0$1 = consumer0$1;
                this.commitCompleted$1 = commitCompleted$1;
                this.committedPosition$1 = committedPosition$1;
            }
        };
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(0L);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"otherTopic"}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(0L);
        Assert.assertEquals((long)0L, (long)committedPosition.elem);
        Assert.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(0L);
        consumer0.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$2.poll(50L);
                java.util.Set set = this.consumer0$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$1 = assignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava(), this.consumer0$2.assignment()}));
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$1 = assignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$3.poll(50L);
                java.util.Set set = this.consumer0$3.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$3 = consumer0$3;
                this.assignment$2 = assignment$2;
            }
        }, (Function0<String>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;
            private final scala.collection.immutable.Set assignment$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava(), this.consumer0$3.assignment()}));
            }
            {
                this.consumer0$3 = consumer0$3;
                this.assignment$2 = assignment$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.wakeup();
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        this.sendRecords(10);
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(topic2, 0));
        this.sendRecords(1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(topic3, 0));
        this.sendRecords(1000, new TopicPartition(topic3, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        ((KafkaConsumer)this.consumers().head()).subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(topic4, 0));
        this.sendRecords(1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ((KafkaConsumer)this.consumers().head()).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(fooTopic, 0));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer0.subscribe(pattern1, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        consumer0.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$4.poll(50L);
                java.util.Set set = this.consumer0$4.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$4 = consumer0$4;
                this.subscriptions$2 = subscriptions$2;
            }
        }, (Function0<String>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;
            private final ObjectRef subscriptions$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava(), this.consumer0$4.assignment()}));
            }
            {
                this.consumer0$4 = consumer0$4;
                this.subscriptions$2 = subscriptions$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(barTopic, 0));
        Pattern pattern2 = Pattern.compile("...");
        consumer0.subscribe(pattern2, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        consumer0.poll(50L);
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$4.poll(50L);
                java.util.Set set = this.consumer0$4.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$4 = consumer0$4;
                this.subscriptions$2 = subscriptions$2;
            }
        }, (Function0<String>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;
            private final ObjectRef subscriptions$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava(), this.consumer0$4.assignment()}));
            }
            {
                this.consumer0$4 = consumer0$4;
                this.subscriptions$2 = subscriptions$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ((KafkaConsumer)this.consumers().head()).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, "foo");
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), callback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((Object)asyncMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.poll(0L);
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)new Serializable(this, consumer, callback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BaseConsumerTest.CountConsumerCommitCallback callback$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)this.callback$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.callback$1 = callback$1;
            }
        });
        this.awaitCommitCallback(consumer, callback, count);
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$5 = subscriptions$5;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$5;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$5 = subscriptions$5;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava(), ((KafkaConsumer)this.$outer.consumers().head()).assignment()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4());
        java.util.List parts = ((KafkaConsumer)this.consumers().head()).partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        java.util.List partitions = ((KafkaConsumer)this.consumers().head()).partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        ((KafkaConsumer)this.consumers().head()).partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        this.sendRecords((int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$27 = consumer;
        int x$28 = 1;
        int x$29 = 0;
        TopicPartition x$30 = this.tp2();
        int x$31 = this.consumeAndVerifyRecords$default$4();
        long x$32 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$33 = this.consumeAndVerifyRecords$default$6();
        int x$34 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$27, x$28, x$29, x$31, x$32, x$33, x$30, x$34);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$35 = consumer;
        int x$36 = 1;
        int x$37 = (int)mid;
        int x$38 = (int)mid;
        long x$39 = mid;
        TopicPartition x$40 = this.tp2();
        TimestampType x$41 = this.consumeAndVerifyRecords$default$6();
        int x$42 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$35, x$36, x$37, x$38, x$39, x$41, x$40, x$42);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        String x$43 = this.brokerList();
        SecurityProtocol x$44 = this.securityProtocol();
        Option<File> x$45 = this.trustStoreFile();
        Option<Properties> x$46 = this.clientSaslProperties();
        int x$47 = 0;
        long x$48 = Long.MAX_VALUE;
        Some x$49 = new Some((Object)producerProps);
        int x$50 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$51 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$52 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$53 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$54 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$55 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$43, x$50, x$51, x$52, x$47, x$48, x$53, x$44, x$45, x$46, x$54, x$55, (Option<Properties>)x$49);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, tp, producer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.tp$1 = tp$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        this.sendRecords(5);
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().head()).committed(new TopicPartition(this.topic(), 15)));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((KafkaConsumer)this.$outer.consumers().head()).position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        ((KafkaConsumer)this.consumers().head()).commitSync();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        ((KafkaConsumer)this.consumers().head()).commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(1)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(1)), 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        this.sendRecords(5);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        ((KafkaConsumer)this.consumers().head()).pause((Collection)partitions);
        this.sendRecords(5);
        Assert.assertTrue((boolean)((KafkaConsumer)this.consumers().head()).poll(0L).isEmpty());
        ((KafkaConsumer)this.consumers().head()).resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int totalRecords = 2;
        this.sendRecords(totalRecords, this.tp());
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$5.poll(50L);
            }
            {
                this.consumer0$5 = consumer0$5;
            }
        }, ClassTag$.MODULE$.apply(NoOffsetForPartitionException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        int outOfRangePos = totalRecords + 1;
        consumer0.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$5.poll(20000L);
            }
            {
                this.consumer0$5 = consumer0$5;
            }
        }, ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        ((KafkaProducer)this.producers().head()).send(record);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer0.poll(20000L);
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        ((KafkaProducer)this.producers().head()).send(smallRecord).get();
        ((KafkaProducer)this.producers().head()).send(largeRecord).get();
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer0.poll(20000L);
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final scala.collection.immutable.Map<Object, Object> apply(String topicName) {
                return this.$outer.createTopic(topicName, this.partitionCount$1, this.$outer.serverCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        });
        Seq partitions = (Seq)topics.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final int partitionCount$1;

            public final IndexedSeq<TopicPartition> apply(String topic) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount$1).map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final TopicPartition apply(int x$1) {
                        return new TopicPartition(this.topic$1, x$1);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, partitions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$6;
            private final Seq partitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$6.poll(50L);
                java.util.Set set = this.consumer0$6.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions$1.toSet()).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$6 = consumer0$6;
                this.partitions$1 = partitions$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, partitions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$6;
            private final Seq partitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitions$1).asJava(), this.consumer0$6.assignment()}));
            }
            {
                this.consumer0$6 = consumer0$6;
                this.partitions$1 = partitions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq producerRecords = (Seq)partitions.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final Seq<ProducerRecord<byte[], byte[]>> apply(TopicPartition x$2) {
                return this.$outer.sendRecords(this.partitionCount$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer0, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Integer, String, String, Long> apply(ProducerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp());
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Object, String, String, Object> apply(ConsumerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp()));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$7.poll(50L);
                java.util.Set set = this.consumer0$7.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$7 = consumer0$7;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava(), this.consumer0$7.assignment()}));
            }
            {
                this.consumer0$7 = consumer0$7;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$7.poll(50L);
                java.util.Set set = this.consumer0$7.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$7 = consumer0$7;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava(), this.consumer0$7.assignment()}));
            }
            {
                this.consumer0$7 = consumer0$7;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$7.poll(50L);
                java.util.Set set = this.consumer0$7.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$7 = consumer0$7;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava(), this.consumer0$7.assignment()}));
            }
            {
                this.consumer0$7 = consumer0$7;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        Buffer consumerPollers;
        Buffer buffer;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) throw new MatchError(tuple2);
        Buffer consumerPollers2 = buffer = (consumerPollers = (Buffer)tuple2._2());
        try {
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, this.consumers(), (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var4_7;
            var4_7.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$3) {
                    x$3.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> reverse(scala.collection.immutable.Map<Object, scala.collection.immutable.Set<TopicPartition>> m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map m$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition v) {
                return new Tuple2((Object)v, ((IterableLike)this.m$1.keys().filter((Function1)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$reverse$1 $outer;
                    private final TopicPartition v$1;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return ((SetLike)this.$outer.m$1.apply((Object)BoxesRunTime.boxToLong((long)x$4))).contains((Object)this.v$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.v$1 = v$1;
                    }
                })).head());
            }
            {
                this.m$1 = m$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Test
    public void testMultiConsumerStickyAssignment() {
        this.consumers().clear();
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions);
        if (tuple2 != null) {
            Buffer consumerPollers;
            Buffer buffer;
            Buffer consumerPollers2 = buffer = (consumerPollers = (Buffer)tuple2._2());
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(partitions).asJava()})), this.validateGroupAssignment$default$4());
            scala.collection.immutable.Map<TopicPartition, Object> prePartition2PollerId = this.reverse((scala.collection.immutable.Map<Object, scala.collection.immutable.Set<TopicPartition>>)((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.addConsumersToGroupAndWaitForGroupAssignment(1, this.consumers(), (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions);
            scala.collection.immutable.Map<TopicPartition, Object> postPartition2PollerId = this.reverse((scala.collection.immutable.Map<Object, scala.collection.immutable.Set<TopicPartition>>)((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
            IntRef changes = IntRef.create((int)0);
            keys.foreach((Function1)new Serializable(this, prePartition2PollerId, postPartition2PollerId, changes){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map prePartition2PollerId$1;
                private final scala.collection.immutable.Map postPartition2PollerId$1;
                private final IntRef changes$1;

                public final void apply(TopicPartition key) {
                    Option preVal = this.prePartition2PollerId$1.get((Object)key);
                    Option postVal = this.postPartition2PollerId$1.get((Object)key);
                    if (preVal.nonEmpty() && postVal.nonEmpty()) {
                        if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                            ++this.changes$1.elem;
                        }
                    } else {
                        ++this.changes$1.elem;
                    }
                }
                {
                    this.prePartition2PollerId$1 = prePartition2PollerId$1;
                    this.postPartition2PollerId$1 = postPartition2PollerId$1;
                    this.changes$1 = changes$1;
                }
            });
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$5) {
                    x$5.shutdown();
                }
            });
            Assert.assertEquals((String)"Expected only two topic partitions that have switched to other consumers.", (long)rand, (long)changes.elem);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerDefaultAssignment() {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 5, 100));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers(this.consumers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, this.consumers(), consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$6) {
                    x$6.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$1.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$1 = testProducer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null);
            throw this.fail("Should not allow sending a null record", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1007));
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
            this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
            KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
            testConsumer.seek(this.tp(), 0L);
            ArrayBuffer records2 = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, appendStr, records2){
                public static final long serialVersionUID = 0L;
                private final String appendStr$1;
                private final ArrayBuffer records$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ConsumerRecord record = (ConsumerRecord)this.records$2.apply(i);
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new String((String)record.key()));
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.appendStr$1})).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
                }
                {
                    this.appendStr$1 = appendStr$1;
                    this.records$2 = records$2;
                }
            });
            int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
            testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
            Assert.assertEquals((long)2L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback();
            testConsumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(5L))}))).asJava(), (OffsetCommitCallback)commitCallback);
            this.awaitCommitCallback(testConsumer, commitCallback, this.awaitCommitCallback$default$3());
            Assert.assertEquals((long)5L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            testConsumer.close();
            testProducer.close();
            MockConsumerInterceptor.resetCounters();
            MockProducerInterceptor.resetCounters();
            return;
        }
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        int numRecords = 100;
        KafkaProducer testProducer = new KafkaProducer(this.producerConfig(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$2;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$2.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$2 = testProducer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$8) {
                return x$8.get();
            }
        });
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)testConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)20L, (long)testConsumer.committed(this.tp2()).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        this.producers().$plus$eq((Object)testProducer);
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$).getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)testConsumer);
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = (ConsumerRecord)records2.head();
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$), (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        this.sendRecords(numRecords, this.tp());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        KafkaConsumer x$56 = (KafkaConsumer)this.consumers().head();
        int x$57 = numRecords;
        TopicPartition x$58 = this.tp2();
        int x$59 = 0;
        int x$60 = 0;
        long x$61 = 0L;
        TimestampType x$62 = this.consumeAndVerifyRecords$default$6();
        int x$63 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$56, x$57, x$59, x$60, x$61, x$62, x$58, x$63);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        this.sendRecords(numRecords, tp1);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        KafkaConsumer x$64 = (KafkaConsumer)this.consumers().head();
        int x$65 = numRecords;
        TopicPartition x$66 = tp1;
        int x$67 = 0;
        int x$68 = 0;
        long x$69 = startTime;
        TimestampType x$70 = TimestampType.LOG_APPEND_TIME;
        int x$71 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$64, x$65, x$67, x$68, x$69, x$70, x$66, x$71);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        KafkaConsumer x$72 = (KafkaConsumer)this.consumers().head();
        int x$73 = numRecords;
        TopicPartition x$74 = tp2;
        int x$75 = 0;
        int x$76 = 0;
        long x$77 = startTime;
        TimestampType x$78 = TimestampType.LOG_APPEND_TIME;
        int x$79 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$72, x$73, x$75, x$76, x$77, x$78, x$74, x$79);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        java.util.Map topics = ((KafkaConsumer)this.consumers().head()).listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.intercept((Function0)new Serializable(this, topic1, consumer){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;
            private final KafkaConsumer consumer$3;

            public final java.util.Map<TopicPartition, OffsetAndTimestamp> apply() {
                return this.consumer$3.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic1$1, 0), Predef$.MODULE$.long2Long(-1L)));
            }
            {
                this.topic1$1 = topic1$1;
                this.consumer$3 = consumer$3;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1203));
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3})).foreach((Function1)new Serializable(this, numParts, timestampsToSearch, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int numParts$1;
            public final HashMap timestampsToSearch$1;
            public final IntRef i$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numParts$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testOffsetsForTimes$2 $outer;
                    private final String topic$2;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.topic$2, part);
                        this.$outer.kafka$api$PlaintextConsumerTest$$anonfun$$$outer().sendRecords(100, tp);
                        this.$outer.timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(this.$outer.i$1.elem * 20)));
                        ++this.$outer.i$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$2 = topic$2;
                    }
                });
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numParts$1 = numParts$1;
                this.timestampsToSearch$1 = timestampsToSearch$1;
                this.i$1 = i$1;
            }
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).offset());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).timestamp());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).offset());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).timestamp());
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 0)));
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 1)));
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).offset());
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).timestamp());
        Assert.assertEquals(null, timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        this.createTopicAndSendRecords(topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(100, new TopicPartition(topic1, 0));
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t1p0));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t1p0));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener();
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer0.poll(50L);
        }
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        this.sendRecords(5);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer0.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        this.sendRecords(5, this.tp());
        this.sendRecords(7, this.tp2());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        long pos1 = ((KafkaConsumer)this.consumers().head()).position(this.tp());
        long pos2 = ((KafkaConsumer)this.consumers().head()).position(this.tp2());
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().head()).committed(this.tp2()));
        Assert.assertEquals((long)pos1, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        Assert.assertEquals((long)pos2, (long)((KafkaConsumer)this.consumers().head()).position(this.tp2()));
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)5L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
        BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(7L))}))).asJava(), (OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((long)7L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int numRecords = 10000;
        this.sendRecords(numRecords);
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, consumer0){
            private final KafkaConsumer consumer0$8;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer0$8.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer0$8 = consumer0$8;
            }
        };
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$8;
            private final scala.collection.immutable.Set assignment$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$8.poll(50L);
                java.util.Set set = this.consumer0$8.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$8 = consumer0$8;
                this.assignment$3 = assignment$3;
            }
        }, (Function0<String>)new Serializable(this, consumer0, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$8;
            private final scala.collection.immutable.Set assignment$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$3).asJava(), this.consumer0$8.assignment()}));
            }
            {
                this.consumer0$8 = consumer0$8;
                this.assignment$3 = assignment$3;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$8;
            private final scala.collection.immutable.Set newAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$8.poll(50L);
                java.util.Set set = this.consumer0$8.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$8 = consumer0$8;
                this.newAssignment$1 = newAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer0, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$8;
            private final scala.collection.immutable.Set newAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava(), this.consumer0$8.assignment()}));
            }
            {
                this.consumer0$8 = consumer0$8;
                this.newAssignment$1 = newAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)300L, (long)consumer0.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)consumer0.committed(this.tp2()).offset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        try {
            BaseConsumerTest.TestConsumerReassignmentListener listener0 = new BaseConsumerTest.TestConsumerReassignmentListener();
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
            ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlaintextConsumerTest $outer;
                private final KafkaConsumer consumer$4;
                private final ObjectRef records$3;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.records$3.elem = this.consumer$4.poll(100L);
                    return !((ConsumerRecords)this.records$3.elem).records(this.$outer.tp()).isEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.consumer$4 = consumer$4;
                    this.records$3 = records$3;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Consumer did not consume any message before timeout.";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener0.callsToAssigned());
            HashMap<String, String> tags1 = new HashMap<String, String>();
            tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
            tags1.put("topic", this.tp().topic());
            tags1.put("partition", String.valueOf(this.tp().partition()));
            HashMap<String, String> tags2 = new HashMap<String, String>();
            tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
            tags2.put("topic", this.tp2().topic());
            tags2.put("partition", String.valueOf(this.tp2().partition()));
            Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
            Assert.assertNotNull((Object)fetchLag0);
            int expectedLag = numMessages - ((ConsumerRecords)records2.elem).count();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)fetchLag0.value(), (double)this.epsilon());
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, listener0){
                public static final long serialVersionUID = 0L;
                private final KafkaConsumer consumer$4;
                private final BaseConsumerTest.TestConsumerReassignmentListener listener0$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.consumer$4.poll(100L);
                    return this.listener0$1.callsToAssigned() >= 2;
                }
                {
                    this.consumer$4 = consumer$4;
                    this.listener0$1 = listener0$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Expected rebalance did not occur.";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
            Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        consumer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        this.sendRecords(numMessages, this.tp());
        this.sendRecords(numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        try {
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
            ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlaintextConsumerTest $outer;
                private final KafkaConsumer consumer$5;
                private final ObjectRef records$4;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.records$4.elem = this.consumer$5.poll(100L);
                    return !((ConsumerRecords)this.records$4.elem).records(this.$outer.tp()).isEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.consumer$5 = consumer$5;
                    this.records$4 = records$4;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Consumer did not consume any message before timeout.";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
            tags.put("topic", this.tp().topic());
            tags.put("partition", String.valueOf(this.tp().partition()));
            Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
            Assert.assertNotNull((Object)fetchLag);
            java.util.Map<String, String> oldTags = Collections.singletonMap("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
            Metric oldFetchLag = (Metric)consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", oldTags));
            Assert.assertEquals((Object)fetchLag.metricValue(), (Object)oldFetchLag.metricValue());
            int expectedLag = numMessages - ((ConsumerRecords)records2.elem).count();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)fetchLag.value(), (double)this.epsilon());
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                private final KafkaConsumer consumer$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return !this.consumer$5.poll(100L).isEmpty();
                }
                {
                    this.consumer$5 = consumer$5;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Consumer did not consume any message before timeout.";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertNull(consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", tags)));
            Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        consumer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        this.sendRecords(numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
                public static final long serialVersionUID = 0L;
                private final KafkaConsumer consumer$6;
                private final ObjectRef records$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.records$5.elem = this.consumer$6.poll(100L);
                    return !((ConsumerRecords)this.records$5.elem).isEmpty();
                }
                {
                    this.consumer$6 = consumer$6;
                    this.records$5 = records$5;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Consumer did not consume any message before timeout.";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            java.util.Map<String, String> oldTags = Collections.singletonMap("client-id", "testPerPartitionLagWithMaxPollRecords");
            Metric oldLag = (Metric)consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", oldTags));
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
            tags.put("topic", this.tp().topic());
            tags.put("partition", String.valueOf(this.tp().partition()));
            Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
            Assert.assertEquals((Object)oldLag.metricValue(), (Object)lag.metricValue());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMessages - ((ConsumerRecords)records2.elem).count()))})), (double)(numMessages - ((ConsumerRecords)records2.elem).count()), (double)lag.value(), (double)this.epsilon());
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        consumer.close();
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        this.sendRecords(numRecords);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$9) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$9, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$10) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$10, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$11) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$11, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$12) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$12, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$13) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$13, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$14) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$14, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$15) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$15, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$16) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$16, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$17) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(x$17);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers().foreach((Function1)new Serializable(this, topic1, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic1$2;
            private final Buffer consumerPollers$4;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$4.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic(), this.topic1$2})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$2 = topic1$2;
                this.consumerPollers$4 = consumerPollers$4;
            }
        });
        KafkaConsumer timeoutConsumer = new KafkaConsumer(this.consumerConfig());
        Object object = closeConsumer ? BoxedUnit.UNIT : this.consumers().$plus$eq((Object)timeoutConsumer);
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.serverCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords(this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$5;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$5.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$5 = consumerPollers$5;
            }
        });
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                return this.consumerGroup$2.$plus$eq((Object)new KafkaConsumer(this.$outer.consumerConfig()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        this.consumers().$plus$plus$eq((TraversableOnce)consumerGroup);
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$2;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int _) {
                KafkaConsumer newConsumer = new KafkaConsumer(this.$outer.consumerConfig());
                this.consumerGroup$1.$plus$eq((Object)newConsumer);
                return this.consumerPollers$2.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)newConsumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$2 = consumerPollers$2;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$1;
            private final scala.collection.immutable.Set subscriptions$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$1.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$18) {
                        return this.assignments$1.$plus$eq(x$18.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerPollers$1 = consumerPollers$1;
                this.subscriptions$6 = subscriptions$6;
            }
        }, (Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, waitTime, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$3 = consumerPollers$3;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$7;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscriptions$7}));
            }
            {
                this.subscriptions$7 = subscriptions$7;
            }
        }, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set subscriptions$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$2.poll(50L);
                java.util.Set set = this.consumer$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$8).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$2 = consumer$2;
                this.subscriptions$8 = subscriptions$8;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set subscriptions$8;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$8).asJava(), this.consumer$2.assignment()}));
            }
            {
                this.consumer$2 = consumer$2;
                this.subscriptions$8 = subscriptions$8;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }
}

