/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8oiJ|G\u000e\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012aB:feZ,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0003EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0013\u0001\u0001\u0004%\tAJ\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\u0005+:LG\u000fC\u0004-I\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAF\u0001\tg\u0016\u0014h/\u001a:tA!)\u0001\u0007\u0001C!c\u0005)1/\u001a;VaR\tq\u0005\u000b\u00020gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002q\u0005\u0019qN]4\n\u0005i*$A\u0002\"fM>\u0014X\rC\u0003=\u0001\u0011\u0005\u0013'\u0001\u0005uK\u0006\u0014Hi\\<oQ\tYd\b\u0005\u00025\u007f%\u0011\u0001)\u000e\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006\u0005\u0002!\t!M\u0001\u0011i\u0016\u001cH/R7qif\u001cE.^:uKJD#!\u0011#\u0011\u0005Q*\u0015B\u0001$6\u0005\u0011!Vm\u001d;\t\u000b!\u0003A\u0011A\u0019\u0002[Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195QKJ\u001c\u0018n\u001d;t/\",g.\u00117m\u0005J|7.\u001a:t\t><h\u000e\u000b\u0002H\t\")1\n\u0001C\u0001c\u0005YC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u0013:\u001c'/Z7f]R\u001c8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u000b\u0002K\t\")a\n\u0001C\u0001c\u0005\tB/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u00055#\u0005\"B)\u0001\t\u0003\t\u0014a\t;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019\u0015\u0003!\u0012CQ\u0001\u0016\u0001\u0005\u0002E\n1\u0004^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007FA*E\u0011\u00159\u0006\u0001\"\u00012\u00035\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8FqB\fgn]5p]^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019\u0015\u0003-\u0012CQA\u0017\u0001\u0005\u0002E\n\u0011\u0004^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\"\u0012\u0011\f\u0012\u0005\u0006;\u0002!\t!M\u0001;i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGoV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u000bG\u000e^5oOB\u0013xn\u001a:fgND#\u0001\u0018#\t\u000b\u0001\u0004A\u0011A\u0019\u0002oQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e*fgVlWm]!gi\u0016\u0014(+\u001a9mS\u000e\f7i\\7fg>sG.\u001b8fQ\tyF\tC\u0003d\u0001\u0011\u0005\u0011'\u0001\u0012uKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003E\u0012CQA\u001a\u0001\u0005\u0002E\nQ\u0006^3ti\n\u000b7m\u001b+p\u0005\u0006\u001c7\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8tQ\t)G\tC\u0003j\u0001\u0011\u0005\u0011'A\u001fuKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\\,ji\"|eM\u001a7j]\u0016\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017\r\u000b\u0002i\t\")A\u000e\u0001C\u0001c\u00051C/Z:u\u0003V$x\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005-$\u0005\"B8\u0001\t\u0003\t\u0014\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007F\u00018E\u0011\u0015\u0011\b\u0001\"\u00012\u0003\r#Xm\u001d;MK\u0006$WM]!oI&\u001b(o\u00165f]\u0016sG/\u001b:f\u0013N\u0014xJ\u001a4mS:,\u0017I\u001c3V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3)\u0005E$\u0005\"B;\u0001\t\u00131\u0018A\b9sK\u001a,'O]3e%\u0016\u0004H.[2b\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o)!9s\u000f @\u0002\u000e\u0005}\u0001\"\u0002=u\u0001\u0004I\u0018\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007C\u0001\u0015{\u0013\tY(DA\u0002J]RDQ! ;A\u0002y\t1b\u001c;iKJ\u0014%o\\6fe\"1q\u0010\u001ea\u0001\u0003\u0003\t!\u0001\u001e9\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u0005\u0003\u0019\u0019w.\\7p]&!\u00111BA\u0003\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u001f!\b\u0019AA\t\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#BA\n\u00033Ihb\u0001\u0015\u0002\u0016%\u0019\u0011q\u0003\u000e\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\u0007M+GOC\u0002\u0002\u0018iAa!!\tu\u0001\u0004I\u0018a\u00037fC\u0012,'/\u00129pG\"Dq!!\n\u0001\t\u0013\t9#\u0001\rxC&$XK\u001c;jY\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$RaJA\u0015\u0003[Aq!a\u000b\u0002$\u0001\u0007\u00110A\u0003fa>\u001c\u0007\u000e\u0003\u0005\u00020\u0005\r\u0002\u0019AA\u0019\u0003\u001diWm]:bO\u0016\u0004B!a\u0005\u00024%!\u0011QGA\u000f\u0005\u0019\u0019FO]5oO\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0012!F<bSR4uN\u001d)beRLG/[8o'R\fG/\u001a\u000b\fO\u0005u\u0012qHA\"\u0003\u000f\nI\u0005C\u0004\u0000\u0003o\u0001\r!!\u0001\t\u000f\u0005\u0005\u0013q\u0007a\u0001s\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002F\u0005]\u0002\u0019A=\u0002\r1,\u0017\rZ3s\u0011\u001d\t\t#a\u000eA\u0002eD\u0001\"a\f\u00028\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003aI7/\u0012=qK\u000e$X\r\u001a)beRLG/[8o'R\fG/\u001a\u000b\u000b\u0003#\n9&!\u0019\u0002d\u0005\u0015\u0004c\u0001\u0015\u0002T%\u0019\u0011Q\u000b\u000e\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011LA&\u0001\u0004\tY&A\u000emK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004%\u0005u\u0013bAA0\u0005\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"Dq!!\u0011\u0002L\u0001\u0007\u0011\u0010C\u0004\u0002F\u0005-\u0003\u0019A=\t\u000f\u0005\u0005\u00121\na\u0001s\"9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0014aC7bW\u0016\u001cVM\u001d<feN$rAFA7\u0003c\n)\bC\u0004\u0002p\u0005\u001d\u0004\u0019A=\u0002\u00159,XnQ8oM&<7\u000f\u0003\u0006\u0002t\u0005\u001d\u0004\u0013!a\u0001\u0003#\n\u0011$Y;u_2+\u0017\rZ3s%\u0016\u0014\u0017\r\\1oG\u0016,e.\u00192mK\"Q\u0011qOA4!\u0003\u0005\r!!\u0015\u00027Ut7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197f\u0011\u001d\tY\b\u0001C\u0005\u0003{\nQ\u0001^5nKJ$B!a \u0002\u0018B!\u0011\u0011QAJ\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001B2pe\u0016TA!!#\u0002\f\u00069Q.\u001a;sS\u000e\u001c(\u0002BAG\u0003\u001f\u000ba!_1n[\u0016\u0014(BAAI\u0003\r\u0019w.\\\u0005\u0005\u0003+\u000b\u0019IA\u0003US6,'\u000f\u0003\u0005\u0002\u001a\u0006e\u0004\u0019AA\u0019\u0003)iW\r\u001e:jG:\u000bW.\u001a\u0005\n\u0003;\u0003\u0011\u0013!C\u0005\u0003?\u000bQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\"*\"\u0011\u0011KARW\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0013Ut7\r[3dW\u0016$'bAAX5\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\\\u0001E\u0005I\u0011BAP\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uIM\u0002")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to kill controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$1) {
                return x$1.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return x$2 != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicAndPartition tp0 = new TopicAndPartition("t", 0);
        TopicAndPartition tp1 = new TopicAndPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ZkUtils qual$1 = this.zkUtils();
        String x$23 = ZkUtils$.MODULE$.getTopicPath(tp0.topic());
        String x$24 = this.zkUtils().replicaAssignmentZkData((Map)expandedAssignment.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> kv) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString()), kv._2());
            }
        }, Map$.MODULE$.canBuildFrom()));
        java.util.List x$25 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$23, x$24, x$25);
        this.waitForPartitionState(tp1, KafkaController$.MODULE$.InitialControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$3) {
                return x$3.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 != this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head());
        TopicAndPartition tp0 = new TopicAndPartition("t", 0);
        TopicAndPartition tp1 = new TopicAndPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$2 = this.zkUtils();
        String x$26 = ZkUtils$.MODULE$.getTopicPath(tp0.topic());
        String x$27 = this.zkUtils().replicaAssignmentZkData((Map)expandedAssignment.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> kv) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString()), kv._2());
            }
        }, Map$.MODULE$.canBuildFrom()));
        java.util.List x$28 = qual$2.updatePersistentPath$default$3();
        qual$2.updatePersistentPath(x$26, x$27, x$28);
        this.waitForPartitionState(tp1, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=ControllerStats,name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ControllerState.PartitionReassignment$.MODULE$.rateAndTimeMetricName().get()}));
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$5) {
                return x$5.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 != this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ZkUtils qual$3 = this.zkUtils();
        String x$29 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$30 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$31 = qual$3.createPersistentPath$default$3();
        qual$3.createPersistentPath(x$29, x$30, x$31);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicAndPartition tp$2;
            private final scala.collection.immutable.Map reassignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.mutable.Map map = this.$outer.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$2.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$1;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.reassignment$1 = reassignment$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer count ", " should be greater than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updatedTimerCount), BoxesRunTime.boxToLong((long)timerCount)})), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$7) {
                return x$7.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$4;

            public final boolean apply(int x$8) {
                return this.apply$mcZI$sp(x$8);
            }

            public boolean apply$mcZI$sp(int x$8) {
                return x$8 != this.controllerId$4;
            }
            {
                this.controllerId$4 = controllerId$4;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$4 = this.zkUtils();
        String x$32 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$33 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$34 = qual$4.createPersistentPath$default$3();
        qual$4.createPersistentPath(x$32, x$33, x$34);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "partition reassignment path should remain while reassignment in progress";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$9) {
                return x$9.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$5;

            public final boolean apply(int x$10) {
                return this.apply$mcZI$sp(x$10);
            }

            public boolean apply$mcZI$sp(int x$10) {
                return x$10 != this.controllerId$5;
            }
            {
                this.controllerId$5 = controllerId$5;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$5 = this.zkUtils();
        String x$35 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$36 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$37 = qual$5.createPersistentPath$default$3();
        qual$5.createPersistentPath(x$35, x$36, x$37);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicAndPartition tp$3;
            private final scala.collection.immutable.Map reassignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.mutable.Map map = this.$outer.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$3.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$2;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$3 = tp$3;
                this.reassignment$2 = reassignment$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$6;

            public final boolean apply(KafkaServer x$11) {
                return x$11.config().brokerId() != this.controllerId$6;
            }
            {
                this.controllerId$6 = controllerId$6;
            }
        }).get();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$7;

            public final boolean apply(KafkaServer x$12) {
                return x$12.config().brokerId() != this.controllerId$7;
            }
            {
                this.controllerId$7 = controllerId$7;
            }
        }).get();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$13) {
                return x$13.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$8;

            public final boolean apply(int x$14) {
                return this.apply$mcZI$sp(x$14);
            }

            public boolean apply$mcZI$sp(int x$14) {
                return x$14 != this.controllerId$8;
            }
            {
                this.controllerId$8 = controllerId$8;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$6 = this.zkUtils();
        String x$38 = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        String x$39 = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
        java.util.List x$40 = qual$6.createPersistentPath$default$3();
        qual$6.createPersistentPath(x$38, x$39, x$40);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after giving up";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$15) {
                return x$15.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$9;

            public final boolean apply(int x$16) {
                return this.apply$mcZI$sp(x$16);
            }

            public boolean apply$mcZI$sp(int x$16) {
                return x$16 != this.controllerId$9;
            }
            {
                this.controllerId$9 = controllerId$9;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$17) {
                return x$17.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$10;

            public final boolean apply(int x$18) {
                return this.apply$mcZI$sp(x$18);
            }

            public boolean apply$mcZI$sp(int x$18) {
                return x$18 != this.controllerId$10;
            }
            {
                this.controllerId$10 = controllerId$10;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$1;
            private final TopicAndPartition tp$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.tp$5})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$5)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5), KafkaController$.MODULE$.InitialControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$1}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$1 = otherBrokerId$1;
                this.tp$5 = tp$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$41 = 2;
        boolean x$42 = true;
        boolean x$43 = this.makeServers$default$2();
        this.servers_$eq(this.makeServers(x$41, x$43, x$42));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$19) {
                return x$19.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$11;

            public final boolean apply(int x$20) {
                return this.apply$mcZI$sp(x$20);
            }

            public boolean apply$mcZI$sp(int x$20) {
                return x$20 != this.controllerId$11;
            }
            {
                this.controllerId$11 = controllerId$11;
            }
        })).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$2;
            private final TopicAndPartition tp$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.tp$6})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$6)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6), KafkaController$.MODULE$.InitialControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$2}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$2 = otherBrokerId$2;
                this.tp$6 = tp$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicAndPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, replicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicAndPartition tp$4;
            private final scala.collection.immutable.Set replicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set set = this.$outer.zkUtils().getInSyncReplicasForPartition(this.tp$4.topic(), this.tp$4.partition()).toSet();
                scala.collection.immutable.Set set2 = this.replicas$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$4 = tp$4;
                this.replicas$1 = replicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "restarted broker failed to join in-sync replicas";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ZkUtils qual$7 = this.zkUtils();
        String x$44 = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        String x$45 = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
        java.util.List x$46 = qual$7.createPersistentPath$default$3();
        qual$7.createPersistentPath(x$44, x$45, x$46);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int epoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option option = ((Option)this.$outer.zkUtils().readDataMaybeNull(ZkUtils$.MODULE$.ControllerEpochPath())._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$21) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$21)).toInt();
                    }
                });
                Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.epoch$1));
                return !(option != null ? !option.equals(some) : some != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void waitForPartitionState(TopicAndPartition tp, int controllerEpoch, int leader2, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, controllerEpoch, leader2, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicAndPartition tp$1;
            private final int controllerEpoch$1;
            private final int leader$1;
            private final int leaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.tp$1})));
                return leaderIsrAndControllerEpochMap.contains((Object)this.tp$1) && this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$1), this.controllerEpoch$1, this.leader$1, this.leaderEpoch$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leader$1 = leader$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$2;

            public final String apply() {
                return this.message$2;
            }
            {
                this.message$2 = message$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public boolean kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader2, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader2 && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1)new Serializable(this, autoLeaderRebalanceEnable, uncleanLeaderElectionEnable){
            public static final long serialVersionUID = 0L;
            private final boolean autoLeaderRebalanceEnable$1;
            private final boolean uncleanLeaderElectionEnable$1;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.autoLeaderRebalanceEnable$1)).toString());
                config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.uncleanLeaderElectionEnable$1)).toString());
                return config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
            }
            {
                this.autoLeaderRebalanceEnable$1 = autoLeaderRebalanceEnable$1;
                this.uncleanLeaderElectionEnable$1 = uncleanLeaderElectionEnable$1;
            }
        });
        return (Seq)configs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties config) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$22) {
                String string = x$22.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final String metricName$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metricName$1 = metricName$1;
            }
        });
    }
}

