/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.DelegationToken$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCache;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u0001-\u0011!\u0004R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d+fgRT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u0005)Ao\\6f]*\u0011q\u0001C\u0001\tg\u0016\u001cWO]5us*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\t\u0003\tQ8.\u0003\u0002\u0012\u001d\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005!A/[7f+\u0005Q\u0002CA\u000e&\u001b\u0005a\"BA\u000f\u001f\u0003\u0015)H/\u001b7t\u0015\ty\u0002%\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011a\u0005\b\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0001\u0006\u0001Q\u0001\ni\tQ\u0001^5nK\u0002BqA\u000b\u0001C\u0002\u0013\u00051&A\u0003po:,'/F\u0001-!\ti\u0013'D\u0001/\u0015\ty\u0003'\u0001\u0003bkRD'BA\u0004\u001f\u0013\t\u0011dF\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\rQ\u0002\u0001\u0015!\u0003-\u0003\u0019ywO\\3sA!9a\u0007\u0001b\u0001\n\u00039\u0014a\u0002:f]\u0016<XM]\u000b\u0002qA\u0019\u0011\b\u0011\u0017\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u000f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004D\u0001\u0001\u0006I\u0001O\u0001\te\u0016tWm^3sA!9Q\t\u0001b\u0001\n\u00031\u0015!C7bgR,'oS3z+\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0011a\u0017M\\4\u000b\u00031\u000bAA[1wC&\u0011a*\u0013\u0002\u0007'R\u0014\u0018N\\4\t\rA\u0003\u0001\u0015!\u0003H\u0003)i\u0017m\u001d;fe.+\u0017\u0010\t\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0003Qi\u0017\r\u001f'jM\u0016$\u0016.\\3Ng\u0012+g-Y;miV\tA\u000b\u0005\u0002V-6\ta(\u0003\u0002X}\t!Aj\u001c8h\u0011\u0019I\u0006\u0001)A\u0005)\u0006)R.\u0019=MS\u001a,G+[7f\u001bN$UMZ1vYR\u0004\u0003bB.\u0001\u0005\u0004%\taU\u0001\u0013e\u0016tWm\u001e+j[\u0016l5\u000fR3gCVdG\u000f\u0003\u0004^\u0001\u0001\u0006I\u0001V\u0001\u0014e\u0016tWm\u001e+j[\u0016l5\u000fR3gCVdG\u000f\t\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0003)!xn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u00111\u0001\u001a\u0006\u0003\u000bAJ!AZ2\u0003)\u0011+G.Z4bi&|g\u000eV8lK:\u001c\u0015m\u00195f\u0011\u001dA\u0007\u00011A\u0005\u0002%\fa\u0002^8lK:\u001c\u0015m\u00195f?\u0012*\u0017\u000f\u0006\u0002k[B\u0011Qk[\u0005\u0003Yz\u0012A!\u00168ji\"9anZA\u0001\u0002\u0004\t\u0017a\u0001=%c!1\u0001\u000f\u0001Q!\n\u0005\f1\u0002^8lK:\u001c\u0015m\u00195fA!9!\u000f\u0001a\u0001\n\u0003\u0019\u0018!\u00029s_B\u001cX#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]\\\u0015\u0001B;uS2L!!\u001f<\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0001?\u0002\u0013A\u0014x\u000e]:`I\u0015\fHC\u00016~\u0011\u001dq'0!AA\u0002QDaa \u0001!B\u0013!\u0018A\u00029s_B\u001c\b\u0005C\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0011!E2sK\u0006$X\rV8lK:\u0014Vm];miV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0005\u0002\rM,'O^3s\u0013\u0011\t\t\"a\u0003\u0003#\r\u0013X-\u0019;f)>\\WM\u001c*fgVdG\u000fC\u0006\u0002\u0016\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0011!F2sK\u0006$X\rV8lK:\u0014Vm];mi~#S-\u001d\u000b\u0004U\u0006e\u0001\"\u00038\u0002\u0014\u0005\u0005\t\u0019AA\u0004\u0011!\ti\u0002\u0001Q!\n\u0005\u001d\u0011AE2sK\u0006$X\rV8lK:\u0014Vm];mi\u0002B\u0011\"!\t\u0001\u0001\u0004%\t!a\t\u0002\u000b\u0015\u0014(o\u001c:\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-b$\u0001\u0005qe>$xnY8m\u0013\u0011\ty#!\u000b\u0003\r\u0015\u0013(o\u001c:t\u0011%\t\u0019\u0004\u0001a\u0001\n\u0003\t)$A\u0005feJ|'o\u0018\u0013fcR\u0019!.a\u000e\t\u00139\f\t$!AA\u0002\u0005\u0015\u0002\u0002CA\u001e\u0001\u0001\u0006K!!\n\u0002\r\u0015\u0014(o\u001c:!\u0011!\ty\u0004\u0001a\u0001\n\u0003\u0019\u0016aD3ya&\u0014\u0018\u0010V5nKN#\u0018-\u001c9\t\u0013\u0005\r\u0003\u00011A\u0005\u0002\u0005\u0015\u0013aE3ya&\u0014\u0018\u0010V5nKN#\u0018-\u001c9`I\u0015\fHc\u00016\u0002H!Aa.!\u0011\u0002\u0002\u0003\u0007A\u000bC\u0004\u0002L\u0001\u0001\u000b\u0015\u0002+\u0002!\u0015D\b/\u001b:z)&lWm\u0015;b[B\u0004\u0003bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002U\"\"\u0011QJA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.G\u0005)!.\u001e8ji&!\u0011qLA-\u0005\u0019\u0011UMZ8sK\"9\u00111\r\u0001\u0005\u0002\u0005E\u0013\u0001\f;fgR$vn[3o%\u0016\fX/Z:ug^KG\u000f\u001b#fY\u0016<\u0017\r^5p]R{7.\u001a8ESN\f'\r\\3eQ\u0011\t\t'a\u001a\u0011\t\u0005]\u0013\u0011N\u0005\u0005\u0003W\nIF\u0001\u0003UKN$\bbBA8\u0001\u0011\u0005\u0011\u0011K\u0001\u0010i\u0016\u001cHo\u0011:fCR,Gk\\6f]\"\"\u0011QNA4\u0011\u001d\t)\b\u0001C\u0001\u0003#\na\u0002^3tiJ+g.Z<U_.,g\u000e\u000b\u0003\u0002t\u0005\u001d\u0004bBA>\u0001\u0011\u0005\u0011\u0011K\u0001\u0010i\u0016\u001cH/\u0012=qSJ,Gk\\6f]\"\"\u0011\u0011PA4\u0011\u001d\t\t\t\u0001C\u0001\u0003#\n\u0011\u0003^3ti\u0012+7o\u0019:jE\u0016$vn[3oQ\u0011\ty(a\u001a\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\u0006Iq-\u001a;U_.,gn\u001d\u000b\r\u0003\u0017\u000b9+!-\u0002@\u0006u\u0017\u0011\u001d\t\u0007\u0003\u001b\u000bi*!)\u000f\t\u0005=\u0015\u0011\u0014\b\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014bAAN}\u00059\u0001/Y2lC\u001e,\u0017bA!\u0002 *\u0019\u00111\u0014 \u0011\u0007\t\f\u0019+C\u0002\u0002&\u000e\u0014q\u0002R3mK\u001e\fG/[8o)>\\WM\u001c\u0005\t\u0003S\u000b)\t1\u0001\u0002,\u0006aAo\\6f]6\u000bg.Y4feB!\u0011\u0011BAW\u0013\u0011\ty+a\u0003\u0003-\u0011+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJD\u0001\"a-\u0002\u0006\u0002\u0007\u0011QW\u0001\u0014g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM\u001d\t\u0005\u0003o\u000bY,\u0004\u0002\u0002:*\u0011qFB\u0005\u0005\u0003{\u000bILA\nTS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'\u000f\u0003\u0005\u0002B\u0006\u0015\u0005\u0019AAb\u0003-Awn\u001d;TKN\u001c\u0018n\u001c8\u0011\t\u0005\u0015\u0017q\u001b\b\u0005\u0003\u000f\f\tN\u0004\u0003\u0002J\u00065g\u0002BAI\u0003\u0017L\u0011!C\u0005\u0004\u0003\u001fD\u0011a\u00028fi^|'o[\u0005\u0005\u0003'\f).\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u000b\u0007\u0005=\u0007\"\u0003\u0003\u0002Z\u0006m'aB*fgNLwN\u001c\u0006\u0005\u0003'\f)\u000eC\u0004\u0002`\u0006\u0015\u0005\u0019\u0001\u0017\u0002!I,\u0017/^3tiB\u0013\u0018N\\2ja\u0006d\u0007\u0002CAr\u0003\u000b\u0003\r!!:\u0002\u001fI,\u0017/^3ti\u0016$wj\u001e8feN\u0004R!!$\u0002\u001e2Bq!!;\u0001\t\u0003\t\t&A\fuKN$\b+\u001a:j_\u0012L7\rV8lK:,\u0005\u0010]5ss\"\"\u0011q]A4\u0011\u001d\ty\u000f\u0001C!\u0003#\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003[\f\u0019\u0010\u0005\u0003\u0002X\u0005U\u0018\u0002BA|\u00033\u0012Q!\u00114uKJDq!a?\u0001\t\u0013\ti0A\rde\u0016\fG/\u001a+pW\u0016t'+Z:vYR\u001c\u0015\r\u001c7CC\u000e\\Gc\u00016\u0002\u0000\"A!\u0011AA}\u0001\u0004\t9!A\u0002sKRDqA!\u0002\u0001\t\u0013\u00119!A\u000bsK:,wOU3ta>t7/Z\"bY2\u0014\u0017mY6\u0015\u000b)\u0014IAa\u0003\t\u0011\t\u0005!1\u0001a\u0001\u0003KAqA!\u0004\u0003\u0004\u0001\u0007A+A\u0005uS6,7\u000b^1na\u0002")
public class DelegationTokenManagerTest
extends ZooKeeperTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
    private final String masterKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public String masterKey() {
        return this.masterKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int x$1 = 0;
        String x$2 = this.zkConnect();
        boolean x$3 = true;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$3));
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ScramMechanism.mechanismNames()).asScala()).mkString(","));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), this.masterKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac())), "scala.this.Predef.byteArrayOps(scala.Array.apply[Byte]()((ClassTag.Byte: scala.reflect.ClassTag[Byte]))).sameElements[Byte](scala.this.Predef.wrapByteArray(DelegationTokenManagerTest.this.createTokenResult.hmac))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    @Test
    public void testCreateToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assert.assertTrue((!token.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Predef$.MODULE$.byteArrayOps(password).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac())));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option $org_scalatest_assert_macro_left = tokenManager.getToken(tokenId);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assert.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testDescribeToken() {
        List<DelegationToken> tokens;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
        simpleAclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer1, renewer2})), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(owner2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer3})), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        List $org_scalatest_assert_macro_left = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        List<DelegationToken> $org_scalatest_assert_macro_left2 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:unknown")})));
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        List<DelegationToken> $org_scalatest_assert_macro_left3 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)Nil$.MODULE$);
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        List<DelegationToken> $org_scalatest_assert_macro_left4 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1})));
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        List<DelegationToken> $org_scalatest_assert_macro_left5 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, null);
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        List<DelegationToken> $org_scalatest_assert_macro_left6 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        int $org_scalatest_assert_macro_right6 = 0;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        List<DelegationToken> $org_scalatest_assert_macro_left7 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})));
        int $org_scalatest_assert_macro_right7 = 2;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        Acl acl = new Acl(owner1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId3));
        List<DelegationToken> $org_scalatest_assert_macro_left8 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})));
        int $org_scalatest_assert_macro_right8 = 3;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        List<DelegationToken> $org_scalatest_assert_macro_left9 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})));
        int $org_scalatest_assert_macro_right9 = 2;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left9, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        List<DelegationToken> $org_scalatest_assert_macro_left10 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3})));
        int $org_scalatest_assert_macro_right10 = 1;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left10, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        acl = new Acl(renewer2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId2));
        List<DelegationToken> $org_scalatest_assert_macro_left11 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3})));
        int $org_scalatest_assert_macro_right11 = 2;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left11, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        simpleAclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, SimpleAclAuthorizer simpleAclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        return requestedOwners != null && requestedOwners.isEmpty() ? Nil$.MODULE$ : tokenManager.getTokens((Function1)new Serializable(this, simpleAclAuthorizer, hostSession, requestPrincipal, requestedOwners){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;
            private final SimpleAclAuthorizer simpleAclAuthorizer$1;
            private final RequestChannel.Session hostSession$1;
            private final KafkaPrincipal requestPrincipal$1;
            private final List requestedOwners$1;

            public final boolean apply(TokenInformation token) {
                return this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$eligible$1(token, this.simpleAclAuthorizer$1, this.hostSession$1, this.requestPrincipal$1, this.requestedOwners$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simpleAclAuthorizer$1 = simpleAclAuthorizer$1;
                this.hostSession$1 = hostSession$1;
                this.requestPrincipal$1 = requestPrincipal$1;
                this.requestedOwners$1 = requestedOwners$1;
            }
        });
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        List $org_scalatest_assert_macro_left = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        List $org_scalatest_assert_macro_left2 = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    public void kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    public void kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    public final boolean kafka$security$token$delegation$DelegationTokenManagerTest$$authorizeToken$1(String tokenId, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1) {
        return simpleAclAuthorizer$1.authorize(hostSession$1, (Operation)Describe$.MODULE$, new Resource((ResourceType)DelegationToken$.MODULE$, tokenId));
    }

    public final boolean kafka$security$token$delegation$DelegationTokenManagerTest$$eligible$1(TokenInformation token, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1, KafkaPrincipal requestPrincipal$1, List requestedOwners$1) {
        return DelegationTokenManager$.MODULE$.filterToken(requestPrincipal$1, Option$.MODULE$.apply((Object)requestedOwners$1), token, (Function1)new Serializable(this, simpleAclAuthorizer$1, hostSession$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;
            private final SimpleAclAuthorizer simpleAclAuthorizer$1;
            private final RequestChannel.Session hostSession$1;

            public final boolean apply(String tokenId) {
                return this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$authorizeToken$1(tokenId, this.simpleAclAuthorizer$1, this.hostSession$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simpleAclAuthorizer$1 = simpleAclAuthorizer$1;
                this.hostSession$1 = hostSession$1;
            }
        });
    }

    public DelegationTokenManagerTest() {
        this.masterKey = "masterKey";
    }
}

