/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.Json$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0003u.L!!\u0004\u0006\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011B\u000b\u0002\u0013i\\g+\u001a:tS>tW#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\u000bu.4VM]:j_:\u0004\u0003bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0006i>\u0004\u0018nY\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB*ue&tw\r\u0003\u0004+\u0001\u0001\u0006I!I\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f1\u0002!\u0019!C\u0005+\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\f\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u00041\u0001\t\u0007I\u0011B\u000b\u0002\r1,\u0017\rZ3s\u0011\u0019\u0011\u0004\u0001)A\u0005-\u00059A.Z1eKJ\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%I!F\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u00047\u0001\u0001\u0006IAF\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\t\u0005\bq\u0001\u0011\r\u0011\"\u0003\u0016\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007B\u0002\u001e\u0001A\u0003%a#\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA!9A\b\u0001b\u0001\n\u0013i\u0014aA5teV\ta\bE\u0002@\tZi\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\rC\u0012AC2pY2,7\r^5p]&\u0011Q\t\u0011\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u0005SN\u0014\b\u0005C\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u0013Q|\u0007/[2QCRDW#A&\u0011\u00051{eBA\fN\u0013\tq\u0005$\u0001\u0004Qe\u0016$WMZ\u0005\u0003QAS!A\u0014\r\t\rI\u0003\u0001\u0015!\u0003L\u0003)!x\u000e]5d!\u0006$\b\u000e\t\u0005\b)\u0002\u0011\r\u0011\"\u0003K\u0003%!x\u000e]5d\t\u0006$\u0018\r\u0003\u0004W\u0001\u0001\u0006IaS\u0001\u000bi>\u0004\u0018n\u0019#bi\u0006\u0004\u0003\"\u0002-\u0001\t\u0003J\u0016!B:fiV\u0003H#\u0001.\u0011\u0005]Y\u0016B\u0001/\u0019\u0005\u0011)f.\u001b;)\u0005]s\u0006CA0e\u001b\u0005\u0001'BA1c\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0017aA8sO&\u0011Q\r\u0019\u0002\u0007\u0005\u00164wN]3\t\u000b\u001d\u0004A\u0011A-\u0002-Q,7\u000f^+qI\u0006$X\rT3bI\u0016\u0014\u0018I\u001c3JgJD#AZ5\u0011\u0005}S\u0017BA6a\u0005\u0011!Vm\u001d;")
public class ReplicationUtilsTest
extends ZooKeeperTestHarness {
    private final int zkVersion;
    private final String topic;
    private final int partition;
    private final int leader;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final List<Object> isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
    private final String topicPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/brokers/topics/", "/partitions/", "/state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partition())}));
    private final String topicData = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.leader())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), this.isr())}))).asJava());

    private int zkVersion() {
        return this.zkVersion;
    }

    private String topic() {
        return this.topic;
    }

    private int partition() {
        return this.partition;
    }

    private int leader() {
        return this.leader;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private List<Object> isr() {
        return this.isr;
    }

    private String topicPath() {
        return this.topicPath;
    }

    private String topicData() {
        return this.topicData;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ZkUtils qual$1 = this.zkUtils();
        String x$4 = this.topicPath();
        String x$5 = this.topicData();
        java.util.List x$6 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$4, x$5, x$6);
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Log log2 = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log2);
        EasyMock.replay((Object[])new Object[]{log2});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicPartition(this.topic(), this.partition()), false)).andReturn((Object)new Some((Object)log2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(configs.head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkClient()).andReturn((Object)this.zkClient());
        EasyMock.replay((Object[])new Object[]{replicaManager});
        this.zkClient().makeSurePersistentPathExists(ZkUtils$.MODULE$.IsrChangeNotificationPath());
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, 0);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr1, this.controllerEpoch());
        if (tuple2 != null) {
            Tuple2.mcZI.sp sp2;
            boolean updateSucceeded1 = tuple2._1$mcZ$sp();
            int newZkVersion1 = tuple2._2$mcI$sp();
            Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded1, newZkVersion1);
            boolean updateSucceeded12 = sp3._1$mcZ$sp();
            int newZkVersion12 = sp3._2$mcI$sp();
            Assert.assertTrue((boolean)updateSucceeded12);
            Assert.assertEquals((long)newZkVersion12, (long)1L);
            LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, this.zkVersion() + 1);
            Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr2, this.controllerEpoch());
            if (tuple22 != null) {
                Tuple2.mcZI.sp sp4;
                boolean updateSucceeded2 = tuple22._1$mcZ$sp();
                int newZkVersion2 = tuple22._2$mcI$sp();
                Tuple2.mcZI.sp sp5 = sp4 = new Tuple2.mcZI.sp(updateSucceeded2, newZkVersion2);
                boolean updateSucceeded22 = sp5._1$mcZ$sp();
                int newZkVersion22 = sp5._2$mcI$sp();
                Assert.assertTrue((boolean)updateSucceeded22);
                Assert.assertEquals((long)newZkVersion22, (long)1L);
                LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.leader(), this.leaderEpoch() + 1, replicas, this.zkVersion() + 1);
                Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr3, this.controllerEpoch());
                if (tuple23 != null) {
                    Tuple2.mcZI.sp sp6;
                    boolean updateSucceeded3 = tuple23._1$mcZ$sp();
                    int newZkVersion3 = tuple23._2$mcI$sp();
                    Tuple2.mcZI.sp sp7 = sp6 = new Tuple2.mcZI.sp(updateSucceeded3, newZkVersion3);
                    boolean updateSucceeded32 = sp7._1$mcZ$sp();
                    int newZkVersion32 = sp7._2$mcI$sp();
                    Assert.assertFalse((boolean)updateSucceeded32);
                    Assert.assertEquals((long)newZkVersion32, (long)-1L);
                    return;
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicationUtilsTest() {
        this.zkVersion = 1;
        this.topic = "my-topic-test";
        this.partition = 0;
        this.leader = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
    }
}

