/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsRequest$;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclRequest$;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclRequest$;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTest$$anon$1$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u00111CW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+fgRT!a\u0001\u0003\u0002\u0013i|wn[3fa\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001C7pG.\u0004\u0016\r\u001e5\u0016\u0003Y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004TiJLgn\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\f\u0002\u00135|7m\u001b)bi\"\u0004\u0003bB\u0011\u0001\u0005\u0004%IAI\u0001\u0005i&lW-F\u0001$!\t!c&D\u0001&\u0015\t1s%A\u0003vi&d7O\u0003\u0002)S\u000511m\\7n_:T!!\u0002\u0016\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0005\u0003_\u0015\u0012A\u0001V5nK\"1\u0011\u0007\u0001Q\u0001\n\r\nQ\u0001^5nK\u0002B\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\u0002\u001fi|wnS3fa\u0016\u00148\t\\5f]R,\u0012!\u000e\t\u0003%YJ!a\u000e\u0002\u0003\u001fi{wnS3fa\u0016\u00148\t\\5f]RD\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002'i|wnS3fa\u0016\u00148\t\\5f]R|F%Z9\u0015\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001B+oSRDqA\u0011\u001d\u0002\u0002\u0003\u0007Q'A\u0002yIEBa\u0001\u0012\u0001!B\u0013)\u0014\u0001\u0005>p_.+W\r]3s\u00072LWM\u001c;!\u0011\u00151\u0005\u0001\"\u0011H\u0003\u0015\u0019X\r^+q)\u0005Y\u0004FA#J!\tQU*D\u0001L\u0015\taE&A\u0003kk:LG/\u0003\u0002O\u0017\n1!)\u001a4pe\u0016DQ\u0001\u0015\u0001\u0005B\u001d\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001fJ\u0003\"AS*\n\u0005Q[%!B!gi\u0016\u0014\b\"\u0002,\u0001\t\u00039\u0015!\b;fgR,fN]3t_24\u0018M\u00197f\u0007>tg.Z2u'R\u0014\u0018N\\4)\tUC6\f\u0018\t\u0003\u0015fK!AW&\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\nQ\f\u0005\u0002_C6\tqL\u0003\u0002a5\u0005\u0019a.\u001a;\n\u0005\t|&\u0001F+oW:|wO\u001c%pgR,\u0005pY3qi&|g\u000eC\u0003e\u0001\u0011\u0005q)A\u000buKN$8i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;)\t\rD6LZ\u0012\u0002OB\u0011!\u0003[\u0005\u0003S\n\u0011qDW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o\u0011\u0015Y\u0007\u0001\"\u0001H\u00039!Xm\u001d;D_:tWm\u0019;j_:D#A\u001b-\t\u000b9\u0004A\u0011A$\u00025Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u00055D\u0006\"B9\u0001\t\u00039\u0015a\u0006;fgR$U\r\\3uK\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\t\u0001\b\fC\u0003u\u0001\u0011\u0005q)\u0001\u000euKN$X\t_5tiNtuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002t1\")q\u000f\u0001C\u0001\u000f\u00069B/Z:u\u000bbL7\u000f^:Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0003mbCQA\u001f\u0001\u0005\u0002\u001d\u000b1\u0004^3ti\u001e+G\u000fR1uC:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007FA=Y\u0011\u0015i\b\u0001\"\u0001H\u0003a!Xm\u001d;HKR$\u0015\r^1Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0003ybCa!!\u0001\u0001\t\u00039\u0015a\u0007;fgR\u001cV\r\u001e#bi\u0006tuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002\u00001\"1\u0011q\u0001\u0001\u0005\u0002\u001d\u000b\u0001\u0004^3tiN+G\u000fR1uC\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\r\t)\u0001\u0017\u0005\u0007\u0003\u001b\u0001A\u0011A$\u00025Q,7\u000f^$fi\u0006\u001bGNT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0007\u0005-\u0001\f\u0003\u0004\u0002\u0014\u0001!\taR\u0001\u0018i\u0016\u001cHoR3u\u0003\u000edW\t_5ti&twM\u0017(pI\u0016D3!!\u0005Y\u0011\u0019\tI\u0002\u0001C\u0001\u000f\u0006QB/Z:u'\u0016$\u0018i\u00197O_:,\u00050[:uK:$(LT8eK\"\u001a\u0011q\u0003-\t\r\u0005}\u0001\u0001\"\u0001H\u0003}!Xm\u001d;HKR\u001c\u0005.\u001b7ee\u0016tgj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0004\u0003;A\u0006BBA\u0013\u0001\u0011\u0005q)\u0001\u000fuKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3)\u0007\u0005\r\u0002\f\u0003\u0004\u0002,\u0001!\taR\u0001)i\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]\u0016C\u0018n\u001d;j]\u001eTfj\u001c3f/&$\bn\u00115jY\u0012\u0014XM\u001c\u0015\u0004\u0003SA\u0006BBA\u0019\u0001\u0011\u0005q)\u0001\u000buKN$\b+\u001b9fY&tW\rZ$fi\u0012\u000bG/\u0019\u0015\u0004\u0003_A\u0006BBA\u001c\u0001\u0011\u0005q)A\tuKN$X*\u001b=fIBK\u0007/\u001a7j]\u0016D3!!\u000eY\u0011\u0019\ti\u0004\u0001C\u0001\u000f\u0006\tC/Z:u5:{G-Z\"iC:<W\rS1oI2,'OR8s\u0007J,\u0017\r^5p]\"\u001a\u00111\b-\t\r\u0005\r\u0003\u0001\"\u0001H\u0003\u0005\"Xm\u001d;[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:EK2,G/[8oQ\r\t\t\u0005\u0017\u0005\u0007\u0003\u0013\u0002A\u0011A$\u0002GQ,7\u000f\u001e.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ4uN\u001d#bi\u0006\u001c\u0005.\u00198hK\"\u001a\u0011q\t-\t\r\u0005=\u0003\u0001\"\u0001H\u0003%\"Xm\u001d;[\u001d>$Wm\u00115jY\u0012\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'o\u00115jY\u0012\u001c\u0005.\u00198hK\"\u001a\u0011Q\n-\t\r\u0005U\u0003\u0001\"\u0001H\u0003\u0011\"Xm\u001d;Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:BkRDg)Y5mkJ,\u0007fAA*1\"1\u00111\f\u0001\u0005\u0002\u001d\u000bA\u0005^3ti\u000e{gN\\3di&|g\u000eT8tgJ+\u0017/^3tiR+'/\\5oCRLwN\u001c\u0015\u0004\u00033B\u0006BBA1\u0001\u0011\u0005q)A\tuKN$8+Z:tS>tW\t\u001f9jefD3!a\u0018Y\u0011\u0019\t9\u0007\u0001C\u0001\u000f\u0006aB/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=EkJLgnZ\"m_N,\u0007fAA31\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014\u0001F5t\u000bb\u0004Xm\u0019;fI6+GO]5d\u001d\u0006lW\r\u0006\u0004\u0002r\u0005]\u00141\u0013\t\u0004y\u0005M\u0014bAA;{\t9!i\\8mK\u0006t\u0007\u0002CA=\u0003W\u0002\r!a\u001f\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002~\u0005=UBAA@\u0015\u0011\t\t)a!\u0002\t\r|'/\u001a\u0006\u0005\u0003\u000b\u000b9)A\u0004nKR\u0014\u0018nY:\u000b\t\u0005%\u00151R\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u00055\u0015aA2p[&!\u0011\u0011SA@\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003+\u000bY\u00071\u0001\u0002\u0018\u0006!a.Y7f!\u0011\tI*a(\u000f\u0007q\nY*C\u0002\u0002\u001ev\na\u0001\u0015:fI\u00164\u0017bA\u000f\u0002\"*\u0019\u0011QT\u001f\t\r\u0005\u0015\u0006\u0001\"\u0001H\u0003\r\"Xm\u001d;[_>\\U-\u001a9feN#\u0018\r^3DQ\u0006tw-\u001a*bi\u0016lU\r\u001e:jGND3!a)Y\u0011\u0019\tY\u000b\u0001C\u0001\u000f\u0006yB/Z:u5>|7*Z3qKJ\u001cVm]:j_:\u001cF/\u0019;f\u001b\u0016$(/[2)\u0007\u0005%\u0006\f\u0003\u0004\u00022\u0002!IaR\u0001\u0015G2,\u0017M\\'fiJL7m\u001d*fO&\u001cHO]=\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\u0006)!-\u001f;fgV\u0011\u0011\u0011\u0018\t\u0006y\u0005m\u0016qX\u0005\u0004\u0003{k$!B!se\u0006L\bc\u0001\u001f\u0002B&\u0019\u00111Y\u001f\u0003\t\tKH/\u001a")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        this.cleanMetricsRegistry();
        super.setUp();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "testMetricGroup", "testMetricType"));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
    }

    @Test(expected=UnknownHostException.class)
    public void testUnresolvableConnectString() {
        new ZooKeeperClient("some.invalid.hostname.foo.bar.local", -1, -1, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test(expected=ZooKeeperClientTimeoutException.class)
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), 100, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testConnection() {
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode());
        this.intercept((Function0)new Serializable(this, deleteResponse){
            public static final long serialVersionUID = 0L;
            private final DeleteResponse deleteResponse$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.deleteResponse$1.maybeThrow();
            }
            {
                this.deleteResponse$1 = deleteResponse$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode());
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)existsResponse.resultCode());
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode());
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match created znode data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode());
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match setData's data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode());
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getAcl should be OK", (Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode());
        Assert.assertEquals((String)new StringBuilder().append((Object)"ACL should be ").append(JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, SetAclRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode());
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode());
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return no children", (Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children());
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder().append((Object)this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append((Object)"/").append((Object)child1).toString();
        String child2Path = new StringBuilder().append((Object)this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append((Object)"/").append((Object)child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child2 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return two children", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{child1, child2})), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPipelinedGetData() {
        IndexedSeq createRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CreateRequest apply(int x) {
                return new CreateRequest(new StringBuilder().append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)x)).toString(), ((Object)BoxesRunTime.boxToInteger((int)(x * 2))).toString().getBytes(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ZooKeeperClient zooKeeperClient = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient();
        IndexedSeq createResponses = (IndexedSeq)createRequests.map((Function1)new Serializable(this, zooKeeperClient){
            public static final long serialVersionUID = 0L;
            private final ZooKeeperClient eta$0$1$1;

            public final CreateResponse apply(CreateRequest request) {
                return (CreateResponse)this.eta$0$1$1.handleRequest((AsyncRequest)request);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        createResponses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CreateResponse createResponse) {
                Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
            }
        });
        IndexedSeq getDataRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GetDataRequest apply(int x) {
                return new GetDataRequest(new StringBuilder().append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)x)).toString(), GetDataRequest$.MODULE$.apply$default$2());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GetDataResponse getDataResponse) {
                Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
            }
        });
        ((IterableLike)getDataResponses.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<GetDataResponse, Object> x0$1) {
                Tuple2<GetDataResponse, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    GetDataResponse getDataResponse = (GetDataResponse)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
                    Assert.assertEquals((String)"Data for getData should match", (Object)BoxesRunTime.boxToInteger((int)((i + 1) * 2)), (Object)Integer.valueOf(new String(getDataResponse.data())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2());
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{getDataRequest, setDataRequest})));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertArrayEquals((String)"Data for getData should be empty", (byte[])((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data());
        Assert.assertEquals((String)"Response code for setData should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode());
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.class.handleDeletion((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.class.handleDataChange((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.class.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{existsRequest, createRequest})));
        Assert.assertEquals((String)"Response code for exists should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.class.handleCreation((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.class.handleDataChange((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                ZNodeChangeHandler.class.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive delete notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.class.handleCreation((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.class.handleDeletion((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                ZNodeChangeHandler.class.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive data change notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                ZNodeChildChangeHandler.class.$init$((ZNodeChildChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder().append((Object)this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append((Object)"/").append((Object)child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        Assert.assertTrue((String)"Failed to receive child change notification", (boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(this, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.class.beforeInitializingSession((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.class.afterInitializingSession((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                StateChangeHandler.class.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
        try {
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.reinitialize();
            Assert.assertTrue((String)"Failed to receive auth failed notification", (boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        zooKeeperClient.close();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testConnectionLossRequestTermination() {
        block3: {
            batchSize = 10;
            zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), 2, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            this.zookeeper().shutdown();
            try {
                requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), batchSize).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GetDataRequest apply(int i) {
                        return new GetDataRequest(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), GetDataRequest$.MODULE$.apply$default$2());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                countDownLatch = new CountDownLatch(1);
                running = new AtomicBoolean(true);
                unexpectedResponses = new ArrayBlockingQueue<E>(batchSize);
                requestThread = new Thread(this, zooKeeperClient, requests, countDownLatch, running, unexpectedResponses){
                    private final ZooKeeperClient zooKeeperClient$1;
                    private final IndexedSeq requests$1;
                    private final CountDownLatch countDownLatch$1;
                    private final AtomicBoolean running$1;
                    public final ArrayBlockingQueue unexpectedResponses$1;

                    public void run() {
                        while (this.running$1.get()) {
                            Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                            Seq suffix = (Seq)responses.dropWhile((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(GetDataResponse response) {
                                    KeeperException.Code code = response.resultCode();
                                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                                    return code != null ? !code.equals(code2) : code2 != null;
                                }
                            });
                            if (!suffix.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(GetDataResponse response) {
                                    KeeperException.Code code = response.resultCode();
                                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                                    return !(code != null ? !code.equals(code2) : code2 != null);
                                }
                            })) {
                                responses.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anon$2 $outer;

                                    public final boolean apply(GetDataResponse x$1) {
                                        return this.$outer.unexpectedResponses$1.add(x$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                            this.running$1.set(false);
                        }
                        this.countDownLatch$1.countDown();
                    }
                    {
                        this.zooKeeperClient$1 = zooKeeperClient$1;
                        this.requests$1 = requests$1;
                        this.countDownLatch$1 = countDownLatch$1;
                        this.running$1 = running$1;
                        this.unexpectedResponses$1 = unexpectedResponses$1;
                    }
                };
                requestThread.start();
                requestThreadTerminated = countDownLatch.await(30L, TimeUnit.SECONDS);
                if (!requestThreadTerminated) ** GOTO lbl22
                if (!unexpectedResponses.isEmpty()) break block3;
            }
            catch (Throwable var3_9) {
                var2_2.close();
                throw var3_9;
            }
            zooKeeperClient.close();
            return;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpectedResponses})), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
lbl22:
        // 1 sources

        running.set(false);
        requestThread.join(5000L);
        throw this.fail("Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendSemaphore, sendCompleteSemaphore){
            public final ExecutorService responseExecutor$1;
            public final Semaphore sendSemaphore$1;
            public final Semaphore sendCompleteSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1)new Serializable(this, processResponse){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final Function1 processResponse$1;

                    public final void apply(AsyncResponse response) {
                        this.$outer.responseExecutor$1.submit(new Runnable(this, response){
                            private final /* synthetic */ $anon$1$$anonfun$send$1 $outer;
                            private final AsyncResponse response$1;

                            public void run() {
                                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$anon$$anonfun$$$outer().sendCompleteSemaphore$1.release();
                                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$anon$$anonfun$$$outer().sendSemaphore$1.acquire();
                                this.$outer.processResponse$1.apply((Object)this.response$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.response$1 = response$1;
                            }
                        });
                    }

                    public /* synthetic */ $anon$1 kafka$zookeeper$ZooKeeperClientTest$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.processResponse$1 = processResponse$1;
                    }
                });
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(this, sendSemaphore, sendSize, stateChanges, zooKeeperClient){
                private final String name;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.class.onAuthFailure((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected thread + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{threadName})), (boolean)threadName.startsWith(this.zooKeeperClient$2.expiryScheduler().threadNamePrefix()));
                }
                {
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.stateChanges$1 = stateChanges$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    StateChangeHandler.class.$init$((StateChangeHandler)this);
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(this, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void run() {
                    IndexedSeq requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.sendSize$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final GetDataRequest apply(int i) {
                            return new GetDataRequest(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), GetDataRequest$.MODULE$.apply$default$2());
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final KeeperException.Code apply(GetDataResponse x$1) {
                            return x$1.resultCode();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                throw this.fail("Request thread did not complete", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
            }
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"beforeInitializingSession", "afterInitializingSession"})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stateChanges).asScala()).toSeq());
            Assert.assertEquals((long)((Seq)resultCodes.elem).size(), (long)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KeeperException.Code x$2) {
                    KeeperException.Code code = x$2;
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected connection lost requests ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)resultCodes.elem})), (connectionLostCount <= maxInflightRequests ? 1 : 0) != 0);
            int expiredCount = ((Seq)resultCodes.elem).count((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KeeperException.Code x$3) {
                    KeeperException.Code code = x$3;
                    KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected session expired requests ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)resultCodes.elem})), (expiredCount <= maxInflightRequests ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No connection lost or expired requests ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)resultCodes.elem})), (connectionLostCount + expiredCount > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS}));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected result code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)resultCodes.elem})), (boolean)((SeqLike)((Seq)resultCodes.elem).filterNot((Function1)new Serializable(this, set){
                public static final long serialVersionUID = 0L;
                private final Set eta$0$2$1;

                public final boolean apply(KeeperException.Code elem) {
                    return this.eta$0$2$1.contains((Object)elem);
                }
                {
                    this.eta$0$2$1 = eta$0$2$1;
                }
            })).isEmpty());
        }
        catch (Throwable throwable) {
            void var2_2;
            void var8_8;
            var8_8.close();
            var2_2.shutdownNow();
            throw throwable;
        }
        zooKeeperClient.close();
        responseExecutor.shutdownNow();
        Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)zooKeeperClient.expiryScheduler().isStarted());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().schedule("test", (Function0)new Serializable(this, semaphore){
                public static final long serialVersionUID = 0L;
                private final Semaphore semaphore$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.semaphore$1.acquireUninterruptibly();
                }
                {
                    this.semaphore$1 = semaphore$1;
                }
            }, 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleSessionExpiryHandler();
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertFalse((String)"Close completed without shutting down expiry scheduler gracefully", (boolean)closeFuture.isDone());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().isStarted());
            closeExecutor.shutdownNow();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdownNow();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        String string2 = name;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metricName.getGroup();
        String string4 = "testMetricGroup";
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = metricName.getType();
        String string6 = "testMetricType";
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assert.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(metrics.allMetrics().keySet()).asScala()).foreach((Function1)new Serializable(this, metrics){
            public static final long serialVersionUID = 0L;
            private final MetricsRegistry metrics$1;

            public final void apply(MetricName x$1) {
                this.metrics$1.removeMetric(x$1);
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Meter meter = (Meter)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric meter = (Metric)A1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                Tuple2<MetricName, Metric> tuple2 = x1;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric meter = (Metric)tuple2._2();
                if (!(meter instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find meter with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
            }
            {
                this.name$1 = name$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected meter count for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (long)expected, (long)meter.count());
    }

    private final Option gaugeValue$1(String name) {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric gauge = (Metric)A1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x2) {
                Tuple2<MetricName, Metric> tuple2 = x2;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric gauge = (Metric)tuple2._2();
                if (!(gauge instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }
}

