/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.common.TopicAndPartition;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tmd!B\u0001\u0003\u0003\u00039!!G#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tIQ\"\u0003\u0002\u000f\u0005\tI1+Y:m'\u0016$X\u000f\u001d\u0005\u0006!\u0001!\t!E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0001\"!\u0003\u0001\t\u000fQ\u0001!\u0019!C!+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C!+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0011\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u00159\u0003\u0001\"\u0011)\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012!\u000b\t\u0003/)J!a\u000b\r\u0003\tUs\u0017\u000e\u001e\u0005\b[\u0001\u0011\r\u0011\"\u0001\u0016\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\f\u0002\u00179,XNU3d_J$7\u000f\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003\u00159'o\\;q+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\t\rq\u0002\u0001\u0015!\u00034\u0003\u00199'o\\;qA!9a\b\u0001b\u0001\n\u0003\u0011\u0014!\u0002;pa&\u001c\u0007B\u0002!\u0001A\u0003%1'\u0001\u0004u_BL7\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00013\u00035!x\u000e]5d/&dGmY1sI\"1A\t\u0001Q\u0001\nM\na\u0002^8qS\u000e<\u0016\u000e\u001c3dCJ$\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A\u000b\u0002\tA\f'\u000f\u001e\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\f\u0002\u000bA\f'\u000f\u001e\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006\u0011A\u000f]\u000b\u0002\u0019B\u0011Q*V\u0007\u0002\u001d*\u0011q\nU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\t&B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!A\u0016(\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0001\f\u0001Q\u0001\n1\u000b1\u0001\u001e9!\u0011\u001dQ\u0006A1A\u0005\u0002m\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o+\u0005a\u0006CA/`\u001b\u0005q&BA(\u0005\u0013\t\u0001gLA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DaA\u0019\u0001!\u0002\u0013a\u0016A\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\u0002Bq\u0001\u001a\u0001C\u0002\u001b\u0005Q-A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m+\u00051\u0007CA4k\u001d\t9\u0002.\u0003\u0002j1\u00051\u0001K]3eK\u001aL!AO6\u000b\u0005%D\u0002bB7\u0001\u0005\u00045\t!Z\u0001\u000fW\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011!y\u0007\u0001#b\u0001\n#\u0002\u0018A\u0004;skN$8\u000b^8sK\u001aKG.Z\u000b\u0002cB\u0019qC\u001d;\n\u0005MD\"\u0001B*p[\u0016\u0004\"!\u001e=\u000e\u0003YT!a^\u001c\u0002\u0005%|\u0017BA=w\u0005\u00111\u0015\u000e\\3\t\u0011m\u0004\u0001\u0012!Q!\nE\fq\u0002\u001e:vgR\u001cFo\u001c:f\r&dW\r\t\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u00035!x\u000e]5d%\u0016\u001cx.\u001e:dKV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003\u0013!\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u00055\u00111\u0001\u0002\t%\u0016\u001cx.\u001e:dK\"9\u0011\u0011\u0003\u0001!\u0002\u0013y\u0018A\u0004;pa&\u001c'+Z:pkJ\u001cW\r\t\u0005\t\u0003+\u0001!\u0019!C\u0001}\u0006iqM]8vaJ+7o\\;sG\u0016Dq!!\u0007\u0001A\u0003%q0\u0001\bhe>,\bOU3t_V\u00148-\u001a\u0011\t\u0011\u0005u\u0001A1A\u0005\u0002y\fqb\u00197vgR,'OU3t_V\u00148-\u001a\u0005\b\u0003C\u0001\u0001\u0015!\u0003\u0000\u0003A\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007\u0005C\u0004\u0002&\u0001!\t!a\n\u0002\u001d\rdWo\u001d;fe\u0006\u001bG.\u0011:hgV\u0011\u0011\u0011\u0006\t\u0005/\u0005-b-C\u0002\u0002.a\u0011Q!\u0011:sCfDq!!\r\u0001\t\u0003\t9#\u0001\fu_BL7M\u0011:pW\u0016\u0014(+Z1e\u0003\u000ed\u0017I]4t\u0011\u001d\t)\u0004\u0001C\u0001\u0003O\ta\u0002\u001d:pIV\u001cW-Q2m\u0003J<7\u000fC\u0004\u0002:\u0001!\t!a\n\u0002\u001f\u0011,7o\u0019:jE\u0016\f5\r\\!sONDq!!\u0010\u0001\t\u0003\t9#A\u000beK2,G/\u001a#fg\u000e\u0014\u0018NY3BG2\f%oZ:\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002(\u0005\u0011B-\u001a7fi\u0016<&/\u001b;f\u0003\u000ed\u0017I]4t\u0011\u001d\t)\u0005\u0001C\u0001\u0003O\tabY8ogVlW-Q2m\u0003J<7\u000fC\u0004\u0002J\u0001!\t!a\n\u0002\u0019\u001d\u0014x.\u001e9BG2\f%oZ:\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005\u00012\t\\;ti\u0016\u0014\u0018i\u0019;j_:\f5\r\\\u000b\u0003\u0003#\u0002b!a\u0015\u0002^\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u0013%lW.\u001e;bE2,'bAA.1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0004'\u0016$\b\u0003BA\u0001\u0003GJA!!\u001a\u0002\u0004\t\u0019\u0011i\u00197\t\u000f\u0005%\u0004\u0001\"\u0001\u0002P\u0005\u0011Bk\u001c9jG\n\u0013xn[3s%\u0016\fG-Q2m\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001f\nAb\u0012:pkB\u0014V-\u00193BG2Dq!!\u001d\u0001\t\u0003\ty%\u0001\u0007U_BL7MU3bI\u0006\u001bG\u000eC\u0004\u0002v\u0001!\t!a\u0014\u0002\u001bQ{\u0007/[2Xe&$X-Q2m\u0011\u001d\tI\b\u0001C\u0001\u0003\u001f\n\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\t\r\u0005u\u0004\u0001\"\u0011)\u0003\u0015\u0019X\r^+qQ\u0011\tY(!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"T\u0003\u0015QWO\\5u\u0013\u0011\tY)!\"\u0003\r\t+gm\u001c:f\u0011\u001d\ty\t\u0001C!\u0003#\u000b\u0011c\u0019:fCR,g*Z<Qe>$WoY3s+\t\t\u0019\n\u0005\u0005\u0002\u0016\u0006}\u00151UAR\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015\u0001\u00039s_\u0012,8-\u001a:\u000b\u0007\u0005u\u0005+A\u0004dY&,g\u000e^:\n\t\u0005\u0005\u0016q\u0013\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b]\tY#!*\u0011\u0007]\t9+C\u0002\u0002*b\u0011AAQ=uK\"1\u0011Q\u0016\u0001\u0005B!\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003W\u000b\t\f\u0005\u0003\u0002\u0004\u0006M\u0016\u0002BA[\u0003\u000b\u0013Q!\u00114uKJDa!!/\u0001\t\u0003A\u0013a\u0007;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u00164\u0016.Y!tg&<g\u000e\u000b\u0003\u00028\u0006u\u0006\u0003BAB\u0003\u007fKA!!1\u0002\u0006\n!A+Z:u\u0011\u0019\t)\r\u0001C\u0001Q\u0005qB/Z:u!J|G-^2f\u0007>t7/^7f-&\f7+\u001e2tGJL'-\u001a\u0015\u0005\u0003\u0007\fi\f\u0003\u0004\u0002L\u0002!\t\u0002K\u0001\u0012g\u0016$\u0018i\u00197t\u0003:$\u0007K]8ek\u000e,\u0007BBAh\u0001\u0011\u0005\u0001&A\u0010uKN$hj\u001c)s_\u0012,8-Z,ji\"|W\u000f\u001e#fg\u000e\u0014\u0018NY3BG2D\u0003\"!4\u0002>\u0006M\u0017Q[\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c(\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\t\t/a7\u00037Q{\u0007/[2BkRDwN]5{CRLwN\\#yG\u0016\u0004H/[8o\u0011\u0019\t)\u000f\u0001C\u0001Q\u0005aB/Z:u\u001d>\u0004&o\u001c3vG\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000ed\u0007\u0006BAr\u0003{Ca!a;\u0001\t\u0003A\u0013\u0001\u000b;fgRtunQ8ogVlWmV5uQ>,H\u000fR3tGJL'-Z!dYZK\u0017-Q:tS\u001et\u0007\u0006CAu\u0003{\u000b\u0019.a<$\u0005\u0005E\bcA'\u0002t&\u0019\u0011Q\u001f(\u0003\u001d-\u000bgm[1Fq\u000e,\u0007\u000f^5p]\"1\u0011\u0011 \u0001\u0005\u0002!\n1\u0006^3ti:{7i\u001c8tk6,w+\u001b;i_V$H)Z:de&\u0014W-Q2m-&\f7+\u001e2tGJL'-\u001a\u0015\t\u0003o\fi,a5\u0002V\"1\u0011q \u0001\u0005\n!\n\u0001E\\8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\"1!1\u0001\u0001\u0005\u0002!\nQ\u0005^3ti:{7i\u001c8tk6,w+\u001b;i\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\t\t\u0005\u0011Q\u0018\u0005\u0007\u0005\u0013\u0001A\u0011\u0001\u0015\u0002QQ,7\u000f\u001e(p\u0007>t7/^7f/&$\b\u000eR3tGJL'-Z!dYZK\u0017mU;cg\u000e\u0014\u0018NY3)\t\t\u001d\u0011Q\u0018\u0005\u0007\u0005\u001f\u0001A\u0011\u0002\u0015\u0002;9|7i\u001c8tk6,w+\u001b;i\t\u0016\u001c8M]5cK\u0006\u001bGnU3ukBDaAa\u0005\u0001\t\u0003A\u0013A\u0004;fgRtun\u0012:pkB\f5\r\u001c\u0015\u0005\u0005#\ti\fC\u0004\u0003\u001a\u0001!IAa\u0007\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u0006S\tu!q\u0004\u0005\u0007[\t]\u0001\u0019\u0001\f\t\r)\u00139\u00021\u0001M\u0011\u001d\u0011\u0019\u0003\u0001C\t\u0005K\tabY8ogVlWMU3d_J$7\u000fF\u0007*\u0005O\u0011)Da\u000e\u0003<\tu\"q\b\u0005\t\u0005S\u0011\t\u00031\u0001\u0003,\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0003.\tE\u00121UAR\u001b\t\u0011yC\u0003\u0003\u0003*\u0005m\u0015\u0002\u0002B\u001a\u0005_\u0011\u0001bQ8ogVlWM\u001d\u0005\t[\t\u0005\u0002\u0013!a\u0001-!I!\u0011\bB\u0011!\u0003\u0005\rAF\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011!q$\u0011\u0005I\u0001\u0002\u00041\u0007\u0002\u0003$\u0003\"A\u0005\t\u0019\u0001\f\t\u0015\t\u0005#\u0011\u0005I\u0001\u0002\u0004\u0011\u0019%A\u0004uS6,w.\u001e;\u0011\u0007]\u0011)%C\u0002\u0003Ha\u0011A\u0001T8oO\"I!1\n\u0001\u0012\u0002\u0013E!QJ\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012TC\u0001B(U\r1\"\u0011K\u0016\u0003\u0005'\u0002BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&A\u0005v]\u000eDWmY6fI*\u0019!Q\f\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003b\t]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\r\u0001\u0012\u0002\u0013E!QJ\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B5\u0001E\u0005I\u0011\u0003B6\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005[R3A\u001aB)\u0011%\u0011\t\bAI\u0001\n#\u0011i%\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIUB\u0011B!\u001e\u0001#\u0003%\tBa\u001e\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0006\u0002\u0003z)\"!1\tB)\u0001")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final int numRecords;
    private final String group;
    private final String topic;
    private final String topicWildcard;
    private final int part;
    private final TopicPartition tp;
    private final TopicAndPartition topicAndPartition;
    private Some<File> trustStoreFile;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    private Some trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
            return this.trustStoreFile;
        }
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterAclArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String group() {
        return this.group;
    }

    public String topic() {
        return this.topic;
    }

    public String topicWildcard() {
        return this.topicWildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    public Some<File> trustStoreFile() {
        return this.bitmap$0 ? this.trustStoreFile : this.trustStoreFile$lzycompute();
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public String[] clusterAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--cluster"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=ClusterAction"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicWildcard()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] produceAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--producer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Write"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] consumeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--consumer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.ClusterActionAcl(), (Authorizer)s.apis().authorizer().get(), Resource$.MODULE$.ClusterResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.TopicBrokerReadAcl(), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        String x$3 = this.brokerList();
        long x$4 = 3000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Some<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.clientSaslProperties();
        Some x$8 = new Some((Object)this.producerConfig());
        int x$9 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$11 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$12 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createNewProducer$default$12();
        return TestUtils$.MODULE$.createNewProducer(x$3, x$9, x$4, x$10, x$11, x$12, x$13, x$5, (Option<File>)x$6, x$7, x$14, x$15, (Option<Properties>)x$8);
    }

    @Override
    @After
    public void tearDown() {
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$1) {
                x$1.wakeup();
            }
        });
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    public void setAclsAndProduce() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.consumeAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicReadAcl().$plus$plus(this.$outer.TopicWriteAcl()).$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoProduceWithoutDescribeAcl() {
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.TopicDescribeAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        try {
            this.sendRecords(this.numRecords(), this.tp());
            throw this.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        KafkaConsumer x$16 = (KafkaConsumer)this.consumers().head();
        long x$17 = 3000L;
        int x$18 = this.consumeRecords$default$2();
        int x$19 = this.consumeRecords$default$3();
        String x$20 = this.consumeRecords$default$4();
        int x$21 = this.consumeRecords$default$5();
        this.consumeRecords((Consumer<byte[], byte[]>)x$16, x$18, x$19, x$20, x$21, x$17);
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }
        catch (GroupAuthorizationException groupAuthorizationException) {
            Assert.assertEquals((Object)this.group(), (Object)groupAuthorizationException.groupId());
            return;
        }
    }

    private void sendRecords(int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;
            private final TopicPartition tp$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return ((KafkaProducer)this.$outer.producers().head()).send(record);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                    return x$2.get();
                }
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        ArrayList records2 = new ArrayList();
        long deadlineMs = System.currentTimeMillis() + timeout;
        while (records2.size() < numRecords && System.currentTimeMillis() < deadlineMs) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1)new Serializable(this, records2){
                public static final long serialVersionUID = 0L;
                private final ArrayList records$1;

                public final boolean apply(ConsumerRecord<byte[], byte[]> record) {
                    return this.records$1.add(record);
                }
                {
                    this.records$1 = records$1;
                }
            });
        }
        if (records2.size() < numRecords) {
            throw new TimeoutException();
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, topic, part, records2){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final String topic$1;
            private final int part$1;
            private final ArrayList records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.get(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.topic$1, (Object)record.topic());
                Assert.assertEquals((long)this.part$1, (long)record.partition());
                Assert.assertEquals((long)offset, (long)record.offset());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.records$1 = records$1;
            }
        });
    }

    public int consumeRecords$default$2() {
        return 1;
    }

    public int consumeRecords$default$3() {
        return 0;
    }

    public String consumeRecords$default$4() {
        return this.topic();
    }

    public int consumeRecords$default$5() {
        return this.part();
    }

    public long consumeRecords$default$6() {
        return 10000L;
    }

    public EndToEndAuthorizationTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.numRecords = 1;
        this.group = "group";
        this.topic = "e2etopic";
        this.topicWildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicAndPartition = new TopicAndPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic());
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group());
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

