/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.admin.ConfigCommand$;
import kafka.api.Both$;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.api.ZkSasl$;
import kafka.security.minikdc.MiniKdc;
import kafka.security.minikdc.MiniKdc$;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.scram.ScramMechanism;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class SaslSetup$class {
    public static void startSasl(SaslSetup $this, Seq jaasSections) {
        LoginManager.closeAll();
        boolean hasKerberos = jaasSections.exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JaasTestUtils.JaasSection x$1) {
                return x$1.modules().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(JaasTestUtils.JaasModule x0$1) {
                        JaasTestUtils.JaasModule jaasModule = x0$1;
                        boolean bl = jaasModule instanceof JaasTestUtils.Krb5LoginModule;
                        return bl;
                    }
                });
            }
        });
        if (hasKerberos) {
            $this.initializeKerberos();
        }
        SaslSetup$class.writeJaasConfigurationToFile($this, jaasSections);
        boolean hasZk = jaasSections.exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JaasTestUtils.JaasSection x$2) {
                return x$2.modules().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(JaasTestUtils.JaasModule x0$2) {
                        JaasTestUtils.JaasModule jaasModule = x0$2;
                        boolean bl = jaasModule instanceof JaasTestUtils.ZkDigestModule;
                        return bl;
                    }
                });
            }
        });
        if (hasZk) {
            System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        }
    }

    public static void initializeKerberos(SaslSetup $this) {
        Tuple2<File, File> tuple2 = $this.maybeCreateEmptyKeytabFiles();
        if (tuple2 != null) {
            Tuple2 tuple22;
            File serverKeytabFile = (File)tuple2._1();
            File clientKeytabFile = (File)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)serverKeytabFile, (Object)clientKeytabFile);
            File serverKeytabFile2 = (File)tuple23._1();
            File clientKeytabFile2 = (File)tuple23._2();
            $this.kafka$api$SaslSetup$$kdc_$eq(new MiniKdc($this.kafka$api$SaslSetup$$kdcConf(), $this.kafka$api$SaslSetup$$workDir()));
            $this.kafka$api$SaslSetup$$kdc().start();
            $this.kafka$api$SaslSetup$$kdc().createPrincipal(serverKeytabFile2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)JaasTestUtils$.MODULE$.KafkaServerPrincipalUnqualifiedName()).append((Object)"/localhost").toString()}));
            $this.kafka$api$SaslSetup$$kdc().createPrincipal(clientKeytabFile2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JaasTestUtils$.MODULE$.KafkaClientPrincipalUnqualifiedName(), JaasTestUtils$.MODULE$.KafkaClientPrincipalUnqualifiedName2()}));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static Tuple2 maybeCreateEmptyKeytabFiles(SaslSetup $this) {
        if ($this.kafka$api$SaslSetup$$serverKeytabFile().isEmpty()) {
            $this.kafka$api$SaslSetup$$serverKeytabFile_$eq((Option<File>)new Some((Object)TestUtils$.MODULE$.tempFile()));
        }
        if ($this.kafka$api$SaslSetup$$clientKeytabFile().isEmpty()) {
            $this.kafka$api$SaslSetup$$clientKeytabFile_$eq((Option<File>)new Some((Object)TestUtils$.MODULE$.tempFile()));
        }
        return new Tuple2($this.kafka$api$SaslSetup$$serverKeytabFile().get(), $this.kafka$api$SaslSetup$$clientKeytabFile().get());
    }

    public static Seq jaasSections(SaslSetup $this, Seq kafkaServerSaslMechanisms, Option kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        SaslSetupMode saslSetupMode;
        block5: {
            Seq seq;
            block3: {
                block4: {
                    block2: {
                        SaslSetupMode saslSetupMode2 = mode;
                        ZkSasl$ zkSasl$ = ZkSasl$.MODULE$;
                        boolean hasKerberos = (saslSetupMode2 == null ? zkSasl$ != null : !saslSetupMode2.equals(zkSasl$)) && (kafkaServerSaslMechanisms.contains((Object)"GSSAPI") || kafkaClientSaslMechanism.contains((Object)"GSSAPI"));
                        Tuple2<File, File> tuple2 = hasKerberos ? $this.maybeCreateEmptyKeytabFiles() : BoxedUnit.UNIT;
                        saslSetupMode = mode;
                        if (!ZkSasl$.MODULE$.equals(saslSetupMode)) break block2;
                        seq = JaasTestUtils$.MODULE$.zkSections();
                        break block3;
                    }
                    if (!KafkaSasl$.MODULE$.equals(saslSetupMode)) break block4;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JaasTestUtils.JaasSection[]{JaasTestUtils$.MODULE$.kafkaServerSection(kafkaServerEntryName, (Seq<String>)kafkaServerSaslMechanisms, $this.kafka$api$SaslSetup$$serverKeytabFile()), JaasTestUtils$.MODULE$.kafkaClientSection((Option<String>)kafkaClientSaslMechanism, $this.kafka$api$SaslSetup$$clientKeytabFile())}));
                    break block3;
                }
                if (!Both$.MODULE$.equals(saslSetupMode)) break block5;
                seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JaasTestUtils.JaasSection[]{JaasTestUtils$.MODULE$.kafkaServerSection(kafkaServerEntryName, (Seq<String>)kafkaServerSaslMechanisms, $this.kafka$api$SaslSetup$$serverKeytabFile()), JaasTestUtils$.MODULE$.kafkaClientSection((Option<String>)kafkaClientSaslMechanism, $this.kafka$api$SaslSetup$$clientKeytabFile())}))).$plus$plus(JaasTestUtils$.MODULE$.zkSections(), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)saslSetupMode);
    }

    public static SaslSetupMode jaasSections$default$3(SaslSetup $this) {
        return Both$.MODULE$;
    }

    public static String jaasSections$default$4(SaslSetup $this) {
        return JaasTestUtils$.MODULE$.KafkaServerContextName();
    }

    private static void writeJaasConfigurationToFile(SaslSetup $this, Seq jaasSections) {
        File file = JaasTestUtils$.MODULE$.writeJaasContextsToFile((Seq<JaasTestUtils.JaasSection>)jaasSections);
        System.setProperty("java.security.auth.login.config", file.getAbsolutePath());
        Configuration.setConfiguration(null);
    }

    public static void closeSasl(SaslSetup $this) {
        if ($this.kafka$api$SaslSetup$$kdc() != null) {
            $this.kafka$api$SaslSetup$$kdc().stop();
        }
        LoginManager.closeAll();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("zookeeper.authProvider.1");
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public static Properties kafkaServerSaslProperties(SaslSetup $this, Seq serverSaslMechanisms, String interBrokerSaslMechanism) {
        void var3_3;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), interBrokerSaslMechanism);
        props.put("sasl.enabled.mechanisms", serverSaslMechanisms.mkString(","));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties kafkaClientSaslProperties(SaslSetup $this, String clientSaslMechanism, boolean dynamicJaasConfig) {
        void var3_3;
        Properties props = new Properties();
        props.put("sasl.mechanism", clientSaslMechanism);
        Object object = dynamicJaasConfig ? props.put("sasl.jaas.config", $this.jaasClientLoginModule(clientSaslMechanism)) : BoxedUnit.UNIT;
        return var3_3;
    }

    public static boolean kafkaClientSaslProperties$default$2(SaslSetup $this) {
        return false;
    }

    public static String jaasClientLoginModule(SaslSetup $this, String clientSaslMechanism) {
        return JaasTestUtils$.MODULE$.clientLoginModule(clientSaslMechanism, $this.kafka$api$SaslSetup$$clientKeytabFile());
    }

    public static void createScramCredentials(SaslSetup $this, String zkConnect, String userName, String password) {
        String[] credentials = (String[])Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).map((Function1)new Serializable($this, password){
            public static final long serialVersionUID = 0L;
            private final String password$1;

            public final String apply(ScramMechanism m) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=[iterations=4096,password=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.mechanismName(), this.password$1}));
            }
            {
                this.password$1 = password$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] args = (String[])((Object[])new String[]{"--zookeeper", zkConnect, "--alter", "--add-config", Predef$.MODULE$.refArrayOps((Object[])credentials).mkString(","), "--entity-type", "users", "--entity-name", userName});
        ConfigCommand$.MODULE$.main(args);
    }

    public static void $init$(SaslSetup $this) {
        $this.kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(TestUtils$.MODULE$.tempDir());
        $this.kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(MiniKdc$.MODULE$.createConfig());
        $this.kafka$api$SaslSetup$$kdc_$eq(null);
        $this.kafka$api$SaslSetup$$serverKeytabFile_$eq((Option<File>)None$.MODULE$);
        $this.kafka$api$SaslSetup$$clientKeytabFile_$eq((Option<File>)None$.MODULE$);
    }
}

