/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0011%\u00112tiJ\f7\r\u001e'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRD\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"aD\u000b\u000f\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0002\rA\u0013X\rZ3g\u0013\t1rC\u0001\u0004TiJLgn\u001a\u0006\u0003)EAQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtDCA\u000e\u001d!\tI\u0001\u0001C\u0003\u000e1\u0001\u0007a\u0002C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u000b\r|G-Z2\u0016\u0003\u0001\u0002\"!I\u0016\u000e\u0003\tR!a\t\u0013\u0002\rI,7m\u001c:e\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011AF\t\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"1a\u0006\u0001Q\u0001\n\u0001\naaY8eK\u000e\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t!M\u0001\u0005i&lW-F\u00013!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\tAQj\\2l)&lW\r\u0003\u0004:\u0001\u0001\u0006IAM\u0001\u0006i&lW\r\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u001d\u0019w.\u001e8uKJ,\u0012!\u0010\t\u0003!yJ!aP\t\u0003\u0007%sG\u000fC\u0004B\u0001\u0001\u0007I\u0011\u0001\"\u0002\u0017\r|WO\u001c;fe~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"\u0001\u0005#\n\u0005\u0015\u000b\"\u0001B+oSRDqa\u0012!\u0002\u0002\u0003\u0007Q(A\u0002yIEBa!\u0013\u0001!B\u0013i\u0014\u0001C2pk:$XM\u001d\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001N!\r\u0001b\nU\u0005\u0003\u001fF\u0011Q!\u0011:sCf\u0004\"!\u0015*\u000e\u0003\u0011J!a\u0015\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1Q\u000b\u0001Q\u0001\n5\u000b\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000b]\u0003A\u0011\u0001-\u0002\u0017\rdW-\u00198feR+7\u000f\u001e\u000b\u0002\u0007\"\u0012aK\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;&\nQA[;oSRL!a\u0018/\u0003\tQ+7\u000f\u001e\u0005\u0006C\u0002!\t\u0001W\u0001(i\u0016\u001cHo\u00117fC:\u001c8i\\7cS:,GmQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3U_BL7\r\u000b\u0002a5\")A\r\u0001C\u0005K\u0006Y2M]3bi\u0016d\u0015M]4f'&tw\r\\3NKN\u001c\u0018mZ3TKR$2A\u001a7o!\u0011\u0001rMD5\n\u0005!\f\"A\u0002+va2,'\u0007\u0005\u0002\"U&\u00111N\t\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000b5\u001c\u0007\u0019A\u001f\u0002\u0007-,\u0017\u0010C\u0003pG\u0002\u0007\u0001/\u0001\u000bnKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,feNLwN\u001c\t\u0003!EL!A]\t\u0003\t\tKH/\u001a\u0005\u0006i\u0002!\t\u0001W\u0001\u001fi\u0016\u001cHo\u00117fC:,'oV5uQ6+7o]1hK\u001a{'/\\1u-BB#a\u001d.\t\u000b]\u0004A\u0011\u0001-\u0002]Q,7\u000f^\"mK\u0006t\u0017N\\4OKN$X\rZ'fgN\fw-Z:XSRDW*\u001e7uSBdWMV3sg&|gn\u001d\u0015\u0003mjCQA\u001f\u0001\u0005\u0002a\u000bqc\u00197fC:,'oQ8oM&<W\u000b\u001d3bi\u0016$Vm\u001d;)\u0005eT\u0006\"B?\u0001\t\u0013q\u0018\u0001E2iK\u000e\\G*Y:u\u00072,\u0017M\\3e)\u0019\u0019u0a\u0001\u0002\b!1\u0011\u0011\u0001?A\u00029\tQ\u0001^8qS\u000eDa!!\u0002}\u0001\u0004i\u0014a\u00039beRLG/[8o\u0013\u0012Dq!!\u0003}\u0001\u0004\tY!\u0001\u0006gSJ\u001cH\u000fR5sif\u00042\u0001EA\u0007\u0013\r\ty!\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002\u0014\u0001!I!!\u0006\u00025\rDWmY6M_\u001e\fe\r^3s\u0003B\u0004XM\u001c3j]\u001e$U\u000f]:\u0015\u000f\r\u000b9\"a\b\u0002$!91!!\u0005A\u0002\u0005e\u0001cA\u0005\u0002\u001c%\u0019\u0011Q\u0004\u0002\u0003\u00071{w\r\u0003\u0005\u0002\"\u0005E\u0001\u0019AA\u0006\u0003%\u0019H/\u0019:u'&TX\r\u0003\u0005\u0002&\u0005E\u0001\u0019AA\u0014\u0003\u001d\t\u0007\u000f]3oIN\u0004b!!\u000b\u0002:\u0005}b\u0002BA\u0016\u0003kqA!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c1\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\r\t9$E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY$!\u0010\u0003\u0007M+\u0017OC\u0002\u00028E\u0001r\u0001EA!{9\tY!C\u0002\u0002DE\u0011a\u0001V;qY\u0016\u001c\u0004bBA$\u0001\u0011%\u0011\u0011J\u0001\u0006i>l\u0015\r\u001d\u000b\u0005\u0003\u0017\nI\u0006E\u0004\u0002N\u0005MS(a\u0016\u000e\u0005\u0005=#bAA)#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0013q\n\u0002\u0004\u001b\u0006\u0004\b#\u0002\th\u001d\u0005-\u0001\u0002CA.\u0003\u000b\u0002\r!!\u0018\u0002\u00115,7o]1hKN\u0004b!!\u0014\u0002`\u0005}\u0012\u0002BA1\u0003\u001f\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003K\u0002A\u0011BA4\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\t\u0005u\u0013\u0011\u000e\u0005\b\u0007\u0005\r\u0004\u0019AA\r\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u001d\u0005\u001d\u0012\u0011OA;\u0003s\nY(! \u0002\u0002\"9\u00111OA6\u0001\u0004i\u0014a\u00028v[.+\u0017p\u001d\u0005\b\u0003o\nY\u00071\u0001>\u0003\u001dqW/\u001c#vaNDqaAA6\u0001\u0004\tI\u0002\u0003\u0004\u001f\u0003W\u0002\r\u0001\t\u0005\n\u0003\u007f\nY\u0007%AA\u0002u\n\u0001b\u001d;beR\\U-\u001f\u0005\n\u0003\u0007\u000bY\u0007%AA\u0002A\f!\"\\1hS\u000e4\u0016\r\\;f\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u000b\u0011d\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fiRq\u0011qEAF\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0005bBA:\u0003\u000b\u0003\r!\u0010\u0005\b\u0003o\n)\t1\u0001>\u0011\u001d\u0019\u0011Q\u0011a\u0001\u00033AaAHAC\u0001\u0004\u0001\u0003\"CA@\u0003\u000b\u0003\n\u00111\u0001>\u0011\u001d\t\u0019)!\"A\u0002AD\u0011\"!'\u0001#\u0003%I!a'\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u%fA\u001f\u0002 .\u0012\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003%)hn\u00195fG.,GMC\u0002\u0002,F\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty+!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00024\u0002\t\n\u0011\"\u0003\u00026\u0006\u0019rO]5uK\u0012+\bo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0017\u0016\u0004a\u0006}\u0005\"CA^\u0001E\u0005I\u0011BAN\u0003\r:(/\u001b;f\tV\u00048oU5oO2,W*Z:tC\u001e,7+\u001a;%I\u00164\u0017-\u001e7uIUBs\u0001AA`\u0003\u0017\fi\r\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\r\t)\rX\u0001\u0007eVtg.\u001a:\n\t\u0005%\u00171\u0019\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\ty\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)\u000eX\u0001\beVtg.\u001a:t\u0013\u0011\tI.a5\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\tiN\u0001E\u0001\u0003?\f\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0019\u0011\"!9\u0007\r\u0005\u0011\u0001\u0012AAr'\u0011\t\t/!:\u0011\u0007A\t9/C\u0002\u0002jF\u0011a!\u00118z%\u00164\u0007bB\r\u0002b\u0012\u0005\u0011Q\u001e\u000b\u0003\u0003?D\u0001\"!=\u0002b\u0012\u0005\u00111_\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cXCAA{!\u0019\t9P!\u0001\u0003\u00065\u0011\u0011\u0011 \u0006\u0005\u0003w\fi0\u0001\u0003vi&d'BAA\u0000\u0003\u0011Q\u0017M^1\n\t\t\r\u0011\u0011 \u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001\tO\u001d!\"\u0011q\u001eB\u0005!\u0011\u0011YA!\b\u000f\t\t5!\u0011\u0004\b\u0005\u0005\u001f\u00119B\u0004\u0003\u0003\u0012\tUa\u0002BA\u0017\u0005'I\u0011AK\u0005\u0003;&J1!!6]\u0013\u0011\u0011Y\"a5\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\u0011yB!\t\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0003\u001c\u0005M\u0007")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private int counter;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$12 = maxMessageSize;
            float x$13 = this.makeCleaner$default$2();
            int x$14 = this.makeCleaner$default$3();
            long x$15 = this.makeCleaner$default$4();
            long x$16 = this.makeCleaner$default$6();
            int x$17 = this.makeCleaner$default$7();
            int x$18 = this.makeCleaner$default$8();
            Option<Object> x$19 = this.makeCleaner$default$9();
            Properties x$20 = this.makeCleaner$default$10();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$11, x$13, x$14, x$15, x$12, x$16, x$17, x$18, x$19, x$20));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3());
            long largeMessageOffset = appendInfo.firstOffset();
            int x$21 = largeMessageKey + 1;
            int x$22 = 100;
            int x$23 = 3;
            Log x$24 = log2;
            CompressionType x$25 = this.codec();
            byte x$26 = this.writeDups$default$6();
            Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$22, x$23, x$24, x$25, x$21, x$26);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            Log log2;
            Log log3;
            Log log4 = log3 = (log2 = (Log)tuple2._1());
            log4.logSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final Path apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log4){
                public static final long serialVersionUID = 0L;
                private final Log log$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$2.numberOfSegments() == 1;
                }
                {
                    this.log$2 = log$2;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There should only be 1 segment remaining";
                }
            }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log4.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                Log log22 = (Log)tuple22._1();
                Seq messages = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages);
                Log log23 = (Log)tuple24._1();
                Seq messages2 = (Seq)tuple24._2();
                Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = this.messageValue$1(128);
        byte[] x$37 = value.getBytes();
        CompressionType x$38 = this.codec();
        byte[] x$39 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$40 = messageFormatVersion;
        long x$41 = TestUtils$.MODULE$.singletonRecords$default$4();
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$37, x$39, x$38, x$41, x$40);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            CompressionType compressionType = this.codec();
            int n = CompressionType.NONE.equals(compressionType) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            WrappedArray x$42 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$43 = maxMessageSize;
            float x$44 = this.makeCleaner$default$2();
            int x$45 = this.makeCleaner$default$3();
            long x$46 = this.makeCleaner$default$4();
            long x$47 = this.makeCleaner$default$6();
            int x$48 = this.makeCleaner$default$7();
            int x$49 = this.makeCleaner$default$8();
            Option<Object> x$50 = this.makeCleaner$default$9();
            Properties x$51 = this.makeCleaner$default$10();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$42, x$44, x$45, x$46, x$43, x$47, x$48, x$49, x$50, x$51));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            int x$52 = maxMessageSize;
            Properties x$53 = this.logConfigProperties$default$1();
            float x$54 = this.logConfigProperties$default$3();
            long x$55 = this.logConfigProperties$default$4();
            int x$56 = this.logConfigProperties$default$5();
            int x$57 = this.logConfigProperties$default$6();
            Properties props = this.logConfigProperties(x$53, x$52, x$54, x$55, x$56, x$57);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$58 = 100;
            int x$59 = 3;
            Log x$60 = log2;
            CompressionType x$61 = this.codec();
            byte x$62 = 0;
            int x$63 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$58, x$59, x$60, x$61, x$63, x$62);
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$7) {
                    return x$7.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            int x$64 = 40;
            int x$65 = 3;
            Log x$66 = log2;
            CompressionType x$67 = this.codec();
            byte x$68 = 0;
            int x$69 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$64, x$65, x$66, x$67, x$69, x$68);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3());
            long largeMessageOffset = appendInfo.firstOffset();
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$70 = 30;
            int x$71 = 40;
            int x$72 = 3;
            Log x$73 = log2;
            CompressionType x$74 = this.codec();
            byte x$75 = 1;
            Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$71, x$72, x$73, x$74, x$70, x$75);
            int x$76 = 15;
            int x$77 = 5;
            int x$78 = 3;
            Log x$79 = log2;
            CompressionType x$80 = this.codec();
            byte x$81 = 2;
            Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$77, x$78, x$79, x$80, x$76, x$81);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        int maxMessageSize = 192;
        WrappedArray x$82 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$83 = maxMessageSize;
        float x$84 = this.makeCleaner$default$2();
        int x$85 = this.makeCleaner$default$3();
        long x$86 = this.makeCleaner$default$4();
        long x$87 = this.makeCleaner$default$6();
        int x$88 = this.makeCleaner$default$7();
        int x$89 = this.makeCleaner$default$8();
        Option<Object> x$90 = this.makeCleaner$default$9();
        Properties x$91 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$82, x$84, x$85, x$86, x$83, x$87, x$88, x$89, x$90, x$91));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$92 = maxMessageSize;
        Properties x$93 = this.logConfigProperties$default$1();
        float x$94 = this.logConfigProperties$default$3();
        long x$95 = this.logConfigProperties$default$4();
        int x$96 = this.logConfigProperties$default$5();
        int x$97 = this.logConfigProperties$default$6();
        Properties props = this.logConfigProperties(x$93, x$92, x$94, x$95, x$96, x$97);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$98 = 2;
        int x$99 = 3;
        Log x$100 = log2;
        CompressionType x$101 = this.codec();
        byte x$102 = 0;
        int x$103 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$98, x$99, x$100, x$101, x$103, x$102);
        int x$104 = 2;
        int x$105 = 3;
        int x$106 = 2;
        Log x$107 = log2;
        CompressionType x$108 = this.codec();
        byte x$109 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$104, x$106, x$107, x$108, x$105, x$109), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$110 = 4;
        int x$111 = 2;
        int x$112 = 2;
        Log x$113 = log2;
        CompressionType x$114 = this.codec();
        byte x$115 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$111, x$112, x$113, x$114, x$110, x$115);
        int x$116 = 4;
        int x$117 = 2;
        int x$118 = 2;
        Log x$119 = log2;
        CompressionType x$120 = this.codec();
        byte x$121 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$117, x$118, x$119, x$120, x$116, x$121), Seq$.MODULE$.canBuildFrom());
        int x$122 = 6;
        int x$123 = 2;
        int x$124 = 2;
        Log x$125 = log2;
        CompressionType x$126 = this.codec();
        byte x$127 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$123, x$124, x$125, x$126, x$122, x$127), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log2.size();
        this.cleaner().startup();
        long firstDirty = log2.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$128 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            long x$129 = 1L;
            int x$130 = maxMessageSize;
            Some x$131 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            float x$132 = this.makeCleaner$default$2();
            int x$133 = this.makeCleaner$default$3();
            long x$134 = this.makeCleaner$default$6();
            int x$135 = this.makeCleaner$default$7();
            int x$136 = this.makeCleaner$default$8();
            Properties x$137 = this.makeCleaner$default$10();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$128, x$132, x$133, x$129, x$130, x$134, x$135, x$136, (Option<Object>)x$131, x$137));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
            long firstDirty = log2.activeSegment().baseOffset();
            TopicPartition topicPartition = new TopicPartition("log", 0);
            this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
            Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
            KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
            KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
            this.cleaner().reconfigure(oldConfig, newConfig);
            Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$10) {
                    return x$10.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$138 = topicPartition;
        long x$139 = firstDirty;
        long x$140 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$138, x$139, x$140);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log2, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log2.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, Object>> apply(Tuple3<Object, String, Object> x0$1) {
                Tuple3<Object, String, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String value = (String)tuple3._2();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, String, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, String, Object> apply(Record deepLogEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, Log log2, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, startKey, magicValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            private final int startKey$1;
            public final byte magicValue$1;

            public final IndexedSeq<Tuple3<Object, String, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple3<Object, String, Object> apply(int key) {
                        String value = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        byte[] x$141 = value.toString().getBytes();
                        CompressionType x$142 = this.$outer.codec$1;
                        byte[] x$143 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        byte x$144 = this.$outer.magicValue$1;
                        long x$145 = TestUtils$.MODULE$.singletonRecords$default$4();
                        LogAppendInfo appendInfo = this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$141, x$143, x$142, x$145, x$144), 0, this.$outer.log$1.appendAsLeader$default$3());
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.startKey$1 = startKey$1;
                this.magicValue$1 = magicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return 2;
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log2, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$2;
            private final int startKey$2;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$2), this.startKey$2 + this.numKeys$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$2 = numKeys$2;
                this.startKey$2 = startKey$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records2 = (IndexedSeq)kvs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log2.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log2.appendAsLeader$default$3());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(Tuple2<Tuple2<Object, String>, Object> x0$3) {
                Tuple2<Tuple2<Object, String>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 kv = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$27 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()).take(1));
        Properties x$28 = logProps$1;
        long x$29 = 100L;
        float x$30 = this.makeCleaner$default$2();
        int x$31 = this.makeCleaner$default$3();
        int x$32 = this.makeCleaner$default$5();
        long x$33 = this.makeCleaner$default$6();
        int x$34 = this.makeCleaner$default$7();
        int x$35 = this.makeCleaner$default$8();
        Option<Object> x$36 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$27, x$30, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$28));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log2.size();
        log2.onHighWatermarkIncremented(log2.logEndOffset());
        long firstDirty = log2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log2, messages);
    }

    private final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    private final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.counter = 0;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

