/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleanerTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\r\rf\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000bq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD#a\u00191\t\u000b\u001d\u0004A\u0011\u0001)\u0002?Q,7\u000f\u001e#va2L7-\u0019;f\u0007\",7m[!gi\u0016\u00148\t\\3b]&tw\r\u000b\u0002gA\")!\u000e\u0001C\u0001!\u0006\tC/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\fu/\u0019:f\u00072,\u0017M\\5oO\"\u0012\u0011\u000e\u0019\u0005\u0006[\u0002!\t\u0001U\u0001*i\u0016\u001cHo\u00117fC:<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>t7o\u00159b]:LgnZ*fO6,g\u000e^:)\u00051\u0004\u0007\"\u00029\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016lwN^1mQ\ty\u0007\rC\u0003t\u0001\u0011\u0005\u0001+\u0001\u0013uKN$H)\u001a7fi\u0016$')\u0019;dQ\u0016\u001cx+\u001b;i\u001d>lUm]:bO\u0016\u001c(+Z1eQ\t\u0011\b\rC\u0003w\u0001\u0011\u0005\u0001+A\u0014uKN$8i\\7nSRl\u0015M]6feJ+G/\u001a8uS>tw+\u001b;i\u000b6\u0004H/\u001f\"bi\u000eD\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u0001=a\u0011\u0015a\b\u0001\"\u0001Q\u0003\u0019\"Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u0003w\u0002DQa \u0001\u0005\u0002A\u000b\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0005y\u0004\u0007BBA\u0003\u0001\u0011\u0005\u0001+A\fuKN$8\t\\3b]&twmV5uQ\u0012+G.\u001a;fg\"\u001a\u00111\u00011\t\r\u0005-\u0001\u0001\"\u0001Q\u0003M!Xm\u001d;M_\u001e\u001cE.Z1oKJ\u001cF/\u0019;t\u0011\u0019\ty\u0001\u0001C\u0001!\u0006IC/Z:u\u0019><7\t\\3b]\u0016\u0014(+\u001a;bS:\u001c\bK]8ek\u000e,'\u000fT1tiN+\u0017/^3oG\u0016D3!!\u0004a\u0011\u0019\t)\u0002\u0001C\u0001!\u0006ID/Z:u\u0019><7\t\\3b]\u0016\u0014(+\u001a;bS:\u001cH*Y:u'\u0016\fX/\u001a8dK\u00163XM\\%g)J\fgn]1di&|g.\u00112peR,G\rK\u0002\u0002\u0014\u0001Da!a\u0007\u0001\t\u0003\u0001\u0016a\u0006;fgR\u0004\u0016M\u001d;jC2\u001cVmZ7f]R\u001cE.Z1oQ\r\tI\u0002\u0019\u0005\u0007\u0003C\u0001A\u0011\u0001)\u0002EQ,7\u000f^\"mK\u0006t\u0017N\\4XSRDWK\\2mK\u0006t\u0017M\u00197f'\u0016\u001cG/[8oQ\r\ty\u0002\u0019\u0005\u0007\u0003O\u0001A\u0011\u0001)\u0002\u001dQ,7\u000f\u001e'pOR{7\t\\3b]\"\u001a\u0011Q\u00051\t\r\u00055\u0002\u0001\"\u0001Q\u0003\u0011\"Xm\u001d;M_\u001e$vn\u00117fC:<\u0016\u000e\u001e5V]\u000edW-\u00198bE2,7+Z2uS>t\u0007fAA\u0016A\"1\u00111\u0007\u0001\u0005\u0002A\u000bq\u0004^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5V].,\u00170\u001a3NKN\u001c\u0018mZ3tQ\r\t\t\u0004\u0019\u0005\b\u0003s\u0001A\u0011AA\u001e\u0003%YW-_:J]2{w\r\u0006\u0003\u0002>\u0005=\u0003CBA \u0003\u000b\nI%\u0004\u0002\u0002B)\u0019\u00111I*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001C%uKJ\f'\r\\3\u0011\u0007I\u000bY%C\u0002\u0002NM\u00131!\u00138u\u0011\u001d\u0019\u0011q\u0007a\u0001\u0003#\u00022AFA*\u0013\r\t)F\u0001\u0002\u0004\u0019><\u0007bBA-\u0001\u0011\u0005\u00111L\u0001\u0019Y\u0006\u001cHo\u00144gg\u0016$8\u000fU3s\u0005\u0006$8\r[%o\u0019><G\u0003BA/\u0003K\u0002b!a\u0010\u0002F\u0005}\u0003c\u0001*\u0002b%\u0019\u00111M*\u0003\t1{gn\u001a\u0005\b\u0007\u0005]\u0003\u0019AA)\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n!\u0003\\1tiN+\u0017/^3oG\u0016\u001c\u0018J\u001c'pOR!\u0011QNA:!!\ty$a\u001c\u0002`\u0005%\u0013\u0002BA9\u0003\u0003\u00121!T1q\u0011\u001d\u0019\u0011q\ra\u0001\u0003#Bq!a\u001e\u0001\t\u0003\tI(\u0001\u0007pM\u001a\u001cX\r^:J]2{w\r\u0006\u0003\u0002^\u0005m\u0004bB\u0002\u0002v\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003a)hn[3zK\u0012lUm]:bO\u0016\u001cu.\u001e8u\u0013:dun\u001a\u000b\u0005\u0003\u0013\n\u0019\tC\u0004\u0004\u0003{\u0002\r!!\u0015\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006q\u0011MY8si\u000eCWmY6E_:,GcA)\u0002\f\"A\u0011QRAC\u0001\u0004\ty)\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u0015QT\u0007\u0003\u0003'SA!!&\u0002\u0018\u000611m\\7n_:T1!BAM\u0015\r\tYJD\u0001\u0007CB\f7\r[3\n\t\u0005}\u00151\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0019\u000b\u0001C\u0001!\u0006QB/Z:u\u00072,\u0017M\\*fO6,g\u000e^:XSRD\u0017IY8si\"\u001a\u0011\u0011\u00151\t\r\u0005%\u0006\u0001\"\u0001Q\u0003M!Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8hQ\r\t9\u000b\u0019\u0005\u0007\u0003_\u0003A\u0011\u0001)\u0002IQ,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4XSRD7\u000b]1sg\u0016|eMZ:fiND3!!,a\u0011\u0019\t)\f\u0001C\u0001!\u0006YC/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO\u001a{G\u000e\\8xS:<Gj\\1e\u001f\u001aTVM]8J]\u0012,\u0007\u0010K\u0002\u00024\u0002Dq!a/\u0001\t\u0013\ti,A\tdQ\u0016\u001c7nU3h[\u0016tGo\u0014:eKJ$2!UA`\u0011!\t\t-!/A\u0002\u0005\r\u0017AB4s_V\u00048\u000f\u0005\u0004\u0002@\u0005\u0015\u0017\u0011Z\u0005\u0005\u0003\u000f\f\tEA\u0002TKF\u0004b!a\u0010\u0002F\u0006-\u0007c\u0001\f\u0002N&\u0019\u0011q\u001a\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004\u0002T\u0002!\t\u0001U\u0001\u0013i\u0016\u001cHOQ;jY\u0012|eMZ:fi6\u000b\u0007\u000fK\u0002\u0002R\u0002Da!!7\u0001\t\u0003\u0001\u0016A\u0006;fgR\u0014VmY8wKJL\u0018I\u001a;fe\u000e\u0013\u0018m\u001d5)\u0007\u0005]\u0007\r\u0003\u0004\u0002`\u0002!\t\u0001U\u0001\u001ci\u0016\u001cHOQ;jY\u0012|eMZ:fi6\u000b\u0007OR1lK2\u000b'oZ3)\u0007\u0005u\u0007\r\u0003\u0004\u0002f\u0002!\t\u0001U\u0001\u001ai\u0016\u001cHOQ;jY\u0012\u0004\u0016M\u001d;jC2|eMZ:fi6\u000b\u0007\u000fK\u0002\u0002d\u0002Da!a;\u0001\t\u0003\u0001\u0016A\u0007;fgR\u001cE.Z1o\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4f'\u0016$\bfAAuA\"1\u0011\u0011\u001f\u0001\u0005\u0002A\u000bQ\u0005^3ti\u000ec\u0017.\u001a8u\u0011\u0006tG\r\\5oO>37i\u001c:skB$X*Z:tC\u001e,7+\u001a;)\u0007\u0005=\b\r\u0003\u0004\u0002x\u0002!\t\u0001U\u0001\u0013i\u0016\u001cHo\u00117fC:$v.\u001c2ti>tW\rK\u0002\u0002v\u0002Dq!!@\u0001\t\u0013\ty0\u0001\u0006xe&$X\rV8M_\u001e$\u0002\"!\u0018\u0003\u0002\t\r!q\u0002\u0005\b\u0007\u0005m\b\u0019AA)\u0011!\u0011)!a?A\u0002\t\u001d\u0011!D6fsN\fe\u000e\u001a,bYV,7\u000f\u0005\u0004\u0002@\u0005\u0015#\u0011\u0002\t\b%\n-\u0011\u0011JA%\u0013\r\u0011ia\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\tE\u00111 a\u0001\u0003;\n\u0011b\u001c4gg\u0016$8+Z9\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005)\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0003\u0003B\r\u0005K\u0011ICa\u000b\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002\u0014\u00061!/Z2pe\u0012LAAa\t\u0003\u001e\tiQ*Z7pef\u0014VmY8sIND\u0001Ba\n\u0003\u0014\u0001\u0007\u0011qL\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\t\u0011\t\u0015!1\u0003a\u0001\u0005\u000fA!B!\f\u0003\u0014A\u0005\t\u0019\u0001B\u0018\u0003\u0015\u0019w\u000eZ3d!\u0011\u0011YB!\r\n\t\tM\"Q\u0004\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"9!q\u0007\u0001\u0005\n\te\u0012!E7fgN\fw-Z,ji\"|eMZ:fiRA!\u0011\u0004B\u001e\u0005\u0017\u0012y\u0005\u0003\u0005\u0003>\tU\u0002\u0019\u0001B \u0003\rYW-\u001f\t\u0006%\n\u0005#QI\u0005\u0004\u0005\u0007\u001a&!B!se\u0006L\bc\u0001*\u0003H%\u0019!\u0011J*\u0003\t\tKH/\u001a\u0005\t\u0005\u001b\u0012)\u00041\u0001\u0003@\u0005)a/\u00197vK\"A!\u0011\u000bB\u001b\u0001\u0004\ty&\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005o\u0001A\u0011\u0002B+)!\u0011IBa\u0016\u0003Z\tm\u0003\u0002\u0003B\u001f\u0005'\u0002\r!!\u0013\t\u0011\t5#1\u000ba\u0001\u0003\u0013B\u0001B!\u0015\u0003T\u0001\u0007\u0011q\f\u0005\b\u0005?\u0002A\u0011\u0002B1\u0003\u001di\u0017m[3M_\u001e$\u0002\"!\u0015\u0003d\t\u0015$\u0011\u000e\u0005\tK\tu\u0003\u0013!a\u00015!I!q\rB/!\u0003\u0005\rAN\u0001\u0007G>tg-[4\t\u0015\t-$Q\fI\u0001\u0002\u0004\ty&A\u0007sK\u000e|g/\u001a:z!>Lg\u000e\u001e\u0005\b\u0005_\u0002A\u0011\u0002B9\u0003-i\u0017m[3DY\u0016\fg.\u001a:\u0015\u0011\tM$\u0011\u0010B?\u0005\u000f\u00032A\u0006B;\u0013\r\u00119H\u0001\u0002\b\u00072,\u0017M\\3s\u0011!\u0011YH!\u001cA\u0002\u0005%\u0013\u0001C2ba\u0006\u001c\u0017\u000e^=\t\u0015\t}$Q\u000eI\u0001\u0002\u0004\u0011\t)A\u0005dQ\u0016\u001c7\u000eR8oKB1!Ka!\u0002\u0010FK1A!\"T\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0006\u0003\n\n5\u0004\u0013!a\u0001\u0003\u0013\na\"\\1y\u001b\u0016\u001c8/Y4f'&TX\rC\u0004\u0002~\u0002!IA!$\u0015\r\u0005u#q\u0012BI\u0011\u001d\u0019!1\u0012a\u0001\u0003#B\u0001Ba%\u0003\f\u0002\u0007!qA\u0001\u0004g\u0016\f\bb\u0002B\u001f\u0001\u0011%!q\u0013\u000b\u0005\u00053\u0013)\u000b\u0005\u0003\u0003\u001c\n\u0005VB\u0001BO\u0015\r\u0011yJH\u0001\u0004]&|\u0017\u0002\u0002BR\u0005;\u0013!BQ=uK\n+hMZ3s\u0011!\u00119K!&A\u0002\u0005%\u0013AA5e\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005W#bB!\u0007\u0003.\n=&\u0011\u0017B[\u0005\u007f\u0013\u0019\r\u0003\u0005\u0003>\t%\u0006\u0019AA%\u0011!\u0011iE!+A\u0002\u0005%\u0003B\u0003BZ\u0005S\u0003\n\u00111\u0001\u0002`\u0005Q\u0001O]8ek\u000e,'/\u00133\t\u0015\t]&\u0011\u0016I\u0001\u0002\u0004\u0011I,A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004%\nm\u0016b\u0001B_'\n)1\u000b[8si\"Q!\u0011\u0019BU!\u0003\u0005\r!!\u0013\u0002\u0011M,\u0017/^3oG\u0016D!B!2\u0003*B\u0005\t\u0019AA%\u0003Q\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t]8dQ\"9!\u0011\u001a\u0001\u0005\n\t-\u0017aG1qa\u0016tG\r\u0016:b]N\f7\r^5p]\u0006d\u0017i\u001d'fC\u0012,'\u000f\u0006\u0005\u0003N\n]'\u0011\u001cBn!\u001d\u0011&1\u0011Bh\u0005#\u0004b!a\u0010\u0002F\u0006%\u0003c\u0001\f\u0003T&\u0019!Q\u001b\u0002\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\u0019!q\u0019a\u0001\u0003#B\u0001Ba-\u0003H\u0002\u0007\u0011q\f\u0005\t\u0005o\u00139\r1\u0001\u0003:\"9!q\u001c\u0001\u0005\n\t\u0005\u0018\u0001G1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193feRQ!Q\u001aBr\u0005K\u00149O!;\t\u000f\r\u0011i\u000e1\u0001\u0002R!A!1\u0017Bo\u0001\u0004\ty\u0006\u0003\u0005\u00038\nu\u0007\u0019\u0001B]\u0011)\u0011YO!8\u0011\u0002\u0003\u0007!Q^\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0019!Ka<\n\u0007\tE8KA\u0004C_>dW-\u00198\t\u000f\tU\b\u0001\"\u0003\u0003x\u0006a1m\\7nSRl\u0015M]6feRA!\u0011\u0004B}\u0005w\u0014i\u0010\u0003\u0005\u00034\nM\b\u0019AA0\u0011!\u00119La=A\u0002\te\u0006B\u0003B\u0000\u0005g\u0004\n\u00111\u0001\u0002`\u0005IA/[7fgR\fW\u000e\u001d\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0003-\t'm\u001c:u\u001b\u0006\u00148.\u001a:\u0015\u0011\te1qAB\u0005\u0007\u0017A\u0001Ba-\u0004\u0002\u0001\u0007\u0011q\f\u0005\t\u0005o\u001b\t\u00011\u0001\u0003:\"Q!q`B\u0001!\u0003\u0005\r!a\u0018\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012\u0005aQM\u001c3Uq:l\u0015M]6feRa!\u0011DB\n\u0007+\u00199b!\t\u0004$!A!1WB\u0007\u0001\u0004\ty\u0006\u0003\u0005\u00038\u000e5\u0001\u0019\u0001B]\u0011!\u0019Ib!\u0004A\u0002\rm\u0011!E2p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qKB!!1DB\u000f\u0013\u0011\u0019yB!\b\u0003#\r{g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\r\u0003\u0005\u0003R\r5\u0001\u0019AA0\u0011!\u0011yp!\u0004A\u0002\u0005}\u0003b\u0002B\u0010\u0001\u0011%1q\u0005\u000b\u0007\u00053\u0019Ica\u000b\t\u0011\tu2Q\u0005a\u0001\u0003\u0013B\u0001B!\u0014\u0004&\u0001\u0007!q\b\u0005\b\u0007_\u0001A\u0011BB\u0019\u00035)hn[3zK\u0012\u0014VmY8sIR!!\u0011DB\u001a\u0011!\u0011ie!\fA\u0002\u0005%\u0003bBB\u001c\u0001\u0011%1\u0011H\u0001\u0010i>l'm\u001d;p]\u0016\u0014VmY8sIR!!\u0011DB\u001e\u0011!\u0011id!\u000eA\u0002\u0005%\u0003\"CB \u0001E\u0005I\u0011BB!\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uII*\"aa\u0011+\t\t\u00055QI\u0016\u0003\u0007\u000f\u0002Ba!\u0013\u0004T5\u001111\n\u0006\u0005\u0007\u001b\u001ay%A\u0005v]\u000eDWmY6fI*\u00191\u0011K*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004V\r-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1\u0011\f\u0001\u0012\u0002\u0013%11L\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iF\u000b\u0003\u0002J\r\u0015\u0003\"CB1\u0001E\u0005I\u0011BB2\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$H%M\u000b\u0003\u0007KR3AGB#\u0011%\u0019I\u0007AI\u0001\n\u0013\u0019Y'A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uII*\"a!\u001c+\u0007Y\u001a)\u0005C\u0005\u0004r\u0001\t\n\u0011\"\u0003\u0004t\u0005\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rU$\u0006BA0\u0007\u000bB\u0011b!\u001f\u0001#\u0003%Iaa\u001d\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012\u001a\u0004\"CB?\u0001E\u0005I\u0011BB@\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0002*\"!\u0011XB#\u0011%\u0019)\tAI\u0001\n\u0013\u0019Y&\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%k!I1\u0011\u0012\u0001\u0012\u0002\u0013%11L\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIYB\u0011b!$\u0001#\u0003%Iaa$\u0002E\u0005\u0004\b/\u001a8e\u0013\u0012,W\u000e]8uK:$\u0018i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tJ\u000b\u0003\u0003n\u000e\u0015\u0003\"CBK\u0001E\u0005I\u0011BB:\u0003U\t'm\u001c:u\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIMB\u0011b!'\u0001#\u0003%Iaa\u001d\u0002-\r|W.\\5u\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIMB\u0011b!(\u0001#\u0003%Iaa(\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\"*\"!qFB#\u0001")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$40 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$41 = this.makeLog$default$1();
        long x$42 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$41, x$40, x$42);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log2.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log2, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log2));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        long x$45 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$44, x$43, x$45);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log2.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        long x$48 = this.makeLog$default$3();
        ObjectRef log2 = ObjectRef.create((Object)this.makeLog(x$47, x$46, x$48));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log2.elem;
        long x$49 = qual$1.roll$default$1();
        qual$1.roll(x$49);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), this.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log2.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log2.elem;
        long x$53 = qual$2.roll$default$1();
        qual$2.roll(x$53);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), this.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$54 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$55 = this.makeLog$default$1();
        long x$56 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$55, x$54, x$56);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)abortedTransactions, (Object)log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$57 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$58 = this.makeLog$default$1();
        long x$59 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$58, x$57, x$59);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log2, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log2.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log2.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), this.keysInLog(log2));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, dirtyOffset, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), this.keysInLog(log2));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$60 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$61 = this.makeLog$default$1();
        long x$62 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$61, x$60, x$62);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log2));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$63 = Integer.MAX_VALUE;
        int x$64 = 100;
        Function1<TopicPartition, BoxedUnit> x$65 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$63, x$65, x$64);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$66 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$67 = this.makeLog$default$1();
        long x$68 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$67, x$66, x$68);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$69 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$70 = this.makeLog$default$1();
        long x$71 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$70, x$69, x$71);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$72 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$73 = this.makeLog$default$1();
        long x$74 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$73, x$72, x$74);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$75 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$76 = this.makeLog$default$1();
        long x$77 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$76, x$75, x$77);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((long)0L, (long)log2.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$78 = Integer.MAX_VALUE;
        int x$79 = 1024;
        Function1<TopicPartition, BoxedUnit> x$80 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$78, x$80, x$79);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$81 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$82 = this.makeLog$default$1();
        long x$83 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$82, x$81, x$83);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log2.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log2));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$84 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$85 = this.makeLog$default$1();
        long x$86 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$85, x$84, x$86);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long leo = log2.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$4;

            public final LogAppendInfo apply(int key) {
                return this.log$4.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$tombstoneRecord(key), 0, this.log$4.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$4 = log$4;
            }
        });
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log2).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToInteger((int)x$4));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$87 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$88 = this.makeLog$default$1();
        long x$89 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$88, x$87, x$89);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long initialLogSize = log2.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log2.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$90 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$91 = this.makeLog$default$1();
        long x$92 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$91, x$90, x$92);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 1, 1L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 2, 2L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 3, 3L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, 2L, (short)0, 1, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$93 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$94 = this.makeLog$default$1();
        long x$95 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$94, x$93, x$95);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$96 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$97 = this.makeLog$default$1();
        long x$98 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$97, x$96, x$98);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 3L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 4L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$99 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$100 = this.makeLog$default$1();
        long x$101 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$100, x$99, x$101);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log2.numberOfSegments() <= numCleanableSegments) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log2.logEndOffset() + 1L;
        while (log2.numberOfSegments() < numTotalSegments - 1) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log2).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$102 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$103 = this.makeLog$default$1();
        long x$104 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$103, x$102, x$104);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$6;

            public final LogAppendInfo apply(int _) {
                return this.log$6.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecorcs$1(), 0, this.log$6.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$6 = log$6;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, log2.activeSegment().baseOffset(), log2.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log2.size() - (long)log2.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$105 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$106 = this.makeLog$default$1();
        long x$107 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$106, x$105, x$107);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$7;

            public final LogAppendInfo apply(int _) {
                return this.log$7.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecords$1(), 0, this.log$7.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        });
        Seq segs = log2.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$7) {
                return x$7.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$108 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$109 = this.makeLog$default$1();
        long x$110 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$109, x$108, x$110);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.unkeyedRecord((int)log2.logEndOffset()), 0, log2.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log2);
        long sizeWithUnkeyedMessages = log2.size();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log2.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log2));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log2.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> keysInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch();
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Record record) {
                                return record.hasValue() && record.hasKey();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Record record) {
                                return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return batch.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log2) {
        return ((TraversableOnce)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch() && batch.hasProducerId();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$9) {
                        return x$9.hasValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$10) {
                        return x$10.hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Record m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log2) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$11) {
                        return x$11.hasValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record m) {
                        return !m.hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$111 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$112 = this.makeLog$default$1();
        long x$113 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$112, x$111, x$113);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keys = this.keysInLog(log2);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log2, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$8;
            private final FakeOffsetMap map$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$8, ((TraversableOnce)this.log$8.logSegments().take(3)).toSeq(), (OffsetMap)this.map$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$8 = log$8;
                this.map$3 = map$3;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$114 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$115 = this.makeLog$default$1();
        long x$116 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$115, x$114, x$116);
        int i = 0;
        while (log2.numberOfSegments() < 10) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), 1, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$12) {
                return x$12.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, 1, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$13) {
                return x$13.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$14) {
                return x$14.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), logSize, Integer.MAX_VALUE, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$16) {
                return x$16.offsetIndex().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, indexSize, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$17) {
                return x$17.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$117 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$118 = this.makeLog$default$1();
        long x$119 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$118, x$117, x$119);
        while (log2.numberOfSegments() == 1) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        MemoryRecords records2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log2.appendAsFollower(records2);
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log2.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)(log2.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$120 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$121 = this.makeLog$default$1();
        long x$122 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$121, x$120, x$122);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log2.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log2.appendAsFollower(record2);
        log2.roll(0x3FFFFFFFL);
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log2.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log2.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log2.logEndOffset() - 1L - log2.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log2.logSegments().last()).offsetIndex().lastOffset() - log2.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$18) {
                return (Seq)x$18.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$19) {
                        return x$19.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log2.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log2.logEndOffset(), log2, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$126 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$127 = this.makeLog$default$1();
        long x$128 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$127, x$126, x$128);
        int messageCount = 0;
        while (log2.numberOfSegments() < 10) {
            Log qual$3 = log2;
            MemoryRecords x$129 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$130 = 0;
            boolean x$131 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$129, x$130, x$131);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log2);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = this.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = this.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck$1(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$4 = log2;
            MemoryRecords x$132 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$133 = 0;
            boolean x$134 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$132, x$133, x$134);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = this.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log2 = this.recoverAndCheck$1(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$5 = log2;
            MemoryRecords x$135 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$136 = 0;
            boolean x$137 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$135, x$136, x$137);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = this.keysInLog(log2);
        log2.close();
        log2 = this.recoverAndCheck$1(config, cleanedKeys);
        log2.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$138 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$139 = this.makeLog$default$1();
        long x$140 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$139, x$138, x$140);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log2, (long)start2, (long)end, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.kafka$log$LogCleanerTest$$key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(4, 4, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.kafka$log$LogCleanerTest$$key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.kafka$log$LogCleanerTest$$key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(4)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$141 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$142 = this.makeLog$default$1();
        long x$143 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$142, x$141, x$143);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log2.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(Record record) {
                                Assert.assertTrue((boolean)record.hasMagic(this.batch$1.magic()));
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)record.offset(), (long)value);
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Record logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$144 = logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$145 = this.makeLog$default$1();
        long x$146 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$145, x$144, x$146);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$147 = "0".getBytes();
        byte[] x$148 = "0".getBytes();
        long x$149 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$150 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$151 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$147, x$148, x$150, x$149, x$151), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        byte[] x$152 = null;
        byte[] x$153 = "0".getBytes();
        long x$154 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$155 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$156 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$152, x$153, x$155, x$154, x$156), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 1L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$157 = "1".getBytes();
        byte[] x$158 = "1".getBytes();
        long x$159 = this.time().milliseconds();
        CompressionType x$160 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$161 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$157, x$158, x$160, x$159, x$161), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$11;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$20) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$20;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$11.appendAsFollower(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset)).lastOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$11 = log$11;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(Tuple2<Object, Object> kv) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$21) {
                return x$21.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$30 = dir;
        LogConfig x$31 = config;
        long x$32 = 0L;
        long x$33 = recoveryPoint;
        MockScheduler x$34 = this.time().scheduler();
        MockTime x$35 = this.time();
        BrokerTopicStats x$36 = new BrokerTopicStats();
        int x$37 = 3600000;
        int x$38 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$39 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$30, x$31, x$32, x$33, (Scheduler)x$34, x$36, (Time)x$35, x$37, x$38, x$39);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TopicPartition x$22) {
            }
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$10;

            public final long apply(Tuple2<Object, Object> x$23) {
                Tuple2<Object, Object> tuple2 = x$23;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$10.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$record(key, value, this.$outer.kafka$log$LogCleanerTest$$record$default$3(), this.$outer.kafka$log$LogCleanerTest$$record$default$4(), this.$outer.kafka$log$LogCleanerTest$$record$default$5(), this.$outer.kafka$log$LogCleanerTest$$record$default$6()), 0, this.log$10.appendAsLeader$default$3()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$10 = log$10;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer kafka$log$LogCleanerTest$$key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log2, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log2, producerId, producerEpoch, true);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log2, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return new Serializable(this, log2, producerId, producerEpoch, isTransactional, sequence){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$2;
            private final long producerId$1;
            private final short producerEpoch$1;
            private final boolean isTransactional$1;
            private final IntRef sequence$1;

            public final LogAppendInfo apply(Seq<Object> keys) {
                Seq simpleRecords = (Seq)keys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$appendIdempotentAsLeader$1 $outer;

                    public final SimpleRecord apply(int key) {
                        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        return new SimpleRecord(this.$outer.kafka$log$LogCleanerTest$$anonfun$$$outer().time().milliseconds(), keyBytes, keyBytes);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                MemoryRecords records2 = this.isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                this.sequence$1.elem += simpleRecords.size();
                return this.log$2.appendAsLeader(records2, 0, this.log$2.appendAsLeader$default$3());
            }

            public /* synthetic */ LogCleanerTest kafka$log$LogCleanerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.producerId$1 = producerId$1;
                this.producerEpoch$1 = producerEpoch$1;
                this.isTransactional$1 = isTransactional$1;
                this.sequence$1 = sequence$1;
            }
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$162 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$163 = value;
        CompressionType x$164 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$165 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$166 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$163, x$162, x$164, x$165, x$166);
    }

    public long kafka$log$LogCleanerTest$$record$default$3() {
        return -1L;
    }

    public short kafka$log$LogCleanerTest$$record$default$4() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$5() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private final void reloadLog$1(Properties logProps$1, ObjectRef log$1) {
        ((Log)log$1.elem).close();
        LogConfig x$50 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$51 = 0L;
        File x$52 = this.makeLog$default$1();
        log$1.elem = this.makeLog(x$52, x$50, x$51);
    }

    private final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$2) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    private final Seq distinctValuesBySegment$1(Log log$5) {
        return ((TraversableOnce)log$5.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Record record) {
                        return TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$9, Cleaner cleaner$2) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$2.buildOffsetMap(log$9, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$4.get(this.$outer.kafka$log$LogCleanerTest$$key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_6;
        LogConfig x$123 = config;
        File x$124 = this.makeLog$default$1();
        long x$125 = this.makeLog$default$3();
        Log recoveredLog = this.makeLog(x$124, x$123, x$125);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_6;
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$24 = Double.MAX_VALUE;
        long x$25 = Long.MAX_VALUE;
        MockTime x$26 = this.time();
        boolean x$27 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$28 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$29 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$24, x$25, x$27, x$28, x$29, (Time)x$26);
    }
}

