/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\u0011B*Z1eKJ,E.Z2uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\nEJ|7.\u001a:JIF*\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\u0006ce>\\WM]%ec\u0001Bqa\b\u0001C\u0002\u0013\u0005Q#A\u0005ce>\\WM]%ee!1\u0011\u0005\u0001Q\u0001\nY\t!B\u0019:pW\u0016\u0014\u0018\n\u001a\u001a!\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\nqa]3sm\u0016\u00148/F\u0001&!\r1c&\r\b\u0003O1r!\u0001K\u0016\u000e\u0003%R!A\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA\u0017\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\f\u0019\u0003\u0007M+\u0017O\u0003\u0002.1A\u0011!CM\u0005\u0003g\t\u00111bS1gW\u0006\u001cVM\u001d<fe\"9Q\u0007\u0001a\u0001\n\u00031\u0014aC:feZ,'o]0%KF$\"a\u000e\u001e\u0011\u0005]A\u0014BA\u001d\u0019\u0005\u0011)f.\u001b;\t\u000fm\"\u0014\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u0003&\u0003!\u0019XM\u001d<feN\u0004\u0003bB \u0001\u0001\u0004%\t\u0001Q\u0001\u001dgR\fG.Z\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195EKR,7\r^3e+\u0005\t\u0005CA\fC\u0013\t\u0019\u0005DA\u0004C_>dW-\u00198\t\u000f\u0015\u0003\u0001\u0019!C\u0001\r\u0006\u00013\u000f^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$U\r^3di\u0016$w\fJ3r)\t9t\tC\u0004<\t\u0006\u0005\t\u0019A!\t\r%\u0003\u0001\u0015)\u0003B\u0003u\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012\u0004\u0003\"B&\u0001\t\u0003b\u0015!B:fiV\u0003H#A\u001c)\u0005)s\u0005CA(U\u001b\u0005\u0001&BA)S\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0016aA8sO&\u0011Q\u000b\u0015\u0002\u0007\u0005\u00164wN]3\t\u000b]\u0003A\u0011\t'\u0002\u0011Q,\u0017M\u001d#po:D#AV-\u0011\u0005=S\u0016BA.Q\u0005\u0015\te\r^3s\u0011\u0015i\u0006\u0001\"\u0001M\u0003i!Xm\u001d;MK\u0006$WM]#mK\u000e$\u0018n\u001c8B]\u0012,\u0005o\\2iQ\tav\f\u0005\u0002PA&\u0011\u0011\r\u0015\u0002\u0005)\u0016\u001cH\u000fC\u0003d\u0001\u0011\u0005A*\u0001\u0016uKN$H*Z1eKJ,E.Z2uS>tw+\u001b;i'R\fG.Z\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195)\u0005\t|\u0006\"\u00024\u0001\t\u00139\u0017\u0001H:uC2,7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007nQ1mY\n\f7m\u001b\u000b\u0003o!DQ![3A\u0002)\f\u0001B]3ta>t7/\u001a\t\u0003WNl\u0011\u0001\u001c\u0006\u0003[:\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003_B\faaY8n[>t'BA\u0003r\u0015\t\u0011(+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003i2\u0014\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3")
public class LeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private boolean staleControllerEpochDetected = false;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        configProps1.put("unclean.leader.election.enable", "true");
        configProps2.put("unclean.leader.election.enable", "true");
        KafkaServer server1 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps1), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps2), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testLeaderElectionAndEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoch: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$1)).toString();
            }
            {
                this.leaderEpoch1$1 = leaderEpoch1$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final int leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader1$1)}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (leader1 == 0 || leader1 == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (long)0L, (long)leaderEpoch1);
        ((KafkaServer)this.servers().last()).shutdown();
        KafkaZkClient x$2 = this.zkClient();
        String x$3 = topic;
        int x$4 = partitionId;
        None$ x$5 = leader1 == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)leader1));
        long x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$2, x$3, x$4, x$6, (Option<Object>)x$5, x$7);
        int leaderEpoch2 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final int leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader1$1)}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leaderEpoch2){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch2$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoch: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch2$1)).toString();
            }
            {
                this.leaderEpoch2$1 = leaderEpoch2$1;
            }
        });
        Assert.assertEquals((String)"Leader must move to broker 0", (long)0L, (long)leader2);
        if (leader1 == leader2) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch1)).append((Object)BoxesRunTime.boxToInteger((int)1)).toString(), (long)(leaderEpoch1 + 1), (long)leaderEpoch2);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 1))})), (long)(leaderEpoch1 + 1), (long)leaderEpoch2);
        }
        ((KafkaServer)this.servers().last()).startup();
        ((KafkaServer)this.servers().head()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        KafkaZkClient x$8 = this.zkClient();
        String x$9 = topic;
        int x$10 = partitionId;
        None$ x$11 = leader2 == 1 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$8, x$9, x$10, x$12, (Option<Object>)x$11, x$13);
        int leaderEpoch3 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch3){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch3$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoch: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch3$1)).toString();
            }
            {
                this.leaderEpoch3$1 = leaderEpoch3$1;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader3){
            public static final long serialVersionUID = 0L;
            private final int leader3$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader3$1)}));
            }
            {
                this.leader3$1 = leader3$1;
            }
        });
        Assert.assertEquals((String)"Leader must return to 1", (long)1L, (long)leader3);
        if (leader2 == leader3) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch2)).toString(), (long)leaderEpoch2, (long)leaderEpoch3);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 1))})), (long)(leaderEpoch2 + 1), (long)leaderEpoch3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = this.zkUtils().getEpochForPartition(topic, partitionId);
        this.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$2;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoch: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$2)).toString();
            }
            {
                this.leaderEpoch1$2 = leaderEpoch1$2;
            }
        });
        this.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final int leader1$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader1$2)}));
            }
            {
                this.leader1$2 = leader1$2;
            }
        });
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (leader1 == 0 || leader1 == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (long)0L, (long)leaderEpoch1);
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)this.servers().map((Function1)new Serializable(this, securityProtocol, listenerName){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol securityProtocol$1;
            private final ListenerName listenerName$1;

            public final Broker apply(KafkaServer s) {
                return new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort(s, TestUtils$.MODULE$.boundPort$default$2()), this.listenerName$1, this.securityProtocol$1);
            }
            {
                this.securityProtocol$1 = securityProtocol$1;
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq nodes = (Seq)brokers.map((Function1)new Serializable(this, listenerName){
            public static final long serialVersionUID = 0L;
            private final ListenerName listenerName$1;

            public final Node apply(Broker x$1) {
                return x$1.node(this.listenerName$1);
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.liveBrokers_$eq((Set)brokers.toSet());
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partitionId)), (Object)new LeaderAndIsrRequest.PartitionState(2, this.brokerId2(), LeaderAndIsr$.MODULE$.initialLeaderEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x$1) {
                    return x$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava(), LeaderAndIsr$.MODULE$.initialZKVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x$1) {
                    return x$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava(), false))}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, staleControllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            controllerChannelManager.sendRequest(this.brokerId2(), ApiKeys.LEADER_AND_ISR, (AbstractRequest.Builder)requestBuilder, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LeaderElectionTest $outer;

                public final void apply(AbstractResponse response) {
                    this.$outer.kafka$server$LeaderElectionTest$$staleControllerEpochCallback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LeaderElectionTest $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.staleControllerEpochDetected();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller epoch should be stale";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Stale controller epoch not detected by the broker", (boolean)this.staleControllerEpochDetected());
        }
        catch (Throwable throwable) {
            void var12_12;
            void var13_13;
            var13_13.shutdown();
            var12_12.close();
            throw throwable;
        }
        controllerChannelManager.shutdown();
        metrics.close();
    }

    public void kafka$server$LeaderElectionTest$$staleControllerEpochCallback(AbstractResponse response) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response;
        Errors errors = leaderAndIsrResponse.error();
        boolean bl = Errors.STALE_CONTROLLER_EPOCH.equals(errors);
        this.staleControllerEpochDetected_$eq(bl);
    }

    public LeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

