/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.KafkaException;
import kafka.common.MessageReader;
import kafka.common.MessageReader$class;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.serializer.DefaultEncoder;
import kafka.tools.ConsoleProducer$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0015s!B\u0001\u0003\u0011\u00039\u0011aD\"p]N|G.\u001a)s_\u0012,8-\u001a:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ty1i\u001c8t_2,\u0007K]8ek\u000e,'o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000bYIA\u0011A\f\u0002\t5\f\u0017N\u001c\u000b\u00031m\u0001\"!D\r\n\u0005iq!\u0001B+oSRDQ\u0001H\u000bA\u0002u\tA!\u0019:hgB\u0019QB\b\u0011\n\u0005}q!!B!se\u0006L\bCA\u0011%\u001d\ti!%\u0003\u0002$\u001d\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019c\u0002C\u0003)\u0013\u0011\u0005\u0011&\u0001\bhKR\u0014V-\u00193feB\u0013x\u000e]:\u0015\u0005)\u0012\u0004CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011\u0007\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B\u001a(\u0001\u0004!\u0014AB2p]\u001aLw\r\u0005\u00026m5\t\u0011B\u0002\u00038\u0013\u0001A$A\u0004)s_\u0012,8-\u001a:D_:4\u0017nZ\n\u0003m1A\u0001\u0002\b\u001c\u0003\u0002\u0003\u0006I!\b\u0005\u0006'Y\"\ta\u000f\u000b\u0003iqBQ\u0001\b\u001eA\u0002uAqA\u0010\u001cC\u0002\u0013\u0005q(\u0001\u0004qCJ\u001cXM]\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\t1)\u0001\u0006k_B$8/[7qY\u0016L!!\u0012\"\u0003\u0019=\u0003H/[8o!\u0006\u00148/\u001a:\t\r\u001d3\u0004\u0015!\u0003A\u0003\u001d\u0001\u0018M]:fe\u0002Bq!\u0013\u001cC\u0002\u0013\u0005!*\u0001\u0005u_BL7m\u00149u+\u0005Y\u0005cA!MA%\u0011QJ\u0011\u0002\u001c\u0003J<W/\\3oi\u0006\u001b7-\u001a9uS:<w\n\u001d;j_:\u001c\u0006/Z2\t\r=3\u0004\u0015!\u0003L\u0003%!x\u000e]5d\u001fB$\b\u0005C\u0004Rm\t\u0007I\u0011\u0001&\u0002\u001b\t\u0014xn[3s\u0019&\u001cHo\u00149u\u0011\u0019\u0019f\u0007)A\u0005\u0017\u0006q!M]8lKJd\u0015n\u001d;PaR\u0004\u0003bB+7\u0005\u0004%\tAV\u0001\bgft7m\u00149u+\u00059\u0006CA!Y\u0013\tI&IA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJDaa\u0017\u001c!\u0002\u00139\u0016\u0001C:z]\u000e|\u0005\u000f\u001e\u0011\t\u000fu3$\u0019!C\u0001\u0015\u0006\u00192m\\7qe\u0016\u001c8/[8o\u0007>$WmY(qi\"1qL\u000eQ\u0001\n-\u000bAcY8naJ,7o]5p]\u000e{G-Z2PaR\u0004\u0003bB17\u0005\u0004%\tAY\u0001\rE\u0006$8\r[*ju\u0016|\u0005\u000f^\u000b\u0002GB\u0019\u0011\t\u00143\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dt\u0013\u0001\u00027b]\u001eL!!\u001b4\u0003\u000f%sG/Z4fe\"11N\u000eQ\u0001\n\r\fQBY1uG\"\u001c\u0016N_3PaR\u0004\u0003bB77\u0005\u0004%\tAY\u0001\u0019[\u0016\u001c8/Y4f'\u0016tG-T1y%\u0016$(/[3t\u001fB$\bBB87A\u0003%1-A\rnKN\u001c\u0018mZ3TK:$W*\u0019=SKR\u0014\u0018.Z:PaR\u0004\u0003bB97\u0005\u0004%\tAY\u0001\u0012e\u0016$(/\u001f\"bG.|gMZ't\u001fB$\bBB:7A\u0003%1-\u0001\nsKR\u0014\u0018PQ1dW>4g-T:PaR\u0004\u0003bB;7\u0005\u0004%\tAY\u0001\u000fg\u0016tG\rV5nK>,Ho\u00149u\u0011\u00199h\u0007)A\u0005G\u0006y1/\u001a8e)&lWm\\;u\u001fB$\b\u0005C\u0004zm\t\u0007I\u0011\u00012\u0002\u0019E,X-^3TSj,w\n\u001d;\t\rm4\u0004\u0015!\u0003d\u00035\tX/Z;f'&TXm\u00149uA!9QP\u000eb\u0001\n\u0003\u0011\u0017\u0001G9vKV,WI\\9vKV,G+[7f_V$Xj](qi\"1qP\u000eQ\u0001\n\r\f\u0011$];fk\u0016,e.];fk\u0016$\u0016.\\3pkRl5o\u00149uA!I\u00111\u0001\u001cC\u0002\u0013\u0005\u0011QA\u0001\u0017e\u0016\fX/Z:u%\u0016\fX/\u001b:fI\u0006\u001b7n](qiV\u0011\u0011q\u0001\t\u0005\u00032\u000bI\u0001E\u0002f\u0003\u0017I!!\n4\t\u0011\u0005=a\u0007)A\u0005\u0003\u000f\tqC]3rk\u0016\u001cHOU3rk&\u0014X\rZ!dWN|\u0005\u000f\u001e\u0011\t\u0011\u0005MaG1A\u0005\u0002\t\f1C]3rk\u0016\u001cH\u000fV5nK>,H/T:PaRDq!a\u00067A\u0003%1-\u0001\u000bsKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H\u000f\t\u0005\n\u000371$\u0019!C\u0001\u0003;\t1#\\3uC\u0012\fG/Y#ya&\u0014\u00180T:PaR,\"!a\b\u0011\t\u0005c\u0015\u0011\u0005\t\u0004K\u0006\r\u0012bAA\u0013M\n!Aj\u001c8h\u0011!\tIC\u000eQ\u0001\n\u0005}\u0011\u0001F7fi\u0006$\u0017\r^1FqBL'/_'t\u001fB$\b\u0005C\u0005\u0002.Y\u0012\r\u0011\"\u0001\u0002\u001e\u0005iQ.\u0019=CY>\u001c7.T:PaRD\u0001\"!\r7A\u0003%\u0011qD\u0001\u000f[\u0006D(\t\\8dW6\u001bx\n\u001d;!\u0011%\t)D\u000eb\u0001\n\u0003\ti\"A\tnCblU-\\8ss\nKH/Z:PaRD\u0001\"!\u000f7A\u0003%\u0011qD\u0001\u0013[\u0006DX*Z7pef\u0014\u0015\u0010^3t\u001fB$\b\u0005C\u0005\u0002>Y\u0012\r\u0011\"\u0001\u0002\u001e\u0005QR.\u0019=QCJ$\u0018\u000e^5p]6+Wn\u001c:z\u0005f$Xm](qi\"A\u0011\u0011\t\u001c!\u0002\u0013\ty\"A\u000enCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fg>\u0003H\u000f\t\u0005\n\u0003\u000b2$\u0019!C\u0001\u0003\u000b\tqB^1mk\u0016,enY8eKJ|\u0005\u000f\u001e\u0005\t\u0003\u00132\u0004\u0015!\u0003\u0002\b\u0005\u0001b/\u00197vK\u0016s7m\u001c3fe>\u0003H\u000f\t\u0005\n\u0003\u001b2$\u0019!C\u0001\u0003\u000b\tQb[3z\u000b:\u001cw\u000eZ3s\u001fB$\b\u0002CA)m\u0001\u0006I!a\u0002\u0002\u001d-,\u00170\u00128d_\u0012,'o\u00149uA!I\u0011Q\u000b\u001cC\u0002\u0013\u0005\u0011QA\u0001\u0011[\u0016\u001c8/Y4f%\u0016\fG-\u001a:PaRD\u0001\"!\u00177A\u0003%\u0011qA\u0001\u0012[\u0016\u001c8/Y4f%\u0016\fG-\u001a:PaR\u0004\u0003\u0002CA/m\t\u0007I\u0011\u00012\u0002'M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;\t\u000f\u0005\u0005d\u0007)A\u0005G\u0006!2o\\2lKR\u0014UO\u001a4feNK'0Z(qi\u0002B\u0001\"!\u001a7\u0005\u0004%\tAS\u0001\faJ|\u0007/\u001a:us>\u0003H\u000fC\u0004\u0002jY\u0002\u000b\u0011B&\u0002\u0019A\u0014x\u000e]3sif|\u0005\u000f\u001e\u0011\t\u0011\u00055dG1A\u0005\u0002)\u000b1\u0003\u001d:pIV\u001cWM\u001d)s_B,'\u000f^=PaRDq!!\u001d7A\u0003%1*\u0001\u000bqe>$WoY3s!J|\u0007/\u001a:us>\u0003H\u000f\t\u0005\t\u0003k2$\u0019!C\u0001\u0015\u0006\t\u0002O]8ek\u000e,'oQ8oM&<w\n\u001d;\t\u000f\u0005ed\u0007)A\u0005\u0017\u0006\u0011\u0002O]8ek\u000e,'oQ8oM&<w\n\u001d;!\u0011!\tiH\u000eb\u0001\n\u00031\u0016!E;tK>cG\r\u0015:pIV\u001cWM](qi\"9\u0011\u0011\u0011\u001c!\u0002\u00139\u0016AE;tK>cG\r\u0015:pIV\u001cWM](qi\u0002B\u0011\"!\"7\u0005\u0004%\t!a\"\u0002\u000f=\u0004H/[8ogV\u0011\u0011\u0011\u0012\t\u0004\u0003\u0006-\u0015bAAG\u0005\nIq\n\u001d;j_:\u001cV\r\u001e\u0005\t\u0003#3\u0004\u0015!\u0003\u0002\n\u0006Aq\u000e\u001d;j_:\u001c\b\u0005C\u0005\u0002\u0016Z\u0012\r\u0011\"\u0001\u0002\u0018\u0006qQo]3PY\u0012\u0004&o\u001c3vG\u0016\u0014XCAAM!\ri\u00111T\u0005\u0004\u0003;s!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003C3\u0004\u0015!\u0003\u0002\u001a\u0006yQo]3PY\u0012\u0004&o\u001c3vG\u0016\u0014\b\u0005C\u0005\u0002&Z\u0012\r\u0011\"\u0001\u0002(\u0006)Ao\u001c9jGV\t\u0001\u0005C\u0004\u0002,Z\u0002\u000b\u0011\u0002\u0011\u0002\rQ|\u0007/[2!\u0011%\tyK\u000eb\u0001\n\u0003\t9+\u0001\u0006ce>\\WM\u001d'jgRDq!a-7A\u0003%\u0001%A\u0006ce>\\WM\u001d'jgR\u0004\u0003\"CA\\m\t\u0007I\u0011AAL\u0003\u0011\u0019\u0018P\\2\t\u0011\u0005mf\u0007)A\u0005\u00033\u000bQa]=oG\u0002B\u0011\"a07\u0005\u0004%\t!a*\u00027\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;j_:4\u0016\r\\;f\u0011\u001d\t\u0019M\u000eQ\u0001\n\u0001\nAdY8naJ,7o]5p]\u000e{G-Z2PaRLwN\u001c,bYV,\u0007\u0005C\u0005\u0002HZ\u0012\r\u0011\"\u0001\u0002J\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$WmY\u000b\u0003\u0003\u0013A\u0001\"!47A\u0003%\u0011\u0011B\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003\"CAim\t\u0007I\u0011AAj\u0003%\u0011\u0017\r^2i'&TX-F\u0001e\u0011\u001d\t9N\u000eQ\u0001\n\u0011\f!BY1uG\"\u001c\u0016N_3!\u0011%\tYN\u000eb\u0001\n\u0003\t\u0019.A\u0006tK:$G+[7f_V$\bbBApm\u0001\u0006I\u0001Z\u0001\rg\u0016tG\rV5nK>,H\u000f\t\u0005\n\u0003G4$\u0019!C\u0001\u0003'\f\u0011\"];fk\u0016\u001c\u0016N_3\t\u000f\u0005\u001dh\u0007)A\u0005I\u0006Q\u0011/^3vKNK'0\u001a\u0011\t\u0013\u0005-hG1A\u0005\u0002\u0005M\u0017!F9vKV,WI\\9vKV,G+[7f_V$Xj\u001d\u0005\b\u0003_4\u0004\u0015!\u0003e\u0003Y\tX/Z;f\u000b:\fX/Z;f)&lWm\\;u\u001bN\u0004\u0003\"CAzm\t\u0007I\u0011AAe\u0003M\u0011X-];fgR\u0014V-];je\u0016$\u0017iY6t\u0011!\t9P\u000eQ\u0001\n\u0005%\u0011\u0001\u0006:fcV,7\u000f\u001e*fcVL'/\u001a3BG.\u001c\b\u0005C\u0005\u0002|Z\u0012\r\u0011\"\u0001\u0002T\u0006\u0001\"/Z9vKN$H+[7f_V$Xj\u001d\u0005\b\u0003\u007f4\u0004\u0015!\u0003e\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000f\t\u0005\n\u0005\u00071$\u0019!C\u0001\u0003'\fQ#\\3tg\u0006<WmU3oI6\u000b\u0007PU3ue&,7\u000fC\u0004\u0003\bY\u0002\u000b\u0011\u00023\u0002-5,7o]1hKN+g\u000eZ'bqJ+GO]5fg\u0002B\u0011Ba\u00037\u0005\u0004%\t!a5\u0002\u001dI,GO]=CC\u000e\\wN\u001a4Ng\"9!q\u0002\u001c!\u0002\u0013!\u0017a\u0004:fiJL()Y2l_\u001a4Wj\u001d\u0011\t\u0013\tMaG1A\u0005\u0002\u0005%\u0017aD6fs\u0016s7m\u001c3fe\u000ec\u0017m]:\t\u0011\t]a\u0007)A\u0005\u0003\u0013\t\u0001c[3z\u000b:\u001cw\u000eZ3s\u00072\f7o\u001d\u0011\t\u0013\tmaG1A\u0005\u0002\u0005%\u0017!\u0005<bYV,WI\\2pI\u0016\u00148\t\\1tg\"A!q\u0004\u001c!\u0002\u0013\tI!\u0001\nwC2,X-\u00128d_\u0012,'o\u00117bgN\u0004\u0003\"\u0003B\u0012m\t\u0007I\u0011AAe\u0003-\u0011X-\u00193fe\u000ec\u0017m]:\t\u0011\t\u001db\u0007)A\u0005\u0003\u0013\tAB]3bI\u0016\u00148\t\\1tg\u0002B\u0011Ba\u000b7\u0005\u0004%\t!a5\u0002\u0019M|7m[3u\u0005V4g-\u001a:\t\u000f\t=b\u0007)A\u0005I\u0006i1o\\2lKR\u0014UO\u001a4fe\u0002B\u0011Ba\r7\u0005\u0004%\tA!\u000e\u0002\u0019\rlG\rT5oKB\u0013x\u000e]:\u0016\u0003)BqA!\u000f7A\u0003%!&A\u0007d[\u0012d\u0015N\\3Qe>\u00048\u000f\t\u0005\n\u0005{1$\u0019!C\u0001\u0005k\t!#\u001a=ue\u0006\u0004&o\u001c3vG\u0016\u0014\bK]8qg\"9!\u0011\t\u001c!\u0002\u0013Q\u0013aE3yiJ\f\u0007K]8ek\u000e,'\u000f\u0015:paN\u0004\u0003\"\u0003B#m\t\u0007I\u0011\u0001B$\u00039i\u0017\r_'f[>\u0014\u0018PQ=uKN,\"!!\t\t\u0011\t-c\u0007)A\u0005\u0003C\tq\"\\1y\u001b\u0016lwN]=CsR,7\u000f\t\u0005\n\u0005\u001f2$\u0019!C\u0001\u0005\u000f\nq#\\1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:\t\u0011\tMc\u0007)A\u0005\u0003C\t\u0001$\\1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:!\u0011%\u00119F\u000eb\u0001\n\u0003\u00119%\u0001\tnKR\fG-\u0019;b\u000bb\u0004\u0018N]=Ng\"A!1\f\u001c!\u0002\u0013\t\t#A\tnKR\fG-\u0019;b\u000bb\u0004\u0018N]=Ng\u0002B\u0011Ba\u00187\u0005\u0004%\tAa\u0012\u0002\u00155\f\u0007P\u00117pG.l5\u000f\u0003\u0005\u0003dY\u0002\u000b\u0011BA\u0011\u0003-i\u0017\r\u001f\"m_\u000e\\Wj\u001d\u0011\t\u000f\t\u001d\u0014\u0002\"\u0001\u0003j\u0005\u0019r-\u001a;PY\u0012\u0004&o\u001c3vG\u0016\u0014\bK]8qgR\u0019!Fa\u001b\t\rM\u0012)\u00071\u00015\u0011\u001d\u0011y'\u0003C\u0005\u0005c\nQ\u0002\u001d:pIV\u001cWM\u001d)s_B\u001cHc\u0001\u0016\u0003t!11G!\u001cA\u0002QBqAa\u001e\n\t\u0003\u0011I(A\nhKRtUm\u001e)s_\u0012,8-\u001a:Qe>\u00048\u000fF\u0002+\u0005wBaa\rB;\u0001\u0004!dA\u0002B@\u0013\u0001\u0011\tIA\tMS:,W*Z:tC\u001e,'+Z1eKJ\u001cRA! \r\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013#\u0011AB2p[6|g.\u0003\u0003\u0003\u000e\n\u001d%!D'fgN\fw-\u001a*fC\u0012,'\u000fC\u0004\u0014\u0005{\"\tA!%\u0015\u0005\tM\u0005cA\u001b\u0003~!Q\u0011Q\u0015B?\u0001\u0004%\t!a*\t\u0015\te%Q\u0010a\u0001\n\u0003\u0011Y*A\u0005u_BL7m\u0018\u0013fcR\u0019\u0001D!(\t\u0013\t}%qSA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!A\u00111\u0016B?A\u0003&\u0001\u0005\u0003\u0006\u0003&\nu\u0004\u0019!C\u0001\u0005O\u000baA]3bI\u0016\u0014XC\u0001BU!\u0011\u0011YK!-\u000e\u0005\t5&b\u0001BX]\u0005\u0011\u0011n\\\u0005\u0005\u0005g\u0013iK\u0001\bCk\u001a4WM]3e%\u0016\fG-\u001a:\t\u0015\t]&Q\u0010a\u0001\n\u0003\u0011I,\u0001\u0006sK\u0006$WM]0%KF$2\u0001\u0007B^\u0011)\u0011yJ!.\u0002\u0002\u0003\u0007!\u0011\u0016\u0005\n\u0005\u007f\u0013i\b)Q\u0005\u0005S\u000bqA]3bI\u0016\u0014\b\u0005\u0003\u0006\u0003D\nu\u0004\u0019!C\u0001\u0003/\u000b\u0001\u0002]1sg\u0016\\U-\u001f\u0005\u000b\u0005\u000f\u0014i\b1A\u0005\u0002\t%\u0017\u0001\u00049beN,7*Z=`I\u0015\fHc\u0001\r\u0003L\"Q!q\u0014Bc\u0003\u0003\u0005\r!!'\t\u0013\t='Q\u0010Q!\n\u0005e\u0015!\u00039beN,7*Z=!\u0011)\u0011\u0019N! A\u0002\u0013\u0005\u0011\u0011Z\u0001\rW\u0016L8+\u001a9be\u0006$xN\u001d\u0005\u000b\u0005/\u0014i\b1A\u0005\u0002\te\u0017\u0001E6fsN+\u0007/\u0019:bi>\u0014x\fJ3r)\rA\"1\u001c\u0005\u000b\u0005?\u0013).!AA\u0002\u0005%\u0001\"\u0003Bp\u0005{\u0002\u000b\u0015BA\u0005\u00035YW-_*fa\u0006\u0014\u0018\r^8sA!Q!1\u001dB?\u0001\u0004%\t!a&\u0002\u0017%<gn\u001c:f\u000bJ\u0014xN\u001d\u0005\u000b\u0005O\u0014i\b1A\u0005\u0002\t%\u0018aD5h]>\u0014X-\u0012:s_J|F%Z9\u0015\u0007a\u0011Y\u000f\u0003\u0006\u0003 \n\u0015\u0018\u0011!a\u0001\u00033C\u0011Ba<\u0003~\u0001\u0006K!!'\u0002\u0019%<gn\u001c:f\u000bJ\u0014xN\u001d\u0011\t\u0015\tM(Q\u0010a\u0001\n\u0003\u0011)0\u0001\u0006mS:,g*^7cKJ,\"Aa>\u0011\u00075\u0011I0C\u0002\u0003|:\u00111!\u00138u\u0011)\u0011yP! A\u0002\u0013\u00051\u0011A\u0001\u000fY&tWMT;nE\u0016\u0014x\fJ3r)\rA21\u0001\u0005\u000b\u0005?\u0013i0!AA\u0002\t]\b\"CB\u0004\u0005{\u0002\u000b\u0015\u0002B|\u0003-a\u0017N\\3Ok6\u0014WM\u001d\u0011\t\u0011\r-!Q\u0010C!\u0007\u001b\tA!\u001b8jiR)\u0001da\u0004\u0004\u001a!A1\u0011CB\u0005\u0001\u0004\u0019\u0019\"A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003\u0002BV\u0007+IAaa\u0006\u0003.\nY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0019Yb!\u0003A\u0002)\nQ\u0001\u001d:paND\u0001ba\b\u0003~\u0011\u00053\u0011E\u0001\fe\u0016\fG-T3tg\u0006<W\r\u0006\u0002\u0004$AA1QEB\u001d\u0007{\u0019i$\u0004\u0002\u0004()!1\u0011FB\u0016\u0003!\u0001(o\u001c3vG\u0016\u0014(\u0002BB\u0017\u0007_\tqa\u00197jK:$8OC\u0002\u0006\u0007cQAaa\r\u00046\u00051\u0011\r]1dQ\u0016T!aa\u000e\u0002\u0007=\u0014x-\u0003\u0003\u0004<\r\u001d\"A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\t\u0005\u001by\u0019y\u0004E\u0002\u000e\u0007\u0003J1aa\u0011\u000f\u0005\u0011\u0011\u0015\u0010^3")
public final class ConsoleProducer {
    public static Properties getNewProducerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getNewProducerProps(producerConfig);
    }

    public static Properties getOldProducerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getOldProducerProps(producerConfig);
    }

    public static Properties getReaderProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getReaderProps(producerConfig);
    }

    public static void main(String[] stringArray) {
        ConsoleProducer$.MODULE$.main(stringArray);
    }

    public static class ProducerConfig {
        private final OptionParser parser = new OptionParser(false);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        private final OptionSpecBuilder syncOpt = this.parser().accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        private final ArgumentAcceptingOptionSpec<String> compressionCodecOpt = this.parser().accepts("compression-codec", "The compression codec: either 'none', 'gzip', 'snappy', or 'lz4'.If specified without value, then it defaults to 'gzip'").withOptionalArg().describedAs("compression-codec").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = this.parser().accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt = this.parser().accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> retryBackoffMsOpt = this.parser().accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> sendTimeoutOpt = this.parser().accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting sufficient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> queueSizeOpt = this.parser().accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting sufficient batch size.").withRequiredArg().describedAs("queue_size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> queueEnqueueTimeoutMsOpt = this.parser().accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt = this.parser().accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(String.class).defaultsTo((Object)"1", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt = this.parser().accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt = this.parser().accepts("metadata-expiry-ms", "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any leadership changes.").withRequiredArg().describedAs("metadata expiration interval").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(300000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt = this.parser().accepts("max-block-ms", "The max time that the producer will block for during a send request").withRequiredArg().describedAs("max block on send").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(60000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt = this.parser().accepts("max-memory-bytes", "The total memory used by the producer to buffer records waiting to be sent to the server.").withRequiredArg().describedAs("total memory in bytes").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0x2000000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxPartitionMemoryBytesOpt = this.parser().accepts("max-partition-memory-bytes", "The buffer size allocated for a partition. When records are received which are smaller than this size the producer will attempt to optimistically group them together until this size is reached.").withRequiredArg().describedAs("memory in bytes per partition").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(16384L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<String> valueEncoderOpt = this.parser().accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)DefaultEncoder.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyEncoderOpt = this.parser().accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)DefaultEncoder.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> messageReaderOpt = this.parser().accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)LineMessageReader.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> propertyOpt = this.parser().accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerPropertyOpt = this.parser().accepts("producer-property", "A mechanism to pass user-defined properties in the form key=value to the producer. ").withRequiredArg().describedAs("producer_prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt = this.parser().accepts("producer.config", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer config properties file. Note that ", " takes precedence over this config."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerPropertyOpt()}))).withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder useOldProducerOpt = this.parser().accepts("old-producer", "Use the old producer implementation.");
        private final OptionSet options;
        private final boolean useOldProducer;
        private final String topic;
        private final String brokerList;
        private final boolean sync;
        private final String compressionCodecOptionValue;
        private final String compressionCodec;
        private final Integer batchSize;
        private final Integer sendTimeout;
        private final Integer queueSize;
        private final Integer queueEnqueueTimeoutMs;
        private final String requestRequiredAcks;
        private final Integer requestTimeoutMs;
        private final Integer messageSendMaxRetries;
        private final Integer retryBackoffMs;
        private final String keyEncoderClass;
        private final String valueEncoderClass;
        private final String readerClass;
        private final Integer socketBuffer;
        private final Properties cmdLineProps;
        private final Properties extraProducerProps;
        private final Long maxMemoryBytes;
        private final Long maxPartitionMemoryBytes;
        private final Long metadataExpiryMs;
        private final Long maxBlockMs;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<String> compressionCodecOpt() {
            return this.compressionCodecOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt() {
            return this.messageSendMaxRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> retryBackoffMsOpt() {
            return this.retryBackoffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> sendTimeoutOpt() {
            return this.sendTimeoutOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> queueSizeOpt() {
            return this.queueSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> queueEnqueueTimeoutMsOpt() {
            return this.queueEnqueueTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt() {
            return this.requestRequiredAcksOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt() {
            return this.requestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt() {
            return this.metadataExpiryMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt() {
            return this.maxBlockMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt() {
            return this.maxMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxPartitionMemoryBytesOpt() {
            return this.maxPartitionMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueEncoderOpt() {
            return this.valueEncoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyEncoderOpt() {
            return this.keyEncoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> messageReaderOpt() {
            return this.messageReaderOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> propertyOpt() {
            return this.propertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerPropertyOpt() {
            return this.producerPropertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public OptionSpecBuilder useOldProducerOpt() {
            return this.useOldProducerOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldProducer() {
            return this.useOldProducer;
        }

        public String topic() {
            return this.topic;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public boolean sync() {
            return this.sync;
        }

        public String compressionCodecOptionValue() {
            return this.compressionCodecOptionValue;
        }

        public String compressionCodec() {
            return this.compressionCodec;
        }

        public Integer batchSize() {
            return this.batchSize;
        }

        public Integer sendTimeout() {
            return this.sendTimeout;
        }

        public Integer queueSize() {
            return this.queueSize;
        }

        public Integer queueEnqueueTimeoutMs() {
            return this.queueEnqueueTimeoutMs;
        }

        public String requestRequiredAcks() {
            return this.requestRequiredAcks;
        }

        public Integer requestTimeoutMs() {
            return this.requestTimeoutMs;
        }

        public Integer messageSendMaxRetries() {
            return this.messageSendMaxRetries;
        }

        public Integer retryBackoffMs() {
            return this.retryBackoffMs;
        }

        public String keyEncoderClass() {
            return this.keyEncoderClass;
        }

        public String valueEncoderClass() {
            return this.valueEncoderClass;
        }

        public String readerClass() {
            return this.readerClass;
        }

        public Integer socketBuffer() {
            return this.socketBuffer;
        }

        public Properties cmdLineProps() {
            return this.cmdLineProps;
        }

        public Properties extraProducerProps() {
            return this.extraProducerProps;
        }

        public Long maxMemoryBytes() {
            return this.maxMemoryBytes;
        }

        public Long maxPartitionMemoryBytes() {
            return this.maxPartitionMemoryBytes;
        }

        public Long metadataExpiryMs() {
            return this.metadataExpiryMs;
        }

        public Long maxBlockMs() {
            return this.maxBlockMs;
        }

        public ProducerConfig(String[] args) {
            this.options = this.parser().parse(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Read data from standard input and publish it to Kafka.");
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.brokerListOpt()}));
            this.useOldProducer = this.options().has((OptionSpec)this.useOldProducerOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.brokerList = (String)this.options().valueOf(this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser(), this.brokerList());
            this.sync = this.options().has((OptionSpec)this.syncOpt());
            this.compressionCodecOptionValue = (String)this.options().valueOf(this.compressionCodecOpt());
            this.compressionCodec = this.options().has(this.compressionCodecOpt()) ? (this.compressionCodecOptionValue() == null || this.compressionCodecOptionValue().isEmpty() ? DefaultCompressionCodec$.MODULE$.name() : this.compressionCodecOptionValue()) : NoCompressionCodec$.MODULE$.name();
            this.batchSize = (Integer)this.options().valueOf(this.batchSizeOpt());
            this.sendTimeout = (Integer)this.options().valueOf(this.sendTimeoutOpt());
            this.queueSize = (Integer)this.options().valueOf(this.queueSizeOpt());
            this.queueEnqueueTimeoutMs = (Integer)this.options().valueOf(this.queueEnqueueTimeoutMsOpt());
            this.requestRequiredAcks = (String)this.options().valueOf(this.requestRequiredAcksOpt());
            this.requestTimeoutMs = (Integer)this.options().valueOf(this.requestTimeoutMsOpt());
            this.messageSendMaxRetries = (Integer)this.options().valueOf(this.messageSendMaxRetriesOpt());
            this.retryBackoffMs = (Integer)this.options().valueOf(this.retryBackoffMsOpt());
            this.keyEncoderClass = (String)this.options().valueOf(this.keyEncoderOpt());
            this.valueEncoderClass = (String)this.options().valueOf(this.valueEncoderOpt());
            this.readerClass = (String)this.options().valueOf(this.messageReaderOpt());
            this.socketBuffer = (Integer)this.options().valueOf(this.socketBufferSizeOpt());
            this.cmdLineProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.propertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
            this.extraProducerProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.producerPropertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
            this.maxMemoryBytes = (Long)this.options().valueOf(this.maxMemoryBytesOpt());
            this.maxPartitionMemoryBytes = (Long)this.options().valueOf(this.maxPartitionMemoryBytesOpt());
            this.metadataExpiryMs = (Long)this.options().valueOf(this.metadataExpiryMsOpt());
            this.maxBlockMs = (Long)this.options().valueOf(this.maxBlockMsOpt());
        }
    }

    public static class LineMessageReader
    implements MessageReader {
        private String topic;
        private BufferedReader reader;
        private boolean parseKey;
        private String keySeparator;
        private boolean ignoreError;
        private int lineNumber;

        @Override
        public void close() {
            MessageReader$class.close(this);
        }

        public String topic() {
            return this.topic;
        }

        public void topic_$eq(String x$1) {
            this.topic = x$1;
        }

        public BufferedReader reader() {
            return this.reader;
        }

        public void reader_$eq(BufferedReader x$1) {
            this.reader = x$1;
        }

        public boolean parseKey() {
            return this.parseKey;
        }

        public void parseKey_$eq(boolean x$1) {
            this.parseKey = x$1;
        }

        public String keySeparator() {
            return this.keySeparator;
        }

        public void keySeparator_$eq(String x$1) {
            this.keySeparator = x$1;
        }

        public boolean ignoreError() {
            return this.ignoreError;
        }

        public void ignoreError_$eq(boolean x$1) {
            this.ignoreError = x$1;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public void lineNumber_$eq(int x$1) {
            this.lineNumber = x$1;
        }

        @Override
        public void init(InputStream inputStream, Properties props) {
            this.topic_$eq(props.getProperty("topic"));
            if (props.containsKey("parse.key")) {
                this.parseKey_$eq(props.getProperty("parse.key").trim().equalsIgnoreCase("true"));
            }
            if (props.containsKey("key.separator")) {
                this.keySeparator_$eq(props.getProperty("key.separator"));
            }
            if (props.containsKey("ignore.error")) {
                this.ignoreError_$eq(props.getProperty("ignore.error").trim().equalsIgnoreCase("true"));
            }
            this.reader_$eq(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
        }

        @Override
        public ProducerRecord<byte[], byte[]> readMessage() {
            Tuple2 tuple2;
            block9: {
                ProducerRecord producerRecord;
                block6: {
                    block7: {
                        String line;
                        block8: {
                            ProducerRecord producerRecord2;
                            block5: {
                                String string;
                                this.lineNumber_$eq(this.lineNumber() + 1);
                                Predef$.MODULE$.print((Object)">");
                                tuple2 = new Tuple2((Object)this.reader().readLine(), (Object)BoxesRunTime.boxToBoolean((boolean)this.parseKey()));
                                if (tuple2 == null || (string = (String)tuple2._1()) != null) break block5;
                                producerRecord = null;
                                break block6;
                            }
                            if (tuple2 == null) break block7;
                            line = (String)tuple2._1();
                            boolean bl = tuple2._2$mcZ$sp();
                            if (!bl) break block7;
                            int n = line.indexOf(this.keySeparator());
                            switch (n) {
                                default: {
                                    byte[] value2 = (n + new StringOps(Predef$.MODULE$.augmentString(this.keySeparator())).size() > new StringOps(Predef$.MODULE$.augmentString(line)).size() ? "" : line.substring(n + new StringOps(Predef$.MODULE$.augmentString(this.keySeparator())).size())).getBytes(StandardCharsets.UTF_8);
                                    producerRecord2 = new ProducerRecord(this.topic(), (Object)line.substring(0, n).getBytes(StandardCharsets.UTF_8), (Object)value2);
                                    break;
                                }
                                case -1: {
                                    if (!this.ignoreError()) break block8;
                                    producerRecord2 = new ProducerRecord(this.topic(), (Object)line.getBytes(StandardCharsets.UTF_8));
                                }
                            }
                            producerRecord = producerRecord2;
                            break block6;
                        }
                        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No key found on line ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lineNumber()), line})));
                    }
                    if (tuple2 == null) break block9;
                    String line = (String)tuple2._1();
                    boolean bl = tuple2._2$mcZ$sp();
                    if (bl) break block9;
                    producerRecord = new ProducerRecord(this.topic(), (Object)line.getBytes(StandardCharsets.UTF_8));
                }
                return producerRecord;
            }
            throw new MatchError((Object)tuple2);
        }

        public LineMessageReader() {
            MessageReader$class.$init$(this);
            this.topic = null;
            this.reader = null;
            this.parseKey = false;
            this.keySeparator = "\t";
            this.ignoreError = false;
            this.lineNumber = 0;
        }
    }
}

