/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.api.OffsetRequest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ReplayLogProducer;
import kafka.tools.ReplayLogProducer$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ReplayLogProducer$
implements Logging {
    public static final ReplayLogProducer$ MODULE$;
    private final String GroupId;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplayLogProducer$();
    }

    private Logger logger$lzycompute() {
        ReplayLogProducer$ replayLogProducer$ = this;
        synchronized (replayLogProducer$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private String GroupId() {
        return this.GroupId;
    }

    public void main(String[] args) {
        ReplayLogProducer.Config config = new ReplayLogProducer.Config(args);
        ZkUtils$.MODULE$.maybeDeletePath(config.zkConnect(), new StringBuilder().append((Object)"/consumers/").append((Object)this.GroupId()).toString());
        Thread.sleep(500L);
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", this.GroupId());
        consumerProps.put("zookeeper.connect", config.zkConnect());
        consumerProps.put("consumer.timeout.ms", "10000");
        consumerProps.put("auto.offset.reset", OffsetRequest$.MODULE$.SmallestTimeString());
        consumerProps.put("fetch.message.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        consumerProps.put("socket.receive.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x200000)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.inputTopic()), (Object)BoxesRunTime.boxToInteger((int)config.numThreads()))}))));
        ObjectRef threadList = ObjectRef.create((Object)Nil$.MODULE$);
        topicMessageStreams.values().foreach((Function1)new Serializable(config, threadList){
            public static final long serialVersionUID = 0L;
            public final ReplayLogProducer.Config config$1;
            public final ObjectRef threadList$1;

            public final void apply(List<KafkaStream<byte[], byte[]>> streamList) {
                streamList.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final void apply(KafkaStream<byte[], byte[]> stream) {
                        this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon((Object)new ReplayLogProducer.ZKConsumerThread(this.$outer.config$1, stream));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.config$1 = config$1;
                this.threadList$1 = threadList$1;
            }
        });
        ((List)threadList.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ReplayLogProducer.ZKConsumerThread thread) {
                thread.start();
            }
        });
        ((List)threadList.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ReplayLogProducer.ZKConsumerThread x$1) {
                x$1.shutdown();
            }
        });
        consumerConnector.shutdown();
    }

    private ReplayLogProducer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.GroupId = "replay-log-producer";
    }
}

