/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import kafka.api.BaseQuotaTest;
import kafka.api.QuotaTestClients;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.Before;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u000f\t\t2\t\\5f]RLE-U;pi\u0006$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u00055\u0011\u0015m]3Rk>$\u0018\rV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0005BI\t\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0016\u0003M\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\t1\fgn\u001a\u0006\u00021\u0005!!.\u0019<b\u0013\tQRC\u0001\u0004TiJLgn\u001a\u0005\u00069\u0001!\tEE\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012DQA\b\u0001\u0005B}\tQa]3u+B$\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000f\u000b\u0002\u001eOA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0005\u0019qN]4\n\u00059J#A\u0002\"fM>\u0014X\rC\u00031\u0001\u0011\u0005\u0013'\u0001\fde\u0016\fG/Z)v_R\fG+Z:u\u00072LWM\u001c;t)\r\u0011T'\u0010\t\u0003\u0013MJ!\u0001\u000e\u0002\u0003!E+x\u000e^1UKN$8\t\\5f]R\u001c\b\"\u0002\u001c0\u0001\u00049\u0014!\u0002;pa&\u001c\u0007C\u0001\u001d<\u001d\t\t\u0013(\u0003\u0002;E\u00051\u0001K]3eK\u001aL!A\u0007\u001f\u000b\u0005i\u0012\u0003\"\u0002 0\u0001\u0004y\u0014A\u00037fC\u0012,'OT8eKB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\u000b%aC&bM.\f7+\u001a:wKJ\u0004")
public class ClientIdQuotaTest
extends BaseQuotaTest {
    @Override
    public String producerClientId() {
        return "QuotasTestProducer-!@#$%^&*()";
    }

    @Override
    public String consumerClientId() {
        return "QuotasTestConsumer-!@#$%^&*()";
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultProducerQuota())).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultConsumerQuota())).toString());
        super.setUp();
    }

    @Override
    public QuotaTestClients createQuotaTestClients(String topic, KafkaServer leaderNode) {
        return new QuotaTestClients(this, topic, leaderNode){
            private final /* synthetic */ ClientIdQuotaTest $outer;

            public KafkaPrincipal userPrincipal() {
                return KafkaPrincipal.ANONYMOUS;
            }

            public Map<String, String> quotaMetricTags(String clientId) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
            }

            public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
                Properties producerProps = new Properties();
                producerProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
                producerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
                this.updateQuotaOverride(this.$outer.producerClientId(), producerProps);
                Properties consumerProps = new Properties();
                consumerProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
                consumerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
                this.updateQuotaOverride(this.$outer.consumerClientId(), consumerProps);
            }

            public void removeQuotaOverrides() {
                Properties emptyProps = new Properties();
                this.updateQuotaOverride(this.$outer.producerClientId(), emptyProps);
                this.updateQuotaOverride(this.$outer.consumerClientId(), emptyProps);
            }

            private void updateQuotaOverride(String clientId, Properties properties) {
                this.$outer.adminZkClient().changeClientIdConfig(Sanitizer.sanitize((String)clientId), properties);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(topic$1, leaderNode$1, $outer.producerClientId(), $outer.consumerClientId(), (KafkaProducer<byte[], byte[]>)((KafkaProducer)$outer.producers().head()), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)$outer.consumers().head()));
            }
        };
    }
}

