/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.AdminClientIntegrationTest$$anonfun$testDescribeLogDirs$1$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0001#D\u0001\u000f\u0015\tyA!A\u0003vi&d7/\u0003\u0002\u0012\u001d\t9Aj\\4hS:<\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\tI\u0001\u0001C\u0003\u0018\u0001\u0011\u0005\u0001$A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0006eVdWm\u001d\u0006\u0003=}\tQA[;oSRT\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001c\u0005\u001d!\u0016.\\3pkRD#A\u0006\u0013\u0011\u0005\u00152S\"A\u000f\n\u0005\u001dj\"\u0001\u0002*vY\u0016Dq!\u000b\u0001A\u0002\u0013\u0005!&\u0001\u0004dY&,g\u000e^\u000b\u0002WA\u0011A\u0006N\u0007\u0002[)\u0011afL\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003aE\nqa\u00197jK:$8O\u0003\u0002\u0006e)\u00111gH\u0001\u0007CB\f7\r[3\n\u0005Uj#aC!e[&t7\t\\5f]RDqa\u000e\u0001A\u0002\u0013\u0005\u0001(\u0001\u0006dY&,g\u000e^0%KF$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001Z\n\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015B\u0016\u0002\u000f\rd\u0017.\u001a8uA!9A\t\u0001b\u0001\n\u0003)\u0015!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001eDaa\u0014\u0001!\u0002\u00131\u0015A\u0002;pa&\u001c\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u0013A\f'\u000f^5uS>tW#A*\u0011\u0005i\"\u0016BA+<\u0005\rIe\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B*\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\f\u0005\u0002]?6\tQL\u0003\u0002_c\u000511m\\7n_:L!\u0001Y/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1!\r\u0001Q\u0001\nm\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\u0006I\u0002!\t%Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u00121m\u001a\t\u0003K!L!![\u000f\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0011f\u0003!!X-\u0019:E_^t\u0007F\u00016n!\t)c.\u0003\u0002p;\t)\u0011I\u001a;fe\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\u0016aC:feZ,'oQ8v]RDaa\u001d\u0001!\u0002\u0013\u0019\u0016\u0001D:feZ,'oQ8v]R\u0004\u0003bB;\u0001\u0005\u0004%\tAU\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r]\u0004\u0001\u0015!\u0003T\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002Bq!\u001f\u0001C\u0002\u0013\u0005!+A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B*\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!)Q\u0010\u0001C!}\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0000!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u001fY\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004<!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\t\u000511/\u001a:wKJLA!!\t\u0002\u001c\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tAb\u0019:fCR,7i\u001c8gS\u001e$\"!!\u000b\u0011\u0011\u0005-\u0012\u0011GA\u001b\u0003\u0003j!!!\f\u000b\u0007\u0005=\"*\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003[\u00111!T1q!\u0011\t9$!\u0010\u000f\u0007i\nI$C\u0002\u0002<m\na\u0001\u0015:fI\u00164\u0017bA'\u0002@)\u0019\u00111H\u001e\u0011\u0007\u001d\u000b\u0019%C\u0002\u0002F!\u0013aa\u00142kK\u000e$\bbBA%\u0001\u0011\u0005\u00111J\u0001\u000eo\u0006LGOR8s)>\u0004\u0018nY:\u0015\u000fe\ni%a\u0014\u0002V!1\u0011&a\u0012A\u0002-B\u0001\"!\u0015\u0002H\u0001\u0007\u00111K\u0001\u0010Kb\u0004Xm\u0019;fIB\u0013Xm]3oiB1\u0011\u0011AA\t\u0003kA\u0001\"a\u0016\u0002H\u0001\u0007\u00111K\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\"1\u00111\f\u0001\u0005\u0002\u0015\f\u0011\u0002^3ti\u000ecwn]3)\t\u0005e\u0013q\f\t\u0004K\u0005\u0005\u0014bAA2;\t!A+Z:u\u0011\u0019\t9\u0007\u0001C\u0001K\u0006iA/Z:u\u0019&\u001cHOT8eKNDC!!\u001a\u0002`!1\u0011Q\u000e\u0001\u0005\u0002\u0015\fa\u0003^3ti\u000e\u0013X-\u0019;f\t\u0016dW\r^3U_BL7m\u001d\u0015\u0005\u0003W\ny\u0006\u0003\u0004\u0002t\u0001!\t!Z\u0001\u0014i\u0016\u001cH/T3uC\u0012\fG/\u0019*fMJ,7\u000f\u001b\u0015\u0005\u0003c\ny\u0006\u0003\u0004\u0002z\u0001!\t!Z\u0001\u001di\u0016\u001cH\u000fR3tGJL'-\u001a(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\u0011\t9(a\u0018\t\r\u0005}\u0004\u0001\"\u0001f\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3sQ\u0011\ti(a\u0018\t\r\u0005\u0015\u0005\u0001\"\u0001f\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u0019><G)\u001b:tQ\u0011\t\u0019)a\u0018\t\r\u0005-\u0005\u0001\"\u0001f\u0003i!Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004H.[2b\u0019><G)\u001b:tQ\u0011\tI)a\u0018\t\r\u0005E\u0005\u0001\"\u0001f\u0003]!Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148\u000f\u000b\u0003\u0002\u0010\u0006}\u0003BBAL\u0001\u0011\u0005Q-A\u000euKN$H)Z:de&\u0014W-\u00118e\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0005\u0003+\u000by\u0006\u0003\u0004\u0002\u001e\u0002!\t!Z\u0001\u0015i\u0016\u001cHo\u0011:fCR,\u0007+\u0019:uSRLwN\\:)\t\u0005m\u0015q\f\u0005\u0007\u0003G\u0003A\u0011A3\u00025Q,7\u000f^*fK.\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\t\u0005\u0005\u0016q\f\u0005\u0007\u0003S\u0003A\u0011A3\u00029Q,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"\"\u0011qUA0\u0011\u0019\ty\u000b\u0001C\u0001K\u0006!C/Z:u\u0019><7\u000b^1si>3gm]3u\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000f\u000b\u0003\u0002.\u0006}\u0003BBA[\u0001\u0011\u0005Q-A\u001cuKN$(+\u001a9mS\u000e\f7)\u00198GKR\u001c\u0007N\u0012:p[2{wm\u0015;beR|eMZ:fi\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003g\u000by\u0006\u0003\u0004\u0002<\u0002!\t!Z\u0001#i\u0016\u001cH/\u00117uKJdun\u001a#jeN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\t\u0005e\u0016q\f\u0005\u0007\u0003\u0003\u0004A\u0011A3\u0002KQ,7\u000f^(gMN,Go\u001d$peRKW.Z:BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\b\u0006BA`\u0003?Ba!a2\u0001\t\u0003)\u0017!\b;fgR\u001cuN\\:v[\u0016\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\t\u0005\u0015\u0017q\f\u0005\u0007\u0003\u001b\u0004A\u0011A3\u0002=Q,7\u000f\u001e#fY\u0016$XMU3d_J$7oV5uQ\u0016C8-\u001a9uS>t\u0007\u0006BAf\u0003?Ba!a5\u0001\t\u0003)\u0017a\u0007;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001chi\u001c:U_BL7\r\u000b\u0003\u0002R\u0006}\u0003bBAm\u0001\u0011%\u00111\\\u0001\u001egV\u00147o\u0019:jE\u0016\fe\u000eZ,bSR4uN]!tg&<g.\\3oiR)\u0011(!8\u0002`\"9A)a6A\u0002\u0005U\u0002\u0002CAq\u0003/\u0004\r!a9\u0002\u0011\r|gn];nKJ\u0004\u0002\"!:\u0002j\u00065\u0018Q^\u0007\u0003\u0003OT1!!90\u0013\u0011\tY/a:\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015Q\u0014q^Az\u0013\r\t\tp\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004u\u0005U\u0018bAA|w\t!!)\u001f;f\u0011\u001d\tY\u0010\u0001C\u0005\u0003{\f1b]3oIJ+7m\u001c:egR9\u0011(a@\u0003\u000e\tE\u0001\u0002\u0003B\u0001\u0003s\u0004\rAa\u0001\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002B!\u0002\u0003\n\u00055\u0018Q^\u0007\u0003\u0005\u000fQ1A!\u00010\u0013\u0011\u0011YAa\u0002\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\u0011y!!?A\u0002M\u000b!B\\;n%\u0016\u001cwN\u001d3t\u0011\u0019I\u0016\u0011 a\u00017\"1!Q\u0003\u0001\u0005\u0002\u0015\fq\u0003^3ti&sg/\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\t\tM\u0011q\f\u0005\n\u00057\u0001!\u0019!C\u0001\u0005;\tA!Q\"McU\u0011!q\u0004\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)\u0019!QE/\u0002\u0007\u0005\u001cG.\u0003\u0003\u0003*\t\r\"AC!dY\nKg\u000eZ5oO\"A!Q\u0006\u0001!\u0002\u0013\u0011y\"A\u0003B\u00072\u000b\u0004\u0005\u0003\u0004\u00032\u0001!\t!Z\u0001\u0012i\u0016\u001cH/Q2m\u001fB,'/\u0019;j_:\u001c\b\u0006\u0002B\u0018\u0003?BaAa\u000e\u0001\t\u0003)\u0017\u0001\u0005;fgR$U\r\\1zK\u0012\u001cEn\\:fQ\u0011\u0011)$a\u0018\t\r\tu\u0002\u0001\"\u0001f\u00039!Xm\u001d;G_J\u001cWm\u00117pg\u0016DCAa\u000f\u0002`!1!1\t\u0001\u0005\u0002\u0015\f!\u0004^3ti6Kg.[7v[J+\u0017/^3tiRKW.Z8viNDCA!\u0011\u0002`!1!\u0011\n\u0001\u0005\u0002\u0015\f\u0001\u0004^3ti\u000e\u000bG\u000e\\%o\r2Lw\r\u001b;US6,w.\u001e;tQ\u0011\u00119%a\u0018\t\r\t=\u0003\u0001\"\u0001f\u0003I!Xm\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f]:)\t\t5\u0013qL\u0004\b\u0005+\u0012\u0001\u0012\u0001B,\u0003i\tE-\\5o\u00072LWM\u001c;J]R,wM]1uS>tG+Z:u!\rI!\u0011\f\u0004\u0007\u0003\tA\tAa\u0017\u0014\r\te#Q\fB2!\rQ$qL\u0005\u0004\u0005CZ$AB!osJ+g\rE\u0002;\u0005KJ1Aa\u001a<\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\u0019\"\u0011\fC\u0001\u0005W\"\"Aa\u0016\t\u0011\t=$\u0011\fC\u0001\u0005c\nac\u00195fG.4\u0016\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\bs\tM$Q\u000fBC\u0011\u0019I#Q\u000ea\u0001W!A!q\u000fB7\u0001\u0004\u0011I(\u0001\bu_BL7MU3t_V\u00148-Z\u0019\u0011\t\tm$\u0011Q\u0007\u0003\u0005{R1Aa ^\u0003\u0019\u0019wN\u001c4jO&!!1\u0011B?\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016D\u0001Ba\"\u0003n\u0001\u0007!\u0011P\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY33\u0011!\u0011YI!\u0017\u0005\u0002\t5\u0015\u0001G2iK\u000e\\\u0017J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hgR9\u0011Ha$\u0003 \n-\u0006\u0002\u0003BI\u0005\u0013\u0003\rAa%\u0002\u0011i\\7\t\\5f]R\u0004BA!&\u0003\u001c6\u0011!q\u0013\u0006\u0004\u00053#\u0011A\u0001>l\u0013\u0011\u0011iJa&\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011!\u0011\tK!#A\u0002\t\r\u0016aB:feZ,'o\u001d\t\u0007\u0003\u0003\t\tB!*\u0011\t\u0005e!qU\u0005\u0005\u0005S\u000bYBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bBB\u0015\u0003\n\u0002\u00071\u0006\u0003\u0006\u00030\ne\u0013\u0011!C\u0005\u0005c\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\t")
public class AdminClientIntegrationTest
extends IntegrationTestHarness {
    private AdminClient client = null;
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final int serverCount;
    private final int consumerCount;
    private final int producerCount;
    private final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, adminClient);
    }

    public static void checkValidAlterConfigs(AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$22 = this.serverCount();
        String x$23 = this.zkConnect();
        Some x$24 = new Some((Object)this.securityProtocol());
        Option<File> x$25 = this.trustStoreFile();
        Option<Properties> x$26 = this.serverSaslProperties();
        int x$27 = 2;
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$22, x$23, x$28, x$29, (Option<SecurityProtocol>)x$24, x$25, x$26, x$30, x$31, x$32, x$33, x$34, x$27, x$35);
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
                config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
                config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.$outer.listenerName().value());
                config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), this.$outer.securityProtocol().name})));
                config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
                config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
                return config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? BoxedUnit.UNIT : config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Properties x$1) {
                Implicits$.MODULE$.PropertiesOps(x$1).$plus$plus$eq(this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Seq)cfgs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps2 = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps2).asScala()).foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final HashMap config$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.config$1.put((String)key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, expectedPresent, expectedMissing){
            public static final long serialVersionUID = 0L;
            private final AdminClient client$1;
            private final Seq expectedPresent$1;
            private final Seq expectedMissing$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Set topics = (java.util.Set)this.client$1.listTopics().names().get();
                return this.expectedPresent$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                }) && this.expectedMissing$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return !this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                });
            }
            {
                this.client$1 = client$1;
                this.expectedPresent$1 = expectedPresent$1;
                this.expectedMissing$1 = expectedMissing$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(",")).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Node node) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$5) {
                return x$5.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicDescription topic1$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                TopicPartitionInfo partition = (TopicPartitionInfo)this.topic1$1.partitions().get(partitionId);
                Assert.assertEquals((long)partitionId, (long)partition.partition());
                Assert.assertEquals((long)3L, (long)partition.replicas().size());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCreateDeleteTopics$1 $outer;

                    public final void apply(Node replica) {
                        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                        Assert.assertTrue((replica.id() < this.$outer.kafka$api$AdminClientIntegrationTest$$anonfun$$$outer().serverCount() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$6) {
                        return x$6.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct()).size());
                Assert.assertEquals((long)3L, (long)partition.isr().size());
                Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
                Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
            }

            public /* synthetic */ AdminClientIntegrationTest kafka$api$AdminClientIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final boolean apply(KafkaServer x$7) {
                return x$7.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected(this.$outer.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$8) {
                return new NewTopic(x$8, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0)new Serializable(this, nonExistingTopic, results){
            public static final long serialVersionUID = 0L;
            private final String nonExistingTopic$1;
            private final java.util.Map results$1;

            public final TopicDescription apply() {
                return (TopicDescription)((KafkaFuture)this.results$1.get(this.nonExistingTopic$1)).get();
            }
            {
                this.nonExistingTopic$1 = nonExistingTopic$1;
                this.results$1 = results$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)Predef$.MODULE$.refArrayOps((Object[])brokers).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final String[] brokers$1;

            public final void apply(Node node) {
                String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)Predef$.MODULE$.refArrayOps((Object[])this.brokers$1).contains((Object)hostStr));
            }
            {
                this.brokers$1 = brokers$1;
            }
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int leaderId;
                    int n = leaderId = tuple2._2$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(scala.collection.immutable.Map<Object, Object> x$9) {
                return x$9.keys().toSeq();
            }
        });
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)new Serializable(this, topic, partitionsByBroker, logDirInfosByBroker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            public final String topic$1;
            private final scala.collection.immutable.Map partitionsByBroker$1;
            private final java.util.Map logDirInfosByBroker$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, brokerId){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$1;

                    public final boolean apply(KafkaServer x$10) {
                        return x$10.config().brokerId() == this.brokerId$1;
                    }
                    {
                        this.brokerId$1 = brokerId$1;
                    }
                }).get();
                Seq expectedPartitions = (Seq)this.partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
                java.util.Map logDirInfos = (java.util.Map)this.logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
                Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<TopicPartition, DescribeLogDirsResponse.ReplicaInfo> apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$3) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                            return map;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDescribeLogDirs$1 $outer;

                    public final boolean apply(TopicPartition x$11) {
                        String string = x$11.topic();
                        String string2 = this.$outer.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(TopicPartition x$12) {
                        return x$12.partition();
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    public final KafkaServer server$1;

                    public final void apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$4) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String logDir = (String)tuple2._1();
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1)new Serializable(this, logDir){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeLogDirs$1$$anonfun$apply$mcVI$sp$4 $outer;
                                private final String logDir$1;

                                public final void apply(TopicPartition tp) {
                                    LogManager qual$1 = this.$outer.server$1.logManager();
                                    TopicPartition x$36 = tp;
                                    boolean x$37 = qual$1.getLog$default$2();
                                    Assert.assertEquals((Object)((Log)qual$1.getLog(x$36, x$37).get()).dir().getParent(), (Object)this.logDir$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.logDir$1 = logDir$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.server$1 = server$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partitionsByBroker$1 = partitionsByBroker$1;
                this.logDirInfosByBroker$1 = logDirInfosByBroker$1;
            }
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final TopicPartitionReplica apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    int brokerId = tuple2._2$mcI$sp();
                    TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(this.topic$2, partition, brokerId);
                    return topicPartitionReplica;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> x0$6) {
                Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
                    KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, topicPartitionReplica){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartitionReplica topicPartitionReplica$1;

                        public final boolean apply(KafkaServer x$13) {
                            return x$13.config().brokerId() == this.topicPartitionReplica$1.brokerId();
                        }
                        {
                            this.topicPartitionReplica$1 = topicPartitionReplica$1;
                        }
                    }).get();
                    TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
                    LogManager qual$2 = server.logManager();
                    TopicPartition x$38 = tp;
                    boolean x$39 = qual$2.getLog$default$2();
                    Assert.assertEquals((Object)((Log)qual$2.getLog(x$38, x$39).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<KafkaServer, Object> apply(KafkaServer server) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2)));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(KafkaFuture<Void> future) {
                ExecutionException exception = (ExecutionException)this.$outer.intercept((Function0)new Serializable(this, future){
                    public static final long serialVersionUID = 0L;
                    private final KafkaFuture future$1;

                    public final Void apply() {
                        return (Void)this.future$1.get();
                    }
                    {
                        this.future$1 = future$1;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
                Assert.assertTrue((boolean)(exception.getCause() instanceof UnknownTopicOrPartitionException));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.createTopic(topic, 1, this.serverCount(), this.createTopic$default$4());
        this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final TopicPartition tp$1;
            private final scala.collection.immutable.Map firstReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$40 = this.tp$1;
                boolean x$41 = qual$3.getLog$default$2();
                String logDir = ((Log)qual$3.getLog(x$40, x$41).get()).dir().getParent();
                Assert.assertEquals((Object)this.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
            }
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1)new Serializable(this, topic, tp, secondReplicaAssignment){
            public static final long serialVersionUID = 0L;
            public final String topic$3;
            public final TopicPartition tp$1;
            public final scala.collection.immutable.Map secondReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$5 $outer;
                    private final KafkaServer server$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        LogManager qual$4 = this.server$2.logManager();
                        TopicPartition x$42 = this.$outer.tp$1;
                        boolean x$43 = qual$4.getLog$default$2();
                        String logDir = ((Log)qual$4.getLog(x$42, x$43).get()).dir().getParent();
                        Object object = this.$outer.secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$2.config().brokerId()));
                        String string = logDir;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.server$2 = server$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "timed out waiting for replica movement";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.secondReplicaAssignment$1 = secondReplicaAssignment$1;
            }
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)new Serializable(this, topic, running, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String topic$3;
            private final AtomicBoolean running$1;
            private final AtomicInteger numMessages$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcI$sp() {
                int n;
                String x$44 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.$outer.servers(), this.$outer.securityProtocol());
                SecurityProtocol x$45 = this.$outer.securityProtocol();
                Option<File> x$46 = this.$outer.trustStoreFile();
                int x$47 = 0;
                int x$48 = 10000;
                int x$49 = -1;
                long x$50 = TestUtils$.MODULE$.createProducer$default$3();
                long x$51 = TestUtils$.MODULE$.createProducer$default$4();
                int x$52 = TestUtils$.MODULE$.createProducer$default$6();
                int x$53 = TestUtils$.MODULE$.createProducer$default$7();
                int x$54 = TestUtils$.MODULE$.createProducer$default$8();
                String x$55 = TestUtils$.MODULE$.createProducer$default$9();
                Option<Properties> x$56 = TestUtils$.MODULE$.createProducer$default$13();
                ByteArraySerializer x$57 = TestUtils$.MODULE$.createProducer$default$14();
                ByteArraySerializer x$58 = TestUtils$.MODULE$.createProducer$default$15();
                KafkaProducer<K, V> producer = TestUtils$.MODULE$.createProducer(x$44, x$49, x$50, x$51, x$47, x$52, x$53, x$54, x$55, x$48, x$45, x$46, x$56, x$57, x$58);
                try {
                    while (this.running$1.get()) {
                        Future future = producer.send(new ProducerRecord(this.topic$3, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1})).getBytes()));
                        this.numMessages$1.incrementAndGet();
                        future.get(10L, TimeUnit.SECONDS);
                    }
                    n = this.numMessages$1.get();
                }
                catch (Throwable throwable) {
                    void var1_16;
                    var1_16.close();
                    throw throwable;
                }
                producer.close();
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.running$1 = running$1;
                this.numMessages$1 = numMessages$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced before timeout. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1, this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment, producerFuture){
                public static final long serialVersionUID = 0L;
                public final String topic$3;
                public final TopicPartition tp$1;
                public final scala.collection.immutable.Map firstReplicaAssignment$1;
                public final scala.concurrent.Future producerFuture$1;

                public final void apply(KafkaServer server) {
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;
                        private final KafkaServer server$3;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            LogManager qual$5 = this.server$3.logManager();
                            TopicPartition x$59 = this.$outer.tp$1;
                            boolean x$60 = qual$5.getLog$default$2();
                            String logDir = ((Log)qual$5.getLog(x$59, x$60).get()).dir().getParent();
                            Object object = this.$outer.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$3.config().brokerId()));
                            String string = logDir;
                            return !(object != null ? !object.equals(string) : string != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.server$3 = server$3;
                        }
                    }, (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerFuture$1.value()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                }
                {
                    this.topic$3 = topic$3;
                    this.tp$1 = tp$1;
                    this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final int currentMessagesNum$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() - this.currentMessagesNum$1 > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;
                private final int currentMessagesNum$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced within timeout after replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.numMessages$1.get() - this.currentMessagesNum$1)), this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            running.set(false);
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.set(false);
            throw throwable;
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$61 = this.servers();
        String x$62 = topic;
        int x$63 = finalNumMessages;
        SecurityProtocol x$64 = this.securityProtocol();
        Option<File> x$65 = this.trustStoreFile();
        String x$66 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$67 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$61, x$62, x$63, x$66, x$64, x$65, x$67);
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$7) {
                Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), (Object)new String((byte[])consumerRecord.value()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$14) {
                return x$14.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$15) {
                return x$15.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1)new Serializable(this, topic1, topic2, alterResult, altered, newPartition2Assignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String topic1$2;
            private final String topic2$1;
            private final ObjectRef alterResult$1;
            private final ObjectRef altered$1;
            private final java.util.List newPartition2Assignments$1;

            public final void apply(CreatePartitionsOptions option) {
                String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
                    try {
                        ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
                    }
                    catch (ExecutionException executionException2) {
                        Object object;
                        Object object2;
                        Assert.assertTrue((String)desc, (boolean)(executionException2.getCause() instanceof InvalidPartitionsException));
                        Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException2.getCause().getMessage());
                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)this.newPartition2Assignments$1))}))).asJava(), option);
                        try {
                            object2 = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        }
                        catch (ExecutionException executionException3) {
                            Assert.assertTrue((String)desc, (boolean)(executionException3.getCause() instanceof InvalidPartitionsException));
                            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException3.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                            object2 = BoxedUnit.UNIT;
                        }
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                        try {
                            object = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                        }
                        catch (ExecutionException executionException4) {
                            Assert.assertTrue((String)desc, (boolean)(executionException4.getCause() instanceof InvalidPartitionsException));
                            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException4.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                            object = BoxedUnit.UNIT;
                        }
                        String unknownTopic = "an-unknown-topic";
                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                        try {
                            ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(unknownTopic)).get();
                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
                        }
                        catch (ExecutionException executionException5) {
                            Assert.assertTrue((String)desc, (boolean)(executionException5.getCause() instanceof UnknownTopicOrPartitionException));
                            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)executionException5.getCause().getMessage());
                            this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                            try {
                                this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
                            }
                            catch (ExecutionException executionException6) {
                                Assert.assertTrue((String)desc, (boolean)(executionException6.getCause() instanceof InvalidPartitionsException));
                                Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)executionException6.getCause().getMessage());
                                Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                try {
                                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
                                }
                                catch (ExecutionException executionException7) {
                                    Assert.assertTrue((String)desc, (boolean)(executionException7.getCause() instanceof InvalidReplicaAssignmentException));
                                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)executionException7.getCause().getMessage());
                                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                    try {
                                        this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
                                    }
                                    catch (ExecutionException executionException8) {
                                        Assert.assertTrue((String)desc, (boolean)(executionException8.getCause() instanceof InvalidReplicaAssignmentException));
                                        Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)executionException8.getCause().getMessage());
                                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                        try {
                                            this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                                        }
                                        catch (ExecutionException executionException9) {
                                            Assert.assertTrue((String)desc, (boolean)(executionException9.getCause() instanceof InvalidReplicaAssignmentException));
                                            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)executionException9.getCause().getMessage());
                                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                            this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                            try {
                                                this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                                            }
                                            catch (ExecutionException executionException10) {
                                                Assert.assertTrue((String)desc, (boolean)(executionException10.getCause() instanceof InvalidReplicaAssignmentException));
                                                Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)executionException10.getCause().getMessage());
                                                Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                                                try {
                                                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                    throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
                                                }
                                                catch (ExecutionException executionException11) {
                                                    Assert.assertTrue((String)desc, (boolean)(executionException11.getCause() instanceof InvalidReplicaAssignmentException));
                                                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)executionException11.getCause().getMessage());
                                                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                    this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                                                    try {
                                                        this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
                                                    }
                                                    catch (ExecutionException executionException12) {
                                                        Assert.assertTrue((String)desc, (boolean)(executionException12.getCause() instanceof InvalidReplicaAssignmentException));
                                                        Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)executionException12.getCause().getMessage());
                                                        Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                        this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.<T>emptyList()))}))).asJava(), option);
                                                        try {
                                                            this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                                                            throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
                                                        }
                                                        catch (ExecutionException executionException13) {
                                                            Assert.assertTrue((String)desc, (boolean)(executionException13.getCause() instanceof InvalidReplicaAssignmentException));
                                                            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)executionException13.getCause().getMessage());
                                                            Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$2 = topic1$2;
                this.topic2$1 = topic2$1;
                this.alterResult$1 = alterResult$1;
                this.altered$1 = altered$1;
                this.newPartition2Assignments$1 = newPartition2Assignments$1;
            }
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            throw this.fail("Expect InvalidTopicException when the topic is queued for deletion", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)executionException.getCause().getMessage());
            return;
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.killBroker(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, result, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final ObjectRef result$1;
            private final ObjectRef lowWatermark$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Throwable throwable2;
                block2: {
                    boolean bl;
                    this.result$1.elem = this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
                    this.lowWatermark$1.elem = None$.MODULE$;
                    KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)this.result$1.elem).lowWatermarks().get(this.$outer.topicPartition());
                    try {
                        this.lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
                        bl = ((Option)this.lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
                    }
                    catch (Throwable throwable2) {
                        boolean bl2;
                        ExecutionException executionException;
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) break block2;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, (Function0<String>)new Serializable(this, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lowWatermark$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected low watermark of the partition to be 5 but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.lowWatermark$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "no response within the timeout";
                    }
                })}));
            }
            {
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        scala.collection.immutable.Map<Object, Object> leaders = this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
        int followerIndex = BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result1 = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava());
        result1.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.serverCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)new Serializable(this, expectedLEO){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int expectedLEO$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
                Assert.assertEquals((long)this.expectedLEO$1, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logEndOffset().messageOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedLEO$1 = expectedLEO$1;
            }
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, futureLogDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String futureLogDir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.futureLogDir$1;
                LogManager qual$6 = ((KafkaServer)this.$outer.servers().apply(0)).logManager();
                TopicPartition x$68 = this.$outer.topicPartition();
                boolean x$69 = qual$6.getLog$default$2();
                String string2 = ((Log)qual$6.getLog(x$68, x$69).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.futureLogDir$1 = futureLogDir$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for replica movement";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset().messageOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        IntRef messageCount = IntRef.create((int)0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, messageCount){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final IntRef messageCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.messageCount$1.elem += this.consumer$2.poll(0L).count();
                return this.messageCount$1.elem == 10;
            }
            {
                this.consumer$2 = consumer$2;
                this.messageCount$1 = messageCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected 10 messages";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, messageCount){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final IntRef messageCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.messageCount$1.elem += this.consumer$2.poll(0L).count();
                return this.messageCount$1.elem == 7;
            }
            {
                this.consumer$2 = consumer$2;
                this.messageCount$1 = messageCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected 7 messages";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, messageCount){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final IntRef messageCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.messageCount$1.elem += this.consumer$2.poll(0L).count();
                return this.messageCount$1.elem == 2;
            }
            {
                this.consumer$2 = consumer$2;
                this.messageCount$1 = messageCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected 2 messages";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.$outer.topicPartition())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)this.intercept((Function0)new Serializable(this, nonExistPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition nonExistPartition$1;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.nonExistPartition$1), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.nonExistPartition$1)).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nonExistPartition$1 = nonExistPartition$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0)new Serializable(this, nonExistentTopic, describeResult1){
            public static final long serialVersionUID = 0L;
            private final ConfigResource nonExistentTopic$1;
            private final DescribeConfigsResult describeResult1$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult1$1.values().get(this.nonExistentTopic$1)).get();
            }
            {
                this.nonExistentTopic$1 = nonExistentTopic$1;
                this.describeResult1$1 = describeResult1$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0)new Serializable(this, invalidTopic, describeResult2){
            public static final long serialVersionUID = 0L;
            private final ConfigResource invalidTopic$1;
            private final DescribeConfigsResult describeResult2$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult2$1.values().get(this.invalidTopic$1)).get();
            }
            {
                this.invalidTopic$1 = invalidTopic$1;
                this.describeResult2$1 = describeResult2$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$1.poll(0L);
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final KafkaProducer producer$1;
            private final TopicPartition topicPartition$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.topicPartition$1.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return this.producer$1.send(record);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topicPartition$1 = topicPartition$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$16) {
                return x$16.get();
            }
        });
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$17) {
                return new NewTopic(x$17, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$18) {
                return new NewTopic(x$18, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$19) {
                return new NewTopic(x$19, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((AdminClient)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$20) {
                return new NewTopic(x$20, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$21) {
                return new NewTopic(x$21, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testConsumerGroups() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    public final int kafka$api$AdminClientIntegrationTest$$numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option option = ((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition());
                None$ none$ = None$.MODULE$;
                return option != null ? !option.equals(none$) : none$ != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected follower to create replica for partition";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedStartOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset() == this.expectedStartOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedStartOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to discover new log start offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedStartOffset$1)}));
            }
            {
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedEndOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logEndOffset().messageOffset() == this.expectedEndOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedEndOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to catch up to log end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedEndOffset$1)}));
            }
            {
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public AdminClientIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
        this.serverCount = 3;
        this.consumerCount = 1;
        this.producerCount = 1;
    }
}

