/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.api.PlaintextConsumerTest$;
import kafka.api.PlaintextConsumerTest$DeserializerImpl$class;
import kafka.api.PlaintextConsumerTest$SerializerImpl$class;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012a\u0003;fgRDU-\u00193feN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR4qa\t\u0001\u0011\u0002\u0007\u0005AE\u0001\bTKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u0007\t*S\u0006\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\rqc\u0007O\u0007\u0002_)\u0011\u0001'M\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\u0006i)\u0011QGH\u0001\u0007CB\f7\r[3\n\u0005]z#AC*fe&\fG.\u001b>feB\u0019A#O\u001e\n\u0005i*\"!B!se\u0006L\bC\u0001\u000b=\u0013\tiTC\u0001\u0003CsR,\u0007\"B #\t\u0003\u0011\u0012A\u0002\u0013j]&$H\u0005C\u0004BE\u0001\u0007I\u0011\u0001\"\u0002\u0015M,'/[1mSj,'/F\u0001D!\tqC)\u0003\u0002F_\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\"9qI\ta\u0001\n\u0003A\u0015AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0003'%CqA\u0013$\u0002\u0002\u0003\u00071)A\u0002yIEBa\u0001\u0014\u0012!B\u0013\u0019\u0015aC:fe&\fG.\u001b>fe\u0002BQA\u0014\u0012\u0005B=\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\ta\u0002\u0016,\u0019\u0005\u0006#6\u0003\rAU\u0001\u0006i>\u0004\u0018n\u0019\t\u0003'Zs!\u0001\u0006+\n\u0005U+\u0012A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!V\u000b\t\u000bik\u0005\u0019A.\u0002\u000f!,\u0017\rZ3sgB\u0011AlX\u0007\u0002;*\u0011a,M\u0001\u0007Q\u0016\fG-\u001a:\n\u0005\u0001l&a\u0002%fC\u0012,'o\u001d\u0005\u0006E6\u0003\r\u0001O\u0001\u0005I\u0006$\u0018\rC\u0003eE\u0011\u0005S-A\u0005d_:4\u0017nZ;sKR\u00191C\u001a>\t\u000b\u001d\u001c\u0007\u0019\u00015\u0002\u000f\r|gNZ5hgB\u0012\u0011.\u001d\t\u0005U6\u0014v.D\u0001l\u0015\ta\u0017&\u0001\u0003vi&d\u0017B\u00018l\u0005\ri\u0015\r\u001d\t\u0003aFd\u0001\u0001B\u0005sM\u0006\u0005\t\u0011!B\u0001g\n\u0019q\fJ\u0019\u0012\u0005Q<\bC\u0001\u000bv\u0013\t1XCA\u0004O_RD\u0017N\\4\u0011\u0005QA\u0018BA=\u0016\u0005\r\te.\u001f\u0005\u0006w\u000e\u0004\r\u0001`\u0001\u0006SN\\U-\u001f\t\u0003)uL!A`\u000b\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\u0001\u0012\u0005BI\tQa\u00197pg\u0016DaA\u0014\u0012\u0005B\u0005\u0015A#\u0002\u001d\u0002\b\u0005%\u0001BB)\u0002\u0004\u0001\u0007!\u000b\u0003\u0004c\u0003\u0007\u0001\r\u0001\u000f\u0004\n\u0003\u001b\u0001\u0001\u0013aA\u0001\u0003\u001f\u0011\u0001\u0003R3tKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u000b\u0005-Q%!\u0005\u0011\t9\n\u0019\u0002O\u0005\u0004\u0003+y#\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBB \u0002\f\u0011\u0005!\u0003\u0003\u0006\u0002\u001c\u0005-\u0001\u0019!C\u0001\u0003;\tA\u0002Z3tKJL\u0017\r\\5{KJ,\"!a\b\u0011\u00079\n\t#C\u0002\u0002$=\u0012QCQ=uK\u0006\u0013(/Y=EKN,'/[1mSj,'\u000f\u0003\u0006\u0002(\u0005-\u0001\u0019!C\u0001\u0003S\t\u0001\u0003Z3tKJL\u0017\r\\5{KJ|F%Z9\u0015\u0007M\tY\u0003C\u0005K\u0003K\t\t\u00111\u0001\u0002 !I\u0011qFA\u0006A\u0003&\u0011qD\u0001\u000eI\u0016\u001cXM]5bY&TXM\u001d\u0011\t\u0011\u0005M\u00121\u0002C!\u0003k\t1\u0002Z3tKJL\u0017\r\\5{KR9\u0001(a\u000e\u0002:\u0005m\u0002BB)\u00022\u0001\u0007!\u000b\u0003\u0004[\u0003c\u0001\ra\u0017\u0005\u0007E\u0006E\u0002\u0019\u0001\u001d\t\u000f\u0011\fY\u0001\"\u0011\u0002@Q)1#!\u0011\u0002N!9q-!\u0010A\u0002\u0005\r\u0003\u0007BA#\u0003\u0013\u0002RA[7S\u0003\u000f\u00022\u0001]A%\t-\tY%!\u0011\u0002\u0002\u0003\u0005)\u0011A:\u0003\u0007}##\u0007\u0003\u0004|\u0003{\u0001\r\u0001 \u0005\b\u0003\u0003\tY\u0001\"\u0011\u0013\u0011!\t\u0019$a\u0003\u0005B\u0005MC#\u0002\u001d\u0002V\u0005]\u0003BB)\u0002R\u0001\u0007!\u000b\u0003\u0004c\u0003#\u0002\r\u0001\u000f\u0005\b\u00037\u0002A\u0011BA/\u0003}!Xm\u001d;IK\u0006$WM]:TKJL\u0017\r\\5{K\u0012+7/\u001a:jC2L'0\u001a\u000b\u0006'\u0005}\u0013\u0011\r\u0005\u0007\u0003\u0006e\u0003\u0019A\u0017\t\u0011\u0005m\u0011\u0011\fa\u0001\u0003#Aa!!\u001a\u0001\t\u0003\u0011\u0012!\u000b;fgRDU-\u00193feN,\u0005\u0010^3oI\u0016$7+\u001a:jC2L'0\u001a:EKN,'/[1mSj,'\u000fK\u0002\u0002diAa!a\u001b\u0001\t\u0003\u0011\u0012!\t;fgRDU-\u00193feN\u001cVM]5bY&TXM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bfAA55!1\u0011\u0011\u000f\u0001\u0005\u0002I\t!\u0003^3ti6\u000b\u0007\u0010U8mYJ+7m\u001c:eg\"\u001a\u0011q\u000e\u000e\t\r\u0005]\u0004\u0001\"\u0001\u0013\u0003U!Xm\u001d;NCb\u0004v\u000e\u001c7J]R,'O^1m\u001bND3!!\u001e\u001b\u0011\u0019\ti\b\u0001C\u0001%\u00051C/Z:u\u001b\u0006D\bk\u001c7m\u0013:$XM\u001d<bY6\u001bH)\u001a7bs&s'+\u001a<pG\u0006$\u0018n\u001c8)\u0007\u0005m$\u0004\u0003\u0004\u0002\u0004\u0002!\tAE\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o\u0003N\u001c\u0018n\u001a8nK:$\bfAAA5!1\u0011\u0011\u0012\u0001\u0005\u0002I\tQ\u0003^3ti\u0006+Ho\\\"p[6LGo\u00148DY>\u001cX\rK\u0002\u0002\bjAa!a$\u0001\t\u0003\u0011\u0012\u0001\t;fgR\fU\u000f^8D_6l\u0017\u000e^(o\u00072|7/Z!gi\u0016\u0014x+Y6fkBD3!!$\u001b\u0011\u0019\t)\n\u0001C\u0001%\u0005\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fi\"\u001a\u00111\u0013\u000e\t\r\u0005m\u0005\u0001\"\u0001\u0013\u0003Q!Xm\u001d;He>,\boQ8ogVl\u0007\u000f^5p]\"\u001a\u0011\u0011\u0014\u000e\t\r\u0005\u0005\u0006\u0001\"\u0001\u0013\u0003]!Xm\u001d;QCR$XM\u001d8Tk\n\u001c8M]5qi&|g\u000eK\u0002\u0002 jAa!a*\u0001\t\u0003\u0011\u0012!\t;fgR\u001cVOY:fcV,g\u000e\u001e)biR,'O\\*vEN\u001c'/\u001b9uS>t\u0007fAAS5!1\u0011Q\u0016\u0001\u0005\u0002I\t\u0011\u0004^3tiB\u000bG\u000f^3s]Vs7/\u001e2tGJL\u0007\u000f^5p]\"\u001a\u00111\u0016\u000e\t\r\u0005M\u0006\u0001\"\u0001\u0013\u0003I!Xm\u001d;D_6l\u0017\u000e^'fi\u0006$\u0017\r^1)\u0007\u0005E&\u0004\u0003\u0004\u0002:\u0002!\tAE\u0001\u0010i\u0016\u001cH/Q:z]\u000e\u001cu.\\7ji\"\u001a\u0011q\u0017\u000e\t\r\u0005}\u0006\u0001\"\u0001\u0013\u0003}!Xm\u001d;FqB\fg\u000eZ5oOR{\u0007/[2Tk\n\u001c8M]5qi&|gn\u001d\u0015\u0004\u0003{S\u0002BBAc\u0001\u0011\u0005!#A\u0010uKN$8\u000b\u001b:j].Lgn\u001a+pa&\u001c7+\u001e2tGJL\u0007\u000f^5p]ND3!a1\u001b\u0011\u0019\tY\r\u0001C\u0001%\u0005\tB/Z:u!\u0006\u0014H/\u001b;j_:\u001chi\u001c:)\u0007\u0005%'\u0004\u0003\u0004\u0002R\u0002!\tAE\u0001\u001ci\u0016\u001cH\u000fU1si&$\u0018n\u001c8t\r>\u0014\u0018)\u001e;p\u0007J,\u0017\r^3)\u0007\u0005='\u0004\u0003\u0004\u0002X\u0002!\tAE\u0001\u001ei\u0016\u001cH\u000fU1si&$\u0018n\u001c8t\r>\u0014\u0018J\u001c<bY&$Gk\u001c9jG\":\u0011Q\u001b\u000e\u0002\\\u0006u\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0005\u0005}\u0007\u0003BAq\u0003Ol!!a9\u000b\u0007\u0005\u0015\u0018'\u0001\u0004feJ|'o]\u0005\u0005\u0003S\f\u0019OA\u000bJ]Z\fG.\u001b3U_BL7-\u0012=dKB$\u0018n\u001c8\t\r\u00055\b\u0001\"\u0001\u0013\u0003!!Xm\u001d;TK\u0016\\\u0007fAAv5!9\u00111\u001f\u0001\u0005\n\u0005U\u0018AF:f]\u0012\u001cu.\u001c9sKN\u001cX\rZ'fgN\fw-Z:\u0015\u000bM\t9P!\u0001\t\u0011\u0005e\u0018\u0011\u001fa\u0001\u0003w\f!B\\;n%\u0016\u001cwN\u001d3t!\r!\u0012Q`\u0005\u0004\u0003\u007f,\"aA%oi\"A!1AAy\u0001\u0004\u0011)!\u0001\u0002uaB!!q\u0001B\u0005\u001b\u0005\t\u0014b\u0001B\u0006c\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u0002B\b\u0001\u0011\u0005!#A\u000buKN$\bk\\:ji&|g.\u00118e\u0007>lW.\u001b;)\u0007\t5!\u0004\u0003\u0004\u0003\u0016\u0001!\tAE\u0001\u001ci\u0016\u001cH\u000fU1si&$\u0018n\u001c8QCV\u001cX-\u00118e%\u0016\u001cX/\\3)\u0007\tM!\u0004\u0003\u0004\u0003\u001c\u0001!\tAE\u0001\u0017i\u0016\u001cHOR3uG\"LeN^1mS\u0012|eMZ:fi\"\u001a!\u0011\u0004\u000e\t\r\t\u0005\u0002\u0001\"\u0001\u0013\u0003\u0019\"Xm\u001d;GKR\u001c\u0007NU3d_J$G*\u0019:hKJ$\u0006.\u00198GKR\u001c\u0007.T1y\u0005f$Xm\u001d\u0015\u0004\u0005?Q\u0002b\u0002B\u0014\u0001\u0011%!\u0011F\u0001\u0011G\",7m\u001b'be\u001e,'+Z2pe\u0012$2a\u0005B\u0016\u0011!\u0011iC!\nA\u0002\u0005m\u0018A\u00059s_\u0012,8-\u001a:SK\u000e|'\u000fZ*ju\u0016DaA!\r\u0001\t\u0003\u0011\u0012A\f;fgR4U\r^2i\u0011>tw.\u001e:t\r\u0016$8\r[*ju\u0016Le\rT1sO\u0016\u0014VmY8sI:{GOR5sgRD3Aa\f\u001b\u0011\u001d\u00119\u0004\u0001C\u0005\u0005s\t!f\u00195fG.4U\r^2i\u0011>tw.\u001e:t'&TX-\u00134MCJ<WMU3d_J$gj\u001c;GSJ\u001cH\u000fF\u0002\u0014\u0005wA\u0001B!\u0010\u00036\u0001\u0007\u00111`\u0001\u0018Y\u0006\u0014x-\u001a)s_\u0012,8-\u001a:SK\u000e|'\u000fZ*ju\u0016DaA!\u0011\u0001\t\u0003\u0011\u0012a\u000f;fgR4U\r^2i\u0011>tw.\u001e:t\u001b\u0006D\b+\u0019:uSRLwN\u001c$fi\u000eD')\u001f;fg&3G*\u0019:hKJ+7m\u001c:e\u001d>$h)\u001b:ti\"\u001a!q\b\u000e\t\r\t\u001d\u0003\u0001\"\u0001\u0013\u0003=\"Xm\u001d;GKR\u001c\u0007NU3d_J$G*\u0019:hKJ$\u0006.\u00198NCb\u0004\u0016M\u001d;ji&|gNR3uG\"\u0014\u0015\u0010^3tQ\r\u0011)E\u0007\u0005\u0007\u0005\u001b\u0002A\u0011\u0001\n\u0002SQ,7\u000f\u001e'po6\u000b\u0007PR3uG\"\u001c\u0016N_3G_J\u0014V-];fgR\fe\u000e\u001a)beRLG/[8oQ\r\u0011YE\u0007\u0005\u0007\u0005'\u0002A\u0011\u0001\n\u00021Q,7\u000f\u001e*pk:$'k\u001c2j]\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0003RiAaA!\u0017\u0001\t\u0003\u0011\u0012!\n;fgRlU\u000f\u001c;j\u0007>t7/^7feJ{WO\u001c3S_\nLg.Q:tS\u001etW.\u001a8uQ\r\u00119F\u0007\u0005\u0007\u0005?\u0002A\u0011\u0001\n\u0002CQ,7\u000f^'vYRL7i\u001c8tk6,'o\u0015;jG.L\u0018i]:jO:lWM\u001c;)\u0007\tu#\u0004\u0003\u0004\u0003f\u0001!\tAE\u0001#i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014H)\u001a4bk2$\u0018i]:jO:lWM\u001c;)\u0007\t\r$\u0004\u0003\u0004\u0003l\u0001!\tAE\u0001-i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$xJ\\*u_B\u0004v\u000e\u001c7j]\u001eD3A!\u001b\u001b\u0011\u0019\u0011\t\b\u0001C\u0001%\u00051C/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]\u000ecwn]3)\u0007\t=$\u0004\u0003\u0004\u0003x\u0001!\tAE\u0001\u0011i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peND3A!\u001e\u001b\u0011\u0019\u0011i\b\u0001C\u0001%\u00059B/Z:u\u0003V$xnQ8n[&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0015\u0004\u0005wR\u0002B\u0002BB\u0001\u0011\u0005!#A\u0011uKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8sg^KG\u000f[,s_:<7*Z=WC2,X\rK\u0002\u0003\u0002jAaA!#\u0001\t\u0003\u0011\u0012!\t;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0007J,\u0017\r^3US6,\u0007f\u0001BD5!1!q\u0012\u0001\u0005\u0002I\tA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0004\u0005\u001bS\u0002B\u0002BK\u0001\u0011\u0005!#\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007\tM%\u0004\u0003\u0004\u0003\u001c\u0002!\tAE\u0001\u0014i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm\u001d\u0015\u0004\u00053S\u0002B\u0002BQ\u0001\u0011\u0005!#A\u000euKN$X)\u0019:mS\u0016\u001cHo\u0014:MCR,7\u000f^(gMN,Go\u001d\u0015\u0004\u0005?S\u0002B\u0002BT\u0001\u0011\u0005!#\u0001\u000buKN$XK\\:vEN\u001c'/\u001b2f)>\u0004\u0018n\u0019\u0015\u0004\u0005KS\u0002B\u0002BW\u0001\u0011\u0005!#A\u0013uKN$\b+Y;tKN#\u0018\r^3O_R\u0004&/Z:feZ,GMQ=SK\n\fG.\u00198dK\"\u001a!1\u0016\u000e\t\r\tM\u0006\u0001\"\u0001\u0013\u0003i!Xm\u001d;D_6l\u0017\u000e^*qK\u000eLg-[3e\u001f\u001a47/\u001a;tQ\r\u0011\tL\u0007\u0005\u0007\u0005s\u0003A\u0011\u0001\n\u00023Q,7\u000f^!vi>\u001cu.\\7ji>s'+\u001a2bY\u0006t7-\u001a\u0015\u0004\u0005oS\u0002B\u0002B`\u0001\u0011\u0005!#A\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\u001cVOY:de&\u0014W\rK\u0002\u0003>jAaA!2\u0001\t\u0003\u0011\u0012A\f;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i'V\u00147o\u0019:jE\u0016D3Aa1\u001b\u0011\u0019\u0011Y\r\u0001C\u0001%\u0005aC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'fC\u0012lU\r\u001e:jGN\u001cE.Z1o+B<\u0016\u000e\u001e5BgNLwM\u001c\u0015\u0004\u0005\u0013T\u0002B\u0002Bi\u0001\u0011\u0005!#A\u0016uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bw-T3ue&\u001c7o\u00117fC:,\u0006oV5uQ\u0006\u001b8/[4oQ\r\u0011yM\u0007\u0005\u0007\u0005/\u0004A\u0011\u0001\n\u0002WQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4NKR\u0014\u0018nY:XQ\u0016t'+Z1e\u0007>lW.\u001b;uK\u0012D3A!6\u001b\u0011\u0019\u0011i\u000e\u0001C\u0001%\u00051C/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'fC\u0012<\u0016\u000e\u001e5NCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:)\u0007\tm'\u0004\u0003\u0004\u0003d\u0002!\tAE\u0001&i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ,ji\"l\u0015\r\u001f)pY2\u0014VmY8sIND3A!9\u001b\u0011\u0019\u0011I\u000f\u0001C\u0001%\u0005qC/Z:u#V|G/Y'fiJL7m\u001d(pi\u000e\u0013X-\u0019;fI&3gj\\)v_R\f7oQ8oM&<WO]3eQ\r\u00119O\u0007\u0005\b\u0005_\u0004A\u0011\u0001By\u0003\t\u0012XO\\'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,H\u000fV3tiR\u00191Ca=\t\u000f\tU(Q\u001ea\u0001y\u0006i1\r\\8tK\u000e{gn];nKJDqA!?\u0001\t\u0003\u0011Y0A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cHC\u0003B\u007f\u0007\u0007\u0019)b!\u0007\u0004\u001eA)1Ka@\u0003\u0006%\u00191\u0011\u0001-\u0003\u0007M+G\u000f\u0003\u0005\u0004\u0006\t]\b\u0019AB\u0004\u0003!\u0001(o\u001c3vG\u0016\u0014\bCBB\u0005\u0007#A\u0004(\u0004\u0002\u0004\f)!1QAB\u0007\u0015\r\u0019yaM\u0001\bG2LWM\u001c;t\u0013\u0011\u0019\u0019ba\u0003\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\u00199Ba>A\u0002I\u000b\u0011\u0002^8qS\u000et\u0015-\\3\t\u0011\rm!q\u001fa\u0001\u0003w\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0002CB\u0010\u0005o\u0004\r!a?\u0002'I,7m\u001c:egB+'\u000fU1si&$\u0018n\u001c8\t\u000f\r\r\u0002\u0001\"\u0001\u0004&\u0005\u00013/\u001e2tGJL'-Z\"p]N,X.\u001a:B]\u0012\u001cF/\u0019:u!>dG.\u001b8h)\u0019\u00199ca\f\u0004>A!1\u0011FB\u0016\u001b\u0005\u0001\u0011bAB\u0017\u0015\tA2i\u001c8tk6,'/Q:tS\u001etW.\u001a8u!>dG.\u001a:\t\u0011\rE2\u0011\u0005a\u0001\u0007g\t\u0001bY8ogVlWM\u001d\t\u0007\u0007k\u0019I\u0004\u000f\u001d\u000e\u0005\r]\"\u0002BB\u0019\u0007\u001bIAaa\u000f\u00048\tA1i\u001c8tk6,'\u000f\u0003\u0005\u0004@\r\u0005\u0002\u0019AB!\u0003E!x\u000e]5dgR{7+\u001e2tGJL'-\u001a\t\u0006\u0007\u0007\u001a\u0019F\u0015\b\u0005\u0007\u000b\u001ayE\u0004\u0003\u0004H\r5SBAB%\u0015\r\u0019YEB\u0001\u0007yI|w\u000e\u001e \n\u0003YI1a!\u0015\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u0016\u0004X\t!A*[:u\u0015\r\u0019\t&\u0006\u0005\b\u00077\u0002A\u0011AB/\u0003I\u0019XOY:de&\u0014WmQ8ogVlWM]:\u0015\r\r}3qNB>!\u0019\u0019\tga\u001b\u0004(5\u001111\r\u0006\u0005\u0007K\u001a9'A\u0004nkR\f'\r\\3\u000b\u0007\r%T#\u0001\u0006d_2dWm\u0019;j_:LAa!\u001c\u0004d\t1!)\u001e4gKJD\u0001b!\u001d\u0004Z\u0001\u000711O\u0001\u000eG>t7/^7fe\u001e\u0013x.\u001e9\u0011\r\r\u000541NB;!\u0019\u0019)da\u001e9q%!1\u0011PB\u001c\u00055Y\u0015MZ6b\u0007>t7/^7fe\"A1qHB-\u0001\u0004\u0019\t\u0005C\u0004\u0004\u0000\u0001!\ta!!\u0002O\r\u0014X-\u0019;f\u0007>t7/^7fe\u001e\u0013x.\u001e9B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\t\u0007\u0007\u001bIi!$\u0004\u0010B9Ac!\"\u0004t\r}\u0013bABD+\t1A+\u001e9mKJB\u0001ba#\u0004~\u0001\u0007\u00111`\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\u0011\r}2Q\u0010a\u0001\u0007\u0003B\u0001b!%\u0004~\u0001\u0007!Q`\u0001\u000egV\u00147o\u0019:jaRLwN\\:\t\u000f\rU\u0005\u0001\"\u0001\u0004\u0018\u0006a\u0013\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u000b\f'\re5QTBP\u0007G\u001b)\u000b\u0003\u0005\u0004\u001c\u000eM\u0005\u0019AA~\u0003MqW/\\(g\u0007>t7/^7feN$v.\u00113e\u0011!\u0019\tha%A\u0002\rM\u0004\u0002CBQ\u0007'\u0003\raa\u0018\u0002\u001f\r|gn];nKJ\u0004v\u000e\u001c7feND\u0001ba\u0010\u0004\u0014\u0002\u00071\u0011\t\u0005\t\u0007#\u001b\u0019\n1\u0001\u0003~\"91\u0011\u0016\u0001\u0005\u0002\r-\u0016a\u0006<bY&$\u0017\r^3He>,\b/Q:tS\u001etW.\u001a8u)%\u00192QVBX\u0007c\u001b)\f\u0003\u0005\u0004\"\u000e\u001d\u0006\u0019AB0\u0011!\u0019\tja*A\u0002\tu\bbBBZ\u0007O\u0003\rAU\u0001\u0004[N<\u0007BCB\\\u0007O\u0003\n\u00111\u0001\u0004:\u0006Aq/Y5u)&lW\rE\u0002\u0015\u0007wK1a!0\u0016\u0005\u0011auN\\4\t\u000f\r\u0005\u0007\u0001\"\u0001\u0004D\u0006!4\r[1oO\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN+(m]2sSB$\u0018n\u001c8B]\u00124\u0016\r\\5eCR,\u0017i]:jO:lWM\u001c;\u0015\u000fM\u0019)ma2\u0004J\"A1\u0011UB`\u0001\u0004\u0019y\u0006\u0003\u0005\u0004@\r}\u0006\u0019AB!\u0011!\u0019\tja0A\u0002\tu\bbBBg\u0001\u0011\u00051qZ\u00010G\"\fgnZ3D_:\u001cX/\\3s'V\u00147o\u0019:jaRLwN\\!oIZ\u000bG.\u001b3bi\u0016\f5o]5h]6,g\u000e^\u000b\u0007\u0007#\u001cIna8\u0015\u0013M\u0019\u0019na9\u0004f\u000e\u001d\b\u0002CB\u0019\u0007\u0017\u0004\ra!6\u0011\u0011\rU2\u0011HBl\u0007;\u00042\u0001]Bm\t\u001d\u0019Yna3C\u0002M\u0014\u0011a\u0013\t\u0004a\u000e}GaBBq\u0007\u0017\u0014\ra\u001d\u0002\u0002-\"A1qHBf\u0001\u0004\u0019\t\u0005\u0003\u0005\u0004\u0012\u000e-\u0007\u0019\u0001B\u007f\u0011!\u0019Ioa3A\u0002\r-\u0018!\u0005:fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feB!1QGBw\u0013\u0011\u0019yoa\u000e\u00033\r{gn];nKJ\u0014VMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u0005\n\u0007g\u0004\u0011\u0013!C\u0001\u0007k\f\u0011E^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ*\"aa>+\t\re6\u0011`\u0016\u0003\u0007w\u0004Ba!@\u0005\b5\u00111q \u0006\u0005\t\u0003!\u0019!A\u0005v]\u000eDWmY6fI*\u0019AQA\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0005\n\r}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                Header header = record.headers().lastHeader("headerKey");
                Assert.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
            }
            {
                this.records$1 = records$1;
            }
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records2.size());
    }

    @Test
    public void testHeadersExtendedSerializerDeserializer() {
        ExtendedSerializer<byte[]> extendedSerializer = new ExtendedSerializer<byte[]>(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArraySerializer serializer;

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            @TraitSetter
            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$SerializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$SerializerImpl$class.close(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$SerializerImpl$class.$init$(this);
            }
        };
        ExtendedDeserializer<byte[]> extendedDeserializer = new ExtendedDeserializer<byte[]>(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArrayDeserializer deserializer;

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            @TraitSetter
            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$DeserializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$DeserializerImpl$class.close(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$DeserializerImpl$class.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize((Serializer<byte[]>)extendedSerializer, (Deserializer<byte[]>)extendedDeserializer);
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArraySerializer serializer;

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            @TraitSetter
            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$SerializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$SerializerImpl$class.close(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return PlaintextConsumerTest$SerializerImpl$class.serialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$SerializerImpl$class.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private ByteArrayDeserializer deserializer;

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            @TraitSetter
            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                PlaintextConsumerTest$DeserializerImpl$class.configure(this, configs, isKey);
            }

            public void close() {
                PlaintextConsumerTest$DeserializerImpl$class.close(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return PlaintextConsumerTest$DeserializerImpl$class.deserialize(this, topic, data);
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PlaintextConsumerTest$DeserializerImpl$class.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        KafkaConsumer x$21 = consumer;
        int x$22 = numRecords;
        int x$23 = 0;
        int x$24 = maxPollRecords;
        int x$25 = this.consumeAndVerifyRecords$default$4();
        long x$26 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$27 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$28 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$21, x$22, x$23, x$25, x$26, x$27, x$28, x$24);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)3000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)2000)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
        Thread.sleep(3500L);
        consumer.poll(0L);
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)2L, (long)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this, consumer, commitCompleted, committedPosition){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;
            private final LongRef committedPosition$1;

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (this.callsToRevoked() > 0) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
                this.committedPosition$1 = committedPosition$1;
                super($outer);
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"otherTopic"}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        Assert.assertEquals((long)0L, (long)committedPosition.elem);
        Assert.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$2.poll(50L);
                java.util.Set set = this.consumer$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$2 = consumer$2;
                this.assignment$1 = assignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final scala.collection.immutable.Set assignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava(), this.consumer$2.assignment()}));
            }
            {
                this.consumer$2 = consumer$2;
                this.assignment$1 = assignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)300L, (long)anotherConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)anotherConsumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$3;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$3.poll(50L);
                java.util.Set set = this.consumer$3.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$3 = consumer$3;
                this.assignment$2 = assignment$2;
            }
        }, (Function0<String>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$3;
            private final scala.collection.immutable.Set assignment$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava(), this.consumer$3.assignment()}));
            }
            {
                this.consumer$3 = consumer$3;
                this.assignment$2 = assignment$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)300L, (long)anotherConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)anotherConsumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$4.poll(50L);
                java.util.Set set = this.consumer$4.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$4 = consumer$4;
                this.subscriptions$1 = subscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;
            private final ObjectRef subscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava(), this.consumer$4.assignment()}));
            }
            {
                this.consumer$4 = consumer$4;
                this.subscriptions$1 = subscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$4.poll(50L);
                java.util.Set set = this.consumer$4.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$4 = consumer$4;
                this.subscriptions$1 = subscriptions$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;
            private final ObjectRef subscriptions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava(), this.consumer$4.assignment()}));
            }
            {
                this.consumer$4 = consumer$4;
                this.subscriptions$1 = subscriptions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$5.poll(50L);
                java.util.Set set = this.consumer$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$5 = consumer$5;
                this.subscriptions$2 = subscriptions$2;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final ObjectRef subscriptions$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava(), this.consumer$5.assignment()}));
            }
            {
                this.consumer$5 = consumer$5;
                this.subscriptions$2 = subscriptions$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0));
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$5.poll(50L);
                java.util.Set set = this.consumer$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$5 = consumer$5;
                this.subscriptions$2 = subscriptions$2;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final ObjectRef subscriptions$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava(), this.consumer$5.assignment()}));
            }
            {
                this.consumer$5 = consumer$5;
                this.subscriptions$2 = subscriptions$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$6;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$6.poll(50L);
                java.util.Set set = this.consumer$6.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$6 = consumer$6;
                this.subscriptions$3 = subscriptions$3;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$6;
            private final scala.collection.immutable.Set subscriptions$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava(), this.consumer$6.assignment()}));
            }
            {
                this.consumer$6 = consumer$6;
                this.subscriptions$3 = subscriptions$3;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)consumer.committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        consumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback(consumer, callback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((Object)asyncMetadata, (Object)consumer.committed(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.poll(0L);
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)new Serializable(this, consumer, callback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$7;
            private final BaseConsumerTest.CountConsumerCommitCallback callback$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.consumer$7.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)this.callback$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$7 = consumer$7;
                this.callback$1 = callback$1;
            }
        });
        this.awaitCommitCallback(consumer, callback, count);
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$4;
            private final KafkaConsumer consumer$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$8.poll(50L);
                java.util.Set set = this.consumer$8.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.subscriptions$4 = subscriptions$4;
                this.consumer$8 = consumer$8;
            }
        }, (Function0<String>)new Serializable(this, subscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$4;
            private final KafkaConsumer consumer$8;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava(), this.consumer$8.assignment()}));
            }
            {
                this.subscriptions$4 = subscriptions$4;
                this.consumer$8 = consumer$8;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expandedSubscriptions$1;
            private final KafkaConsumer consumer$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$8.poll(50L);
                java.util.Set set = this.consumer$8.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
                this.consumer$8 = consumer$8;
            }
        }, (Function0<String>)new Serializable(this, expandedSubscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expandedSubscriptions$1;
            private final KafkaConsumer consumer$8;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava(), this.consumer$8.assignment()}));
            }
            {
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
                this.consumer$8 = consumer$8;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$5;
            private final KafkaConsumer consumer$9;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$9.poll(50L);
                java.util.Set set = this.consumer$9.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.subscriptions$5 = subscriptions$5;
                this.consumer$9 = consumer$9;
            }
        }, (Function0<String>)new Serializable(this, subscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$5;
            private final KafkaConsumer consumer$9;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava(), this.consumer$9.assignment()}));
            }
            {
                this.subscriptions$5 = subscriptions$5;
                this.consumer$9 = consumer$9;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;
            private final KafkaConsumer consumer$9;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$9.poll(50L);
                java.util.Set set = this.consumer$9.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
                this.consumer$9 = consumer$9;
            }
        }, (Function0<String>)new Serializable(this, shrunkenSubscriptions, consumer){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;
            private final KafkaConsumer consumer$9;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava(), this.consumer$9.assignment()}));
            }
            {
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
                this.consumer$9 = consumer$9;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.List parts = consumer.partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.List partitions = consumer.partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, (int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$29 = consumer;
        int x$30 = 1;
        int x$31 = 0;
        TopicPartition x$32 = this.tp2();
        int x$33 = this.consumeAndVerifyRecords$default$4();
        long x$34 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$35 = this.consumeAndVerifyRecords$default$6();
        int x$36 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$29, x$30, x$31, x$33, x$34, x$35, x$32, x$36);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$37 = consumer;
        int x$38 = 1;
        int x$39 = (int)mid;
        int x$40 = (int)mid;
        long x$41 = mid;
        TopicPartition x$42 = this.tp2();
        TimestampType x$43 = this.consumeAndVerifyRecords$default$6();
        int x$44 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$37, x$38, x$39, x$40, x$41, x$43, x$42, x$44);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        Properties x$45 = producerProps;
        ByteArraySerializer x$46 = this.createProducer$default$1();
        ByteArraySerializer x$47 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$46, x$47, x$45);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, tp, producer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.tp$1 = tp$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertNull((Object)consumer.committed(new TopicPartition(this.topic(), 15)));
        this.intercept((Function0)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$10;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.consumer$10.position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$10 = consumer$10;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)consumer.committed(this.tp()).offset());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        otherConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)partitions);
        this.sendRecords(producer, 5, this.tp());
        Assert.assertTrue((boolean)consumer.poll(0L).isEmpty());
        consumer.resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$11;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer$11.poll(50L);
            }
            {
                this.consumer$11 = consumer$11;
            }
        }, ClassTag$.MODULE$.apply(NoOffsetForPartitionException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$11;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer$11.poll(20000L);
            }
            {
                this.consumer$11 = consumer$11;
            }
        }, ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer.poll(20000L);
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records2 = consumer.poll(20000L);
        Assert.assertEquals((long)1L, (long)records2.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records2.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final scala.collection.immutable.Map<Object, Object> apply(String topicName) {
                return this.$outer.createTopic(topicName, this.partitionCount$1, this.$outer.serverCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        });
        Seq partitions = (Seq)topics.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final int partitionCount$1;

            public final IndexedSeq<TopicPartition> apply(String topic) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount$1).map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final TopicPartition apply(int x$1) {
                        return new TopicPartition(this.topic$1, x$1);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, partitions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$12;
            private final Seq partitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$12.poll(50L);
                java.util.Set set = this.consumer$12.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions$1.toSet()).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$12 = consumer$12;
                this.partitions$1 = partitions$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, partitions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$12;
            private final Seq partitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitions$1).asJava(), this.consumer$12.assignment()}));
            }
            {
                this.consumer$12 = consumer$12;
                this.partitions$1 = partitions$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1)new Serializable(this, partitionCount, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;
            private final KafkaProducer producer$2;

            public final Seq<ProducerRecord<byte[], byte[]>> apply(TopicPartition x$2) {
                return this.$outer.sendRecords((KafkaProducer<byte[], byte[]>)this.producer$2, this.partitionCount$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
                this.producer$2 = producer$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Integer, String, String, Long> apply(ProducerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp());
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Object, String, String, Object> apply(ConsumerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp()));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$13.poll(50L);
                java.util.Set set = this.consumer$13.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$13 = consumer$13;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava(), this.consumer$13.assignment()}));
            }
            {
                this.consumer$13 = consumer$13;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$13.poll(50L);
                java.util.Set set = this.consumer$13.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$13 = consumer$13;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava(), this.consumer$13.assignment()}));
            }
            {
                this.consumer$13 = consumer$13;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$13.poll(50L);
                java.util.Set set = this.consumer$13.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$13 = consumer$13;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$13;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava(), this.consumer$13.assignment()}));
            }
            {
                this.consumer$13 = consumer$13;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        Tuple2 tuple22;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) throw new MatchError(tuple2);
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
        Buffer consumerGroup2 = (Buffer)tuple23._1();
        Buffer consumerPollers2 = (Buffer)tuple23._2();
        try {
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var11_11;
            var11_11.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$4) {
                    x$4.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerStickyAssignment() {
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer consumerGroup = (Buffer)tuple2._1();
            Buffer consumerPollers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
            Buffer consumerGroup2 = (Buffer)tuple23._1();
            Buffer consumerPollers2 = (Buffer)tuple23._2();
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(partitions).asJava()})), this.validateGroupAssignment$default$4());
            scala.collection.immutable.Map prePartition2PollerId = this.reverse$1(((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), partitions);
            scala.collection.immutable.Map postPartition2PollerId = this.reverse$1(((TraversableOnce)consumerPollers2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
            IntRef changes = IntRef.create((int)0);
            keys.foreach((Function1)new Serializable(this, prePartition2PollerId, postPartition2PollerId, changes){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map prePartition2PollerId$1;
                private final scala.collection.immutable.Map postPartition2PollerId$1;
                private final IntRef changes$1;

                public final void apply(TopicPartition key) {
                    Option preVal = this.prePartition2PollerId$1.get((Object)key);
                    Option postVal = this.postPartition2PollerId$1.get((Object)key);
                    if (preVal.nonEmpty() && postVal.nonEmpty()) {
                        if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                            ++this.changes$1.elem;
                        }
                    } else {
                        ++this.changes$1.elem;
                    }
                }
                {
                    this.prePartition2PollerId$1 = prePartition2PollerId$1;
                    this.postPartition2PollerId$1 = postPartition2PollerId$1;
                    this.changes$1 = changes$1;
                }
            });
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$7) {
                    x$7.shutdown();
                }
            });
            Assert.assertEquals((String)"Expected only two topic partitions that have switched to other consumers.", (long)rand, (long)changes.elem);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerDefaultAssignment() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$8) {
                    x$8.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$1.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$1 = testProducer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                return x$9.get();
            }
        });
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null);
            throw this.fail("Should not allow sending a null record", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1050));
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
            this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
            KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3());
            testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
            testConsumer.seek(this.tp(), 0L);
            ArrayBuffer records2 = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, appendStr, records2){
                public static final long serialVersionUID = 0L;
                private final String appendStr$1;
                private final ArrayBuffer records$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ConsumerRecord record = (ConsumerRecord)this.records$2.apply(i);
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new String((String)record.key()));
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.appendStr$1})).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
                }
                {
                    this.appendStr$1 = appendStr$1;
                    this.records$2 = records$2;
                }
            });
            int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
            testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
            Assert.assertEquals((long)2L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback(this);
            testConsumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(5L))}))).asJava(), (OffsetCommitCallback)commitCallback);
            this.awaitCommitCallback(testConsumer, commitCallback, this.awaitCommitCallback$default$3());
            Assert.assertEquals((long)5L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            testConsumer.close();
            testProducer.close();
            MockConsumerInterceptor.resetCounters();
            MockProducerInterceptor.resetCounters();
            return;
        }
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$2;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$2.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$2 = testProducer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$10) {
                return x$10.get();
            }
        });
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)testConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)20L, (long)testConsumer.committed(this.tp2()).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$).getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records2 = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = (ConsumerRecord)records2.head();
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$), (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        KafkaConsumer x$48 = consumer;
        int x$49 = numRecords;
        TopicPartition x$50 = this.tp2();
        int x$51 = 0;
        int x$52 = 0;
        long x$53 = 0L;
        TimestampType x$54 = this.consumeAndVerifyRecords$default$6();
        int x$55 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$48, x$49, x$51, x$52, x$53, x$54, x$50, x$55);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        KafkaConsumer x$56 = consumer;
        int x$57 = numRecords;
        TopicPartition x$58 = tp1;
        int x$59 = 0;
        int x$60 = 0;
        long x$61 = startTime;
        TimestampType x$62 = TimestampType.LOG_APPEND_TIME;
        int x$63 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$56, x$57, x$59, x$60, x$61, x$62, x$58, x$63);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        KafkaConsumer x$64 = consumer;
        int x$65 = numRecords;
        TopicPartition x$66 = tp2;
        int x$67 = 0;
        int x$68 = 0;
        long x$69 = startTime;
        TimestampType x$70 = TimestampType.LOG_APPEND_TIME;
        int x$71 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$64, x$65, x$67, x$68, x$69, x$70, x$66, x$71);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.Map topics = consumer.listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.intercept((Function0)new Serializable(this, topic1, consumer){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;
            private final KafkaConsumer consumer$15;

            public final java.util.Map<TopicPartition, OffsetAndTimestamp> apply() {
                return this.consumer$15.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic1$1, 0), Predef$.MODULE$.long2Long(-1L)));
            }
            {
                this.topic1$1 = topic1$1;
                this.consumer$15 = consumer$15;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1250));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3})).foreach((Function1)new Serializable(this, numParts, producer, timestampsToSearch, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int numParts$1;
            public final KafkaProducer producer$4;
            public final HashMap timestampsToSearch$1;
            public final IntRef i$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numParts$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testOffsetsForTimes$2 $outer;
                    private final String topic$2;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.topic$2, part);
                        this.$outer.kafka$api$PlaintextConsumerTest$$anonfun$$$outer().sendRecords((KafkaProducer<byte[], byte[]>)this.$outer.producer$4, 100, tp);
                        this.$outer.timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(this.$outer.i$1.elem * 20)));
                        ++this.$outer.i$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$2 = topic$2;
                    }
                });
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numParts$1 = numParts$1;
                this.producer$4 = producer$4;
                this.timestampsToSearch$1 = timestampsToSearch$1;
                this.i$1 = i$1;
            }
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).offset());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).timestamp());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).offset());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).timestamp());
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 0)));
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 1)));
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).offset());
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).timestamp());
        Assert.assertEquals(null, timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0));
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t1p0));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t1p0));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer.poll(50L);
        }
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        this.sendRecords(producer, 7, this.tp2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        consumer.poll(50L);
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)consumer.committed(this.tp()).offset());
        Assert.assertNull((Object)consumer.committed(this.tp2()));
        Assert.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assert.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)consumer.committed(this.tp()).offset());
        Assert.assertEquals((long)5L, (long)consumer.committed(this.tp2()).offset());
        BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        consumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(7L))}))).asJava(), (OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback(consumer, commitCallback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((long)7L, (long)consumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, consumer){
            private final KafkaConsumer consumer$16;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$16.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$16 = consumer$16;
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set assignment2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$16;
            private final scala.collection.immutable.Set assignment$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$16.poll(50L);
                java.util.Set set = this.consumer$16.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$16 = consumer$16;
                this.assignment$3 = assignment$3;
            }
        }, (Function0<String>)new Serializable(this, consumer, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$16;
            private final scala.collection.immutable.Set assignment$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$3).asJava(), this.consumer$16.assignment()}));
            }
            {
                this.consumer$16 = consumer$16;
                this.assignment$3 = assignment$3;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$16;
            private final scala.collection.immutable.Set newAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$16.poll(50L);
                java.util.Set set = this.consumer$16.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$16 = consumer$16;
                this.newAssignment$1 = newAssignment$1;
            }
        }, (Function0<String>)new Serializable(this, consumer, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$16;
            private final scala.collection.immutable.Set newAssignment$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava(), this.consumer$16.assignment()}));
            }
            {
                this.consumer$16 = consumer$16;
                this.newAssignment$1 = newAssignment$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)300L, (long)consumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)consumer.committed(this.tp2()).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener0 = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$17;
            private final ObjectRef records$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$3.elem = this.consumer$17.poll(100L);
                return !((ConsumerRecords)this.records$3.elem).records(this.$outer.tp()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$17 = consumer$17;
                this.records$3 = records$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener0.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLead0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((ConsumerRecords)records2.elem).count())})), (BoxesRunTime.equals((Object)fetchLead0.metricValue(), (Object)BoxesRunTime.boxToInteger((int)((ConsumerRecords)records2.elem).count())) ? 1 : 0) != 0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, listener0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$17;
            private final BaseConsumerTest.TestConsumerReassignmentListener listener0$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$17.poll(100L);
                return this.listener0$1.callsToAssigned() >= 2;
            }
            {
                this.consumer$17 = consumer$17;
                this.listener0$1 = listener0$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected rebalance did not occur.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener0 = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$18;
            private final ObjectRef records$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$4.elem = this.consumer$18.poll(100L);
                return !((ConsumerRecords)this.records$4.elem).records(this.$outer.tp()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$18 = consumer$18;
                this.records$4 = records$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener0.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - ((ConsumerRecords)records2.elem).count();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, listener0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$18;
            private final BaseConsumerTest.TestConsumerReassignmentListener listener0$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$18.poll(100L);
                return this.listener0$2.callsToAssigned() >= 2;
            }
            {
                this.consumer$18 = consumer$18;
                this.listener0$2 = listener0$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected rebalance did not occur.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$19;
            private final ObjectRef records$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$5.elem = this.consumer$19.poll(100L);
                return !((ConsumerRecords)this.records$5.elem).records(this.$outer.tp()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$19 = consumer$19;
                this.records$5 = records$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLead);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((ConsumerRecords)records2.elem).count())})), (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)((ConsumerRecords)records2.elem).count()), (Object)fetchLead.metricValue()) ? 1 : 0) != 0);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$19;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$19.poll(100L).isEmpty();
            }
            {
                this.consumer$19 = consumer$19;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$20;
            private final ObjectRef records$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$6.elem = this.consumer$20.poll(100L);
                return !((ConsumerRecords)this.records$6.elem).records(this.$outer.tp()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$20 = consumer$20;
                this.records$6 = records$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - ((ConsumerRecords)records2.elem).count();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedLag)})), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$20;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$20.poll(100L).isEmpty();
            }
            {
                this.consumer$20 = consumer$20;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", tags)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$21;
            private final ObjectRef records$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$7.elem = this.consumer$21.poll(100L);
                return !((ConsumerRecords)this.records$7.elem).records(this.$outer.tp()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$21 = consumer$21;
                this.records$7 = records$7;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$22;
            private final ObjectRef records$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$8.elem = this.consumer$22.poll(100L);
                return !((ConsumerRecords)this.records$8.elem).isEmpty();
            }
            {
                this.consumer$22 = consumer$22;
                this.records$8 = records$8;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lead should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxPollRecords)})), (BoxesRunTime.equals((Object)lead.metricValue(), (Object)BoxesRunTime.boxToInteger((int)maxPollRecords)) ? 1 : 0) != 0);
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ObjectRef records2 = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$23;
            private final ObjectRef records$9;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$9.elem = this.consumer$23.poll(100L);
                return !((ConsumerRecords)this.records$9.elem).isEmpty();
            }
            {
                this.consumer$23 = consumer$23;
                this.records$9 = records$9;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Consumer did not consume any message before timeout.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lag should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMessages - ((ConsumerRecords)records2.elem).count()))})), (double)(numMessages - ((ConsumerRecords)records2.elem).count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$11) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$11, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$12) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$12, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$13) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$13, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$14) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$14, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$15) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$15, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$16) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$16, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.producerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$17) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$17, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$18) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoMetric$1(x$18, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.$outer.consumerClientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final void apply(KafkaServer x$19) {
                this.$outer.kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(x$19);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.serverCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, producer, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer producer$3;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords((KafkaProducer<byte[], byte[]>)this.producer$3, this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$3 = producer$3;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$4;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$4.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$4 = consumerPollers$4;
            }
        });
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                return this.consumerGroup$2.$plus$eq(this.$outer.createConsumer(this.$outer.createConsumer$default$1(), this.$outer.createConsumer$default$2(), this.$outer.createConsumer$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$2;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int _) {
                KafkaConsumer<K, V> consumer = this.$outer.createConsumer(this.$outer.createConsumer$default$1(), this.$outer.createConsumer$default$2(), this.$outer.createConsumer$default$3());
                this.consumerGroup$1.$plus$eq(consumer);
                return this.consumerPollers$2.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$2 = consumerPollers$2;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$1;
            private final scala.collection.immutable.Set subscriptions$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$1.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$20) {
                        return this.assignments$1.$plus$eq(x$20.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerPollers$1 = consumerPollers$1;
                this.subscriptions$6 = subscriptions$6;
            }
        }, (Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, waitTime, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$3 = consumerPollers$3;
            }
        }, (Function0<String>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set subscriptions$7;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscriptions$7}));
            }
            {
                this.subscriptions$7 = subscriptions$7;
            }
        }, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$14;
            private final scala.collection.immutable.Set subscriptions$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$14.poll(50L);
                java.util.Set set = this.consumer$14.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$8).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$14 = consumer$14;
                this.subscriptions$8 = subscriptions$8;
            }
        }, (Function0<String>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$14;
            private final scala.collection.immutable.Set subscriptions$8;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$8).asJava(), this.consumer$14.assignment()}));
            }
            {
                this.consumer$14 = consumer$14;
                this.subscriptions$8 = subscriptions$8;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map m$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition v) {
                return new Tuple2((Object)v, ((IterableLike)this.m$1.keys().filter((Function1)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$reverse$1$1 $outer;
                    private final TopicPartition v$1;

                    public final boolean apply(long x$5) {
                        return this.apply$mcZJ$sp(x$5);
                    }

                    public boolean apply$mcZJ$sp(long x$5) {
                        return ((SetLike)this.$outer.m$1.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains((Object)this.v$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.v$1 = v$1;
                    }
                })).head());
            }
            {
                this.m$1 = m$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public final void kafka$api$PlaintextConsumerTest$$assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assert.assertNull((String)new StringBuilder().append((Object)"Metric should not hanve been created ").append((Object)metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        @TraitSetter
        public void serializer_$eq(ByteArraySerializer var1);

        public byte[] serialize(String var1, Headers var2, byte[] var3);

        public void configure(java.util.Map<String, ?> var1, boolean var2);

        public void close();

        public byte[] serialize(String var1, byte[] var2);

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        @TraitSetter
        public void deserializer_$eq(ByteArrayDeserializer var1);

        public byte[] deserialize(String var1, Headers var2, byte[] var3);

        public void configure(java.util.Map<String, ?> var1, boolean var2);

        public void close();

        public byte[] deserialize(String var1, byte[] var2);

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();
    }
}

