/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerIntegrationTest$;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8oiJ|G\u000e\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012aB:feZ,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0003EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0013\u0001\u0001\u0004%\tAJ\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\u0005+:LG\u000fC\u0004-I\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAF\u0001\tg\u0016\u0014h/\u001a:tA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u00064jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.F\u00013!\tA3'\u0003\u000255\t\u0019\u0011J\u001c;\t\rY\u0002\u0001\u0015!\u00033\u0003U1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011'A\u000fgSJ\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8o\u0011\u0019Q\u0004\u0001)A\u0005e\u0005qb-\u001b:ti\u000e{g\u000e\u001e:pY2,'/\u00129pG\"T6NV3sg&|g\u000e\t\u0005\u0006y\u0001!\t%P\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002O!\u00121h\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bQA[;oSRT\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$B\u0005\u0019\u0011UMZ8sK\")\u0001\n\u0001C!{\u0005AA/Z1s\t><h\u000e\u000b\u0002H\u0015B\u0011\u0001iS\u0005\u0003\u0019\u0006\u0013Q!\u00114uKJDQA\u0014\u0001\u0005\u0002u\n\u0001\u0003^3ti\u0016k\u0007\u000f^=DYV\u001cH/\u001a:)\u00055\u0003\u0006C\u0001!R\u0013\t\u0011\u0016I\u0001\u0003UKN$\b\"\u0002+\u0001\t\u0003i\u0014!\f;fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007+\u001a:tSN$8o\u00165f]\u0006cGN\u0011:pW\u0016\u00148\u000fR8x]\"\u00121\u000b\u0015\u0005\u0006/\u0002!\t!P\u0001,i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4X-\u00138de\u0016lWM\u001c;t\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"\u0012a\u000b\u0015\u0005\u00065\u0002!\t!P\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0007FA-Q\u0011\u0015i\u0006\u0001\"\u0001>\u0003\r\"Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#\u0001\u0018)\t\u000b\u0001\u0004A\u0011A\u001f\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\ty\u0006\u000bC\u0003d\u0001\u0011\u0005Q(A\u0017uKN$Hk\u001c9jGB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#A\u0019)\t\u000b\u0019\u0004A\u0011A\u001f\u00023Q,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003KBCQ!\u001b\u0001\u0005\u0002u\n!\b^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019%bYRLgn\u001a)s_\u001e\u0014Xm]:)\u0005!\u0004\u0006\"\u00027\u0001\t\u0003i\u0014a\u000e;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u0014Vm];nKN\fe\r^3s%\u0016\u0004H.[2b\u0007>lWm](oY&tW\r\u000b\u0002l!\")q\u000e\u0001C\u0001{\u0005\u0011C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:D#A\u001c)\t\u000bI\u0004A\u0011A\u001f\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000f\u000b\u0002r!\")Q\u000f\u0001C\u0001{\u0005iD/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\"\u0012A\u000f\u0015\u0005\u0006q\u0002!\t!P\u0001'i\u0016\u001cH/Q;u_B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t\u0007FA<Q\u0011\u0015Y\b\u0001\"\u0001>\u0003\u0011#Xm\u001d;MK\u0006$WM]!oI&\u001b(o\u00165f]\u0016sG/\u001b:f\u0013N\u0014xJ\u001a4mS:,\u0017I\u001c3V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3eQ\tQ\b\u000bC\u0003\u007f\u0001\u0011\u0005Q(A\"uKN$H*Z1eKJ\fe\u000eZ%te^CWM\\#oi&\u0014X-S:s\u001f\u001a4G.\u001b8f\u0003:$WK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007FA?Q\u0011\u0019\t\u0019\u0001\u0001C\u0001{\u00051B/Z:u\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eK\u0002\u0002\u0002ACa!!\u0003\u0001\t\u0003i\u0014!\t;fgR\u001cuN\u001c;s_2dWM]'pm\u0016|e\u000eV8qS\u000e\u001c%/Z1uS>t\u0007fAA\u0004!\"1\u0011q\u0002\u0001\u0005\u0002u\n\u0011\u0005^3ti\u000e{g\u000e\u001e:pY2,'/T8wK>sGk\u001c9jG\u0012+G.\u001a;j_:D3!!\u0004Q\u0011\u0019\t)\u0002\u0001C\u0001{\u0005aC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-\u00127fGRLwN\u001c\u0015\u0004\u0003'\u0001\u0006BBA\u000e\u0001\u0011\u0005Q(A\u0015uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u00033\u0001\u0006bBA\u0011\u0001\u0011%\u00111E\u0001\u0013i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4X\rF\u0002(\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011F\u0001\u0004MVt\u0007\u0003\u0002\u0015\u0002,\u001dJ1!!\f\u001b\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u00022\u0001!I!a\r\u0002=A\u0014XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>tGcC\u0014\u00026\u0005e\u0012QHA*\u0003KBq!a\u000e\u00020\u0001\u0007!'\u0001\u0007d_:$(o\u001c7mKJLE\rC\u0004\u0002<\u0005=\u0002\u0019\u0001\u0010\u0002\u0017=$\b.\u001a:Ce>\\WM\u001d\u0005\t\u0003\u007f\ty\u00031\u0001\u0002B\u0005\u0011A\u000f\u001d\t\u0005\u0003\u0007\ny%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0019\u0019w.\\7p]*\u0019Q!a\u0013\u000b\u0007\u000553)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003#\n)E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005U\u0013q\u0006a\u0001\u0003/\n\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u00033\nyF\r\b\u0004Q\u0005m\u0013bAA/5\u00051\u0001K]3eK\u001aLA!!\u0019\u0002d\t\u00191+\u001a;\u000b\u0007\u0005u#\u0004C\u0004\u0002h\u0005=\u0002\u0019\u0001\u001a\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0003W\u0002A\u0011BA7\u0003a9\u0018-\u001b;V]RLGnQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u000b\u0006O\u0005=\u00141\u000f\u0005\b\u0003c\nI\u00071\u00013\u0003\u0015)\u0007o\\2i\u0011!\t)(!\u001bA\u0002\u0005]\u0014aB7fgN\fw-\u001a\t\u0005\u00033\nI(\u0003\u0003\u0002|\u0005\r$AB*ue&tw\rC\u0004\u0002\u0000\u0001!I!!!\u0002+]\f\u0017\u000e\u001e$peB\u000b'\u000f^5uS>t7\u000b^1uKRYq%a!\u0002\u0006\u0006%\u0015QRAH\u0011!\ty$! A\u0002\u0005\u0005\u0003bBAD\u0003{\u0002\rAM\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"9\u00111RA?\u0001\u0004\u0011\u0014A\u00027fC\u0012,'\u000fC\u0004\u0002h\u0005u\u0004\u0019\u0001\u001a\t\u0011\u0005U\u0014Q\u0010a\u0001\u0003oBq!a%\u0001\t\u0013\t)*\u0001\rjg\u0016C\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\"\"a&\u0002\u001e\u0006\u001d\u0016\u0011VAV!\rA\u0013\u0011T\u0005\u0004\u00037S\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003?\u000b\t\n1\u0001\u0002\"\u0006YB.Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\u00042AEAR\u0013\r\t)K\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\u0005\u001d\u0015\u0011\u0013a\u0001e!9\u00111RAI\u0001\u0004\u0011\u0004bBA4\u0003#\u0003\rA\r\u0005\b\u0003_\u0003A\u0011BAY\u0003-i\u0017m[3TKJ4XM]:\u0015\u000fY\t\u0019,a.\u0002<\"9\u0011QWAW\u0001\u0004\u0011\u0014A\u00038v[\u000e{gNZ5hg\"Q\u0011\u0011XAW!\u0003\u0005\r!a&\u00023\u0005,Ho\u001c'fC\u0012,'OU3cC2\fgnY3F]\u0006\u0014G.\u001a\u0005\u000b\u0003{\u000bi\u000b%AA\u0002\u0005]\u0015aG;oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rC\u0004\u0002B\u0002!I!a1\u0002\u000bQLW.\u001a:\u0015\t\u0005\u0015\u0017Q\u001c\t\u0005\u0003\u000f\fI.\u0004\u0002\u0002J*!\u00111ZAg\u0003\u0011\u0019wN]3\u000b\t\u0005=\u0017\u0011[\u0001\b[\u0016$(/[2t\u0015\u0011\t\u0019.!6\u0002\re\fW.\\3s\u0015\t\t9.A\u0002d_6LA!a7\u0002J\n)A+[7fe\"A\u0011q\\A`\u0001\u0004\t9(\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016Dq!a9\u0001\t\u0013\t)/A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0002=!I\u0011\u0011\u001e\u0001\u0012\u0002\u0013%\u00111^\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiO\u000b\u0003\u0002\u0018\u0006=8FAAy!\u0011\t\u00190!@\u000e\u0005\u0005U(\u0002BA|\u0003s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m($\u0001\u0006b]:|G/\u0019;j_:LA!a@\u0002v\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\r\u0001!%A\u0005\n\u0005-\u0018!F7bW\u0016\u001cVM\u001d<feN$C-\u001a4bk2$He\r")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to kill controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$1) {
                return x$1.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return x$2 != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$3) {
                return x$3.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 != this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=ControllerStats,name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ControllerState.PartitionReassignment$.MODULE$.rateAndTimeMetricName().get()}));
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$5) {
                return x$5.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 != this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$2;
            private final scala.collection.immutable.Map reassignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map map = this.$outer.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$2.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$1;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.reassignment$1 = reassignment$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer count ", " should be greater than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updatedTimerCount), BoxesRunTime.boxToLong((long)timerCount)})), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$7) {
                return x$7.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$4;

            public final boolean apply(int x$8) {
                return this.apply$mcZI$sp(x$8);
            }

            public boolean apply$mcZI$sp(int x$8) {
                return x$8 != this.controllerId$4;
            }
            {
                this.controllerId$4 = controllerId$4;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "partition reassignment path should remain while reassignment in progress";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$9) {
                return x$9.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$5;

            public final boolean apply(int x$10) {
                return this.apply$mcZI$sp(x$10);
            }

            public boolean apply$mcZI$sp(int x$10) {
                return x$10 != this.controllerId$5;
            }
            {
                this.controllerId$5 = controllerId$5;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$3;
            private final scala.collection.immutable.Map reassignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map map = this.$outer.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$3.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$2;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$3 = tp$3;
                this.reassignment$2 = reassignment$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$6;

            public final boolean apply(KafkaServer x$11) {
                return x$11.config().brokerId() != this.controllerId$6;
            }
            {
                this.controllerId$6 = controllerId$6;
            }
        }).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$7;

            public final boolean apply(KafkaServer x$12) {
                return x$12.config().brokerId() != this.controllerId$7;
            }
            {
                this.controllerId$7 = controllerId$7;
            }
        }).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$13) {
                return x$13.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$8;

            public final boolean apply(int x$14) {
                return this.apply$mcZI$sp(x$14);
            }

            public boolean apply$mcZI$sp(int x$14) {
                return x$14 != this.controllerId$8;
            }
            {
                this.controllerId$8 = controllerId$8;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after giving up";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$15) {
                return x$15.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$9;

            public final boolean apply(int x$16) {
                return this.apply$mcZI$sp(x$16);
            }

            public boolean apply$mcZI$sp(int x$16) {
                return x$16 != this.controllerId$9;
            }
            {
                this.controllerId$9 = controllerId$9;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$17) {
                return x$17.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$10;

            public final boolean apply(int x$18) {
                return this.apply$mcZI$sp(x$18);
            }

            public boolean apply$mcZI$sp(int x$18) {
                return x$18 != this.controllerId$10;
            }
            {
                this.controllerId$10 = controllerId$10;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$1;
            private final TopicPartition tp$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$5})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$5)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5), this.$outer.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$1}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$1 = otherBrokerId$1;
                this.tp$5 = tp$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$26 = 2;
        boolean x$27 = true;
        boolean x$28 = this.makeServers$default$2();
        this.servers_$eq(this.makeServers(x$26, x$28, x$27));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$19) {
                return x$19.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$11;

            public final boolean apply(int x$20) {
                return this.apply$mcZI$sp(x$20);
            }

            public boolean apply$mcZI$sp(int x$20) {
                return x$20 != this.controllerId$11;
            }
            {
                this.controllerId$11 = controllerId$11;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$2;
            private final TopicPartition tp$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$6})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$6)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6), this.$outer.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$2}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$2 = otherBrokerId$2;
                this.tp$6 = tp$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testControlledShutdown() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$12;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$12;
            }
            {
                this.controllerId$12 = controllerId$12;
            }
        }).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Serializable controlledShutdownCallback = new Serializable(this, resultQueue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue resultQueue$1;

            public final void apply(Try<Set<TopicPartition>> controlledShutdownResult) {
                this.resultQueue$1.put(controlledShutdownResult);
            }
            {
                this.resultQueue$1 = resultQueue$1;
            }
        };
        controller.controlledShutdown(2, (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
            public static final long serialVersionUID = 0L;
            public final String topic$1;
            public final int partition$1;
            private final ObjectRef activeServers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Seq)this.activeServers$1.elem).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testControlledShutdown$1 $outer;

                    public final boolean apply(KafkaServer x$21) {
                        return ((UpdateMetadataRequest.PartitionState)x$21.apis().metadataCache().getPartitionInfo((String)this.$outer.topic$1, (int)this.$outer.partition$1).get()).basePartitionState.isr.size() != 3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
                this.activeServers$1 = activeServers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Topic test not created after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequest.PartitionState partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.basePartitionState.isr.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.basePartitionState.isr).asScala());
        controller.controlledShutdown(1, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == 0;
            }
        });
        partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partition$1;

            public final boolean apply(KafkaServer x$22) {
                return ((UpdateMetadataRequest.PartitionState)x$22.apis().metadataCache().getPartitionInfo((String)this.topic$1, (int)this.partition$1).get()).basePartitionState.leader == 0;
            }
            {
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        }));
        controller.controlledShutdown(0, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partition$1;

            public final boolean apply(KafkaServer x$23) {
                return ((UpdateMetadataRequest.PartitionState)x$23.apis().metadataCache().getPartitionInfo((String)this.topic$1, (int)this.partition$1).get()).basePartitionState.leader == 0;
            }
            {
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        }));
    }

    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp, assignment2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$7;
            private final scala.collection.immutable.Map assignment$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient adminZkClient = new AdminZkClient(this.$outer.zkClient());
                adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(this.tp$7.topic(), (Map)this.assignment$1, new Properties(), adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$7 = tp$7;
                this.assignment$1 = assignment$1;
            }
        });
    }

    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$8;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient adminZkClient = new AdminZkClient(this.$outer.zkClient());
                adminZkClient.deleteTopic(this.tp$8.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$8 = tp$8;
            }
        });
    }

    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$9;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$9})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$9 = tp$9;
            }
        });
    }

    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final scala.collection.immutable.Map reassignment$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPartitionReassignment(this.reassignment$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.reassignment$3 = reassignment$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), Level.INFO);
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controller){
                public static final long serialVersionUID = 0L;
                private final KafkaController controller$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    ControllerState controllerState = this.controller$1.eventManager().state();
                    ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                    return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
                }
                {
                    this.controller$1 = controller$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller event thread is still busy";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new KafkaController.AwaitOnLatch(latch));
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controller){
                public static final long serialVersionUID = 0L;
                private final KafkaController controller$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return !this.controller$1.isActive();
                }
                {
                    this.controller$1 = controller$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller fails to resign";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Option event = appender.getMessages().find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(LoggingEvent e) {
                    Level level = e.getLevel();
                    Level level2 = Level.INFO;
                    if (level == null) {
                        if (level2 != null) {
                            return false;
                        }
                    } else if (!level.equals(level2)) return false;
                    if (e.getThrowableInformation() == null) return false;
                    if (!e.getThrowableInformation().getThrowable().getClass().getName().equals(new ControllerMovedException("").getClass().getName())) return false;
                    return true;
                }
            });
            Assert.assertTrue((boolean)event.isDefined());
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
        catch (Throwable throwable) {
            void var4_4;
            void var2_2;
            void var3_3;
            LogCaptureAppender$.MODULE$.unregister((LogCaptureAppender)var3_3);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(var2_2.eventManager().thread().getClass(), (Level)var4_4);
            throw throwable;
        }
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, replicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$4;
            private final scala.collection.immutable.Set replicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set set = ((TraversableOnce)this.$outer.zkClient().getInSyncReplicasForPartition(new TopicPartition(this.tp$4.topic(), this.tp$4.partition())).get()).toSet();
                scala.collection.immutable.Set set2 = this.replicas$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$4 = tp$4;
                this.replicas$1 = replicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "restarted broker failed to join in-sync replicas";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int epoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerEpoch().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Stat> x$24) {
                        return x$24._1$mcI$sp();
                    }
                }).contains((Object)BoxesRunTime.boxToInteger((int)this.epoch$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader2, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, controllerEpoch, leader2, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$1;
            private final int controllerEpoch$1;
            private final int leader$1;
            private final int leaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
                return leaderIsrAndControllerEpochMap.contains((Object)this.tp$1) && this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$1), this.controllerEpoch$1, this.leader$1, this.leaderEpoch$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leader$1 = leader$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$2;

            public final String apply() {
                return this.message$2;
            }
            {
                this.message$2 = message$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public boolean kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader2, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader2 && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1)new Serializable(this, autoLeaderRebalanceEnable, uncleanLeaderElectionEnable){
            public static final long serialVersionUID = 0L;
            private final boolean autoLeaderRebalanceEnable$1;
            private final boolean uncleanLeaderElectionEnable$1;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.autoLeaderRebalanceEnable$1)).toString());
                config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.uncleanLeaderElectionEnable$1)).toString());
                return config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
            }
            {
                this.autoLeaderRebalanceEnable$1 = autoLeaderRebalanceEnable$1;
                this.uncleanLeaderElectionEnable$1 = uncleanLeaderElectionEnable$1;
            }
        });
        return (Seq)configs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties config) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$25) {
                String string = x$25.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final String metricName$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metricName$1 = metricName$1;
            }
        });
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$13;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$13;
            }
            {
                this.controllerId$13 = controllerId$13;
            }
        })).head();
    }
}

