/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.LogUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\"1\u0011\u0006\u0001Q\u0001\n\u0001\nq\u0001^7q\t&\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011A\u0010\u0002\r1|w\rR5s\u0011\u0019i\u0003\u0001)A\u0005A\u00059An\\4ESJ\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005\t\u0004C\u0001\u001a9\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u0011QA\u000e\u0006\u0003o9\ta!\u00199bG\",\u0017BA\u001d4\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Daa\u000f\u0001!\u0002\u0013\t\u0014a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\t\u000fu\u0002!\u0019!C\u0001}\u0005AAn\\4Qe>\u00048/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E%\u0001\u0003vi&d\u0017B\u0001#B\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007\r\u0002\u0001\u000b\u0011B \u0002\u00131|w\r\u0015:paN\u0004\u0003b\u0002%\u0001\u0005\u0004%\t!S\u0001\nY><7i\u001c8gS\u001e,\u0012A\u0013\t\u00039-K!\u0001\u0014\u0002\u0003\u00131{wmQ8oM&<\u0007B\u0002(\u0001A\u0003%!*\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+\u0001\u0003uS6,W#\u0001*\u0011\u0005M\u0019\u0016B\u0001+\u0015\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%!+A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002%\rdW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u00025B!1LY\u0019e\u001b\u0005a&BA/_\u0003\u001diW\u000f^1cY\u0016T!a\u00181\u0002\u0015\r|G\u000e\\3di&|gNC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019GLA\u0002NCB\u0004\"!\u001a4\u000e\u0003\u0001L!a\u001a1\u0003\t1{gn\u001a\u0005\u0007S\u0002\u0001\u000b\u0011\u0002.\u0002'\rdW-\u00198fe\u000eCWmY6q_&tGo\u001d\u0011\u0007\t-\u0004\u0001\u0001\u001c\u0002\u0016\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l'\tQW\u000e\u0005\u0002\u001d]&\u0011qN\u0001\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b\"C9k\u0005\u0003\u0005\u000b\u0011\u0002:\u007f\u0003\u001dawn\u001a#jeN\u00042a]>!\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\r\u00051AH]8pizJ\u0011!Y\u0005\u0003u\u0002\fq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005i\u0004\u0017BA9o\u00111\t\tA\u001bB\u0001B\u0003%\u00111AA\b\u0003\u0011awnZ:\u0011\rM\t)!MA\u0005\u0013\r\t9\u0001\u0006\u0002\u0005!>|G\u000eE\u0002\u001d\u0003\u0017I1!!\u0004\u0003\u0005\raunZ\u0005\u0004\u0003\u0003q\u0007\u0002DA\nU\n\u0005\t\u0015!\u0003\u0002\u0016\u0005\u0005\u0012\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005}\u0011\u0011\u0004\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\n\u0007\u0005Ma\u000e\u0003\u0004\u001aU\u0012\u0005\u0011Q\u0005\u000b\t\u0003O\tY#!\f\u00020A\u0019\u0011\u0011\u00066\u000e\u0003\u0001Aa!]A\u0012\u0001\u0004\u0011\b\u0002CA\u0001\u0003G\u0001\r!a\u0001\t\u0011\u0005M\u00111\u0005a\u0001\u0003+Aq!a\rk\t\u0003\n)$A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005]\u0002CBA\u001d\u0003\u007f\tDMD\u0002f\u0003wI1!!\u0010a\u0003\u0019\u0001&/\u001a3fM&\u00191-!\u0011\u000b\u0007\u0005u\u0002\rC\u0004\u0002F\u0001!\t!a\u0012\u0002\u0011Q,\u0017M\u001d#po:$\"!!\u0013\u0011\u0007\u0015\fY%C\u0002\u0002N\u0001\u0014A!\u00168ji\"\"\u00111IA)!\u0011\t\u0019&a\u0016\u000e\u0005\u0005U#BA\u0006\u000f\u0013\u0011\tI&!\u0016\u0003\u000b\u00053G/\u001a:\t\u000f\u0005u\u0003\u0001\"\u0001\u0002H\u0005AD/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{wMU3ukJt7\u000fT8h/&$\b\u000eR5si&,7\u000f\u001e*bi&|\u0007\u0006BA.\u0003C\u0002B!a\u0015\u0002d%!\u0011QMA+\u0005\u0011!Vm\u001d;\t\u000f\u0005%\u0004\u0001\"\u0001\u0002H\u0005ID/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7/\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u000b\u0003\u0002h\u0005\u0005\u0004bBA8\u0001\u0011\u0005\u0011qI\u00019i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8tQ\u0011\ti'!\u0019\t\u000f\u0005U\u0004\u0001\"\u0001\u0002H\u0005!F/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7OQ8uQ&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8t\u0003:$WK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\b\u0006BA:\u0003CBq!a\u001f\u0001\t\u0003\t9%\u0001#uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u0012+G.\u001a;f\u0019><7\u000f\u000b\u0003\u0002z\u0005\u0005\u0004bBAA\u0001\u0011\u0005\u0011qI\u0001Ii\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;EK2,G/\u001a'pONDC!a \u0002b!9\u0011q\u0011\u0001\u0005\u0002\u0005\u001d\u0013A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fT8hg\"\"\u0011QQA1\u0011\u001d\ti\t\u0001C\u0001\u0003\u000f\n1\u0006^3ti2{wm]+oI\u0016\u00148\t\\3b]V\u0004\u0018J\\3mS\u001eL'\r\\3G_J\u001cu.\u001c9bGRLwN\u001c\u0015\u0005\u0003\u0017\u000b\t\u0007C\u0004\u0002\u0014\u0002!\t!a\u0012\u0002QQ,7\u000f^\"p]\u000e,(O]3oi2{wm\u00117fC:,\b/\u00118e\u0019><GK];oG\u0006$\u0018n\u001c8)\t\u0005E\u0015\u0011\r\u0005\b\u00033\u0003A\u0011AA$\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oIR{\u0007/[2EK2,G/[8oQ\u0011\t9*!\u0019\t\u000f\u0005}\u0005\u0001\"\u0001\u0002H\u0005\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\t\u0005u\u0015\u0011\r\u0005\b\u0003K\u0003A\u0011AA$\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\"\u00111UA1\u0011\u001d\tY\u000b\u0001C\u0001\u0003\u000f\n1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:US6,\u0007\u0006BAU\u0003CBq!!-\u0001\t\u0003\t9%\u0001\u0011uKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peNCwN\u001d;US6,\u0007\u0006BAX\u0003CBq!a.\u0001\t\u0003\t9%\u0001\u0016uKN$XK\u001c3fG&$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000eR1uC:{Go\u00117fC:\f'\r\\3)\t\u0005U\u0016\u0011\r\u0005\b\u0003{\u0003A\u0011AA$\u0003A!Xm\u001d;E_:,7\t\\3b]&tw\r\u000b\u0003\u0002<\u0006\u0005\u0004bBAb\u0001\u0011\u0005\u0011qI\u0001\u0011i\u0016\u001cH\u000fR8oK\u0012+G.\u001a;j]\u001eDC!!1\u0002b!9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017\u0001F2sK\u0006$Xm\u00117fC:,'/T1oC\u001e,'\u000fF\u0002n\u0003\u001bDqaAAd\u0001\u0004\tI\u0001C\u0004\u0002J\u0002!I!!5\u0015\u000b5\f\u0019.a6\t\u0011\u0005U\u0017q\u001aa\u0001\u0003\u0007\tA\u0001]8pY\"Q\u0011\u0011\\Ah!\u0003\u0005\r!a7\u0002\rQ|Wj\\2l!\r)\u0017Q\\\u0005\u0004\u0003?\u0004'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003G\u0004A\u0011BAs\u0003%\u0019'/Z1uK2{w\r\u0006\u0005\u0002\n\u0005\u001d\u0018\u0011_A~\u0011!\tI/!9A\u0002\u0005-\u0018aC:fO6,g\u000e^*ju\u0016\u00042!ZAw\u0013\r\ty\u000f\u0019\u0002\u0004\u0013:$\b\u0002CAz\u0003C\u0004\r!!>\u0002\u001b\rdW-\u00198vaB{G.[2z!\u0011\tI$a>\n\t\u0005e\u0018\u0011\t\u0002\u0007'R\u0014\u0018N\\4\t\u0015\u0005u\u0018\u0011\u001dI\u0001\u0002\u0004\tY/A\u0007tK\u001elWM\u001c;t\u0007>,h\u000e\u001e\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0003\u001di\u0017m[3M_\u001e$b!!\u0003\u0003\u0006\t%\u0001\"\u0003B\u0004\u0003\u007f\u0004\n\u00111\u0001!\u0003\r!\u0017N\u001d\u0005\b\u0005\u0017\ty\u00101\u0001K\u0003\u0019\u0019wN\u001c4jO\"9!q\u0002\u0001\u0005\n\tE\u0011a\u0002:fG>\u0014Hm\u001d\u000b\t\u0005'\u0011yBa\t\u0003(A!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001aM\naA]3d_J$\u0017\u0002\u0002B\u000f\u0005/\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002\u0003B\u0011\u0005\u001b\u0001\r!a;\u0002\u0007-,\u0017\u0010\u0003\u0005\u0003&\t5\u0001\u0019AAv\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011IC!\u0004A\u0002\u0011\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u0013\t5\u0002!%A\u0005\n\t=\u0012aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0019U\u0011\tYOa\r,\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0010a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\u0012IDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0012\u0001#\u0003%IA!\u0013\u0002=\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B&U\u0011\tYNa\r\t\u0013\t=\u0003!%A\u0005\n\tE\u0013!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000b\u0016\u0004A\tM\u0002")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records2.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records2.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log2, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records2.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records2.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records2.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records2.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records2.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records2.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(log3.dir().getParent(), tp3);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertTrue((boolean)filthiestLog.isEmpty());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3());
        log2.onHighWatermarkIncremented(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log2.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log2.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$1) {
                return (TopicPartition)x$1._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log2.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$2) {
                return (TopicPartition)x$2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$3) {
                return (TopicPartition)x$3._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$14 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$15 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$15, x$14);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$16 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$17 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$17, x$16);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3());
        }
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t1), 0, log2.appendAsLeader$default$3());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$18 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$19 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$19, x$18);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3());
        }
        this.time().sleep(compactionLag + 1);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$20 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$21 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$21, x$20);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        log2.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log2.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false);
        log2.roll(log2.roll$default$1());
        log2.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$22 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$23 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$23, x$22);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        this.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$1;
            private final LogCleanerManager cleanerManager$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$1.doneCleaning(this.$outer.topicPartition(), this.log$1.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.cleanerManager$1 = cleanerManager$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$1;
            private final LogCleanerManager cleanerManager$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$1.doneCleaning(this.$outer.topicPartition(), this.log$1.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.cleanerManager$1 = cleanerManager$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        TopicPartition tp = new TopicPartition("log", 0);
        this.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$2;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
            }
            {
                this.cleanerManager$2 = cleanerManager$2;
                this.tp$1 = tp$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$2;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
            }
            {
                this.cleanerManager$2 = cleanerManager$2;
                this.tp$1 = tp$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log2) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log2);
        return this.createCleanerManager((Pool<TopicPartition, Log>)logs, this.createCleanerManager$default$2());
    }

    private LogCleanerManager createCleanerManager(Pool<TopicPartition, Log> pool, boolean toMock) {
        return toMock ? new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null) : new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private boolean createCleanerManager$default$2() {
        return false;
    }

    private Log createLog(int segmentSize, String cleanupPolicy, int segmentsCount) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$24 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$25 = config;
        long x$26 = 0L;
        long x$27 = 0L;
        MockScheduler x$28 = this.time().scheduler();
        MockTime x$29 = this.time();
        BrokerTopicStats x$30 = new BrokerTopicStats();
        int x$31 = 3600000;
        int x$32 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$33 = new LogDirFailureChannel(10);
        Log log2 = Log$.MODULE$.apply(x$24, x$25, x$26, x$27, (Scheduler)x$28, x$30, (Time)x$29, x$31, x$32, x$33);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentsCount).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$2;

            public final LogSegment apply(int i) {
                int startOffset = i * 10;
                int endOffset = startOffset + 10;
                LogSegment segment = LogUtils$.MODULE$.createSegment(startOffset, this.$outer.logDir(), LogUtils$.MODULE$.createSegment$default$3(), LogUtils$.MODULE$.createSegment$default$4());
                LongRef lastTimestamp = LongRef.create((long)0L);
                IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startOffset), endOffset).map((Function1)new Serializable(this, endOffset, lastTimestamp){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createLog$1 $outer;
                    private final int endOffset$1;
                    private final LongRef lastTimestamp$1;

                    public final SimpleRecord apply(int offset) {
                        long currentTimestamp = this.$outer.kafka$log$LogCleanerManagerTest$$anonfun$$$outer().time().milliseconds();
                        if (offset == this.endOffset$1 - 1) {
                            this.lastTimestamp$1.elem = currentTimestamp;
                        }
                        return new SimpleRecord(currentTimestamp, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})).getBytes(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})).getBytes());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.endOffset$1 = endOffset$1;
                        this.lastTimestamp$1 = lastTimestamp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                segment.append((long)endOffset, lastTimestamp.elem, (long)endOffset, MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
                return this.log$2.addSegment(segment);
            }

            public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
            }
        });
        return log2;
    }

    private int createLog$default$3() {
        return 0;
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$4 = dir;
        LogConfig x$5 = config;
        long x$6 = 0L;
        long x$7 = 0L;
        MockScheduler x$8 = this.time().scheduler();
        MockTime x$9 = this.time();
        BrokerTopicStats x$10 = new BrokerTopicStats();
        int x$11 = 3600000;
        int x$12 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$13 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$4, x$5, x$6, x$7, (Scheduler)x$8, x$10, (Time)x$9, x$11, x$12, x$13);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.class.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

