/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleanerTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\rmg\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000ba\u0006^3ti\u000ecW-\u00198TK\u001elWM\u001c;t/&$\bnQ8oGV\u0014(/\u001a8u'\u0016<W.\u001a8u\t\u0016dW\r^5p]\"\u00121\r\u0019\u0005\u0006O\u0002!\t\u0001U\u00010i\u0016\u001cHoU5{KR\u0013\u0018.\\7fI\u001a{'\u000f\u0015:fC2dwnY1uK\u0012\fe\u000eZ\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u0015\u0003M\u0002DQA\u001b\u0001\u0005\u0002A\u000bq\u0004^3ti\u0012+\b\u000f\\5dCR,7\t[3dW\u00063G/\u001a:DY\u0016\fg.\u001b8hQ\tI\u0007\rC\u0003n\u0001\u0011\u0005\u0001+A\u0011uKN$()Y:jGR\u0013\u0018M\\:bGRLwN\\!xCJ,7\t\\3b]&tw\r\u000b\u0002mA\")\u0001\u000f\u0001C\u0001!\u0006IC/Z:u\u00072,\u0017M\\,ji\"$&/\u00198tC\u000e$\u0018n\u001c8t'B\fgN\\5oON+w-\\3oiND#a\u001c1\t\u000bM\u0004A\u0011\u0001)\u0002/Q,7\u000f^\"p[6LG/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u0001:a\u0011\u00151\b\u0001\"\u0001Q\u0003\u0011\"Xm\u001d;EK2,G/\u001a3CCR\u001c\u0007.Z:XSRDgj\\'fgN\fw-Z:SK\u0006$\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003\u001d\"Xm\u001d;D_6l\u0017\u000e^'be.,'OU3uK:$\u0018n\u001c8XSRDW)\u001c9us\n\u000bGo\u00195)\u0005a\u0004\u0007\"\u0002?\u0001\t\u0003\u0001\u0016A\u0007;fgR\u001cE.Z1o\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007FA>a\u0011\u0015y\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u0001@a\u0011\u0019\t)\u0001\u0001C\u0001!\u00061C/Z:u\u0003\n|'\u000f^'be.,'OU3uK:$\u0018n\u001c8XSRDW)\u001c9us\n\u000bGo\u00195)\u0007\u0005\r\u0001\r\u0003\u0004\u0002\f\u0001!\t\u0001U\u0001\u0011i\u0016\u001cH\u000fT1sO\u0016lUm]:bO\u0016D3!!\u0003a\u0011\u0019\t\t\u0002\u0001C\u0001!\u0006\u0019C/Z:u\u001b\u0016\u001c8/Y4f\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=NKN\u001c\u0018mZ3TSj,\u0007fAA\bA\"1\u0011q\u0003\u0001\u0005\u0002A\u000bA\u0007^3ti6+7o]1hK2\u000b'oZ3s)\"\fg.T1y\u001b\u0016\u001c8/Y4f'&TXmV5uQ\u000e{'O];qi\"+\u0017\rZ3sQ\r\t)\u0002\u0019\u0005\u0007\u0003;\u0001A\u0011\u0001)\u0002]Q,7\u000f^\"peJ,\b\u000f^'fgN\fw-Z*ju\u0016d\u0015M]4feRC\u0017M\u001c\"zi\u0016\u001c\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004\u00037\u0001\u0007bBA\u0012\u0001\u0011\u0005\u0011QE\u0001'GJ,\u0017\r^3M_\u001e<\u0016\u000e\u001e5NKN\u001c\u0018mZ3t\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=TSj,G\u0003BA\u0014\u0003s\u0001rAUA\u0015\u0003[\t\u0019$C\u0002\u0002,M\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001\f\u00020%\u0019\u0011\u0011\u0007\u0002\u0003\u00071{w\rE\u0002\u0017\u0003kI1!a\u000e\u0003\u000551\u0015m[3PM\u001a\u001cX\r^'ba\"A\u00111HA\u0011\u0001\u0004\ti$\u0001\tmCJ<W-T3tg\u0006<WmU5{KB\u0019!+a\u0010\n\u0007\u0005\u00053KA\u0002J]RDa!!\u0012\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\r\t\u0019\u0005\u0019\u0005\u0007\u0003\u0017\u0002A\u0011\u0001)\u0002'Q,7\u000f\u001e'pO\u000ecW-\u00198feN#\u0018\r^:\t\r\u0005=\u0003\u0001\"\u0001Q\u0003%\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]N\u0004&o\u001c3vG\u0016\u0014H*Y:u'\u0016\fX/\u001a8dK\"\u001a\u0011Q\n1\t\r\u0005U\u0003\u0001\"\u0001Q\u0003e\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]Nd\u0015m\u001d;TKF,XM\\2f\u000bZ,g.\u00134Ue\u0006t7/Y2uS>t\u0017IY8si\u0016$\u0007fAA*A\"1\u00111\f\u0001\u0005\u0002A\u000bq\u0003^3tiB\u000b'\u000f^5bYN+w-\\3oi\u000ecW-\u00198)\u0007\u0005e\u0003\r\u0003\u0004\u0002b\u0001!\t\u0001U\u0001#i\u0016\u001cHo\u00117fC:LgnZ,ji\",fn\u00197fC:\f'\r\\3TK\u000e$\u0018n\u001c8)\u0007\u0005}\u0003\r\u0003\u0004\u0002h\u0001!\t\u0001U\u0001\u000fi\u0016\u001cH\u000fT8h)>\u001cE.Z1oQ\r\t)\u0007\u0019\u0005\u0007\u0003[\u0002A\u0011\u0001)\u0002IQ,7\u000f\u001e'pOR{7\t\\3b]^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D3!a\u001ba\u0011\u0019\t\u0019\b\u0001C\u0001!\u0006yB/Z:u\u00072,\u0017M\\5oO^KG\u000f[+oW\u0016LX\rZ'fgN\fw-Z:)\u0007\u0005E\u0004\rC\u0004\u0002z\u0001!\t!a\u001f\u000211\f7\u000f^(gMN,Go\u001d)fe\n\u000bGo\u00195J]2{w\r\u0006\u0003\u0002~\u0005=\u0005CBA@\u0003\u000b\u000bI)\u0004\u0002\u0002\u0002*\u0019\u00111Q*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C%uKJ\f'\r\\3\u0011\u0007I\u000bY)C\u0002\u0002\u000eN\u0013A\u0001T8oO\"91!a\u001eA\u0002\u00055\u0002bBAJ\u0001\u0011\u0005\u0011QS\u0001\u0013Y\u0006\u001cHoU3rk\u0016t7-Z:J]2{w\r\u0006\u0003\u0002\u0018\u0006u\u0005\u0003CA@\u00033\u000bI)!\u0010\n\t\u0005m\u0015\u0011\u0011\u0002\u0004\u001b\u0006\u0004\bbB\u0002\u0002\u0012\u0002\u0007\u0011Q\u0006\u0005\b\u0003C\u0003A\u0011AAR\u00031ygMZ:fiNLe\u000eT8h)\u0011\ti(!*\t\u000f\r\ty\n1\u0001\u0002.!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0016\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!\u0011QHAW\u0011\u001d\u0019\u0011q\u0015a\u0001\u0003[Aq!!-\u0001\t\u0003\t\u0019,\u0001\bbE>\u0014Ho\u00115fG.$uN\\3\u0015\u0007E\u000b)\f\u0003\u0005\u00028\u0006=\u0006\u0019AA]\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a/\u0002H6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005\r'bAAc\u001d\u00051\u0011\r]1dQ\u0016LA!!3\u0002>\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAg\u0001\u0011\u0005\u0001+\u0001\u000euKN$8\t\\3b]N+w-\\3oiN<\u0016\u000e\u001e5BE>\u0014H\u000fK\u0002\u0002L\u0002Da!a5\u0001\t\u0003\u0001\u0016a\u0005;fgR\u001cVmZ7f]R<%o\\;qS:<\u0007fAAiA\"1\u0011\u0011\u001c\u0001\u0005\u0002A\u000bA\u0005^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001e<\u0016\u000e\u001e5Ta\u0006\u00148/Z(gMN,Go\u001d\u0015\u0004\u0003/\u0004\u0007BBAp\u0001\u0011\u0005\u0001+A\u0016uKN$8+Z4nK:$xI]8va&twMR8mY><\u0018N\\4M_\u0006$wJ\u001a.fe>Le\u000eZ3yQ\r\ti\u000e\u0019\u0005\b\u0003K\u0004A\u0011BAt\u0003E\u0019\u0007.Z2l'\u0016<W.\u001a8u\u001fJ$WM\u001d\u000b\u0004#\u0006%\b\u0002CAv\u0003G\u0004\r!!<\u0002\r\u001d\u0014x.\u001e9t!\u0019\ty(a<\u0002t&!\u0011\u0011_AA\u0005\r\u0019V-\u001d\t\u0007\u0003\u007f\ny/!>\u0011\u0007Y\t90C\u0002\u0002z\n\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\ti\u0010\u0001C\u0001!\u0006\u0011B/Z:u\u0005VLG\u000eZ(gMN,G/T1qQ\r\tY\u0010\u0019\u0005\u0007\u0005\u0007\u0001A\u0011\u0001)\u0002;Q,7\u000f^*fO6,g\u000e^,ji\"|eMZ:fi>3XM\u001d4m_^D3A!\u0001a\u0011\u0019\u0011I\u0001\u0001C\u0001!\u00061B/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eK\u0002\u0003\b\u0001DaAa\u0004\u0001\t\u0003\u0001\u0016a\u0007;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCB4\u0015m[3MCJ<W\rK\u0002\u0003\u000e\u0001DaA!\u0006\u0001\t\u0003\u0001\u0016!\u0007;fgR\u0014U/\u001b7e!\u0006\u0014H/[1m\u001f\u001a47/\u001a;NCBD3Aa\u0005a\u0011\u0019\u0011Y\u0002\u0001C\u0001!\u0006QB/Z:u\u00072,\u0017M\\\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a!\u0011\u00041\t\r\t\u0005\u0002\u0001\"\u0001Q\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002\u0003 \u0001DaAa\n\u0001\t\u0003\u0001\u0016A\u0005;fgR\u001cE.Z1o)>l'm\u001d;p]\u0016D3A!\na\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_\t!b\u001e:ji\u0016$v\u000eT8h)!\tiH!\r\u00034\tm\u0002bB\u0002\u0003,\u0001\u0007\u0011Q\u0006\u0005\t\u0005k\u0011Y\u00031\u0001\u00038\u0005i1.Z=t\u0003:$g+\u00197vKN\u0004b!a \u0002\u0006\ne\u0002c\u0002*\u0002*\u0005u\u0012Q\b\u0005\t\u0005{\u0011Y\u00031\u0001\u0002~\u0005IqN\u001a4tKR\u001cV-\u001d\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003UIgN^1mS\u0012\u001cE.Z1oK\u0012lUm]:bO\u0016$\u0002B!\u0012\u0003R\tU#q\u000b\t\u0005\u0005\u000f\u0012i%\u0004\u0002\u0003J)!!1JA_\u0003\u0019\u0011XmY8sI&!!q\nB%\u00055iU-\\8ssJ+7m\u001c:eg\"A!1\u000bB \u0001\u0004\tI)A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u0005\t\u0005k\u0011y\u00041\u0001\u00038!Q!\u0011\fB !\u0003\u0005\rAa\u0017\u0002\u000b\r|G-Z2\u0011\t\t\u001d#QL\u0005\u0005\u0005?\u0012IEA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005K\n\u0011#\\3tg\u0006<WmV5uQ>3gm]3u)!\u0011)Ea\u001a\u0003x\tm\u0004\u0002\u0003B5\u0005C\u0002\rAa\u001b\u0002\u0007-,\u0017\u0010E\u0003S\u0005[\u0012\t(C\u0002\u0003pM\u0013Q!\u0011:sCf\u00042A\u0015B:\u0013\r\u0011)h\u0015\u0002\u0005\u0005f$X\r\u0003\u0005\u0003z\t\u0005\u0004\u0019\u0001B6\u0003\u00151\u0018\r\\;f\u0011!\u0011iH!\u0019A\u0002\u0005%\u0015AB8gMN,G\u000fC\u0004\u0003d\u0001!IA!!\u0015\u0011\t\u0015#1\u0011BC\u0005\u000fC\u0001B!\u001b\u0003\u0000\u0001\u0007\u0011Q\b\u0005\t\u0005s\u0012y\b1\u0001\u0002>!A!Q\u0010B@\u0001\u0004\tI\tC\u0004\u0003\f\u0002!IA!$\u0002\u000f5\f7.\u001a'pORA\u0011Q\u0006BH\u0005#\u0013)\n\u0003\u0005&\u0005\u0013\u0003\n\u00111\u0001\u001b\u0011%\u0011\u0019J!#\u0011\u0002\u0003\u0007a'\u0001\u0004d_:4\u0017n\u001a\u0005\u000b\u0005/\u0013I\t%AA\u0002\u0005%\u0015!\u0004:fG>4XM]=Q_&tG\u000fC\u0004\u0003\u001c\u0002!IA!(\u0002\u00175\f7.Z\"mK\u0006tWM\u001d\u000b\t\u0005?\u0013)K!+\u00034B\u0019aC!)\n\u0007\t\r&AA\u0004DY\u0016\fg.\u001a:\t\u0011\t\u001d&\u0011\u0014a\u0001\u0003{\t\u0001bY1qC\u000eLG/\u001f\u0005\u000b\u0005W\u0013I\n%AA\u0002\t5\u0016!C2iK\u000e\\Gi\u001c8f!\u0019\u0011&qVA]#&\u0019!\u0011W*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0003B[\u00053\u0003\n\u00111\u0001\u0002>\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007b\u0002B\u0017\u0001\u0011%!\u0011\u0018\u000b\u0007\u0003{\u0012YL!0\t\u000f\r\u00119\f1\u0001\u0002.!A!q\u0018B\\\u0001\u0004\u00119$A\u0002tKFDqA!\u001b\u0001\t\u0013\u0011\u0019\r\u0006\u0003\u0003F\nE\u0007\u0003\u0002Bd\u0005\u001bl!A!3\u000b\u0007\t-g$A\u0002oS>LAAa4\u0003J\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\tM'\u0011\u0019a\u0001\u0003\u0013\u000b!!\u001b3\t\u000f\t-\u0003\u0001\"\u0003\u0003XRq!Q\tBm\u00057\u0014iN!9\u0003l\n=\b\u0002\u0003B5\u0005+\u0004\r!!\u0010\t\u0011\te$Q\u001ba\u0001\u0003{A!Ba8\u0003VB\u0005\t\u0019AAE\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\u000b\u0005G\u0014)\u000e%AA\u0002\t\u0015\u0018!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002S\u0005OL1A!;T\u0005\u0015\u0019\u0006n\u001c:u\u0011)\u0011iO!6\u0011\u0002\u0003\u0007\u0011QH\u0001\tg\u0016\fX/\u001a8dK\"Q!\u0011\u001fBk!\u0003\u0005\r!!\u0010\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011\u001d\u0011)\u0010\u0001C\u0005\u0005o\f1$\u00199qK:$GK]1og\u0006\u001cG/[8oC2\f5\u000fT3bI\u0016\u0014H\u0003\u0003B}\u0007\u0007\u0019)aa\u0002\u0011\u000fI\u0013yKa?\u0003~B1\u0011qPAx\u0003{\u00012A\u0006B\u0000\u0013\r\u0019\tA\u0001\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\r\u0011\u0019\u00101\u0001\u0002.!A!q\u001cBz\u0001\u0004\tI\t\u0003\u0005\u0003d\nM\b\u0019\u0001Bs\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001b\t\u0001$\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3s))\u0011Ipa\u0004\u0004\u0012\rM1Q\u0003\u0005\b\u0007\r%\u0001\u0019AA\u0017\u0011!\u0011yn!\u0003A\u0002\u0005%\u0005\u0002\u0003Br\u0007\u0013\u0001\rA!:\t\u0015\r]1\u0011\u0002I\u0001\u0002\u0004\u0019I\"A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\r\u001161D\u0005\u0004\u0007;\u0019&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007C\u0001A\u0011BB\u0012\u00031\u0019w.\\7ji6\u000b'o[3s)!\u0011)e!\n\u0004(\r%\u0002\u0002\u0003Bp\u0007?\u0001\r!!#\t\u0011\t\r8q\u0004a\u0001\u0005KD!ba\u000b\u0004 A\u0005\t\u0019AAE\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u00040\u0001!Ia!\r\u0002\u0017\u0005\u0014wN\u001d;NCJ\\WM\u001d\u000b\t\u0005\u000b\u001a\u0019d!\u000e\u00048!A!q\\B\u0017\u0001\u0004\tI\t\u0003\u0005\u0003d\u000e5\u0002\u0019\u0001Bs\u0011)\u0019Yc!\f\u0011\u0002\u0003\u0007\u0011\u0011\u0012\u0005\b\u0007w\u0001A\u0011BB\u001f\u00031)g\u000e\u001a+y]6\u000b'o[3s)1\u0011)ea\u0010\u0004B\r\r3QJB(\u0011!\u0011yn!\u000fA\u0002\u0005%\u0005\u0002\u0003Br\u0007s\u0001\rA!:\t\u0011\r\u00153\u0011\ba\u0001\u0007\u000f\n\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\u00119e!\u0013\n\t\r-#\u0011\n\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007\u0002\u0003B?\u0007s\u0001\r!!#\t\u0011\r-2\u0011\ba\u0001\u0003\u0013CqAa\u0013\u0001\t\u0013\u0019\u0019\u0006\u0006\u0004\u0003F\rU3q\u000b\u0005\t\u0005S\u001a\t\u00061\u0001\u0002>!A!\u0011PB)\u0001\u0004\u0011Y\u0007C\u0004\u0004\\\u0001!Ia!\u0018\u0002\u001bUt7.Z=fIJ+7m\u001c:e)\u0011\u0011)ea\u0018\t\u0011\te4\u0011\fa\u0001\u0003{Aqaa\u0019\u0001\t\u0013\u0019)'A\bu_6\u00147\u000f^8oKJ+7m\u001c:e)\u0011\u0011)ea\u001a\t\u0011\t%4\u0011\ra\u0001\u0003{Aqaa\u001b\u0001\t\u0013\u0019i'A\bsK\u000e|g/\u001a:B]\u0012\u001c\u0005.Z2l)\u0019\tica\u001c\u0004r!9!1SB5\u0001\u00041\u0004\u0002CB:\u0007S\u0002\r!! \u0002\u0019\u0015D\b/Z2uK\u0012\\U-_:\t\u0013\r]\u0004!%A\u0005\n\re\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007wRCA!,\u0004~-\u00121q\u0010\t\u0005\u0007\u0003\u001bY)\u0004\u0002\u0004\u0004*!1QQBD\u0003%)hn\u00195fG.,GMC\u0002\u0004\nN\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019iia!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004\u0012\u0002\t\n\u0011\"\u0003\u0004\u0014\u0006)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u001aTCABKU\u0011\tid! \t\u0013\re\u0005!%A\u0005\n\rm\u0015!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u0014\u0016\u00045\ru\u0004\"CBQ\u0001E\u0005I\u0011BBR\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0007KS3ANB?\u0011%\u0019I\u000bAI\u0001\n\u0013\u0019Y+A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIM*\"a!,+\t\u0005%5Q\u0010\u0005\n\u0007c\u0003\u0011\u0013!C\u0005\u0007W\u000b\u0001C]3d_J$G\u0005Z3gCVdG\u000fJ\u001a\t\u0013\rU\u0006!%A\u0005\n\r]\u0016\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IL\u000b\u0003\u0003f\u000eu\u0004\"CB_\u0001E\u0005I\u0011BBJ\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$S\u0007C\u0005\u0004B\u0002\t\n\u0011\"\u0003\u0004\u0014\u0006\u0001\"/Z2pe\u0012$C-\u001a4bk2$HE\u000e\u0005\n\u0007\u000b\u0004\u0011\u0013!C\u0005\u0007\u000f\f!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\"TCABeU\u0011\u0019Ib! \t\u0013\r5\u0007!%A\u0005\n\r-\u0016!F1c_J$X*\u0019:lKJ$C-\u001a4bk2$He\r\u0005\n\u0007#\u0004\u0011\u0013!C\u0005\u0007W\u000bacY8n[&$X*\u0019:lKJ$C-\u001a4bk2$He\r\u0005\n\u0007+\u0004\u0011\u0013!C\u0005\u0007/\fq$\u001b8wC2LGm\u00117fC:,G-T3tg\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IN\u000b\u0003\u0003\\\ru\u0004")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        long x$45 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$44, x$43, x$45);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log2.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log2, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToLong((long)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        Log log2 = new Log(this, deleteStartLatch, deleteCompleteLatch, logProps, topicPartition, producerStateManager){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
                    return;
                }
                throw new IllegalStateException("Log segment deletion timed out");
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), LogConfig$.MODULE$.fromProps($outer.logConfig().originals(), logProps$1), 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, producerStateManager$1, new LogDirFailureChannel(10));
            }
        };
        Thread t = new Thread(this, deleteStartLatch, deleteCompleteLatch, log2){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;
            private final Log log$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset());
                this.log$1.onHighWatermarkIncremented(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                this.log$1 = log$1;
            }
        };
        t.start();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
            log2.roll(log2.roll$default$1());
        }
        Assert.assertEquals((long)3L, (long)log2.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log2.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log2.logSegments(0L, log2.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 0L, log2.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log2, segments, (OffsetMap)offsetMap, 0L, stats);
        Assert.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assert.assertEquals((long)2L, (long)log2.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        long x$48 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$47, x$46, x$48);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log2.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$49 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$50 = this.makeLog$default$1();
        long x$51 = this.makeLog$default$3();
        ObjectRef log2 = ObjectRef.create((Object)this.makeLog(x$50, x$49, x$51));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log2.elem;
        Option x$52 = qual$1.roll$default$1();
        qual$1.roll(x$52);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log2.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log2.elem;
        Option x$56 = qual$2.roll$default$1();
        qual$2.roll(x$56);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$57 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$58 = this.makeLog$default$1();
        long x$59 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$58, x$57, x$59);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)abortedTransactions, (Object)log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$60 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$61 = this.makeLog$default$1();
        long x$62 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$61, x$60, x$62);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log2, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log2.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log2.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log2));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, dirtyOffset, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$63 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$64 = this.makeLog$default$1();
        long x$65 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$64, x$63, x$65);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log2));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$66 = Integer.MAX_VALUE;
        int x$67 = 100;
        Function1<TopicPartition, BoxedUnit> x$68 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$66, x$68, x$67);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$69 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$70 = this.makeLog$default$1();
        long x$71 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$70, x$69, x$71);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$72 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$73 = this.makeLog$default$1();
        long x$74 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$73, x$72, x$74);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log2, 1L, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log2, 2L, producerEpoch);
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.roll(log2.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6})), this.lastOffsetsPerBatchInLog(log2));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 8, 9})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 8, 9})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$75 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$76 = this.makeLog$default$1();
        long x$77 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$76, x$75, x$77);
        short producerEpoch = (short)0;
        log2.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$78 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$79 = this.makeLog$default$1();
        long x$80 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$79, x$78, x$80);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$81 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$82 = this.makeLog$default$1();
        long x$83 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$82, x$81, x$83);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((long)0L, (long)log2.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$84 = Integer.MAX_VALUE;
        int x$85 = 1024;
        Function1<TopicPartition, BoxedUnit> x$86 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$84, x$86, x$85);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$87 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$88 = this.makeLog$default$1();
        long x$89 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$88, x$87, x$89);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$2.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log2.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToLong((long)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testMessageLargerThanMaxMessageSize() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            int x$90 = Integer.MAX_VALUE;
            int x$91 = 1024;
            Function1<TopicPartition, BoxedUnit> x$92 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$90, x$92, x$91);
            cleaner.cleanSegments(log3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log3.logSegments().head()})), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log3).filter((Function1)new Serializable(this, offsetMap2){
                public static final long serialVersionUID = 0L;
                private final FakeOffsetMap offsetMap$1;

                public final boolean apply(long k) {
                    return this.apply$mcZJ$sp(k);
                }

                public boolean apply$mcZJ$sp(long k) {
                    return !this.offsetMap$1.map().containsKey(((Object)BoxesRunTime.boxToLong((long)k)).toString());
                }
                {
                    this.offsetMap$1 = offsetMap$1;
                }
            });
            Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log3));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.seek(16L);
            file.write(255);
            file.close();
            int x$93 = Integer.MAX_VALUE;
            int x$94 = 1024;
            Function1<TopicPartition, BoxedUnit> x$95 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$93, x$95, x$94);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$5;
                private final FakeOffsetMap offsetMap$2;
                private final Cleaner cleaner$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$1.cleanSegments(this.log$5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$5.logSegments().head()})), (OffsetMap)this.offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
                }
                {
                    this.log$5 = log$5;
                    this.offsetMap$2 = offsetMap$2;
                    this.cleaner$1 = cleaner$1;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.setLength(1024L);
            file.close();
            int x$96 = Integer.MAX_VALUE;
            int x$97 = 1024;
            Function1<TopicPartition, BoxedUnit> x$98 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$96, x$98, x$97);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$6;
                private final FakeOffsetMap offsetMap$3;
                private final Cleaner cleaner$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$2.cleanSegments(this.log$6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$6.logSegments().head()})), (OffsetMap)this.offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
                }
                {
                    this.log$6 = log$6;
                    this.offsetMap$3 = offsetMap$3;
                    this.cleaner$2 = cleaner$2;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$99 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$100 = this.makeLog$default$1();
        long x$101 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$100, x$99, x$101);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log2.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        return new Tuple2((Object)log2, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$102 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$103 = this.makeLog$default$1();
        long x$104 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$103, x$102, x$104);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long leo = log2.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$7;

            public final LogAppendInfo apply(int key) {
                return this.log$7.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$tombstoneRecord(key), 0, this.log$7.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        });
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Set keys = LogTest$.MODULE$.keysInLog(log2).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$7) {
                return this.apply$mcZI$sp(x$7);
            }

            public boolean apply$mcZI$sp(int x$7) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToLong((long)x$7));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$105 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$106 = this.makeLog$default$1();
        long x$107 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$106, x$105, x$107);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long initialLogSize = log2.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log2.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$108 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$109 = this.makeLog$default$1();
        long x$110 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$109, x$108, x$110);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 1, 1L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 2, 2L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 3, 3L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, 2L, (short)0, 1, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$111 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$112 = this.makeLog$default$1();
        long x$113 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$112, x$111, x$113);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$114 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$115 = this.makeLog$default$1();
        long x$116 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$115, x$114, x$116);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 3L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 4L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$117 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$118 = this.makeLog$default$1();
        long x$119 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$118, x$117, x$119);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log2.numberOfSegments() <= numCleanableSegments) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log2.logEndOffset() + 1L;
        while (log2.numberOfSegments() < numTotalSegments - 1) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log2).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$9) {
                return this.apply$mcZI$sp(x$9);
            }

            public boolean apply$mcZI$sp(int x$9) {
                return x$9 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$120 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$121 = this.makeLog$default$1();
        long x$122 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$121, x$120, x$122);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$9;

            public final LogAppendInfo apply(int _) {
                return this.log$9.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecorcs$1(), 0, this.log$9.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$9 = log$9;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, log2.activeSegment().baseOffset(), log2.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log2.size() - (long)log2.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$123 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$124 = this.makeLog$default$1();
        long x$125 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$124, x$123, x$125);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$10;

            public final LogAppendInfo apply(int _) {
                return this.log$10.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecords$1(), 0, this.log$10.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$10 = log$10;
            }
        });
        Seq segs = log2.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$10) {
                return x$10.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$11) {
                return x$11.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$126 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$127 = this.makeLog$default$1();
        long x$128 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$127, x$126, x$128);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.unkeyedRecord((int)log2.logEndOffset()), 0, log2.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log2);
        long sizeWithUnkeyedMessages = log2.size();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log2.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log2));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log2.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return batch.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log2) {
        return ((TraversableOnce)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch() && batch.hasProducerId();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$12) {
                        return x$12.hasValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$13) {
                        return x$13.hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Record m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log2) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$14) {
                        return x$14.hasValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record m) {
                        return !m.hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$129 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$130 = this.makeLog$default$1();
        long x$131 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$130, x$129, x$131);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$4.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log2, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$3;
            private final Log log$11;
            private final FakeOffsetMap map$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$3.cleanSegments(this.log$11, ((TraversableOnce)this.log$11.logSegments().take(3)).toSeq(), (OffsetMap)this.map$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$3 = cleaner$3;
                this.log$11 = log$11;
                this.map$4 = map$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$132 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$133 = this.makeLog$default$1();
        long x$134 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$133, x$132, x$134);
        int i = 0;
        while (log2.numberOfSegments() < 10) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), 1, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, 1, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$16) {
                return x$16.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$17) {
                return x$17.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), logSize, Integer.MAX_VALUE, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$18) {
                return x$18.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$19) {
                return x$19.offsetIndex().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, indexSize, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$20) {
                return x$20.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$135 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$136 = this.makeLog$default$1();
        long x$137 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$136, x$135, x$137);
        while (log2.numberOfSegments() == 1) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        MemoryRecords records2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log2.appendAsFollower(records2);
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log2.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)(log2.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$138 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$139 = this.makeLog$default$1();
        long x$140 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$139, x$138, x$140);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log2.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log2.appendAsFollower(record2);
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log2.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log2.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log2.logEndOffset() - 1L - log2.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log2.logSegments().last()).offsetIndex().lastOffset() - log2.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$21) {
                return (Seq)x$21.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$22) {
                        return x$22.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log2.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log2.logEndOffset(), log2, cleaner);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        LogConfig x$141 = config;
        long x$142 = Long.MAX_VALUE;
        File x$143 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$143, x$141, x$142);
        LogSegment segmentWithOverflow = (LogSegment)LogTest$.MODULE$.firstOverflowSegment(log2).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Failed to create log with a segment which has overflowed offsets", new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numSegmentsInitial = log2.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log2).toList();
        MutableList expectedKeysAfterCleaning = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)new Serializable(this, allKeys, expectedKeysAfterCleaning, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final List allKeys$1;
            private final MutableList expectedKeysAfterCleaning$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.expectedKeysAfterCleaning$1.$plus$eq(this.allKeys$1.apply(k - 1));
                this.offsetMap$4.put(this.$outer.kafka$log$LogCleanerTest$$key(BoxesRunTime.unboxToLong((Object)this.allKeys$1.apply(k))), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allKeys$1 = allKeys$1;
                this.expectedKeysAfterCleaning$1 = expectedKeysAfterCleaning$1;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        this.assertThrows((Function0)new Serializable(this, cleaner, log2, segmentWithOverflow, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$15;
            private final LogSegment segmentWithOverflow$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$5.cleanSegments(this.log$15, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.segmentWithOverflow$1})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$15 = log$15;
                this.segmentWithOverflow$1 = segmentWithOverflow$1;
                this.offsetMap$4 = offsetMap$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1202));
        Assert.assertEquals((long)(numSegmentsInitial + 1), (long)log2.logSegments().size());
        Assert.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.logSegments().foreach((Function1)new Serializable(this, cleaner, log2, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$15;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(LogSegment segmentToClean) {
                this.cleaner$5.cleanSegments(this.log$15, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{segmentToClean})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$15 = log$15;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        Assert.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$144 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$145 = this.makeLog$default$1();
        long x$146 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$145, x$144, x$146);
        int messageCount = 0;
        while (log2.numberOfSegments() < 10) {
            Log qual$3 = log2;
            MemoryRecords x$147 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$148 = 0;
            boolean x$149 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$147, x$148, x$149);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$4 = log2;
            MemoryRecords x$150 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$151 = 0;
            boolean x$152 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$150, x$151, x$152);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$5 = log2;
            MemoryRecords x$153 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$154 = 0;
            boolean x$155 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$153, x$154, x$155);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        log2 = this.recoverAndCheck(config, cleanedKeys);
        log2.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$156 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$157 = this.makeLog$default$1();
        long x$158 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$157, x$156, x$158);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log2, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)offsetEnd, (long)map.latestOffset());
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(keyEnd - keyStart), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((String)"Map should contain second value", (long)offsetEnd, (long)map.get(this.kafka$log$LogCleanerTest$$key(1L)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(4, 4, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((long)2L, (long)map.get(this.kafka$log$LogCleanerTest$$key(2L)));
        Assert.assertEquals((long)3L, (long)map.get(this.kafka$log$LogCleanerTest$$key(3L)));
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(4L)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$159 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$160 = this.makeLog$default$1();
        long x$161 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$160, x$159, x$161);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log2.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(Record record) {
                                Assert.assertTrue((boolean)record.hasMagic(this.batch$1.magic()));
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)record.offset(), (long)value);
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Record logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$162 = logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$163 = this.makeLog$default$1();
        long x$164 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$163, x$162, x$164);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$165 = "0".getBytes();
        byte[] x$166 = "0".getBytes();
        long x$167 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$168 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$169 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$165, x$166, x$168, x$167, x$169), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        byte[] x$170 = null;
        byte[] x$171 = "0".getBytes();
        long x$172 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$173 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$174 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$170, x$171, x$173, x$172, x$174), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 1L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$175 = "1".getBytes();
        byte[] x$176 = "1".getBytes();
        long x$177 = this.time().milliseconds();
        CompressionType x$178 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$179 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$175, x$176, x$178, x$177, x$179), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$14;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$23) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$23;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$14.appendAsFollower(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset)).lastOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$14 = log$14;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(Tuple2<Object, Object> kv) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$24) {
                return x$24.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$33 = dir;
        LogConfig x$34 = config;
        long x$35 = 0L;
        long x$36 = recoveryPoint;
        MockScheduler x$37 = this.time().scheduler();
        MockTime x$38 = this.time();
        BrokerTopicStats x$39 = new BrokerTopicStats();
        int x$40 = 3600000;
        int x$41 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$42 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$33, x$34, x$35, x$36, (Scheduler)x$37, x$39, (Time)x$38, x$40, x$41, x$42);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TopicPartition x$25) {
            }
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$13;

            public final long apply(Tuple2<Object, Object> x$26) {
                Tuple2<Object, Object> tuple2 = x$26;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = BoxesRunTime.unboxToLong((Object)this.log$13.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$record(key, value, this.$outer.kafka$log$LogCleanerTest$$record$default$3(), this.$outer.kafka$log$LogCleanerTest$$record$default$4(), this.$outer.kafka$log$LogCleanerTest$$record$default$5(), this.$outer.kafka$log$LogCleanerTest$$record$default$6()), 0, this.log$13.appendAsLeader$default$3()).firstOffset().get());
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$13 = log$13;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer kafka$log$LogCleanerTest$$key(long id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)id)).toString().getBytes());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log2, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log2, producerId, producerEpoch, true);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log2, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return new Serializable(this, log2, producerId, producerEpoch, isTransactional, sequence){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$3;
            private final long producerId$1;
            private final short producerEpoch$1;
            private final boolean isTransactional$1;
            private final IntRef sequence$1;

            public final LogAppendInfo apply(Seq<Object> keys) {
                Seq simpleRecords = (Seq)keys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$appendIdempotentAsLeader$1 $outer;

                    public final SimpleRecord apply(int key) {
                        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        return new SimpleRecord(this.$outer.kafka$log$LogCleanerTest$$anonfun$$$outer().time().milliseconds(), keyBytes, keyBytes);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                MemoryRecords records2 = this.isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                this.sequence$1.elem += simpleRecords.size();
                return this.log$3.appendAsLeader(records2, 0, this.log$3.appendAsLeader$default$3());
            }

            public /* synthetic */ LogCleanerTest kafka$log$LogCleanerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$3 = log$3;
                this.producerId$1 = producerId$1;
                this.producerEpoch$1 = producerEpoch$1;
                this.isTransactional$1 = isTransactional$1;
                this.sequence$1 = sequence$1;
            }
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$180 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$181 = value;
        CompressionType x$182 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$183 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$184 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$181, x$180, x$182, x$183, x$184);
    }

    public long kafka$log$LogCleanerTest$$record$default$3() {
        return -1L;
    }

    public short kafka$log$LogCleanerTest$$record$default$4() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$5() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler(), LogTest$.MODULE$.recoverAndCheck$default$7());
    }

    private final void reloadLog$1(Properties logProps$2, ObjectRef log$2) {
        ((Log)log$2.elem).close();
        LogConfig x$53 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$2);
        long x$54 = 0L;
        File x$55 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$55, x$53, x$54);
    }

    private final void assertAbortedTransactionIndexed$1(Log log$4, long producerId$2) {
        List abortedTxns = log$4.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    private final Seq distinctValuesBySegment$1(Log log$8) {
        return ((TraversableOnce)log$8.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Record record) {
                        return TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$12, Cleaner cleaner$4) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$12, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$5.get(this.$outer.kafka$log$LogCleanerTest$$key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$5 = map$5;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$27 = Double.MAX_VALUE;
        long x$28 = Long.MAX_VALUE;
        MockTime x$29 = this.time();
        boolean x$30 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$31 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$32 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$27, x$28, x$30, x$31, x$32, (Time)x$29);
    }
}

