/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511m\u001c8gS\u001e,\u0012\u0001\u000b\t\u0003%%J!A\u000b\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\bG>tg-[4!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nAB\\;n\u0007\u0006dGNY1dWN,\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001\u001c:!\tIq'\u0003\u00029\u0015\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005ia.^7DC2d'-Y2lg\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001bY1mY\n\f7m\u001b\u000b\u0003m\u0001CQ!Q\u001fA\u0002\t\u000b\u0001B]3ta>t7/\u001a\t\u0003\u0007&s!\u0001R$\u000e\u0003\u0015S!A\u0012\u0003\u0002\u000f9,Go^8sW&\u0011\u0001*R\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tQ5J\u0001\u0005SKN\u0004xN\\:f\u0015\tAU\tC\u0003N\u0001\u0011\u0005a*\u0001\u0007cK\u001a|'/Z'fi\"|G\rF\u00017Q\ta\u0005\u000b\u0005\u0002R)6\t!K\u0003\u0002T?\u0005)!.\u001e8ji&\u0011QK\u0015\u0002\u0007\u0005\u00164wN]3\t\u000b]\u0003A\u0011\u0002-\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0016\u0005e{Fc\u0001.ooB!\u0011bW/l\u0013\ta&B\u0001\u0004UkBdWM\r\t\u0003=~c\u0001\u0001B\u0003a-\n\u0007\u0011MA\u0001U#\t\u0011W\r\u0005\u0002\nG&\u0011AM\u0003\u0002\b\u001d>$\b.\u001b8h!\t1\u0017.D\u0001h\u0015\tA'$\u0001\u0005sKF,Xm\u001d;t\u0013\tQwMA\bBEN$(/Y2u%\u0016\fX/Z:u!\t\u0019E.\u0003\u0002n\u0017\n9!+Z9vKN$\b\"B8W\u0001\u0004\u0001\u0018a\u00022vS2$WM\u001d\t\u0004cRlfB\u00014s\u0013\t\u0019x-A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\t)hOA\u0004Ck&dG-\u001a:\u000b\u0005M<\u0007b\u0002=W!\u0003\u0005\r!_\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0003url\u0011a\u001f\u0006\u0003\rjI!!`>\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\r}\u0004A\u0011BA\u0001\u0003-i\u0017-\u001f2f%\u0016\u001cwN\u001d3\u0015\u0013A\n\u0019!!\u0004\u0002 \u0005\r\u0002bBA\u0003}\u0002\u0007\u0011qA\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004%\u0005%\u0011bAA\u0006\u0005\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\tyA a\u0001\u0003#\tA!^:feB!\u00111CA\r\u001d\rI\u0011QC\u0005\u0004\u0003/Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018)Aq!!\t\u007f\u0001\u0004\t\t\"\u0001\u0005dY&,g\u000e^%e\u0011\u001d\t)C a\u0001\u0003O\tQA^1mk\u0016\u00042!CA\u0015\u0013\r\tYC\u0003\u0002\u0007\t>,(\r\\3\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\u0005AA\u000f\u001b:piRdW\rF\u00067\u0003g\t)$a\u000e\u0002:\u0005u\u0002\u0002CA\u0003\u0003[\u0001\r!a\u0002\t\u0011\u0005=\u0011Q\u0006a\u0001\u0003#A\u0001\"!\t\u0002.\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003w\ti\u00031\u00011\u00039!\bN]8ui2,G+[7f\u001bND\u0001\"a\u0010\u0002.\u0001\u0007\u0011\u0011I\u0001\u001aG\"\fgN\\3m)\"\u0014x\u000e\u001e;mS:<7)\u00197mE\u0006\u001c7\u000eE\u0003\n\u0003\u0007\u0012e'C\u0002\u0002F)\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005\u0001B/Z:u#V|G/\u0019)beNLgn\u001a\u000b\fm\u00055\u0013q\nB\u001b\u0005s\u0011i\u0004\u0003\u0004'\u0003\u000f\u0002\r\u0001\u000b\u0005\t\u0003#\n9\u00051\u0001\u0002T\u000591\r\\5f]R\f\u0004\u0003BA+\u0003/j\u0011\u0001\u0001\u0004\u0007\u00033\u0002A)a\u0017\u0003\u0015U\u001bXM]\"mS\u0016tGoE\u0004\u0002X!\ti&a\u0019\u0011\u0007%\ty&C\u0002\u0002b)\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002\n\u0003KJ1!a\u001a\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\ty!a\u0016\u0003\u0016\u0004%\t!a\u001b\u0016\u0005\u0005E\u0001bCA8\u0003/\u0012\t\u0012)A\u0005\u0003#\tQ!^:fe\u0002B1\"!\t\u0002X\tU\r\u0011\"\u0001\u0002l!Y\u0011QOA,\u0005#\u0005\u000b\u0011BA\t\u0003%\u0019G.[3oi&#\u0007\u0005C\u0006\u0002z\u0005]#Q3A\u0005\u0002\u0005m\u0014AC2p]\u001aLw-V:feV\u0011\u0011Q\u0010\t\u0006\u0013\u0005}\u0014\u0011C\u0005\u0004\u0003\u0003S!AB(qi&|g\u000eC\u0006\u0002\u0006\u0006]#\u0011#Q\u0001\n\u0005u\u0014aC2p]\u001aLw-V:fe\u0002B1\"!#\u0002X\tU\r\u0011\"\u0001\u0002|\u0005q1m\u001c8gS\u001e\u001cE.[3oi&#\u0007bCAG\u0003/\u0012\t\u0012)A\u0005\u0003{\nqbY8oM&<7\t\\5f]RLE\r\t\u0005\b\u001f\u0005]C\u0011AAI))\t\u0019&a%\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\t\u0003\u001f\ty\t1\u0001\u0002\u0012!A\u0011\u0011EAH\u0001\u0004\t\t\u0002\u0003\u0006\u0002z\u0005=\u0005\u0013!a\u0001\u0003{B!\"!#\u0002\u0010B\u0005\t\u0019AA?\u0011!\ti*a\u0016\u0005\u0002\u0005}\u0015aF:b]&$\u0018N_3e\u0007>tg-[4DY&,g\u000e^%e+\t\t\t\u000bE\u0003\n\u0003\u007f\n\u0019\u000b\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\t1\fgn\u001a\u0006\u0003\u0003[\u000bAA[1wC&!\u00111DAT\u0011)\t\u0019,a\u0016\u0002\u0002\u0013\u0005\u0011QW\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002T\u0005]\u0016\u0011XA^\u0003{C!\"a\u0004\u00022B\u0005\t\u0019AA\t\u0011)\t\t#!-\u0011\u0002\u0003\u0007\u0011\u0011\u0003\u0005\u000b\u0003s\n\t\f%AA\u0002\u0005u\u0004BCAE\u0003c\u0003\n\u00111\u0001\u0002~!Q\u0011\u0011YA,#\u0003%\t!a1\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0019\u0016\u0005\u0003#\t9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019NC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\tY.a\u0016\u0012\u0002\u0013\u0005\u00111Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\ty.a\u0016\u0012\u0002\u0013\u0005\u0011\u0011]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019O\u000b\u0003\u0002~\u0005\u001d\u0007BCAt\u0003/\n\n\u0011\"\u0001\u0002b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004BCAv\u0003/\n\t\u0011\"\u0011\u0002n\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a)\t\u0013\u0005E\u0018qKA\u0001\n\u0003y\u0013\u0001\u00049s_\u0012,8\r^!sSRL\bBCA{\u0003/\n\t\u0011\"\u0001\u0002x\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA}\u0003\u007f\u00042!CA~\u0013\r\tiP\u0003\u0002\u0004\u0003:L\b\u0002\u0003\u001e\u0002t\u0006\u0005\t\u0019\u0001\u0019\t\u0015\t\r\u0011qKA\u0001\n\u0003\u0012)!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0001\u0005\u0004\u0003\n\t=\u0011\u0011`\u0007\u0003\u0005\u0017Q1A!\u0004\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u0011YA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011)\"a\u0016\u0002\u0002\u0013\u0005!qC\u0001\tG\u0006tW)];bYR!!\u0011\u0004B\u0010!\rI!1D\u0005\u0004\u0005;Q!a\u0002\"p_2,\u0017M\u001c\u0005\nu\tM\u0011\u0011!a\u0001\u0003sD!Ba\t\u0002X\u0005\u0005I\u0011\tB\u0013\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0019\t\u0015\t%\u0012qKA\u0001\n\u0003\u0012Y#\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u000b\u0003\u0006\u00030\u0005]\u0013\u0011!C!\u0005c\ta!Z9vC2\u001cH\u0003\u0002B\r\u0005gA\u0011B\u000fB\u0017\u0003\u0003\u0005\r!!?\t\u0011\t]\u0012q\ta\u0001\u0003'\nqa\u00197jK:$(\u0007\u0003\u0005\u0003<\u0005\u001d\u0003\u0019AA*\u00031\u0011\u0018M\u001c3p[\u000ec\u0017.\u001a8u\u0011!\u0011y$a\u0012A\u0002\u0005M\u0013a\u00053fM\u0006,H\u000e^\"p]\u001aLwm\u00117jK:$\bB\u0002B\"\u0001\u0011\u0005a*\u0001\ruKN$8\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001eDCA!\u0011\u0003HA\u0019\u0011K!\u0013\n\u0007\t-#K\u0001\u0003UKN$\bB\u0002B(\u0001\u0011\u0005a*\u0001\u000buKN$Xk]3s#V|G/\u0019)beNLgn\u001a\u0015\u0005\u0005\u001b\u00129\u0005\u0003\u0004\u0003V\u0001!\tAT\u0001\u001di\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\u0011\u0011\u0019Fa\u0012\t\r\tm\u0003\u0001\"\u0001O\u00031\"Xm\u001d;Vg\u0016\u0014\u0018+^8uCB\u000b'o]5oO^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\r\u000b\u0003\u0003Z\t\u001d\u0003B\u0002B1\u0001\u0011\u0005a*\u0001\u001buKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018\rU1sg&tw-\u00133XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006DCAa\u0018\u0003H!1!q\r\u0001\u0005\u00029\u000b\u0011\u0004^3tiF+x\u000e^1D_:4\u0017n\u001a)sK\u000e,G-\u001a8dK\"\"!Q\rB$\u0011\u0019\u0011i\u0007\u0001C\u0001\u001d\u0006\u0011B/Z:u#V|G/\u0019,j_2\fG/[8oQ\u0011\u0011YGa\u0012\t\r\tM\u0004\u0001\"\u0001O\u0003\r\"Xm\u001d;SKF,Xm\u001d;QKJ\u001cWM\u001c;bO\u0016\fVo\u001c;b-&|G.\u0019;j_:DCA!\u001d\u0003H!1!\u0011\u0010\u0001\u0005\u00029\u000bA\u0004^3ti\u0016C\b/\u001b:f)\"\u0014x\u000e\u001e;mKRKW.Z*f]N|'\u000f\u000b\u0003\u0003x\t\u001d\u0003B\u0002B@\u0001\u0011\u0005a*\u0001\fuKN$X\t\u001f9je\u0016\fVo\u001c;b'\u0016t7o\u001c:tQ\u0011\u0011iHa\u0012\t\r\t\u0015\u0005\u0001\"\u0001O\u0003a!Xm\u001d;DY&,g\u000e^%e\u001d>$8+\u00198ji&TX\r\u001a\u0015\u0005\u0005\u0007\u00139\u0005C\u0004\u0003\f\u0002!\tA!$\u0002\u00159,w/T3ue&\u001c7/\u0006\u0002\u0003\u0010B!!\u0011\u0013BL\u001b\t\u0011\u0019JC\u0002\u0003\u0016j\tq!\\3ue&\u001c7/\u0003\u0003\u0003\u001a\nM%aB'fiJL7m]\u0004\n\u0005;\u0003\u0011\u0011!E\u0005\u0005?\u000b!\"V:fe\u000ec\u0017.\u001a8u!\u0011\t)F!)\u0007\u0013\u0005e\u0003!!A\t\n\t\r6C\u0002BQ\u0005K\u000b\u0019\u0007\u0005\b\u0003(\n5\u0016\u0011CA\t\u0003{\ni(a\u0015\u000e\u0005\t%&b\u0001BV\u0015\u00059!/\u001e8uS6,\u0017\u0002\u0002BX\u0005S\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85\u0011\u001dy!\u0011\u0015C\u0001\u0005g#\"Aa(\t\u0015\t%\"\u0011UA\u0001\n\u000b\u0012Y\u0003\u0003\u0006\u0003:\n\u0005\u0016\u0011!CA\u0005w\u000bQ!\u00199qYf$\"\"a\u0015\u0003>\n}&\u0011\u0019Bb\u0011!\tyAa.A\u0002\u0005E\u0001\u0002CA\u0011\u0005o\u0003\r!!\u0005\t\u0015\u0005e$q\u0017I\u0001\u0002\u0004\ti\b\u0003\u0006\u0002\n\n]\u0006\u0013!a\u0001\u0003{B!Ba2\u0003\"\u0006\u0005I\u0011\u0011Be\u0003\u001d)h.\u00199qYf$BAa3\u0003TB)\u0011\"a \u0003NBY\u0011Ba4\u0002\u0012\u0005E\u0011QPA?\u0013\r\u0011\tN\u0003\u0002\u0007)V\u0004H.\u001a\u001b\t\u0015\tU'QYA\u0001\u0002\u0004\t\u0019&A\u0002yIAB!B!7\u0003\"F\u0005I\u0011AAq\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bo\u0005C\u000b\n\u0011\"\u0001\u0002b\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003b\n\u0005\u0016\u0013!C\u0001\u0003C\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bs\u0005C\u000b\n\u0011\"\u0001\u0002b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB\u0011B!;\u0001#\u0003%IAa;\u0002-\t,\u0018\u000e\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*BA!<\u0003rV\u0011!q\u001e\u0016\u0004s\u0006\u001dGA\u00021\u0003h\n\u0007\u0011\r")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;
    private volatile ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.kafka$server$ClientQuotaManagerTest$$UserClient$module != null) return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
            this.kafka$server$ClientQuotaManagerTest$$UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
        }
    }

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2;
        block4: {
            block3: {
                block2: {
                    response2 = response;
                    if (!(response2 instanceof RequestChannel.StartThrottlingResponse)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(response2 instanceof RequestChannel.EndThrottlingResponse)) break block4;
                this.numCallbacks_$eq(this.numCallbacks() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)response2);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public int kafka$server$ClientQuotaManagerTest$$maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 != null) {
            RequestChannel.Request request;
            RequestChannel.Request request2;
            RequestChannel.Request request3 = request2 = (request = (RequestChannel.Request)tuple2._2());
            quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder().append((Object)"Default producer quota should be ").append((Object)BoxesRunTime.boxToLong((long)config.quotaBytesPerSecondDefault())).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRequestPercentageQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0)));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                    Assert.assertEquals((long)1000L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$2, "ANONYMOUS", "test-client", 0.0));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientIdNotSanitized() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = metrics.getSensor(new StringBuilder().append((Object)"ProduceThrottleTime-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor(new StringBuilder().append((Object)"Produce-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    }

    public ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient() {
        return this.kafka$server$ClientQuotaManagerTest$$UserClient$module == null ? this.kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() : this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager$1.quota(user, clientId).bound(), (double)0.0);
        int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager$1, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    public final double kafka$server$ClientQuotaManagerTest$$millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    String string = x;
                    String string2 = ConfigEntityName$.MODULE$.Default();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
                }
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.configClientId();
                    break;
                }
                case 2: {
                    object = this.configUser();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.user();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

