/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u000f\tQB)Z:de&\u0014W\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0006m_\u001e$\u0015N]\"pk:$X#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u0007%sG\u000f\u0003\u0004\u001b\u0001\u0001\u0006IaE\u0001\rY><G)\u001b:D_VtG\u000f\t\u0005\b9\u0001\u0011\r\u0011\"\u0011\u0013\u0003)qW/\u001c\"s_.,'o\u001d\u0005\u0007=\u0001\u0001\u000b\u0011B\n\u0002\u00179,XN\u0011:pW\u0016\u00148\u000f\t\u0005\bA\u0001\u0011\r\u0011\"\u0001\"\u0003\u0015!x\u000e]5d+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\nAA[1wC&\u0011\u0011\u0006\n\u0002\u0007'R\u0014\u0018N\\4\t\r-\u0002\u0001\u0015!\u0003#\u0003\u0019!x\u000e]5dA!9Q\u0006\u0001b\u0001\n\u0003\u0011\u0012\u0001\u00049beRLG/[8o\u001dVl\u0007BB\u0018\u0001A\u0003%1#A\u0007qCJ$\u0018\u000e^5p]:+X\u000e\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003\r!\b\u000fM\u000b\u0002gA\u0011A\u0007P\u0007\u0002k)\u0011agN\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015A$BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001eL!!P\u001b\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1q\b\u0001Q\u0001\nM\nA\u0001\u001e91A!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0014a\u0001;qc!11\t\u0001Q\u0001\nM\nA\u0001\u001e92A!)Q\t\u0001C\u0001\r\u0006QB/Z:u\t\u0016\u001c8M]5cK2{w\rR5sgJ+\u0017/^3tiR\tq\t\u0005\u0002\u0015\u0011&\u0011\u0011*\u0006\u0002\u0005+:LG\u000f\u000b\u0002E\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJO\u0001\u0006UVt\u0017\u000e^\u0005\u0003!6\u0013A\u0001V3ti\u0002")
public class DescribeLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int numBrokers;
    private final String topic;
    private final int partitionNum;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int numBrokers() {
        return this.numBrokers;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionNum() {
        return this.partitionNum;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    @Test
    public void testDescribeLogDirsRequest() {
        String onlineDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$1 = offlineDir;
        boolean x$2 = qual$1.handleLogDirFailure$default$2();
        qual$1.handleLogDirFailure(x$1, x$2);
        this.createTopic(this.topic(), this.partitionNum(), 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        DescribeLogDirsRequest request = (DescribeLogDirsRequest)new DescribeLogDirsRequest.Builder(null).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DESCRIBE_LOG_DIRS, this.controllerSocketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        Map logDirInfos = DescribeLogDirsResponse.parse((ByteBuffer)response, (short)request.version()).logDirInfos();
        Assert.assertEquals((long)this.logDirCount(), (long)logDirInfos.size());
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).error);
        Assert.assertEquals((long)0L, (long)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).replicaInfos.size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).error);
        DescribeLogDirsResponse.ReplicaInfo replicaInfo0 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp0());
        DescribeLogDirsResponse.ReplicaInfo replicaInfo1 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp1());
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$3 = this.tp0();
        boolean x$4 = qual$2.getLog$default$2();
        Log log0 = (Log)qual$2.getLog(x$3, x$4).get();
        LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$5 = this.tp1();
        boolean x$6 = qual$3.getLog$default$2();
        Log log1 = (Log)qual$3.getLog(x$5, x$6).get();
        Assert.assertEquals((long)log0.size(), (long)replicaInfo0.size);
        Assert.assertEquals((long)log1.size(), (long)replicaInfo1.size);
        LogManager qual$4 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$7 = this.tp0();
        boolean x$8 = qual$4.getLog$default$2();
        Assert.assertTrue((((Log)qual$4.getLog(x$7, x$8).get()).logEndOffset() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp0(), log0.logEndOffset(), false), (long)replicaInfo0.offsetLag);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp1(), log1.logEndOffset(), false), (long)replicaInfo1.offsetLag);
    }

    public DescribeLogDirsRequestTest() {
        this.logDirCount = 2;
        this.numBrokers = 1;
        this.topic = "topic";
        this.partitionNum = 2;
    }
}

