/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.cluster.Broker;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.MetadataCacheTest$$anonfun$getTopicMetadata$1$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u000f\t\tR*\u001a;bI\u0006$\u0018mQ1dQ\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#A\u0011hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC:{g.\u0012=jgRLgn\u001a+pa&\u001c7\u000fF\u0001\u0017!\tIq#\u0003\u0002\u0019\u0015\t!QK\\5uQ\t\u0019\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\t!F\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006D#A\t\u000e\t\u000b\u0019\u0002A\u0011A\u000b\u0002W\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016D#!\n\u000e\t\u000b%\u0002A\u0011A\u000b\u0002k\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'jgR,g.\u001a:O_R\fe/Y5mC\ndWm\u00148MK\u0006$WM\u001d\u0015\u0003QiAQ\u0001\f\u0001\u0005\u0002U\tqiZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]2K7\u000f^3oKJtu\u000e^!wC&d\u0017M\u00197f\u001f:dU-\u00193fe>cG-T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003WiAQa\f\u0001\u0005\nA\n\u0001H^3sS\u001aLHk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014xJ]#oIB|\u0017N\u001c;O_R\fe/Y5mC\ndW\r\u0006\u0004\u0017cUk&M\u001b\u0005\u0006e9\u0002\raM\u0001\bEJ|7.\u001a:t!\r!tG\u000f\b\u0003\u0013UJ!A\u000e\u0006\u0002\rA\u0013X\rZ3g\u0013\tA\u0014HA\u0002TKRT!A\u000e\u0006\u0011\u0005m\u0012fB\u0001\u001fP\u001d\tiDJ\u0004\u0002?\u0013:\u0011qh\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!a\u0011\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012B\u0001$\u001f\u0003\u0019\t\u0007/Y2iK&\u0011Q\u0001\u0013\u0006\u0003\rzI!AS&\u0002\r\r|W.\\8o\u0015\t)\u0001*\u0003\u0002N\u001d\u0006A!/Z9vKN$8O\u0003\u0002K\u0017&\u0011\u0001+U\u0001\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0015\tie*\u0003\u0002T)\n1!I]8lKJT!\u0001U)\t\u000bYs\u0003\u0019A,\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\u0005a[V\"A-\u000b\u0005is\u0015a\u00028fi^|'o[\u0005\u00039f\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016DQA\u0018\u0018A\u0002}\u000ba\u0001\\3bI\u0016\u0014\bCA\u0005a\u0013\t\t'BA\u0002J]RDQa\u0019\u0018A\u0002\u0011\fQ\"\u001a=qK\u000e$X\rZ#se>\u0014\bCA3i\u001b\u00051'BA4O\u0003!\u0001(o\u001c;pG>d\u0017BA5g\u0005\u0019)%O]8sg\")1N\fa\u0001Y\u0006IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t!\tIQ.\u0003\u0002o\u0015\t9!i\\8mK\u0006t\u0007\"\u00029\u0001\t\u0003)\u0012aI4fiR{\u0007/[2NKR\fG-\u0019;b%\u0016\u0004H.[2b\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0003_jAQa\u001d\u0001\u0005\u0002U\tqdZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1JgJtu\u000e^!wC&d\u0017M\u00197fQ\t\u0011(\u0004C\u0003w\u0001\u0011\u0005Q#\u0001\u0019hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC^KG\u000f\u001b(p]N+\b\u000f]8si\u0016$7+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0015\u0003kjAQ!\u001f\u0001\u0005\u0002U\tafZ3u\u00032Lg/\u001a\"s_.,'o]*i_VdGMT8u\u0005\u0016lU\u000f^1uK\u0012\u0014\u00150\u00169eCR,7)Y2iK\"\u0012\u0001P\u0007")
public class MetadataCacheTest {
    @Test
    public void getTopicMetadataNonExistingTopics() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertTrue((boolean)topicMetadata.isEmpty());
    }

    @Test
    public void getTopicMetadata() {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        scala.collection.immutable.Set brokers = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                return new UpdateMetadataRequest.Broker(brokerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.$outer.kafka$server$MetadataCacheTest$$endPoints$1(brokerId)).asJava(), "rack1");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic0, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 0, 0, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), Arrays.asList((Object[])new Integer[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic0, 1)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 1, 1, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 2, 2, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}))).foreach((Function1)new Serializable(this, topic0, topic1, cache, partitionStates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;
            private final String topic0$1;
            private final String topic1$1;
            private final MetadataCache cache$1;
            private final scala.collection.immutable.Map partitionStates$1;

            public final void apply(SecurityProtocol securityProtocol) {
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                this.checkTopicMetadata$1(this.topic0$1, listenerName);
                this.checkTopicMetadata$1(this.topic1$1, listenerName);
            }

            public /* synthetic */ MetadataCacheTest kafka$server$MetadataCacheTest$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkTopicMetadata$1(String topic, ListenerName listenerName$1) {
                Seq topicMetadatas = this.cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, this.cache$1.getTopicMetadata$default$3(), this.cache$1.getTopicMetadata$default$4());
                Assert.assertEquals((long)1L, (long)topicMetadatas.size());
                MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
                Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
                Assert.assertEquals((Object)topic, (Object)topicMetadata.topic());
                scala.collection.immutable.Map topicPartitionStates = (scala.collection.immutable.Map)this.partitionStates$1.filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState> x0$1) {
                        Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState> tuple2 = x0$1;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            String string = tp.topic();
                            String string2 = this.topic$1;
                            boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                });
                Buffer partitionMetadatas = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MetadataResponse.PartitionMetadata x$1) {
                        return x$1.partition();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected partition count for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (long)topicPartitionStates.size(), (long)partitionMetadatas.size());
                ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, listenerName$1, topic, topicPartitionStates){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTopicMetadata$1 $outer;
                    public final ListenerName listenerName$1;
                    private final String topic$1;
                    private final scala.collection.immutable.Map topicPartitionStates$1;

                    public final void apply(Tuple2<MetadataResponse.PartitionMetadata, Object> x0$2) {
                        Tuple2<MetadataResponse.PartitionMetadata, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)tuple2._1();
                            int partitionId = tuple2._2$mcI$sp();
                            Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
                            Assert.assertEquals((long)partitionId, (long)partitionMetadata.partition());
                            Node leader2 = partitionMetadata.leader();
                            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)this.topicPartitionStates$1.apply((Object)new TopicPartition(this.topic$1, partitionId));
                            Assert.assertEquals((long)partitionState.basePartitionState.leader, (long)leader2.id());
                            Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)partitionState.basePartitionState.leaderEpoch)), (Object)partitionMetadata.leaderEpoch());
                            Assert.assertEquals((Object)partitionState.basePartitionState.isr, (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$2) {
                                    return x$2.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            Assert.assertEquals((Object)partitionState.basePartitionState.replicas, (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$3) {
                                    return x$3.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            UpdateMetadataRequest.EndPoint endPoint = (UpdateMetadataRequest.EndPoint)this.$outer.kafka$server$MetadataCacheTest$$anonfun$$$outer().kafka$server$MetadataCacheTest$$endPoints$1(partitionMetadata.leader().id()).find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getTopicMetadata$1$$anonfun$checkTopicMetadata$1$1 $outer;

                                public final boolean apply(UpdateMetadataRequest.EndPoint x$4) {
                                    ListenerName listenerName = x$4.listenerName;
                                    ListenerName listenerName2 = this.$outer.listenerName$1;
                                    return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).get();
                            Assert.assertEquals((Object)endPoint.host, (Object)leader2.host());
                            Assert.assertEquals((long)endPoint.port, (long)leader2.port());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.listenerName$1 = listenerName$1;
                        this.topic$1 = topic$1;
                        this.topicPartitionStates$1 = topicPartitionStates$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic0$1 = topic0$1;
                this.topic1$1 = topic1$1;
                this.cache$1 = cache$1;
                this.partitionStates$1 = partitionStates$1;
            }
        });
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host0", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName), new UpdateMetadataRequest.EndPoint("host0", 9093, SecurityProtocol.SSL, sslListenerName)}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host1", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName)}));
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava(), null), new UpdateMetadataRequest.Broker(1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeaderOldMetadataVersion() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host0", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName), new UpdateMetadataRequest.EndPoint("host0", 9093, SecurityProtocol.SSL, sslListenerName)}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host1", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName)}));
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava(), null), new UpdateMetadataRequest.Broker(1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(scala.collection.immutable.Set<UpdateMetadataRequest.Broker> brokers, ListenerName listenerName, int leader2, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        scala.collection.immutable.Set x$14 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        ListenerName x$15 = listenerName;
        boolean x$16 = errorUnavailableListeners;
        boolean x$17 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$14, x$15, x$17, x$16);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)expectedError, (Object)partitionMetadata.error());
        Assert.assertTrue((boolean)partitionMetadata.isr().isEmpty());
        Assert.assertEquals((long)1L, (long)partitionMetadata.replicas().size());
        Assert.assertEquals((long)0L, (long)((Node)partitionMetadata.replicas().get(0)).id());
    }

    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), null)}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, zkVersion, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$5) {
                return x$5.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$6) {
                return x$6.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$7) {
                return x$7.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataIsrNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), "rack1")}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, zkVersion, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$9) {
                return x$9.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$10) {
                return x$10.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$11) {
                return x$11.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$12) {
                return x$12.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), "")}));
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 3, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadata.size());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().size());
        Assert.assertEquals((long)-1L, (long)((MetadataResponse.PartitionMetadata)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().get(0)).leaderId());
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        scala.collection.immutable.Set initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).toSet();
        this.updateCache$1(initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), topic, cache);
        Assert.assertEquals((Object)initialBrokerIds, (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$13) {
                return x$13.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public final Seq kafka$server$MetadataCacheTest$$endPoints$1(int brokerId) {
        String host = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)}));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint(host, 9092, SecurityProtocol.PLAINTEXT, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)), new UpdateMetadataRequest.EndPoint(host, 9093, SecurityProtocol.SSL, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL))}));
    }

    private final void updateCache$1(scala.collection.immutable.Set brokerIds, String topic$2, MetadataCache cache$2) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                return new UpdateMetadataRequest.Broker(brokerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), "");
            }
        }, Set$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic$2, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 3, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache$2.updateMetadata(15, updateMetadataRequest);
    }
}

