/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$4$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rUc\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0006\u0001)Q\u0005\u007f\u0005I!p[\"mS\u0016tG\u000f\t\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000bQb[1gW\u0006T6n\u00117jK:$X#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]#\u0011A\u0001>l\u0013\tIfKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\n7\u0002\u0001\r\u00111A\u0005\u0002q\u000b\u0011c[1gW\u0006T6n\u00117jK:$x\fJ3r)\tQU\fC\u0004O5\u0006\u0005\t\u0019\u0001+\t\r}\u0003\u0001\u0015)\u0003U\u00039Y\u0017MZ6b5.\u001cE.[3oi\u0002Bq!\u0019\u0001C\u0002\u0013\u0005!-A\u0005{WZ+'o]5p]V\t1\r\u0005\u0002\nI&\u0011QM\u0003\u0002\u0004\u0013:$\bBB4\u0001A\u0003%1-\u0001\u0006{WZ+'o]5p]\u0002Bq!\u001b\u0001C\u0002\u0013\u0005!-A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B2\u0002\u001d\r|'O]3mCRLwN\\%eA!9Q\u000e\u0001a\u0001\n\u0003\u0011\u0017aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f=\u0004\u0001\u0019!C\u0001a\u0006\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0011!*\u001d\u0005\b\u001d:\f\t\u00111\u0001d\u0011\u0019\u0019\b\u0001)Q\u0005G\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\u0006k\u0002!\tA^\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0015\"\u0012A\u000f\u001f\t\u0003srl\u0011A\u001f\u0006\u0003wZ\nQA[;oSRL!! >\u0003\r\t+gm\u001c:f\u0011\u0015y\b\u0001\"\u0001w\u0003!!X-\u0019:E_^t\u0007f\u0001@\u0002\u0004A\u0019\u00110!\u0002\n\u0007\u0005\u001d!PA\u0003BMR,'\u000f\u0003\u0004\u0002\f\u0001!\tA^\u0001\"i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:NCJ\\G)\u001b:fGR|'/_'baBLgn\u001a\u0015\u0005\u0003\u0013\ty\u0001E\u0002z\u0003#I1!a\u0005{\u0005\u0011!Vm\u001d;\t\r\u0005]\u0001\u0001\"\u0001w\u0003%\"Xm\u001d;IS\u001eDw/\u0019;fe6\u000b'o\u001b*fY\u0006$\u0018N^3ESJ,7\r^8ss6\u000b\u0007\u000f]5oO\"\"\u0011QCA\b\u0011\u0019\ti\u0002\u0001C\u0001m\u00069B/Z:u\u00132dWmZ1m%\u0016\fX/\u001b:fI\u0006\u001b7n\u001d\u0015\u0005\u00037\ty\u0001\u0003\u0004\u0002$\u0001!\tA^\u0001%i\u0016\u001cHo\u00117fCJ\u0004VO]4bi>\u0014\u0018p\u00148CK\u000e|W.\u001b8h\r>dGn\\<fe\"\"\u0011\u0011EA\b\u0011\u0019\tI\u0003\u0001C\u0001m\u0006AD/Z:u%\u0016\u001cW-\u001b<f\u001fV$xJZ(sI\u0016\u00148+Z9vK:\u001cW-\u0012=dKB$\u0018n\u001c8XSRDGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0006BA\u0014\u0003\u001fAa!a\f\u0001\t\u00031\u0018A\t;fgR\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u001a+Go\u00195MS6LG/\u001a3Bi2\u001bv\n\u000b\u0003\u0002.\u0005=\u0001BBA\u001b\u0001\u0011\u0005a/A\u0016uKN$H)\u001a7bs\u0016$g)\u001a;dQ&s7\r\\;eKN\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8tQ\u0011\t\u0019$a\u0004\t\r\u0005m\u0002\u0001\"\u0001w\u0003=\"Xm\u001d;GKR\u001c\u0007NQ3z_:$\u0007*[4i/\u0006$XM]7be.\u0014V\r^;s]\u0016k\u0007\u000f^=SKN\u0004xN\\:fQ\u0011\tI$a\u0004\t\r\u0005\u0005\u0003\u0001\"\u0001w\u0003=\"Xm\u001d;GKR\u001c\u0007.T3tg\u0006<Wm],iK:tu\u000e\u001e$pY2|w/\u001a:G_J|e.\u001a)beRLG/[8oQ\u0011\ty$a\u0004\t\r\u0005\u001d\u0003\u0001\"\u0001w\u0003q\"Xm\u001d;CK\u000e|W.\u001a$pY2|w/\u001a:XQ\u0016tG*Z1eKJL5/\u00168dQ\u0006tw-\u001a3CkRl\u0015n]:fI2+\u0017\rZ3s+B$\u0017\r^3)\t\u0005\u0015\u0013q\u0002\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003\t\u0002(/\u001a9be\u0016\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\fe\u000e\u001a'pO6\u000bg.Y4feRq\u0011\u0011KA5\u0003[\n\t(!\u001e\u0002z\u00055\u0005cB\u0005\u0002T\u0005]\u0013QL\u0005\u0004\u0003+R!A\u0002+va2,'\u0007E\u0002\u0013\u00033J1!a\u0017\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\"\u0011a\u00017pO&!\u0011qMA1\u0005)aunZ'b]\u0006<WM\u001d\u0005\b\u0003W\nY\u00051\u0001d\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u001c\u0002L\u0001\u00071-A\rmK\u0006$WM]#q_\u000eD\u0017J\u001c'fC\u0012,'/\u00118e\u0013N\u0014\bbBA:\u0003\u0017\u0002\raY\u0001\u0011M>dGn\\<fe\n\u0013xn[3s\u0013\u0012Dq!a\u001e\u0002L\u0001\u00071-\u0001\bmK\u0006$WM\u001d\"s_.,'/\u00133\t\u0011\u0005m\u00141\na\u0001\u0003{\nabY8v]R$un\u001e8MCR\u001c\u0007\u000e\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\bj\tA!\u001e;jY&!\u00111RAA\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a$\u0002L\u0001\u0007\u0011\u0011S\u0001\u0011Kb\u0004Xm\u0019;UeVt7-\u0019;j_:\u00042!CAJ\u0013\r\t)J\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\n\u0001C\u0005\u00037\u000b!\u0004\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\u0002\"!(\u00022\u0006U\u0016q\u0017\t\u0005\u0003?\u000bYK\u0004\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)+M\u0001\te\u0016\fX/Z:ug&!\u0011\u0011VAR\u0003MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0013\u0011\ti+a,\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011\u0011VAR\u0011\u001d\t\u0019,a&A\u0002\r\f1\u0002\\3bI\u0016\u0014X\t]8dQ\"9\u0011qOAL\u0001\u0004\u0019\u0007\u0002CA]\u0003/\u0003\r!a/\u0002\u001d\u0005d\u0017N^3Ce>\\WM]%egB1\u0011QXAg\u0003'tA!a0\u0002J:!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0007\u0005-'\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0017\u0011\u001b\u0002\u0004'\u0016\f(bAAf\u0015A\u0019q#!6\n\u0007\u0005]\u0007DA\u0004J]R,w-\u001a:\u0007\r\u0005m\u0007\u0001BAo\u00059\u0019\u0015\r\u001c7cC\u000e\\'+Z:vYR,B!a8\u0002nN\u0019\u0011\u0011\u001c\u0005\t\u000f=\tI\u000e\"\u0001\u0002dR\u0011\u0011Q\u001d\t\u0007\u0003O\fI.!;\u000e\u0003\u0001\u0001B!a;\u0002n2\u0001A\u0001CAx\u00033\u0014\r!!=\u0003\u0003Q\u000bB!a=\u0002zB\u0019\u0011\"!>\n\u0007\u0005](BA\u0004O_RD\u0017N\\4\u0011\u0007%\tY0C\u0002\u0002~*\u00111!\u00118z\u0011)\u0011\t!!7A\u0002\u0013%!1A\u0001\u0006m\u0006dW/Z\u000b\u0003\u0005\u000b\u0001R!\u0003B\u0004\u0003SL1A!\u0003\u000b\u0005\u0019y\u0005\u000f^5p]\"Q!QBAm\u0001\u0004%IAa\u0004\u0002\u0013Y\fG.^3`I\u0015\fHc\u0001&\u0003\u0012!IaJa\u0003\u0002\u0002\u0003\u0007!Q\u0001\u0005\n\u0005+\tI\u000e)Q\u0005\u0005\u000b\taA^1mk\u0016\u0004\u0003B\u0003B\r\u00033\u0004\r\u0011\"\u0003\u0003\u001c\u0005\u0019a-\u001e8\u0016\u0005\tu\u0001#B\u0005\u0003\b\t}\u0001CB\u0005\u0003\"\u0005%(*C\u0002\u0003$)\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\t\u001d\u0012\u0011\u001ca\u0001\n\u0013\u0011I#A\u0004gk:|F%Z9\u0015\u0007)\u0013Y\u0003C\u0005O\u0005K\t\t\u00111\u0001\u0003\u001e!I!qFAmA\u0003&!QD\u0001\u0005MVt\u0007\u0005\u0003\u0005\u00034\u0005eG\u0011\u0001B\u001b\u0003-\t7o]3si\u001aK'/\u001a3\u0016\u0005\u0005%\b\u0002\u0003B\u001d\u00033$\tAa\u000f\u0002\u000f%\u001ch)\u001b:fIV\u0011\u0011\u0011\u0013\u0005\t\u0005\u007f\tI\u000e\"\u0001\u0003B\u0005!a-\u001b:f)\rQ%1\t\u0005\t\u0005\u0003\u0011i\u00041\u0001\u0002j\"A!qIAm\t\u0003\u0011I%\u0001\u0004p]\u001aK'/\u001a\u000b\u0005\u0003K\u0014Y\u0005\u0003\u0005\u0003\u001a\t\u0015\u0003\u0019\u0001B\u0010\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\nQ\"\u00199qK:$'+Z2pe\u0012\u001cH\u0003\u0004B*\u0005o\u0012YHa\"\u0003\u0018\nm\u0005CBAt\u00033\u0014)\u0006\u0005\u0003\u0003X\tEd\u0002\u0002B-\u0005[rAAa\u0017\u0003l9!!Q\fB5\u001d\u0011\u0011yFa\u001a\u000f\t\t\u0005$Q\r\b\u0005\u0003\u0003\u0014\u0019'C\u00018\u0013\t)d'\u0003\u0002\u0006i%\u0011!gM\u0005\u0004\u0003K\u000b\u0014\u0002\u0002B8\u0003G\u000bq\u0002\u0015:pIV\u001cWMU3ta>t7/Z\u0005\u0005\u0005g\u0012)HA\tQCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TAAa\u001c\u0002$\"A!\u0011\u0010B'\u0001\u0004\t9&\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\t\u0011\tu$Q\na\u0001\u0005\u007f\n\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\t\u0005%1Q\u0007\u0002c%\u0019!QQ\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A!\u0011\u0012B'\u0001\u0004\u0011Y)A\u0004sK\u000e|'\u000fZ:\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%2\u0003\u0019\u0011XmY8sI&!!Q\u0013BH\u00055iU-\\8ssJ+7m\u001c:eg\"Q!\u0011\u0014B'!\u0003\u0005\r!!%\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\t\u0015\tu%Q\nI\u0001\u0002\u0004\u0011y*\u0001\u0007sKF,\u0018N]3e\u0003\u000e\\7\u000fE\u0002\n\u0005CK1Aa)\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u00119\u000b\u0001C\u0005\u0005S\u000bqBZ3uG\"\f5oQ8ogVlWM\u001d\u000b\r\u0005W\u0013\u0019L!.\u00038\n%'Q\u001a\t\u0007\u0003O\fIN!,\u0011\u0007I\u0011y+C\u0002\u00032\n\u0011!CR3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uC\"A!\u0011\u0010BS\u0001\u0004\t9\u0006\u0003\u0005\u0003~\t\u0015\u0006\u0019\u0001B@\u0011!\u0011IL!*A\u0002\tm\u0016!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0003>\n\rg\u0002\u0002B-\u0005\u007fKAA!1\u0002$\u0006aa)\u001a;dQJ+\u0017/^3ti&!!Q\u0019Bd\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!!\u0011YAR\u0011%\u0011YM!*\u0011\u0002\u0003\u00071-\u0001\u0005nS:\u0014\u0015\u0010^3t\u0011)\u0011yM!*\u0011\u0002\u0003\u0007!\u0011[\u0001\u000fSN|G.\u0019;j_:dUM^3m!\u0011\t\tKa5\n\t\tU\u00171\u0015\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057\fqBZ3uG\"\f5OR8mY><XM\u001d\u000b\r\u0005W\u0013iNa8\u0003b\n\r(Q\u001d\u0005\t\u0005s\u00129\u000e1\u0001\u0002X!A!Q\u0010Bl\u0001\u0004\u0011y\b\u0003\u0005\u0003:\n]\u0007\u0019\u0001B^\u0011%\u0011YMa6\u0011\u0002\u0003\u00071\r\u0003\u0006\u0003P\n]\u0007\u0013!a\u0001\u0005#DqA!;\u0001\t\u0013\u0011Y/A\u0007gKR\u001c\u0007.T3tg\u0006<Wm\u001d\u000b\u000f\u0005W\u0013iOa<\u0003t\nU(q\u001fB}\u0011!\u0011IHa:A\u0002\u0005]\u0003b\u0002By\u0005O\u0004\raY\u0001\ne\u0016\u0004H.[2b\u0013\u0012D\u0001B! \u0003h\u0002\u0007!q\u0010\u0005\t\u0005s\u00139\u000f1\u0001\u0003<\"9!1\u001aBt\u0001\u0004\u0019\u0007\u0002\u0003Bh\u0005O\u0004\rA!5\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\u0006A3/\u001a;vaJ+\u0007\u000f\\5dC6\u000bg.Y4fe^KG\u000f['pG.,G\rU;sO\u0006$xN]5fgR1\u0011qKB\u0001\u0007\u001fA\u0001ba\u0001\u0003|\u0002\u00071QA\u0001\u0006i&lWM\u001d\t\u0005\u0007\u000f\u0019Y!\u0004\u0002\u0004\n)\u001911A\u0013\n\t\r51\u0011\u0002\u0002\n\u001b>\u001c7\u000eV5nKJD!\"!/\u0003|B\u0005\t\u0019AB\t!\u0015\ti,!4d\u0011%\u0019)\u0002AI\u0001\n\u0013\u00199\"A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0004\u0016\u0005\u0003#\u001bYb\u000b\u0002\u0004\u001eA!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012!C;oG\",7m[3e\u0015\r\u00199CC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0016\u0007C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019y\u0003AI\u0001\n\u0013\u0019\t$A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\u0007\u0016\u0005\u0005?\u001bY\u0002C\u0005\u00048\u0001\t\n\u0011\"\u0003\u0004:\u0005Ib-\u001a;dQ\u0006\u001b8i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019YDK\u0002d\u00077A\u0011ba\u0010\u0001#\u0003%Ia!\u0011\u00023\u0019,Go\u00195Bg\u000e{gn];nKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007\u0007RCA!5\u0004\u001c!I1q\t\u0001\u0012\u0002\u0013%1\u0011J\u00013g\u0016$X\u000f\u001d*fa2L7-Y'b]\u0006<WM],ji\"lunY6fIB+(oZ1u_JLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\n\u0016\u0005\u0007#\u0019Y\u0002C\u0005\u0004P\u0001\t\n\u0011\"\u0003\u0004:\u0005Ib-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0019\u0019\u0006AI\u0001\n\u0013\u0019\t%A\rgKR\u001c\u0007.Q:G_2dwn^3sI\u0011,g-Y;mi\u0012*\u0004")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$5, Iterable<Partition> x$6) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.kafka$server$ReplicaManagerTest$$appendRecords(rm, new TopicPartition(this.topic(), 0), records2, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
                }
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty()), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$7, Iterable<Partition> x$8) {
                }
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$9, Iterable<Partition> x$10) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$1;
                private final long producerId$1;
                private final short epoch$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$1 = replicaManager$1;
                    this.producerId$1 = producerId$1;
                    this.epoch$1 = epoch$1;
                }
            });
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
                    Assert.assertEquals((long)0L, (long)response.logStartOffset);
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$11, Iterable<Partition> x$12) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$2;
                private final long producerId$2;
                private final short epoch$2;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$2, (short)this.epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$2, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$2 = replicaManager$2;
                    this.producerId$2 = producerId$2;
                    this.epoch$2 = epoch$2;
                }
            });
            ReplicaManager x$24 = replicaManager;
            TopicPartition x$25 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$26 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$27 = IsolationLevel.READ_UNCOMMITTED;
            int x$28 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$24, x$25, x$26, x$28, x$27);
            ReplicaManager x$29 = replicaManager;
            TopicPartition x$30 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$31 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$32 = IsolationLevel.READ_COMMITTED;
            int x$33 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$29, x$30, x$31, x$33, x$32);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$34 = replicaManager;
            TopicPartition x$35 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$36 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$37 = IsolationLevel.READ_COMMITTED;
            int x$38 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$34, x$35, x$36, x$38, x$37);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer2.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$39 = replicaManager;
            TopicPartition x$40 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$41 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$42 = IsolationLevel.READ_COMMITTED;
            int x$43 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$39, x$40, x$41, x$43, x$42);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$44 = replicaManager;
            TopicPartition x$45 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$46 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$47 = IsolationLevel.READ_UNCOMMITTED;
            int x$48 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$44, x$45, x$46, x$48, x$47);
            ReplicaManager x$49 = replicaManager;
            TopicPartition x$50 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$51 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$52 = IsolationLevel.READ_COMMITTED;
            int x$53 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$49, x$50, x$51, x$53, x$52);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$13, Iterable<Partition> x$14) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$3;
                private final long producerId$3;
                private final short epoch$3;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$3, (short)this.epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$3, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$3 = replicaManager$3;
                    this.producerId$3 = producerId$3;
                    this.epoch$3 = epoch$3;
                }
            });
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$54 = replicaManager;
            TopicPartition x$55 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$56 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$57 = IsolationLevel.READ_UNCOMMITTED;
            int x$58 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$54, x$55, x$56, x$58, x$57);
            ReplicaManager x$59 = replicaManager;
            TopicPartition x$60 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$61 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$62 = IsolationLevel.READ_COMMITTED;
            int x$63 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$59, x$60, x$61, x$63, x$62);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer2.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$15, Iterable<Partition> x$16) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.rm$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$64 = 0;
            boolean x$65 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$64, x$65);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$66 = 0;
            boolean x$67 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$66, x$67);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$17, Iterable<Partition> x$18) {
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, replicaManager, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$4;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$4 = replicaManager$4;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            });
            long x$68 = 1000L;
            int x$69 = 1;
            int x$70 = 0;
            int x$71 = Integer.MAX_VALUE;
            boolean x$72 = false;
            Seq x$73 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()))}));
            Serializable x$74 = new Serializable(this, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.tp0$1, this.tp1$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            };
            IsolationLevel x$75 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$76 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$68, x$69, x$70, x$71, x$72, x$73, x$76, (Function1)x$74, x$75);
            Option tp0Replica = replicaManager.localReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.localReplica(tp1);
            Option tp1Replica = replicaManager.localReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
            LogManager mockLogMgr = (LogManager)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)replicaManager, (Object)mockLogMgr);
            ReplicaManager replicaManager2 = (ReplicaManager)tuple23._1();
            LogManager mockLogMgr2 = (LogManager)tuple23._2();
            Partition partition = replicaManager2.getOrCreatePartition(new TopicPartition(this.topic(), topicPartition));
            partition.getOrCreateReplica(followerBrokerId, partition.getOrCreateReplica$default$2());
            partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId());
            LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)this.leaderAndIsrPartitionState(leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
            replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2)new Serializable(this, followerBrokerId){
                public static final long serialVersionUID = 0L;
                private final int followerBrokerId$1;

                public final void apply(Iterable<Partition> x$20, Iterable<Partition> followers) {
                    Assert.assertEquals((long)this.followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
                }
                {
                    this.followerBrokerId$1 = followerBrokerId$1;
                }
            });
            Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
            EasyMock.verify((Object[])new Object[]{mockLogMgr2});
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation) {
        BoxedUnit boxedUnit;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, topicPartition, config, localLogOffset, leaderEpochFromLeader, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel){
            private final int localLogOffset$1;
            private final int leaderEpochFromLeader$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }
            {
                this.localLogOffset$1 = localLogOffset$1;
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic()}))), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$1), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$1), new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic(), BoxesRunTime.boxToInteger((int)topicPartition$1)}))), 30000), mockLogDirFailureChannel$1);
            }
        };
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$21) {
                return new File(x$21).getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(new TopicPartition(this.topic(), topicPartition), LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)BoxesRunTime.boxToLong((long)offsetFromLeader))})), false);
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).once();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Integer brokerId) {
                return TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerId})), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$1;

            public final IExpectationSetters<Object> apply(Integer brokerId) {
                return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache$1.isBrokerAlive(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId))))))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
            }
            {
                this.metadataCache$1 = metadataCache$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer2 = new MockTimer();
        String x$77 = "Produce";
        MockTimer x$78 = timer2;
        boolean x$79 = false;
        int x$80 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$81 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$82 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$77, (Timer)x$78, x$80, x$81, x$79, x$82);
        String x$83 = "Fetch";
        MockTimer x$84 = timer2;
        boolean x$85 = false;
        int x$86 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$87 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$88 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$83, (Timer)x$84, x$86, x$87, x$85, x$88);
        String x$89 = "DeleteRecords";
        MockTimer x$90 = timer2;
        boolean x$91 = false;
        int x$92 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$93 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$94 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$89, (Timer)x$90, x$92, x$93, x$91, x$94);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader))}))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, topicPartition, leaderEpochInLeaderAndIsr, countDownLatch, config, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel, mockLogMgr, metadataCache, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, quota, blockingSend){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final int topicPartition$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final CountDownLatch countDownLatch$1;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$4 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$4$$anon$2 $outer;

                            public void doWork() {
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$1)), (Object)initialOffset)})));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplicaFetcherThread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId$1)})), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$4 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.countDownLatch$1 = countDownLatch$1;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private LeaderAndIsrRequest.PartitionState leaderAndIsrPartitionState(int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequest.PartitionState(this.controllerEpoch(), leaderBrokerId, leaderEpoch, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), this.zkVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), false);
    }

    public CallbackResult<ProduceResponse.PartitionResponse> kafka$server$ReplicaManagerTest$$appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records2, boolean isFromClient, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records2)})), (Function1)new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$1;
            private final CallbackResult result$1;

            public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responses) {
                this.$outer.kafka$server$ReplicaManagerTest$$appendCallback$1(responses, this.partition$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    public boolean kafka$server$ReplicaManagerTest$$appendRecords$default$4() {
        return true;
    }

    public short kafka$server$ReplicaManagerTest$$appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$95 = 1000L;
        int x$96 = replicaId;
        int x$97 = minBytes;
        int x$98 = Integer.MAX_VALUE;
        boolean x$99 = false;
        Seq x$100 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Serializable x$101 = new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$2;
            private final CallbackResult result$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.partition$2, this.result$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.result$2 = result$2;
            }
        };
        IsolationLevel x$102 = isolationLevel;
        ReplicaQuota x$103 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$95, x$96, x$97, x$98, x$99, x$100, x$103, (Function1)x$101, x$102);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer2, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$23) {
                return new File(x$23);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int brokerId) {
                return TestUtils$.MODULE$.createBroker(brokerId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), brokerId, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$2;

            public final IExpectationSetters<Object> apply(int brokerId) {
                return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache$2.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
            }
            {
                this.metadataCache$2 = metadataCache$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$104 = "Produce";
        MockTimer x$105 = timer2;
        boolean x$106 = false;
        int x$107 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$108 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$109 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$104, (Timer)x$105, x$107, x$108, x$106, x$109);
        String x$110 = "Fetch";
        MockTimer x$111 = timer2;
        boolean x$112 = false;
        int x$113 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$114 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$115 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$110, (Timer)x$111, x$113, x$114, x$112, x$115);
        String x$116 = "DeleteRecords";
        MockTimer x$117 = timer2;
        boolean x$118 = false;
        int x$119 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$120 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$121 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$116, (Timer)x$117, x$119, x$120, x$118, x$121);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public final void kafka$server$ReplicaManagerTest$$appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
            Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
            result$2.fire(fetchData2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Object value$1;

                public final void apply(Function1<T, BoxedUnit> f) {
                    f.apply(this.value$1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

