/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.security.auth.Acl;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.zk.AdminZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConsumerOffset$;
import kafka.zk.ControllerEpochZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.KafkaZkClientTest$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkData$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.CreateResponse$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.SetDataResponse$;
import kafka.zookeeper.ZNodeChangeHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cS1gW\u0006T6n\u00117jK:$H+Z:u\u0015\t\u0019A!\u0001\u0002{W*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013%!#A\u0003he>,\b/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003mC:<'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011aa\u0015;sS:<\u0007B\u0002\u000f\u0001A\u0003%1#\u0001\u0004he>,\b\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dc!1\u0001\u0005\u0001Q\u0001\nM\tq\u0001^8qS\u000e\f\u0004\u0005C\u0004#\u0001\t\u0007I\u0011\u0002\n\u0002\rQ|\u0007/[23\u0011\u0019!\u0003\u0001)A\u0005'\u00059Ao\u001c9jGJ\u0002\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8ocA*\u0012\u0001\u000b\t\u0003SEj\u0011A\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]F\u0002\u0004\u0005C\u00047\u0001\t\u0007I\u0011A\u0014\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]F\n\u0004B\u0002\u001d\u0001A\u0003%\u0001&A\tu_BL7\rU1si&$\u0018n\u001c82c\u0001BqA\u000f\u0001C\u0002\u0013\u0005q%\u0001\tu_BL7\rU1si&$\u0018n\u001c83a!1A\b\u0001Q\u0001\n!\n\u0011\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0019!\u0011\u001dq\u0004A1A\u0005\u0002}\nA\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u00191?F\nT#\u0001!\u0011\u0007\u00053\u0005&D\u0001C\u0015\t\u0019E)\u0001\u0006d_2dWm\u0019;j_:T\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\n\u00131aU3r\u0011\u0019I\u0005\u0001)A\u0005\u0001\u0006)Bo\u001c9jGB\u000b'\u000f^5uS>t7/\r\u0019`cE\u0002\u0003bB&\u0001\u0005\u0004%\t\u0001T\u0001\u0019G>tGO]8mY\u0016\u0014X\t]8dQj[g+\u001a:tS>tW#A'\u0011\u00059{U\"\u0001#\n\u0005A#%aA%oi\"1!\u000b\u0001Q\u0001\n5\u000b\u0011dY8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8oA!IA\u000b\u0001a\u0001\u0002\u0004%\t!V\u0001\u000e_RDWM\u001d.l\u00072LWM\u001c;\u0016\u0003Y\u0003\"!C,\n\u0005a\u0013!!D&bM.\f'l[\"mS\u0016tG\u000fC\u0005[\u0001\u0001\u0007\t\u0019!C\u00017\u0006\tr\u000e\u001e5fej[7\t\\5f]R|F%Z9\u0015\u0005q{\u0006C\u0001(^\u0013\tqFI\u0001\u0003V]&$\bb\u00021Z\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0004B\u00022\u0001A\u0003&a+\u0001\bpi\",'OW6DY&,g\u000e\u001e\u0011\t\u000b\u0011\u0004A\u0011I3\u0002\u000bM,G/\u00169\u0015\u0003qC#aY4\u0011\u0005!\\W\"A5\u000b\u0005)|\u0013!\u00026v]&$\u0018B\u00017j\u0005\u0019\u0011UMZ8sK\")a\u000e\u0001C!K\u0006AA/Z1s\t><h\u000e\u000b\u0002naB\u0011\u0001.]\u0005\u0003e&\u0014Q!\u00114uKJDq\u0001\u001e\u0001C\u0002\u0013%q%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\rY\u0004\u0001\u0015!\u0003)\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003\"\u0002=\u0001\t\u0003)\u0017a\u0007;fgR\u001cV\r^!oI\u001e+GoQ8ogVlWM](gMN,G\u000f\u000b\u0002xuB\u0011\u0001n_\u0005\u0003y&\u0014A\u0001V3ti\")a\u0010\u0001C\u0001K\u0006YB/Z:u\u000f\u0016$8i\u001c8tk6,'o\u00144gg\u0016$hj\u001c#bi\u0006D#! >\t\r\u0005\r\u0001\u0001\"\u0001f\u0003M!Xm\u001d;EK2,G/\u001a*fGV\u00148/\u001b<fQ\r\t\tA\u001f\u0005\u0007\u0003\u0013\u0001A\u0011A3\u0002eQ,7\u000f\u001e#fY\u0016$XMU3dkJ\u001c\u0018N^3XSRD7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007NV3sg&|gn\u00115fG.D3!a\u0002{\u0011\u0019\ty\u0001\u0001C\u0001K\u0006\u0019B/Z:u\u0007J,\u0017\r^3SK\u000e,(o]5wK\"\u001a\u0011Q\u0002>\t\r\u0005U\u0001\u0001\"\u0001f\u0003i!Xm\u001d;U_BL7-Q:tS\u001etW.\u001a8u\u001b\u0016$\bn\u001c3tQ\r\t\u0019B\u001f\u0005\u0007\u00037\u0001A\u0011A3\u0002+Q,7\u000f^$fi\u0012\u000bG/Y!oIZ+'o]5p]\"\u001a\u0011\u0011\u0004>\t\r\u0005\u0005\u0002\u0001\"\u0001f\u0003e!Xm\u001d;D_:$\u0017\u000e^5p]\u0006dW\u000b\u001d3bi\u0016\u0004\u0016\r\u001e5)\u0007\u0005}!\u0010\u0003\u0004\u0002(\u0001!\t!Z\u0001#i\u0016\u001cHo\u0011:fCR,7+Z9vK:$\u0018.\u00197QKJ\u001c\u0018n\u001d;f]R\u0004\u0016\r\u001e5)\u0007\u0005\u0015\"\u0010\u0003\u0004\u0002.\u0001!\t!Z\u0001\u0018i\u0016\u001cH\u000f\u0015:pa\u0006<\u0017\r^3JgJ\u001c\u0005.\u00198hKND3!a\u000b{\u0011\u0019\t\u0019\u0004\u0001C\u0001K\u0006\u0001C/Z:u\u0013N\u00148\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u000f\u0016$H/\u001a:tQ\r\t\tD\u001f\u0005\u0007\u0003s\u0001A\u0011A3\u0002EQ,7\u000f^%te\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\:EK2,G/[8oQ\r\t9D\u001f\u0005\u0007\u0003\u007f\u0001A\u0011A3\u0002'Q,7\u000f\u001e)s_B\fw-\u0019;f\u0019><G)\u001b:)\u0007\u0005u\"\u0010\u0003\u0004\u0002F\u0001!\t!Z\u0001\u0012i\u0016\u001cH\u000fT8h\t&\u0014x)\u001a;uKJ\u001c\bfAA\"u\"1\u00111\n\u0001\u0005\u0002\u0015\fA\u0005^3ti2{w\rR5s\u000bZ,g\u000e\u001e(pi&4\u0017nY1uS>t7\u000fR3mKRLwN\u001c\u0015\u0004\u0003\u0013R\bBBA)\u0001\u0011\u0005Q-\u0001\u0015uKN$8+\u001a;HKR\fe\u000e\u001a#fY\u0016$X\rU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fK\u0002\u0002PiDa!a\u0016\u0001\t\u0003)\u0017A\u0005;fgR<U\r\u001e#bi\u0006\fe\u000eZ*uCRD3!!\u0016{\u0011\u0019\ti\u0006\u0001C\u0001K\u0006yA/Z:u\u000f\u0016$8\t[5mIJ,g\u000eK\u0002\u0002\\iDa!a\u0019\u0001\t\u0003)\u0017\u0001\u0007;fgR\f5\r\\'b]\u0006<W-\\3oi6+G\u000f[8eg\"\u001a\u0011\u0011\r>\t\r\u0005%\u0004\u0001\"\u0001f\u00039!Xm\u001d;EK2,G/\u001a)bi\"D3!a\u001a{\u0011\u0019\ty\u0007\u0001C\u0001K\u0006!B/Z:u\t\u0016dW\r^3U_BL7M\u0017(pI\u0016D3!!\u001c{\u0011\u0019\t)\b\u0001C\u0001K\u0006QB/Z:u\t\u0016dW\r^3U_BL7\rU1uQ6+G\u000f[8eg\"\u001a\u00111\u000f>\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u0005Q\u0012m]:feR\u0004\u0016\r\u001e5Fq&\u001cH/\u001a8dK\u0006sG\rR1uCR)A,a \u0002\u0010\"A\u0011\u0011QA=\u0001\u0004\t\u0019)\u0001\u0007fqB,7\r^3e!\u0006$\b\u000e\u0005\u0003\u0002\u0006\u0006-eb\u0001(\u0002\b&\u0019\u0011\u0011\u0012#\u0002\rA\u0013X\rZ3g\u0013\rQ\u0012Q\u0012\u0006\u0004\u0003\u0013#\u0005\u0002CAI\u0003s\u0002\r!a!\u0002\t\u0011\fG/\u0019\u0005\u0007\u0003+\u0003A\u0011A3\u0002CQ,7\u000f^\"sK\u0006$X\rV8lK:\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8)\u0007\u0005M%\u0010\u0003\u0004\u0002\u001c\u0002!\t!Z\u0001\"i\u0016\u001cH/\u00128uSRL8i\u001c8gS\u001el\u0015M\\1hK6,g\u000e^'fi\"|Gm\u001d\u0015\u0004\u00033S\bBBAQ\u0001\u0011\u0005Q-\u0001\u0012uKN$8I]3bi\u0016\u001cuN\u001c4jO\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c\u0015\u0004\u0003?S\bbBAT\u0001\u0011%\u0011\u0011V\u0001\u000fGJ,\u0017\r^3M_\u001e\u0004&o\u001c9t)\u0011\tY+a.\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-\u0018\u0003\u0011)H/\u001b7\n\t\u0005U\u0016q\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA]\u0003K\u0003\r!T\u0001\nEf$Xm\u001d)s_BD\u0011\"!0\u0001\u0005\u0004%I!a0\u0002\u00111|w\r\u0015:paN,\"!a+\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003W\u000b\u0011\u0002\\8h!J|\u0007o\u001d\u0011\t\r\u0005\u001d\u0007\u0001\"\u0001f\u0003E!Xm\u001d;HKRdunZ\"p]\u001aLwm\u001d\u0015\u0004\u0003\u000bT\bbBAg\u0001\u0011%\u0011qZ\u0001\u0011GJ,\u0017\r^3Ce>\\WM]%oM>$B\"!5\u0002X\u0006m\u0017q\\Ar\u0003o\u00042!CAj\u0013\r\t)N\u0001\u0002\u000b\u0005J|7.\u001a:J]\u001a|\u0007bBAm\u0003\u0017\u0004\r!T\u0001\u0003S\u0012D\u0001\"!8\u0002L\u0002\u0007\u00111Q\u0001\u0005Q>\u001cH\u000fC\u0004\u0002b\u0006-\u0007\u0019A'\u0002\tA|'\u000f\u001e\u0005\t\u0003K\fY\r1\u0001\u0002h\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u0003S\f\u00190\u0004\u0002\u0002l*!\u0011Q^Ax\u0003\u0011\tW\u000f\u001e5\u000b\u0007\u0005E(&\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t)0a;\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007BCA}\u0003\u0017\u0004\n\u00111\u0001\u0002|\u0006!!/Y2l!\u0015q\u0015Q`AB\u0013\r\ty\u0010\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\r\t\r\u0001\u0001\"\u0001f\u0003Y!Xm\u001d;SK\u001eL7\u000f^3s\u0005J|7.\u001a:J]\u001a|\u0007f\u0001B\u0001u\"1!\u0011\u0002\u0001\u0005\u0002\u0015\fA\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;i_\u0012\u001c\bf\u0001B\u0004u\"1!q\u0002\u0001\u0005\u0002\u0015\fA\u0003^3tiV\u0003H-\u0019;f\u0005J|7.\u001a:J]\u001a|\u0007f\u0001B\u0007u\"9!Q\u0003\u0001\u0005\n\t]\u0011aD:uCR<\u0016\u000e\u001e5WKJ\u001c\u0018n\u001c8\u0015\t\te!q\u0005\t\u0005\u00057\u0011\u0019#\u0004\u0002\u0003\u001e)!\u0011\u0011\u0013B\u0010\u0015\r\u0011\t#L\u0001\nu>|7.Z3qKJLAA!\n\u0003\u001e\t!1\u000b^1u\u0011\u001d\u0011ICa\u0005A\u00025\u000bqA^3sg&|g\u000eC\u0004\u0003.\u0001!IAa\f\u000291,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2igR1!\u0011\u0007B\"\u0005\u000f\u0002r!!\"\u00034!\u00129$\u0003\u0003\u00036\u00055%aA'baB!!\u0011\bB \u001b\t\u0011YDC\u0002\u0003>\u0011\t!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011\tEa\u000f\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\u0011)Ea\u000bA\u00025\u000bQa\u001d;bi\u0016DqA!\u0013\u0003,\u0001\u0007Q*A\u0005{WZ+'o]5p]\"I!Q\n\u0001C\u0002\u0013\u0005!qJ\u0001$S:LG/[1m\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195t+\t\u0011\t\u0004\u0003\u0005\u0003T\u0001\u0001\u000b\u0011\u0002B\u0019\u0003\u0011Jg.\u001b;jC2dU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQN\u0004\u0003\"\u0003B,\u0001\t\u0007I\u0011\u0001B-\u0003EIg.\u001b;jC2dU-\u00193fe&\u001b(o]\u000b\u0003\u00057\u0002r!!\"\u00034!\u0012i\u0006\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019\u0007B\u0001\u0004CBL\u0017\u0002\u0002B4\u0005C\u0012A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJD\u0001Ba\u001b\u0001A\u0003%!1L\u0001\u0013S:LG/[1m\u0019\u0016\fG-\u001a:JgJ\u001c\b\u0005C\u0004\u0003p\u0001!IA!\u001d\u0002\u00151,\u0017\rZ3s\u0013N\u00148\u000f\u0006\u0004\u0003\\\tM$Q\u000f\u0005\b\u0005\u000b\u0012i\u00071\u0001N\u0011\u001d\u0011IE!\u001cA\u00025CqA!\u001f\u0001\t\u0013\u0011Y(A\u000fdQ\u0016\u001c7.\u00169eCR,G*Z1eKJ\fe\u000eZ%teJ+7/\u001e7u)%a&Q\u0010BA\u0005\u000b\u0013y\u000b\u0003\u0005\u0003\u0000\t]\u0004\u0019\u0001B.\u0003q)\u0007\u0010]3di\u0016$7+^2dKN\u001ch-\u001e7QCJ$\u0018\u000e^5p]NDqAa!\u0003x\u0001\u0007\u0001)A\rfqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c*fiJL\b\u0002\u0003BD\u0005o\u0002\rA!#\u00021\u0015D\b/Z2uK\u00124\u0015-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0004\u0002\u0006\nM\u0002Fa#\u0011\u000f9\u0013iI!%\u0002\u0004&\u0019!q\u0012#\u0003\rQ+\b\u000f\\33a\u0011\u0011\u0019J!(\u0011\r\u0005\u0015%Q\u0013BM\u0013\u0011\u00119*!$\u0003\u000b\rc\u0017m]:\u0011\t\tm%Q\u0014\u0007\u0001\t1\u0011yJ!\"\u0002\u0002\u0003\u0005)\u0011\u0001BQ\u0005\ryF%M\t\u0005\u0005G\u0013I\u000bE\u0002O\u0005KK1Aa*E\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0014BV\u0013\r\u0011i\u000b\u0012\u0002\u0004\u0003:L\b\u0002\u0003BY\u0005o\u0002\rAa-\u0002=\u0005\u001cG/^1m+B$\u0017\r^3MK\u0006$WM]!oI&\u001b(OU3tk2$\b\u0003\u0002B[\u0005\u0013tAAa.\u0003F:!!\u0011\u0018Bb\u001d\u0011\u0011YL!1\u000e\u0005\tu&b\u0001B`\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I1Aa2\u0003\u00035Y\u0015MZ6b5.\u001cE.[3oi&!!1\u001aBg\u0005a)\u0006\u000fZ1uK2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKN,H\u000e\u001e\u0006\u0004\u0005\u000f\u0014\u0001B\u0002Bi\u0001\u0011\u0005Q-\u0001\fuKN$X\u000b\u001d3bi\u0016dU-\u00193fe\u0006sG-S:sQ\r\u0011yM\u001f\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0003Q\u0019\u0007.Z2l\u000f\u0016$H)\u0019;b%\u0016\u001c\bo\u001c8tKR9ALa7\u0003^\n}\u0007\u0002\u0003B\u0017\u0005+\u0004\rA!\r\t\rQ\u0014)\u000e1\u0001)\u0011!\u0011\tO!6A\u0002\t\r\u0018\u0001\u0003:fgB|gn]3\u0011\t\t\u0015(\u0011^\u0007\u0003\u0005OT1A!\t\u0005\u0013\u0011\u0011YOa:\u0003\u001f\u001d+G\u000fR1uCJ+7\u000f]8og\u0016DqAa<\u0001\t\u0013\u0011\t0\u0001\u0012fe\u0006\u001cX-\u00168dQ\u0016\u001c7.\u001a3J]\u001a|\u0017J\\\"sK\u0006$XMU3ta>t7/\u001a\u000b\u0005\u0005g\u0014I\u0010\u0005\u0003\u0003f\nU\u0018\u0002\u0002B|\u0005O\u0014ab\u0011:fCR,'+Z:q_:\u001cX\r\u0003\u0005\u0003b\n5\b\u0019\u0001Bz\u0011\u0019\u0011i\u0010\u0001C\u0001K\u0006QB/Z:u\u000f\u0016$Hk\u001c9jGN\fe\u000e\u001a)beRLG/[8og\"\u001a!1 >\t\r\r\r\u0001\u0001\"\u0001f\u0003\u001d\"Xm\u001d;De\u0016\fG/Z!oI\u001e+G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c(+Y<)\u0007\r\u0005!\u0010\u0003\u0004\u0004\n\u0001!\t!Z\u0001\u001fi\u0016\u001cHoU3u)>\u0004\u0018n\u0019)beRLG/[8o'R\fG/Z:SC^D3aa\u0002{\u0011\u0019\u0019y\u0001\u0001C\u0001K\u0006\u0001C/Z:u%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7/\u00138Qe><'/Z:tQ\r\u0019iA\u001f\u0005\u0007\u0007+\u0001A\u0011A3\u00027Q,7\u000f^$fiR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3tQ\r\u0019\u0019B\u001f\u0005\b\u00077\u0001A\u0011BB\u000f\u0003\r*'/Y:f+:\u001c\u0007.Z2lK\u0012LeNZ8J]N+G\u000fR1uCJ+7\u000f]8og\u0016$Baa\b\u0004&A!!Q]B\u0011\u0013\u0011\u0019\u0019Ca:\u0003\u001fM+G\u000fR1uCJ+7\u000f]8og\u0016D\u0001B!9\u0004\u001a\u0001\u00071q\u0004\u0005\u0007\u0007S\u0001A\u0011A3\u00025Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195NKRDw\u000eZ:)\u0007\r\u001d\"\u0010\u0003\u0004\u00040\u0001!\t!Z\u0001 i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b\u0006t\u0017mZ3nK:$X*\u001a;i_\u0012\u001c\bfAB\u0017u\"11Q\u0007\u0001\u0005\u0002\u0015\f1\u0005^3tijsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0012\u000bG/Y\"iC:<W\rK\u0002\u00044iDaaa\u000f\u0001\t\u0003)\u0017\u0001\u0006;fgR\u001cE.^:uKJLE-T3uQ>$7\u000fK\u0002\u0004:iDaa!\u0011\u0001\t\u0003)\u0017a\u0007;fgR\u0014%o\\6feN+\u0017/^3oG\u0016LE-T3uQ>$7\u000fK\u0002\u0004@iDaaa\u0012\u0001\t\u0003)\u0017a\u0006;fgR\u001c%/Z1uKR{\u0007\u000fT3wK2\u0004\u0016\r\u001e5tQ\r\u0019)E\u001f\u0005\u0007\u0007\u001b\u0002A\u0011A3\u0002GQ,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u000b2,7\r^5p]6+G\u000f[8eg\"\u001a11\n>\t\u000f\rM\u0003\u0001\"\u0003\u0004V\u0005aA-\u0019;b\u0003N\u001cFO]5oOR!\u00111`B,\u0011!\u0019If!\u0015A\u0002\u0005\r\u0015\u0001\u00029bi\"Daa!\u0018\u0001\t\u0003)\u0017A\u0007;fgR$U\r\\3hCRLwN\u001c+pW\u0016tW*\u001a;i_\u0012\u001c\bfAB.u\"111\r\u0001\u0005\u0002\u0015\fa\u0003^3ti\u000e{gn];nKJ|eMZ:fiB\u000bG\u000f\u001b\u0015\u0004\u0007CR\b\"CB5\u0001E\u0005I\u0011BB6\u0003i\u0019'/Z1uK\n\u0013xn[3s\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019iG\u000b\u0003\u0002|\u000e=4FAB9!\u0011\u0019\u0019h! \u000e\u0005\rU$\u0002BB<\u0007s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rmD)\u0001\u0006b]:|G/\u0019;j_:LAaa \u0004v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class KafkaZkClientTest
extends ZooKeeperTestHarness {
    private final String group;
    private final String kafka$zk$KafkaZkClientTest$$topic1;
    private final String kafka$zk$KafkaZkClientTest$$topic2;
    private final TopicPartition topicPartition10 = new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 0);
    private final TopicPartition topicPartition11 = new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 1);
    private final TopicPartition topicPartition20 = new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic2(), 0);
    private final Seq<TopicPartition> topicPartitions10_11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}));
    private final int controllerEpochZkVersion;
    private KafkaZkClient otherZkClient;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Properties logProps = this.createLogProps(1024);
    private final scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs = this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(0, 0);
    private final scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs = this.initialLeaderIsrAndControllerEpochs().mapValues((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$7) {
            return x$7.leaderAndIsr();
        }
    });

    private String group() {
        return this.group;
    }

    public String kafka$zk$KafkaZkClientTest$$topic1() {
        return this.kafka$zk$KafkaZkClientTest$$topic1;
    }

    public String kafka$zk$KafkaZkClientTest$$topic2() {
        return this.kafka$zk$KafkaZkClientTest$$topic2;
    }

    public TopicPartition topicPartition10() {
        return this.topicPartition10;
    }

    public TopicPartition topicPartition11() {
        return this.topicPartition11;
    }

    public TopicPartition topicPartition20() {
        return this.topicPartition20;
    }

    public Seq<TopicPartition> topicPartitions10_11() {
        return this.topicPartitions10_11;
    }

    public int controllerEpochZkVersion() {
        return this.controllerEpochZkVersion;
    }

    public KafkaZkClient otherZkClient() {
        return this.otherZkClient;
    }

    public void otherZkClient_$eq(KafkaZkClient x$1) {
        this.otherZkClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkClient().createControllerEpochRaw(1);
        this.otherZkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return JaasUtils.isZkSecurityEnabled();
            }
        })), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
    }

    @Override
    @After
    public void tearDown() {
        if (this.otherZkClient() != null) {
            this.otherZkClient().close();
        }
        this.zkClient().deletePath(ControllerEpochZNode$.MODULE$.path());
        super.tearDown();
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Test
    public void testSetAndGetConsumerOffset() {
        long offset = 123L;
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset);
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset + 2L);
        Assert.assertEquals((long)(offset + 2L), (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
    }

    @Test
    public void testGetConsumerOffsetNoData() {
        KafkaZkClient qual$1 = this.zkClient();
        String x$12 = ConsumerOffset$.MODULE$.path(this.group(), this.topicPartition().topic(), Predef$.MODULE$.int2Integer(this.topicPartition().partition()));
        byte[] x$13 = qual$1.createRecursive$default$2();
        boolean x$14 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$12, x$13, x$14);
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
    }

    @Test
    public void testDeleteRecursive() {
        KafkaZkClient qual$2 = this.zkClient();
        String x$15 = "/delete/does-not-exist";
        int x$16 = qual$2.deleteRecursive$default$2();
        qual$2.deleteRecursive(x$15, x$16);
        KafkaZkClient qual$3 = this.zkClient();
        String x$17 = "/delete/some/random/path";
        byte[] x$18 = qual$3.createRecursive$default$2();
        boolean x$19 = qual$3.createRecursive$default$3();
        qual$3.createRecursive(x$17, x$18, x$19);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        KafkaZkClient qual$4 = this.zkClient();
        String x$20 = "/delete";
        int x$21 = qual$4.deleteRecursive$default$2();
        Assert.assertTrue((boolean)qual$4.deleteRecursive(x$20, x$21));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                KafkaZkClient qual$5 = this.$outer.zkClient();
                String x$22 = "delete-invalid-path";
                int x$23 = qual$5.deleteRecursive$default$2();
                return qual$5.deleteRecursive(x$22, x$23);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    @Test
    public void testDeleteRecursiveWithControllerEpochVersionCheck() {
        Assert.assertFalse((boolean)this.zkClient().deleteRecursive("/delete/does-not-exist", this.controllerEpochZkVersion()));
        KafkaZkClient qual$6 = this.zkClient();
        String x$24 = "/delete/some/random/path";
        byte[] x$25 = qual$6.createRecursive$default$2();
        boolean x$26 = qual$6.createRecursive$default$3();
        qual$6.createRecursive(x$24, x$25, x$26);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().deleteRecursive("/delete", this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        Assert.assertTrue((boolean)this.zkClient().deleteRecursive("/delete", this.controllerEpochZkVersion()));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().deleteRecursive("delete-invalid-path", this.$outer.controllerEpochZkVersion());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }

    @Test
    public void testCreateRecursive() {
        KafkaZkClient qual$7 = this.zkClient();
        String x$27 = "/create-newrootpath";
        byte[] x$28 = qual$7.createRecursive$default$2();
        boolean x$29 = qual$7.createRecursive$default$3();
        qual$7.createRecursive(x$27, x$28, x$29);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create-newrootpath"));
        KafkaZkClient qual$8 = this.zkClient();
        String x$30 = "/create/some/random/long/path";
        byte[] x$31 = qual$8.createRecursive$default$2();
        boolean x$32 = qual$8.createRecursive$default$3();
        qual$8.createRecursive(x$30, x$31, x$32);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create/some/random/long/path"));
        KafkaZkClient qual$9 = this.zkClient();
        String x$33 = "/create/some/random/long/path";
        boolean x$34 = false;
        byte[] x$35 = qual$9.createRecursive$default$2();
        qual$9.createRecursive(x$33, x$35, x$34);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaZkClient qual$10 = this.$outer.zkClient();
                String x$36 = "create-invalid-path";
                byte[] x$37 = qual$10.createRecursive$default$2();
                boolean x$38 = qual$10.createRecursive$default$3();
                qual$10.createRecursive(x$36, x$37, x$38);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
    }

    @Test
    public void testTopicAssignmentMethods() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertFalse((boolean)this.zkClient().topicExists(this.kafka$zk$KafkaZkClientTest$$topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionCount(this.kafka$zk$KafkaZkClientTest$$topic1()).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 2)).isEmpty());
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(this.kafka$zk$KafkaZkClientTest$$topic1(), assignment2);
        Assert.assertTrue((boolean)this.zkClient().topicExists(this.kafka$zk$KafkaZkClientTest$$topic1()));
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)assignment2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> topicAssignment) {
                int partition = ((TopicPartition)topicAssignment._1()).partition();
                Seq assignment2 = (Seq)topicAssignment._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)assignment2.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.kafka$zk$KafkaZkClientTest$$topic1()).get()));
        Assert.assertEquals((Object)expectedAssignment, (Object)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()}))).get((Object)this.kafka$zk$KafkaZkClientTest$$topic1()).get());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()}))).get((Object)this.kafka$zk$KafkaZkClientTest$$topic1()).get()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 2)).toSet());
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment2.$minus((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 2));
        KafkaZkClient qual$11 = this.zkClient();
        String x$39 = this.kafka$zk$KafkaZkClientTest$$topic1();
        scala.collection.immutable.Map x$40 = updatedAssignment;
        int x$41 = qual$11.setTopicAssignment$default$3();
        qual$11.setTopicAssignment(x$39, x$40, x$41);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.kafka$zk$KafkaZkClientTest$$topic1()).get()));
        scala.collection.immutable.Map secondAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic2(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic2(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        this.zkClient().createTopicAssignment(this.kafka$zk$KafkaZkClientTest$$topic2(), secondAssignment);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
    }

    @Test
    public void testGetDataAndVersion() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option data0 = (Option)tuple2._1();
            int version0 = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data0, (Object)BoxesRunTime.boxToInteger((int)version0));
            Option data02 = (Option)tuple23._1();
            int version02 = tuple23._2$mcI$sp();
            Assert.assertTrue((boolean)data02.isEmpty());
            Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)version02);
            KafkaZkClient qual$12 = this.zkClient();
            String x$42 = path;
            byte[] x$43 = qual$12.createRecursive$default$2();
            boolean x$44 = qual$12.createRecursive$default$3();
            qual$12.createRecursive(x$42, x$43, x$44);
            KafkaZkClient qual$13 = this.zkClient();
            String x$45 = path;
            byte[] x$46 = "version1".getBytes(StandardCharsets.UTF_8);
            int x$47 = 0;
            Option x$48 = qual$13.conditionalUpdatePath$default$4();
            qual$13.conditionalUpdatePath(x$45, x$46, x$47, x$48);
            Tuple2 tuple24 = this.zkClient().getDataAndVersion(path);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Option data1 = (Option)tuple24._1();
                int version1 = tuple24._2$mcI$sp();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)data1, (Object)BoxesRunTime.boxToInteger((int)version1));
                Option data12 = (Option)tuple26._1();
                int version12 = tuple26._2$mcI$sp();
                Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)version12);
                KafkaZkClient qual$14 = this.zkClient();
                String x$49 = path;
                byte[] x$50 = "version2".getBytes(StandardCharsets.UTF_8);
                int x$51 = 1;
                Option x$52 = qual$14.conditionalUpdatePath$default$4();
                qual$14.conditionalUpdatePath(x$49, x$50, x$51, x$52);
                Tuple2 tuple27 = this.zkClient().getDataAndVersion(path);
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Option data2 = (Option)tuple27._1();
                    int version2 = tuple27._2$mcI$sp();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)data2, (Object)BoxesRunTime.boxToInteger((int)version2));
                    Option data22 = (Option)tuple29._1();
                    int version22 = tuple29._2$mcI$sp();
                    Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
                    Assert.assertEquals((long)2L, (long)version22);
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testConditionalUpdatePath() {
        String path = "/testconditionalpath";
        KafkaZkClient qual$15 = this.zkClient();
        String x$53 = path;
        byte[] x$54 = "version0".getBytes(StandardCharsets.UTF_8);
        int x$55 = 0;
        Option x$56 = qual$15.conditionalUpdatePath$default$4();
        Tuple2 statusAndVersion = qual$15.conditionalUpdatePath(x$53, x$54, x$55, x$56);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$16 = this.zkClient();
        String x$57 = path;
        byte[] x$58 = qual$16.createRecursive$default$2();
        boolean x$59 = qual$16.createRecursive$default$3();
        qual$16.createRecursive(x$57, x$58, x$59);
        KafkaZkClient qual$17 = this.zkClient();
        String x$60 = path;
        byte[] x$61 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$62 = 0;
        Option x$63 = qual$17.conditionalUpdatePath$default$4();
        statusAndVersion = qual$17.conditionalUpdatePath(x$60, x$61, x$62, x$63);
        Assert.assertTrue((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)1L, (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$18 = this.zkClient();
        String x$64 = path;
        byte[] x$65 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$66 = 2;
        Option x$67 = qual$18.conditionalUpdatePath$default$4();
        statusAndVersion = qual$18.conditionalUpdatePath(x$64, x$65, x$66, x$67);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
    }

    @Test
    public void testCreateSequentialPersistentPath() {
        String path = "/testpath";
        KafkaZkClient qual$19 = this.zkClient();
        String x$68 = path;
        byte[] x$69 = qual$19.createRecursive$default$2();
        boolean x$70 = qual$19.createRecursive$default$3();
        qual$19.createRecursive(x$68, x$69, x$70);
        String result = this.zkClient().createSequentialPersistentPath(new StringBuilder().append((Object)path).append((Object)"/sequence_").toString(), null);
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)None$.MODULE$, this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        result = this.zkClient().createSequentialPersistentPath(new StringBuilder().append((Object)path).append((Object)"/sequence_").toString(), "some value".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)new Some((Object)"some value"), this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
    }

    @Test
    public void testPropagateIsrChanges() {
        KafkaZkClient qual$20 = this.zkClient();
        String x$71 = "/isr_change_notification";
        byte[] x$72 = qual$20.createRecursive$default$2();
        boolean x$73 = qual$20.createRecursive$default$3();
        qual$20.createRecursive(x$71, x$72, x$73);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-a", 0), new TopicPartition("topic-b", 0)})));
        String expectedPath = "/isr_change_notification/isr_change_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-a\",\"partition\":0},{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-b", 0)})));
        expectedPath = "/isr_change_notification/isr_change_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testIsrChangeNotificationGetters() {
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$21 = this.zkClient();
        String x$74 = "/isr_change_notification";
        byte[] x$75 = qual$21.createRecursive$default$2();
        boolean x$76 = qual$21.createRecursive$default$3();
        qual$21.createRecursive(x$74, x$75, x$76);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11(), this.topicPartition10()})), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"}))));
    }

    @Test
    public void testIsrChangeNotificationsDeletion() {
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"})), this.controllerEpochZkVersion());
        KafkaZkClient qual$22 = this.zkClient();
        String x$77 = "/isr_change_notification";
        byte[] x$78 = qual$22.createRecursive$default$2();
        boolean x$79 = qual$22.createRecursive$default$3();
        qual$22.createRecursive(x$77, x$78, x$79);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()})));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.controllerEpochZkVersion());
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
    }

    @Test
    public void testPropagateLogDir() {
        KafkaZkClient qual$23 = this.zkClient();
        String x$80 = "/log_dir_event_notification";
        byte[] x$81 = qual$23.createRecursive$default$2();
        boolean x$82 = qual$23.createRecursive$default$3();
        qual$23.createRecursive(x$80, x$81, x$82);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        String expectedPath = "/log_dir_event_notification/log_dir_event_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        this.zkClient().propagateLogDirEvent(brokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000002";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":4,\"event\":1}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testLogDirGetters() {
        Assert.assertEquals((String)"getAllLogDirEventNotifications failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
        Assert.assertEquals((String)"getBrokerIdsFromLogDirEvents failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$24 = this.zkClient();
        String x$83 = "/log_dir_event_notification";
        byte[] x$84 = qual$24.createRecursive$default$2();
        boolean x$85 = qual$24.createRecursive$default$3();
        qual$24.createRecursive(x$83, x$84, x$85);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        this.zkClient().propagateLogDirEvent(brokerId);
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        Seq notifications012 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"}));
        Assert.assertEquals((Object)notifications012.toSet(), (Object)this.zkClient().getAllLogDirEventNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3, 4})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents(notifications012));
    }

    @Test
    public void testLogDirEventNotificationsDeletion() {
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.controllerEpochZkVersion());
        KafkaZkClient qual$25 = this.zkClient();
        String x$86 = "/log_dir_event_notification";
        byte[] x$87 = qual$25.createRecursive$default$2();
        boolean x$88 = qual$25.createRecursive$default$3();
        qual$25.createRecursive(x$86, x$87, x$88);
        int brokerId = 3;
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
    }

    @Test
    public void testSetGetAndDeletePartitionReassignment() {
        KafkaZkClient qual$26 = this.zkClient();
        String x$89 = AdminZNode$.MODULE$.path();
        byte[] x$90 = qual$26.createRecursive$default$2();
        boolean x$91 = qual$26.createRecursive$default$3();
        qual$26.createRecursive(x$89, x$90, x$91);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_b", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_c", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3})))}));
        this.intercept((Function0)new Serializable(this, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final scala.collection.immutable.Map reassignment$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().setOrCreatePartitionReassignment((Map)this.reassignment$1, this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.reassignment$1 = reassignment$1;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, this.controllerEpochZkVersion());
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map updatedReassignment = (scala.collection.immutable.Map)reassignment.$minus((Object)new TopicPartition("topic_b", 0));
        this.zkClient().setOrCreatePartitionReassignment((Map)updatedReassignment, this.controllerEpochZkVersion());
        Assert.assertEquals((Object)updatedReassignment, (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().deletePartitionReassignment(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().createPartitionReassignment(reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
    }

    @Test
    public void testGetDataAndStat() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option data0 = (Option)tuple2._1();
            Stat version0 = (Stat)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data0, (Object)version0);
            Option data02 = (Option)tuple23._1();
            Stat version02 = (Stat)tuple23._2();
            Assert.assertTrue((boolean)data02.isEmpty());
            Assert.assertEquals((long)0L, (long)version02.getVersion());
            KafkaZkClient qual$27 = this.zkClient();
            String x$92 = path;
            byte[] x$93 = qual$27.createRecursive$default$2();
            boolean x$94 = qual$27.createRecursive$default$3();
            qual$27.createRecursive(x$92, x$93, x$94);
            KafkaZkClient qual$28 = this.zkClient();
            String x$95 = path;
            byte[] x$96 = "version1".getBytes(StandardCharsets.UTF_8);
            int x$97 = 0;
            Option x$98 = qual$28.conditionalUpdatePath$default$4();
            qual$28.conditionalUpdatePath(x$95, x$96, x$97, x$98);
            Tuple2 tuple24 = this.zkClient().getDataAndStat(path);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Option data1 = (Option)tuple24._1();
                Stat version1 = (Stat)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)data1, (Object)version1);
                Option data12 = (Option)tuple26._1();
                Stat version12 = (Stat)tuple26._2();
                Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)version12.getVersion());
                KafkaZkClient qual$29 = this.zkClient();
                String x$99 = path;
                byte[] x$100 = "version2".getBytes(StandardCharsets.UTF_8);
                int x$101 = 1;
                Option x$102 = qual$29.conditionalUpdatePath$default$4();
                qual$29.conditionalUpdatePath(x$99, x$100, x$101, x$102);
                Tuple2 tuple27 = this.zkClient().getDataAndStat(path);
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Option data2 = (Option)tuple27._1();
                    Stat version2 = (Stat)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)data2, (Object)version2);
                    Option data22 = (Option)tuple29._1();
                    Stat version22 = (Stat)tuple29._2();
                    Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
                    Assert.assertEquals((long)2L, (long)version22.getVersion());
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testGetChildren() {
        String path = "/testpath";
        Assert.assertTrue((boolean)this.zkClient().getChildren(path).isEmpty());
        KafkaZkClient qual$30 = this.zkClient();
        String x$103 = "/testpath/child1";
        byte[] x$104 = qual$30.createRecursive$default$2();
        boolean x$105 = qual$30.createRecursive$default$3();
        qual$30.createRecursive(x$103, x$104, x$105);
        KafkaZkClient qual$31 = this.zkClient();
        String x$106 = "/testpath/child2";
        byte[] x$107 = qual$31.createRecursive$default$2();
        boolean x$108 = qual$31.createRecursive$default$3();
        qual$31.createRecursive(x$106, x$107, x$108);
        KafkaZkClient qual$32 = this.zkClient();
        String x$109 = "/testpath/child3";
        byte[] x$110 = qual$32.createRecursive$default$2();
        boolean x$111 = qual$32.createRecursive$default$3();
        qual$32.createRecursive(x$109, x$110, x$111);
        Seq children = this.zkClient().getChildren(path);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"child1", "child2", "child3"})), (Object)children.toSet());
    }

    @Test
    public void testAclManagementMethods() {
        ZkAclStore$.MODULE$.stores().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(ZkAclStore store) {
                Assert.assertFalse((boolean)this.$outer.zkClient().pathExists(store.aclPath()));
                Assert.assertFalse((boolean)this.$outer.zkClient().pathExists(store.changeStore().aclChangePath()));
                ResourceType$.MODULE$.values().foreach((Function1)new Serializable(this, store){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementMethods$1 $outer;
                    private final ZkAclStore store$1;

                    public final void apply(ResourceType resource) {
                        Assert.assertFalse((boolean)this.$outer.kafka$zk$KafkaZkClientTest$$anonfun$$$outer().zkClient().pathExists(this.store$1.path(resource)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.store$1 = store$1;
                    }
                });
            }

            public /* synthetic */ KafkaZkClientTest kafka$zk$KafkaZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkClient().createAclPaths();
        ZkAclStore$.MODULE$.stores().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(ZkAclStore store) {
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(store.aclPath()));
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(store.changeStore().aclChangePath()));
                ResourceType$.MODULE$.values().foreach((Function1)new Serializable(this, store){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementMethods$2 $outer;
                    private final ZkAclStore store$2;

                    public final void apply(ResourceType resource) {
                        Assert.assertTrue((boolean)this.$outer.kafka$zk$KafkaZkClientTest$$anonfun$$$outer().zkClient().pathExists(this.store$2.path(resource)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.store$2 = store$2;
                    }
                });
                Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
                Resource resource2 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
                SimpleAclAuthorizer.VersionedAcls versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertTrue((boolean)versionedAcls.acls().isEmpty());
                Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)versionedAcls.zkVersion());
                Assert.assertFalse((boolean)this.$outer.zkClient().resourceExists(resource1));
                Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
                Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
                Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
                Assert.assertFalse((boolean)this.$outer.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
                Assert.assertTrue((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))._1$mcZ$sp());
                Assert.assertTrue((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
                Assert.assertFalse((boolean)this.$outer.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
                versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})), (Object)versionedAcls.acls());
                Assert.assertEquals((long)0L, (long)versionedAcls.zkVersion());
                Assert.assertTrue((boolean)this.$outer.zkClient().resourceExists(resource1));
                Assert.assertTrue((boolean)this.$outer.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
                versionedAcls = this.$outer.zkClient().getVersionedAclsForResource(resource1);
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), (Object)versionedAcls.acls());
                Assert.assertEquals((long)1L, (long)versionedAcls.zkVersion());
                scala.collection.immutable.Set set = ((TraversableOnce)ResourceType$.MODULE$.values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ResourceType rt) {
                        return rt.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                scala.collection.immutable.Set set2 = this.$outer.zkClient().getResourceTypes(store.patternType()).toSet();
                Assert.assertTrue((!(set != null ? !set.equals(set2) : set2 != null) ? 1 : 0) != 0);
                Seq resourceNames = this.$outer.zkClient().getResourceNames(store.patternType(), (ResourceType)Topic$.MODULE$);
                Assert.assertEquals((long)2L, (long)resourceNames.size());
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resource1.name(), resource2.name()}));
                scala.collection.immutable.Set set3 = resourceNames.toSet();
                Assert.assertTrue((!(genTraversable != null ? !genTraversable.equals(set3) : set3 != null) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)this.$outer.zkClient().deleteResource(resource1));
                Assert.assertFalse((boolean)this.$outer.zkClient().resourceExists(resource1));
                Assert.assertFalse((boolean)this.$outer.zkClient().conditionalDelete(resource2, 10));
                Assert.assertTrue((boolean)this.$outer.zkClient().conditionalDelete(resource2, 0));
                this.$outer.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "resource1", store.patternType()));
                this.$outer.zkClient().createAclChangeNotification(new Resource((ResourceType)Topic$.MODULE$, "resource2", store.patternType()));
                Assert.assertEquals((long)2L, (long)this.$outer.zkClient().getChildren(store.changeStore().aclChangePath()).size());
                this.$outer.zkClient().deleteAclChangeNotifications();
                Assert.assertTrue((boolean)this.$outer.zkClient().getChildren(store.changeStore().aclChangePath()).isEmpty());
            }

            public /* synthetic */ KafkaZkClientTest kafka$zk$KafkaZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testDeletePath() {
        String path = "/a/b/c";
        KafkaZkClient qual$33 = this.zkClient();
        String x$112 = path;
        byte[] x$113 = qual$33.createRecursive$default$2();
        boolean x$114 = qual$33.createRecursive$default$3();
        qual$33.createRecursive(x$112, x$113, x$114);
        this.zkClient().deletePath(path);
        Assert.assertFalse((boolean)this.zkClient().pathExists(path));
    }

    @Test
    public void testDeleteTopicZNode() {
        this.zkClient().deleteTopicZNode(this.kafka$zk$KafkaZkClientTest$$topic1(), this.controllerEpochZkVersion());
        KafkaZkClient qual$34 = this.zkClient();
        String x$115 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$116 = qual$34.createRecursive$default$2();
        boolean x$117 = qual$34.createRecursive$default$3();
        qual$34.createRecursive(x$115, x$116, x$117);
        this.zkClient().deleteTopicZNode(this.kafka$zk$KafkaZkClientTest$$topic1(), this.controllerEpochZkVersion());
        Assert.assertFalse((boolean)this.zkClient().pathExists(TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1())));
    }

    @Test
    public void testDeleteTopicPathMethods() {
        Assert.assertFalse((boolean)this.zkClient().isTopicMarkedForDeletion(this.kafka$zk$KafkaZkClientTest$$topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
        this.zkClient().createDeleteTopicPath(this.kafka$zk$KafkaZkClientTest$$topic1());
        this.zkClient().createDeleteTopicPath(this.kafka$zk$KafkaZkClientTest$$topic2());
        Assert.assertTrue((boolean)this.zkClient().isTopicMarkedForDeletion(this.kafka$zk$KafkaZkClientTest$$topic1()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$zk$KafkaZkClientTest$$topic1(), this.$outer.kafka$zk$KafkaZkClientTest$$topic2()})), this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
    }

    private void assertPathExistenceAndData(String expectedPath, String data) {
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)data), this.dataAsString(expectedPath));
    }

    @Test
    public void testCreateTokenChangeNotification() {
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createTokenChangeNotification("delegationToken");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().createTokenChangeNotification("delegationToken");
        this.assertPathExistenceAndData("/delegation_token/token_changes/token_change_0000000000", "delegationToken");
    }

    @Test
    public void testEntityConfigManagementMethods() {
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1()).isEmpty());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1()));
        this.logProps().remove(LogConfig$.MODULE$.CleanupPolicyProp());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic2(), this.logProps());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), (Object)this.zkClient().getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).toSet());
        this.zkClient().deleteTopicConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1()).isEmpty());
    }

    @Test
    public void testCreateConfigChangeNotification() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000000", "{\"version\":2,\"entity_path\":\"/config/topics/topic1\"}");
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic2()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000001", "{\"version\":2,\"entity_path\":\"/config/topics/topic2\"}");
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProps(int bytesProp) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        return var2_2;
    }

    private Properties logProps() {
        return this.logProps;
    }

    @Test
    public void testGetLogConfigs() {
        LogConfig emptyConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((String)"Non existent config, no defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic1()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()})), Collections.emptyMap()));
        Properties logProps2 = this.createLogProps(2048);
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic1(), this.logProps());
        Assert.assertEquals((String)"One existing and one non-existent topic", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic2()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), Collections.emptyMap()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$zk$KafkaZkClientTest$$topic2(), logProps2);
        Assert.assertEquals((String)"Two existing topics", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic2()), (Object)new LogConfig((java.util.Map)logProps2, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), Collections.emptyMap()));
        Properties logProps1WithMoreValues = this.createLogProps(1024);
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentJitterMsProp(), "100");
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentBytesProp(), "1024");
        Assert.assertEquals((String)"Config with defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$zk$KafkaZkClientTest$$topic1()), (Object)new LogConfig((java.util.Map)logProps1WithMoreValues, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1()})), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"128")}))).asJava()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    @Test
    public void testRegisterBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo differentBrokerInfoWithSameId = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBroker(brokerInfo);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        Assert.assertEquals((String)"Other ZK clients can read broker info", (Object)new Some((Object)brokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
        this.zkClient().registerBroker(differentBrokerInfoWithSameId);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.intercept((Function0)new Serializable(this, differentBrokerInfoWithSameId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final BrokerInfo differentBrokerInfoWithSameId$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.otherZkClient().registerBroker(this.differentBrokerInfoWithSameId$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.differentBrokerInfoWithSameId$1 = differentBrokerInfoWithSameId$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
    }

    @Test
    public void testGetBrokerMethods() {
        this.zkClient().createTopLevelPaths();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getBroker(0));
        BrokerInfo brokerInfo0 = this.createBrokerInfo(0, "test.host0", 9998, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo brokerInfo1 = this.createBrokerInfo(1, "test.host1", 9999, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBroker(brokerInfo1);
        this.otherZkClient().registerBroker(brokerInfo0);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{brokerInfo0.broker(), brokerInfo1.broker()})), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)new Some((Object)brokerInfo0.broker()), (Object)this.zkClient().getBroker(0));
    }

    @Test
    public void testUpdateBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo originalBrokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        this.intercept((Function0)new Serializable(this, originalBrokerInfo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final BrokerInfo originalBrokerInfo$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().updateBrokerInfo(this.originalBrokerInfo$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalBrokerInfo$1 = originalBrokerInfo$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
        this.zkClient().registerBroker(originalBrokerInfo);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.otherZkClient().updateBrokerInfo(originalBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)originalBrokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
    }

    /*
     * WARNING - void declaration
     */
    private Stat statWithVersion(int version) {
        void var2_2;
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        stat.setVersion(version);
        return var2_2;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(int state, int zkVersion) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, state, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2 + state, 3 + state})), zkVersion), 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, state + 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1 + state, 2 + state})), zkVersion), 4))}));
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs() {
        return this.initialLeaderIsrAndControllerEpochs;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs() {
        return this.initialLeaderIsrs;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> leaderIsrs(int state, int zkVersion) {
        return this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(state, zkVersion).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$8) {
                return x$8.leaderAndIsr();
            }
        });
    }

    private void checkUpdateLeaderAndIsrResult(scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> expectedSuccessfulPartitions, Seq<TopicPartition> expectedPartitionsToRetry, scala.collection.immutable.Map<TopicPartition, Tuple2<Class<?>, String>> expectedFailedPartitions, KafkaZkClient.UpdateLeaderAndIsrResult actualUpdateLeaderAndIsrResult) {
        scala.collection.immutable.Map failedPartitionsExcerpt = actualUpdateLeaderAndIsrResult.failedPartitions().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Class<Exception>, String> apply(Exception e) {
                return new Tuple2(e.getClass(), (Object)e.getMessage());
            }
        });
        Assert.assertEquals((String)"Permanently failed updates do not match expected", expectedFailedPartitions, (Object)failedPartitionsExcerpt);
        Assert.assertEquals((String)"Retriable updates (due to BADVERSION) do not match expected", expectedPartitionsToRetry, (Object)actualUpdateLeaderAndIsrResult.partitionsToRetry());
        Assert.assertEquals((String)"Successful updates do not match expected", expectedSuccessfulPartitions, (Object)actualUpdateLeaderAndIsrResult.successfulPartitions());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        KafkaZkClient qual$35 = this.zkClient();
        String x$118 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$119 = qual$35.createRecursive$default$2();
        boolean x$120 = qual$35.createRecursive$default$3();
        qual$35.createRecursive(x$118, x$119, x$120);
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/0/state")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/1/state"))})), this.zkClient().updateLeaderAndIsr(this.initialLeaderIsrs(), 4, this.controllerEpochZkVersion()));
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final KafkaZkClient.UpdateLeaderAndIsrResult apply() {
                return this.$outer.zkClient().updateLeaderAndIsr(this.$outer.initialLeaderIsrs(), 4, this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        this.checkUpdateLeaderAndIsrResult(this.leaderIsrs(1, 1), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4, this.controllerEpochZkVersion()));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4, this.controllerEpochZkVersion()));
        scala.collection.immutable.Map mixedState = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderAndIsr(1, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0))}));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)this.leaderIsrs(2, 2).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final boolean apply(TopicPartition x$9) {
                TopicPartition topicPartition = x$9;
                TopicPartition topicPartition2 = this.$outer.topicPartition10();
                return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()}))), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic2/partitions/0/state"))})), this.zkClient().updateLeaderAndIsr(mixedState, 4, this.controllerEpochZkVersion()));
    }

    public void kafka$zk$KafkaZkClientTest$$checkGetDataResponse(scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs, TopicPartition topicPartition, GetDataResponse response) {
        int zkVersion = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)topicPartition)).leaderAndIsr().zkVersion();
        Assert.assertEquals((Object)KeeperException.Code.OK, (Object)response.resultCode());
        Assert.assertEquals((Object)TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Object)response.path());
        Assert.assertEquals((Object)new Some((Object)topicPartition), (Object)response.ctx());
        Assert.assertEquals((Object)new Some(leaderIsrAndControllerEpochs.apply((Object)topicPartition)), (Object)TopicPartitionStateZNode$.MODULE$.decode(response.data(), this.statWithVersion(zkVersion)));
    }

    public CreateResponse kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInCreateResponse(CreateResponse response) {
        ResponseMetadata x$121 = new ResponseMetadata(0L, 0L);
        None$ x$122 = None$.MODULE$;
        KeeperException.Code x$123 = response.copy$default$1();
        String x$124 = response.copy$default$2();
        Option x$125 = response.copy$default$3();
        String x$126 = response.copy$default$4();
        return response.copy(x$123, x$124, x$125, x$126, x$121, (Option)x$122);
    }

    @Test
    public void testGetTopicsAndPartitions() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        KafkaZkClient qual$36 = this.zkClient();
        String x$127 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$128 = qual$36.createRecursive$default$2();
        boolean x$129 = qual$36.createRecursive$default$3();
        qual$36.createRecursive(x$127, x$128, x$129);
        KafkaZkClient qual$37 = this.zkClient();
        String x$130 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic2());
        byte[] x$131 = qual$37.createRecursive$default$2();
        boolean x$132 = qual$37.createRecursive$default$3();
        qual$37.createRecursive(x$130, x$131, x$132);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$zk$KafkaZkClientTest$$topic1(), this.kafka$zk$KafkaZkClientTest$$topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})), (Object)this.zkClient().getAllPartitions());
    }

    @Test
    public void testCreateAndGetTopicPartitionStatesRaw() {
        KafkaZkClient qual$38 = this.zkClient();
        String x$133 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$134 = qual$38.createRecursive$default$2();
        boolean x$135 = qual$38.createRecursive$default$3();
        qual$38.createRecursive(x$133, x$134, x$135);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final Seq<CreateResponse> apply() {
                return this.$outer.zkClient().createTopicPartitionStatesRaw(this.$outer.initialLeaderIsrAndControllerEpochs(), this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final CreateResponse apply(CreateResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInCreateResponse(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(Tuple2<TopicPartition, GetDataResponse> x0$1) {
                Tuple2<TopicPartition, GetDataResponse> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    GetDataResponse r = (GetDataResponse)tuple2._2();
                    this.$outer.kafka$zk$KafkaZkClientTest$$checkGetDataResponse(this.$outer.initialLeaderIsrAndControllerEpochs(), tp, r);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final CreateResponse apply(CreateResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInCreateResponse(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSetTopicPartitionStatesRaw() {
        KafkaZkClient qual$39 = this.zkClient();
        String x$136 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$137 = qual$39.createRecursive$default$2();
        boolean x$138 = qual$39.createRecursive$default$3();
        qual$39.createRecursive(x$136, x$137, x$138);
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.NONODE, null), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SetDataResponse apply(SetDataResponse x$10) {
                ResponseMetadata x$139 = new ResponseMetadata(0L, 0L);
                None$ x$140 = None$.MODULE$;
                KeeperException.Code x$141 = x$10.copy$default$1();
                String x$142 = x$10.copy$default$2();
                Option x$143 = x$10.copy$default$3();
                Stat x$144 = x$10.copy$default$4();
                return x$10.copy(x$141, x$142, x$143, x$144, x$139, (Option)x$140);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(1)), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(1, 0), this.controllerEpochZkVersion()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final SetDataResponse apply(SetDataResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final Seq<SetDataResponse> apply() {
                return this.$outer.zkClient().setTopicPartitionStatesRaw(this.$outer.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(1, 0), this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(Tuple2<TopicPartition, GetDataResponse> x0$2) {
                Tuple2<TopicPartition, GetDataResponse> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    GetDataResponse r = (GetDataResponse)tuple2._2();
                    this.$outer.kafka$zk$KafkaZkClientTest$$checkGetDataResponse(this.$outer.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(1, 0), tp, r);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)this.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(2)), (Object)((TraversableOnce)this.otherZkClient().setTopicPartitionStatesRaw(this.kafka$zk$KafkaZkClientTest$$leaderIsrAndControllerEpochs(2, 1), this.controllerEpochZkVersion()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final SetDataResponse apply(SetDataResponse response) {
                return this.$outer.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testReassignPartitionsInProgress() {
        Assert.assertFalse((boolean)this.zkClient().reassignPartitionsInProgress());
        KafkaZkClient qual$40 = this.zkClient();
        String x$145 = ReassignPartitionsZNode$.MODULE$.path();
        byte[] x$146 = qual$40.createRecursive$default$2();
        boolean x$147 = qual$40.createRecursive$default$3();
        qual$40.createRecursive(x$145, x$146, x$147);
        Assert.assertTrue((boolean)this.zkClient().reassignPartitionsInProgress());
    }

    @Test
    public void testGetTopicPartitionStates() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        KafkaZkClient qual$41 = this.zkClient();
        String x$148 = TopicZNode$.MODULE$.path(this.kafka$zk$KafkaZkClientTest$$topic1());
        byte[] x$149 = qual$41.createRecursive$default$2();
        boolean x$150 = qual$41.createRecursive$default$3();
        qual$41.createRecursive(x$148, x$149, x$150);
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals(this.initialLeaderIsrAndControllerEpochs(), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))));
        Assert.assertEquals((Object)new Some(this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10())), (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        TopicPartition notExistingPartition = new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 2);
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{notExistingPartition}))).isEmpty());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10()))})), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), notExistingPartition}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(notExistingPartition));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(notExistingPartition));
    }

    public SetDataResponse kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(SetDataResponse response) {
        Stat stat = response.stat() == null ? null : this.statWithVersion(response.stat().getVersion());
        ResponseMetadata x$151 = new ResponseMetadata(0L, 0L);
        Stat x$152 = stat;
        None$ x$153 = None$.MODULE$;
        KeeperException.Code x$154 = response.copy$default$1();
        String x$155 = response.copy$default$2();
        Option x$156 = response.copy$default$3();
        return response.copy(x$154, x$155, x$156, x$152, x$151, (Option)x$153);
    }

    @Test
    public void testControllerEpochMethods() {
        this.zkClient().deletePath(ControllerEpochZNode$.MODULE$.path());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerEpoch());
        Assert.assertEquals((String)"Setting non existing nodes should return NONODE results", (Object)new SetDataResponse(KeeperException.Code.NONODE, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((String)"Creating non existing nodes is OK", (Object)new CreateResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, ControllerEpochZNode$.MODULE$.path(), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), (Object)this.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInCreateResponse(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((long)0L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Attemt to create existing nodes should return NODEEXISTS", (Object)new CreateResponse(KeeperException.Code.NODEEXISTS, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), (Object)this.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInCreateResponse(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((String)"Updating existing nodes is OK", (Object)new SetDataResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, this.statWithVersion(1), new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((long)1L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Updating with wrong ZK version returns BADVERSION", (Object)new SetDataResponse(KeeperException.Code.BADVERSION, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.kafka$zk$KafkaZkClientTest$$eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
    }

    @Test
    public void testControllerManagementMethods() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
        Tuple2 tuple2 = this.zkClient().registerControllerAndIncrementControllerEpoch(1);
        if (tuple2 != null) {
            int newEpochZkVersion;
            int n;
            int newEpochZkVersion2 = n = (newEpochZkVersion = tuple2._2$mcI$sp());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getControllerId());
            this.zkClient().deleteController(newEpochZkVersion2);
            Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        String mockPath = "/foo";
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, mockPath, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.class.handleDeletion((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.class.handleDataChange((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.class.$init$((ZNodeChangeHandler)this);
                this.path = mockPath$1;
            }
        };
        this.zkClient().registerZNodeChangeHandlerAndCheckExistence(zNodeChangeHandler);
        KafkaZkClient qual$42 = this.zkClient();
        String x$157 = mockPath;
        byte[] x$158 = qual$42.createRecursive$default$2();
        boolean x$159 = qual$42.createRecursive$default$3();
        qual$42.createRecursive(x$157, x$158, x$159);
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testClusterIdMethods() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assert.assertEquals((Object)clusterId, (Object)this.zkClient().getClusterId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("No cluster id found", new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1016));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    @Test
    public void testBrokerSequenceIdMethods() {
        int sequenceId = this.zkClient().generateBrokerSequenceId();
        Assert.assertEquals((long)(sequenceId + 1), (long)this.zkClient().generateBrokerSequenceId());
    }

    @Test
    public void testCreateTopLevelPaths() {
        this.zkClient().createTopLevelPaths();
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply(String path) {
                Assert.assertTrue((boolean)this.$outer.zkClient().pathExists(path));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPreferredReplicaElectionMethods() {
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
        scala.collection.immutable.Set electionPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 0), new TopicPartition(this.kafka$zk$KafkaZkClientTest$$topic1(), 1)}));
        this.zkClient().createPreferredReplicaElection(electionPartitions);
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.intercept((Function0)new Serializable(this, electionPartitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;
            private final scala.collection.immutable.Set electionPartitions$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPreferredReplicaElection(this.electionPartitions$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.electionPartitions$1 = electionPartitions$1;
            }
        }, ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1042));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().deletePreferredReplicaElection(this.$outer.controllerEpochZkVersion() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.zkClient().deletePreferredReplicaElection(this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
    }

    private Option<String> dataAsString(String path) {
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 != null) {
            Option data;
            Option option;
            Option data2 = option = (data = (Option)tuple2._1());
            return data2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(byte[] x$11) {
                    return new String(x$11, StandardCharsets.UTF_8);
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDelegationTokenMethods() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createDelegationTokenPaths();
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        String tokenId = "token1";
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        List renewers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)renewers).asJava(), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        byte[] bytes = new byte[20];
        Random$.MODULE$.nextBytes(bytes);
        DelegationToken token = new DelegationToken(tokenInfo, bytes);
        Assert.assertTrue((boolean)this.zkClient().getDelegationTokenInfo(tokenId).isEmpty());
        Assert.assertFalse((boolean)this.zkClient().deleteDelegationToken(tokenId));
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        tokenInfo.setExpiryTimestamp(System.currentTimeMillis());
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        Assert.assertTrue((boolean)this.zkClient().deleteDelegationToken(tokenId));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getDelegationTokenInfo(tokenId));
    }

    @Test
    public void testConsumerOffsetPath() {
        String consumerGroup = "test-group";
        String topic = "test-topic";
        int partition = 2;
        String expectedConsumerGroupOffsetsPath = this.getConsumersOffsetsZkPath$1(consumerGroup, topic, partition);
        String actualConsumerGroupOffsetsPath = ConsumerOffset$.MODULE$.path(consumerGroup, topic, Predef$.MODULE$.int2Integer(partition));
        Assert.assertEquals((Object)expectedConsumerGroupOffsetsPath, (Object)actualConsumerGroupOffsetsPath);
    }

    private final Seq expectedSetDataResponses$1(Seq topicPartitions, KeeperException.Code resultCode, Stat stat) {
        return (Seq)topicPartitions.map((Function1)new Serializable(this, resultCode, stat){
            public static final long serialVersionUID = 0L;
            private final KeeperException.Code resultCode$1;
            private final Stat stat$1;

            public final SetDataResponse apply(TopicPartition topicPartition) {
                return new SetDataResponse(this.resultCode$1, TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Option)new Some((Object)topicPartition), this.stat$1, new ResponseMetadata(0L, 0L), (Option)None$.MODULE$);
            }
            {
                this.resultCode$1 = resultCode$1;
                this.stat$1 = stat$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final String getConsumersOffsetsZkPath$1(String consumerGroup, String topic, int partition) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/consumers/", "/offsets/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerGroup, topic, BoxesRunTime.boxToInteger((int)partition)}));
    }

    public KafkaZkClientTest() {
        this.group = "my-group";
        this.kafka$zk$KafkaZkClientTest$$topic1 = "topic1";
        this.kafka$zk$KafkaZkClientTest$$topic2 = "topic2";
        this.controllerEpochZkVersion = 0;
    }
}

