/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u0011qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u001a-\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011m\u0001!Q1A\u0005\u0002q\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002;A\u0011\u0011BH\u0005\u0003?)\u00111!\u00138u\u0011!\t\u0003A!A!\u0002\u0013i\u0012!\u00032s_.,'/\u00133!\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001\u0006B\u0001\b]\u0016$xo\u001c:l\u0013\tQsE\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\u00111\u0002!\u0011!Q\u0001\n\u0015\nqB]3rk\u0016\u001cHo\u00115b]:,G\u000e\t\u0005\t]\u0001\u0011)\u0019!C\u0001_\u0005!\u0011\r]5t+\u0005\u0001\u0004CA\u00193\u001b\u0005\u0011\u0011BA\u001a\u0003\u0005%Y\u0015MZ6b\u0003BL7\u000f\u0003\u00056\u0001\t\u0005\t\u0015!\u00031\u0003\u0015\t\u0007/[:!\u0011!9\u0004A!A!\u0002\u0013A\u0014\u0001\u0002;j[\u0016\u0004\"!\u000f\"\u000e\u0003iR!!E\u001e\u000b\u0005qj\u0014AB2p[6|gN\u0003\u0002\u0006})\u0011q\bQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019%H\u0001\u0003US6,\u0007\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u00159,X\u000e\u00165sK\u0006$7\u000f\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003}\u0011X-];fgRD\u0015M\u001c3mKJ\feoZ%eY\u0016lU\r\u001e:jG:\u000bW.\u001a\t\u0003\u00132s!!\u0003&\n\u0005-S\u0011A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\u0006\t\u0011A\u0003!\u0011!Q\u0001\n!\u000ba\u0003\\8h\u0003:$G\u000b\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0005\u0006%\u0002!\taU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011Q+fk\u0016-Z5n\u0003\"!\r\u0001\t\u000bm\t\u0006\u0019A\u000f\t\u000b\r\n\u0006\u0019A\u0013\t\u000b9\n\u0006\u0019\u0001\u0019\t\u000b]\n\u0006\u0019\u0001\u001d\t\u000b\u0015\u000b\u0006\u0019A\u000f\t\u000b\u001d\u000b\u0006\u0019\u0001%\t\u000bA\u000b\u0006\u0019\u0001%\t\u000fu\u0003!\u0019!C\u0005=\u0006qA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,W#A0\u0011\u0005\u0001LW\"A1\u000b\u0005\t\u001c\u0017AB1u_6L7M\u0003\u0002eK\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0019<\u0017\u0001B;uS2T\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kC\ni\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u001c\u0001!\u0002\u0013y\u0016a\u0004;ie\u0016\fG\rU8pYNK'0\u001a\u0011\t\u000f9\u0004!\u0019!C\u0005_\u0006\u0011\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3s+\u0005\u0001\bCA9z\u001b\u0005\u0011(BA:u\u0003\u0011\u0019wN]3\u000b\u0005])(B\u0001<x\u0003\u0019I\u0018-\\7fe*\t\u00010A\u0002d_6L!A\u001f:\u0003\u000b5+G/\u001a:\t\rq\u0004\u0001\u0015!\u0003q\u0003M\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:!\u0011\u001dq\bA1A\u0005\u0002}\f\u0011B];o]\u0006\u0014G.Z:\u0016\u0005\u0005\u0005\u0001CBA\u0002\u0003\u001b\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u001diW\u000f^1cY\u0016T1!a\u0003\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\t)AA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA\u0019\u0002\u0014%\u0019\u0011Q\u0003\u0002\u0003'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0003\t!B];o]\u0006\u0014G.Z:!\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\tQb\u0019:fCR,\u0007*\u00198eY\u0016\u0014H\u0003BA\u0011\u0003O\u00012!CA\u0012\u0013\r\t)C\u0003\u0002\u0005+:LG\u000fC\u0004\u0002*\u0005m\u0001\u0019A\u000f\u0002\u0005%$\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!!\t\u00022!9\u00111GA\u0016\u0001\u0004i\u0012a\u00028foNK'0\u001a\u0005\b\u0003o\u0001A\u0011AA\u001d\u0003!\u0019\b.\u001e;e_^tGCAA\u0011\u0001")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandlerPool kafkaRequestHandlerPool = this;
        synchronized (kafkaRequestHandlerPool) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder().append((Object)this.logAndThreadNamePrefix).append((Object)"-kafka-request-handler-").append((Object)BoxesRunTime.boxToInteger((int)id)).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)new Serializable(this, newSize, currentSize){
            public static final long serialVersionUID = 0L;
            private final int newSize$1;
            private final int currentSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing request handler thread pool size from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentSize$1), BoxesRunTime.boxToInteger((int)this.newSize$1)}));
            }
            {
                this.newSize$1 = newSize$1;
                this.currentSize$1 = currentSize$1;
            }
        });
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRequestHandlerPool $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.createHandler(i);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)new Serializable(this, currentSize){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRequestHandlerPool $outer;
                private final int currentSize$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ((KafkaRequestHandler)this.$outer.runnables().remove(this.currentSize$1 - i)).stop();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentSize$1 = currentSize$1;
                }
            });
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "shutting down";
            }
        });
        this.runnables().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaRequestHandler handler) {
                handler.initiateShutdown();
            }
        });
        this.runnables().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaRequestHandler handler) {
                handler.awaitShutdown();
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "shut down completely";
            }
        });
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, KafkaApis apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        this.logIdent_$eq(new StringBuilder().append((Object)"[").append((Object)logAndThreadNamePrefix).append((Object)" Kafka Request Handler on Broker ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRequestHandlerPool $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.createHandler(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

