/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ta!\t\\8dW&twmU3oI\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u000591\r\\;ti\u0016\u0014\u0018BA\r\u0017\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u001fuI!A\b\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0011%\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\b\u001b\u0016$(/[2t\u0011!q\u0003A!A!\u0002\u0013y\u0013\u0001\u0002;j[\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$\u0001\u0002+j[\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u0003\u001d\n\u0005eR!aA%oi\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005dY&,g\u000e^%e!\ti\u0004I\u0004\u0002\n}%\u0011qHC\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@\u0015!AA\t\u0001B\u0001B\u0003%Q)\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"\u0001\r$\n\u0005\u001d\u000b$A\u0003'pO\u000e{g\u000e^3yi\")\u0011\n\u0001C\u0001\u0015\u00061A(\u001b8jiz\"\u0002b\u0013'N\u001d>\u0003\u0016K\u0015\t\u0003\u001f\u0001AQa\u0005%A\u0002QAQa\u0007%A\u0002qAQ\u0001\t%A\u0002\u0005BQA\f%A\u0002=BQA\u000e%A\u0002]BQa\u000f%A\u0002qBQ\u0001\u0012%A\u0002\u0015Cq\u0001\u0016\u0001C\u0002\u0013%Q+\u0001\u0006t_V\u00148-\u001a(pI\u0016,\u0012A\u0016\t\u0003/bk\u0011\u0001J\u0005\u00033\u0012\u0012AAT8eK\"11\f\u0001Q\u0001\nY\u000b1b]8ve\u000e,gj\u001c3fA!9Q\f\u0001b\u0001\n\u0013q\u0016!D:pG.,G\u000fV5nK>,H/F\u00018\u0011\u0019\u0001\u0007\u0001)A\u0005o\u0005q1o\\2lKR$\u0016.\\3pkR\u0004\u0003b\u00022\u0001\u0005\u0004%IaY\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0014\u0002\u000f\rd\u0017.\u001a8ug&\u0011\u0011N\u001a\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\r-\u0004\u0001\u0015!\u0003e\u00039qW\r^<pe.\u001cE.[3oi\u0002BQ!\u001c\u0001\u0005B9\f1b]3oIJ+\u0017/^3tiR\u0011qN\u001d\t\u0003KBL!!\u001d4\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\")1\u000f\u001ca\u0001i\u0006q!/Z9vKN$()^5mI\u0016\u0014\bgA;\u0002\u001cA)a/!\u0005\u0002\u00189\u0019q/a\u0003\u000f\u0007a\f9AD\u0002z\u0003\u000bq1A_A\u0002\u001d\rY\u0018\u0011\u0001\b\u0003y~l\u0011! \u0006\u0003}\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005!J\u0013BA\u0003(\u0013\t)c%C\u0002\u0002\n\u0011\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u001b\ty!A\bBEN$(/Y2u%\u0016\fX/Z:u\u0015\r\tI\u0001J\u0005\u0005\u0003'\t)BA\u0004Ck&dG-\u001a:\u000b\t\u00055\u0011q\u0002\t\u0005\u00033\tY\u0002\u0004\u0001\u0005\u0017\u0005u!/!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\u0012\u0014\u0003BA\u0011\u0003O\u00012!CA\u0012\u0013\r\t)C\u0003\u0002\b\u001d>$\b.\u001b8h!\u0011\tI#a\u000b\u000e\u0005\u0005=\u0011\u0002BA\u0017\u0003\u001f\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003c\u0001A\u0011IA\u001a\u00035Ig.\u001b;jCR,7\t\\8tKR\u0011\u0011Q\u0007\t\u0004\u0013\u0005]\u0012bAA\u001d\u0015\t!QK\\5u\u0011\u001d\ti\u0004\u0001C\u0001\u0003g\tQa\u00197pg\u0016\u0004")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
                return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
            }
            throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeout())})));
        }
        catch (Throwable throwable) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString());
            throw throwable;
        }
    }

    @Override
    public void initiateClose() {
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, Metrics metrics, Time time, int fetcherId, String clientId2, LogContext logContext) {
        this.sourceBroker = sourceBroker;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig2.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig2.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig2, (ListenerName)brokerConfig2.interBrokerListenerName(), (String)brokerConfig2.saslMechanismInterBrokerProtocol(), (Time)time, (boolean)brokerConfig2.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig2.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder, logContext);
        this.networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId2, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig2.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig2.requestTimeoutMs()), ClientDnsLookup.DEFAULT, time, false, new ApiVersions(), logContext);
    }
}

