/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args) {
        void var2_2;
        block4: {
            void var3_3;
            block7: {
                boolean bl;
                ZkSecurityMigrator.ZkSecurityMigratorOptions opts;
                block6: {
                    String string;
                    block5: {
                        String jaasFile = System.getProperty("java.security.auth.login.config");
                        opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
                        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
                        if (jaasFile == null) {
                            String errorMsg = new StringBuilder().append((Object)"No JAAS configuration file has been specified. Please make sure that you have set ").append((Object)new StringOps(Predef$.MODULE$.augmentString("the system property %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config"}))).toString();
                            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                            throw new IllegalArgumentException("Incorrect configuration");
                        }
                        if (!JaasUtils.isZkSecurityEnabled()) break block4;
                        string = (String)opts.options().valueOf(opts.zkAclOpt());
                        if (!"secure".equals(string)) break block5;
                        this.info((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "zookeeper.acl option is secure";
                            }
                        });
                        bl = true;
                        break block6;
                    }
                    if (!"unsecure".equals(string)) break block7;
                    this.info((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "zookeeper.acl option is unsecure";
                        }
                    });
                    bl = false;
                }
                boolean zkAcl = bl;
                String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
                int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
                int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
                KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, zkAcl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
                ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkClient);
                migrator.kafka$admin$ZkSecurityMigrator$$run();
                return;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie(var3_3.parser(), this.usageMessage());
        }
        String errorMsg = new StringOps(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}));
        System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
        throw new IllegalArgumentException("Incorrect configuration");
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }
}

