/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u0002KMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\f%oZ#se>\u0014H#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u00033\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000b),h.\u001b;\u000b\u0003!\n1a\u001c:h\u0013\tQSE\u0001\u0003UKN$\b\"\u0002\u0017\u0001\t\u0003Y\u0012aK:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148[W\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005-\u001a\u0003\"B\u0018\u0001\t\u0003Y\u0012aL:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Ce>\\WM]\"p[6\fg\u000eZ#se>\u0014\bF\u0001\u0018$\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003]\t7o]3si:{gNW3s_N#\u0018\r^;t\u000bbLG\u000f\u0006\u0002\u001di!)Q'\ra\u0001m\u0005!\u0011M]4t!\rir'O\u0005\u0003qy\u0011Q!\u0011:sCf\u0004\"AO\u001f\u000f\u0005uY\u0014B\u0001\u001f\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qr\u0002\"B!\u0001\t\u0003Y\u0012\u0001K:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u00072LWM\u001c;t\u000b:$\u0018\u000e^=UsB,\u0007F\u0001!$\u0011\u0015!\u0005\u0001\"\u0001\u001c\u0003\u001d\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'\u000fV8qS\u000e\u001cXI\u001c;jif$\u0016\u0010]3)\u0005\r\u001b\u0003\"B$\u0001\t\u0003Y\u0012\u0001K:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u0005J|7.\u001a:t\u000b:$\u0018\u000e^=UsB,\u0007F\u0001$$\u0011\u0015Q\u0005\u0001\"\u0001L\u0003E!Xm\u001d;Be\u001e,X.\u001a8u!\u0006\u00148/\u001a\u000b\u000391CQ!T%A\u0002e\n!\"\u001a8uSRLH+\u001f9f\u0011\u0015y\u0005\u0001\"\u0001\u001c\u0003\t\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g+:\u0014XmY8h]&\u001cX\rZ#oi&$\u0018\u0010V=qK\"\"ajI)S\u0003!)\u0007\u0010]3di\u0016$7%A*\u0011\u0005QcfBA+[\u001d\t1\u0016,D\u0001X\u0015\tAf!\u0001\u0004=e>|GOP\u0005\u0002?%\u00111LH\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!a\u0017\u0010\t\u000b\u0001\u0004A\u0011A\u000e\u0002+MDw.\u001e7e\u0003\u0012$7\t\\5f]R\u001cuN\u001c4jO\"\u0012ql\t\u0005\u0006G\u0002!\taG\u0001\u0015g\"|W\u000f\u001c3BI\u0012$v\u000e]5d\u0007>tg-[4)\u0005\t\u001c\u0003\"\u00024\u0001\t\u0003Y\u0012AG:i_VdG-\u00113e\u0005J|7.\u001a:Rk>$\u0018mQ8oM&<\u0007FA3$\u0011\u0015I\u0007\u0001\"\u0001\u001c\u0003q\u0019\bn\\;mI\u0006#GM\u0011:pW\u0016\u0014H)\u001f8b[&\u001c7i\u001c8gS\u001eD#\u0001[\u0012\t\u000b1\u0004A\u0011A\u000e\u0002GMDw.\u001e7e\u0003\u0012$G)\u001a4bk2$(I]8lKJ$\u0015P\\1nS\u000e\u001cuN\u001c4jO\"\u00121n\t\u0005\u0006_\u0002!\t\u0001]\u0001\u0018m\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e$B\u0001H9}}\")!O\u001ca\u0001g\u0006!an\u001c3f!\t!(0D\u0001v\u0015\t1x/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000baT!!_\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tYXO\u0001\u0003O_\u0012,\u0007\"B?o\u0001\u0004I\u0014\u0001\u0004:fg>,(oY3OC6,\u0007BB@o\u0001\u0004\t\t!\u0001\u0007sKN|WO]2f\u001fB$8\u000f\u0005\u0003U\u0003\u0007I\u0014bAA\u0003=\n!A*[:u\u0011\u0019\tI\u0001\u0001C\u00017\u0005\t3\u000f[8vY\u0012\u001cV\u000f\u001d9peR\u001cu.\\7b'\u0016\u0004\u0018M]1uK\u00124\u0016\r\\;fg\"\u001a\u0011qA\u0012\t\r\u0005=\u0001\u0001\"\u0001\u001c\u0003A\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\rZ#oi&$\u0018PT1nK\"*\u0011QB\u0012R%\"1\u0011Q\u0003\u0001\u0005\u0002m\t1\u0006^3ti\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4Va\u0012\fG/Z+tS:<'l\\8LK\u0016\u0004XM\u001d\u0015\u0004\u0003'\u0019\u0003BBA\u000e\u0001\u0011\u00051$\u0001\u0017tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u001cuN\u001c4jO\"*\u0011\u0011D\u0012R%\"1\u0011\u0011\u0005\u0001\u0005\u0002m\t1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\u000b\u0005}1%\u0015*\t\r\u0005\u001d\u0002\u0001\"\u0001\u001c\u0003]\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3gj\u001c8Fq&\u001cH/\u001b8h\u0007>tg-[4Jg\u0012+G.\u001a;fI\"2\u0011QE\u0012R\u0003W\u0019#!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rv\u0003\u0019)'O]8sg&!\u0011qGA\u0019\u0005uIeN^1mS\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t\u0007BBA\u001e\u0001\u0011\u00051$\u0001\rtQ>,H\u000e\u001a#fY\u0016$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eD3!!\u000f$\u0011\u0019\t\t\u0005\u0001C\u00017\u0005!B/Z:u'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYND3!a\u0010$\u0011\u0019\t9\u0005\u0001C\u00017\u0005)B/Z:u#V|G/Y\"p]\u001aLw-\u00128uSRL\bfAA#G!1\u0011Q\n\u0001\u0005\u0002m\tq\u0003^3tiV\u001bXM]\"mS\u0016tG/U;pi\u0006|\u0005\u000f^:)\u0007\u0005-3\u0005\u0003\u0004\u0002T\u0001!\taG\u0001\u001ai\u0016\u001cH/U;pi\u0006$Um]2sS\n,WI\u001c;ji&,7\u000fK\u0002\u0002R\rBq!!\u0017\u0001\t\u0013\tY&\u0001\nsK\u001eL7\u000f^3s\u0005J|7.\u001a:J]j[Gc\u0001\u000f\u0002^!A\u0011qLA,\u0001\u0004\t\t'\u0001\u0002jIB\u0019Q$a\u0019\n\u0007\u0005\u0015dDA\u0002J]R4a!!\u001b\u0001\u0001\u0005-$A\u0005#v[6L\u0018\tZ7j]j[7\t\\5f]R\u001cB!a\u001a\u0002nA\u0019\u0011\"a\u001c\n\u0007\u0005E$BA\u0007BI6LgNW6DY&,g\u000e\u001e\u0005\f\u0003k\n9G!A!\u0002\u0013\t9(\u0001\u0005{W\u000ec\u0017.\u001a8u!\rI\u0011\u0011P\u0005\u0004\u0003wR!!D&bM.\f'l[\"mS\u0016tG\u000fC\u0004\u0016\u0003O\"\t!a \u0015\t\u0005\u0005\u0015Q\u0011\t\u0005\u0003\u0007\u000b9'D\u0001\u0001\u0011!\t)(! A\u0002\u0005]\u0004\u0002CAE\u0003O\"\t%a#\u0002%\rD\u0017M\\4f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u00069\u00055\u0015Q\u0014\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002\u0012\u0006I!M]8lKJLEm\u001d\t\u0007\u0003'\u000bI*!\u0019\u000e\u0005\u0005U%bAAL=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\u0004'\u0016\f\b\u0002CAP\u0003\u000f\u0003\r!!)\u0002\u000f\r|gNZ5hgB!\u00111UAW\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016\u0001B;uS2T!!a+\u0002\t)\fg/Y\u0005\u0005\u0003_\u000b)K\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001\"a-\u0002h\u0011\u0005\u0013QW\u0001\u0012M\u0016$8\r[#oi&$\u0018pQ8oM&<GCBAQ\u0003o\u000bI\f\u0003\u0004N\u0003c\u0003\r!\u000f\u0005\b\u0003w\u000b\t\f1\u0001:\u0003))g\u000e^5us:\u000bW.\u001a\u0005\t\u0003\u007f\u000b9\u0007\"\u0011\u0002B\u0006!2\r[1oO\u0016\u001cE.[3oi&#7i\u001c8gS\u001e$R\u0001HAb\u0003\u000fDq!!2\u0002>\u0002\u0007\u0011(\u0001\u0005dY&,g\u000e^%e\u0011!\ty*!0A\u0002\u0005\u0005\u0006\u0002CAf\u0003O\"\t%!4\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<G#\u0002\u000f\u0002P\u0006M\u0007bBAi\u0003\u0013\u0004\r!O\u0001\u0014g\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\t\u0003?\u000bI\r1\u0001\u0002\"\"A\u0011q[A4\t\u0003\nI.A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$R\u0001HAn\u0003?Dq!!8\u0002V\u0002\u0007\u0011(A\u0003u_BL7\r\u0003\u0005\u0002 \u0006U\u0007\u0019AAQ\u0001")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigCommandTest$CredentialChange$4$ CredentialChange$2$lzycompute(scala.collection.mutable.Map x$1, VolatileObjectRef x$2) {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (x$2.elem != null) return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
            x$2.elem = new ConfigCommandTest$CredentialChange$4$(this, x$1);
            return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
        }
    }

    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this, exitStatus){
            public static final long serialVersionUID = 0L;
            private final ObjectRef exitStatus$1;

            public final Nothing$ apply(int status, Option<String> x$1) {
                this.exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
                throw new RuntimeException();
            }
            {
                this.exitStatus$1 = exitStatus$1;
            }
        });
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(this, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(this, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(this, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "1"})));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default"})));
    }

    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        List optsList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--alter", "--add-config", "message.max.bytes=10"})).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, brokerConfigs, describeResult, alterResult){
            private final String resourceName$1;
            public final scala.collection.mutable.Map brokerConfigs$1;
            private final DescribeConfigsResult describeResult$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$1, (Object)resource.name());
                return this.describeResult$1;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final Option<String> apply(ConfigEntry e) {
                        return this.$outer.brokerConfigs$1.put((Object)e.name(), (Object)e.value());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return this.alterResult$1;
            }
            {
                this.resourceName$1 = resourceName$1;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.describeResult$1 = describeResult$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterBrokerConfig((AdminClient)mockAdminClient, alterOpts, resourceName);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")})), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public void changeTopicConfig(String topic, Properties configs) {
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(this, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"});
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"110000")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"120000")})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"130000")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"140000")})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.intercept((Function0)new Serializable(this, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)None$.MODULE$, this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"2")}));
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret")}));
        this.kafka$admin$ConfigCommandTest$$alterConfig$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, adminZkClient, alterOpts);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password"), (Object)"secret2")}));
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()), (Object)"DES/CBC/PKCS5Padding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()), (Object)"1024"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp()), (Object)"PBKDF2WithHmacSHA1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()), (Object)"64")}));
        this.kafka$admin$ConfigCommandTest$$alterConfig$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, adminZkClient, alterOpts);
        Properties brokerConfigs2 = this.zkClient().getEntityConfigs("brokers", brokerId);
        String encodedPassword2 = brokerConfigs2.getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        this.intercept((Function0)new Serializable(this, adminZkClient, alterOpts, configs, encoderConfigs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;
            private final scala.collection.immutable.Map configs$1;
            private final scala.collection.immutable.Map encoderConfigs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1(this.configs$1, (Option)None$.MODULE$, this.encoderConfigs$1, this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
                this.configs$1 = configs$1;
                this.encoderConfigs$1 = encoderConfigs$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.registerBrokerInZk(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt());
        this.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"210000")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.intercept((Function0)new Serializable(this, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"220000")})), (Option)None$.MODULE$, this.$outer.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"230000")})), (Option)new Some((Object)"2"), adminZkClient, alterOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(this, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        VolatileObjectRef CredentialChange$module = VolatileObjectRef.zero();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends AdminZkClient
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            public final /* synthetic */ ConfigCommandTest $outer;
            public final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Properties apply() {
                        return new Properties();
                    }
                });
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1)new Serializable(this, configChange){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Kafka_admin_ConfigCommandTest$CredentialChange$3 $outer;
                    private final Properties configChange$1;

                    public final Object apply(String mechanism) {
                        String value = this.configChange$1.getProperty(mechanism);
                        Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                        ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                        Assert.assertEquals((long)this.$outer.iterations(), (long)scramCredential.iterations());
                        return this.configChange$1 == null ? BoxedUnit.UNIT : this.$outer.credentials$1.put((Object)this.$outer.user(), (Object)this.configChange$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.configChange$1 = configChange$1;
                    }
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.kafka$admin$ConfigCommandTest$CredentialChange$$$outer(), user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 0: {
                        object = this.user();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)((Object)x$1);
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual((Object)((Object)this))) return false;
                return true;
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$CredentialChange$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.class.$init$((Product)this);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, clientId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String clientId$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)this.clientId$1), this.clientId$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientId$1 = clientId$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, principal, sanitizedPrincipal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String principal$1;
            private final String sanitizedPrincipal$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.sanitizedPrincipal$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String[] describeOpts$1;
            private final String clientId$1;
            private final String principal$1;
            private final String sanitizedPrincipal$1;
            private final String userClient$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.userClient$1, (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), new StringBuilder().append((Object)this.sanitizedPrincipal$1).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)this.clientId$1).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])this.describeOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
                this.clientId$1 = clientId$1;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
                this.userClient$1 = userClient$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients").toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])describeOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.kafka$admin$ConfigCommandTest$$clientIdOpts$1(clientId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/").append((Object)Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    @Test
    public void testQuotaDescribeEntities() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/<default>").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-4").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        this.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    private final String[] entityOpt$1(Option brokerId) {
        return (String[])brokerId.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String id) {
                return (String[])((Object[])new String[]{"--entity-name", id});
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])((Object[])new String[]{"--entity-default"});
            }
        });
    }

    public final void kafka$admin$ConfigCommandTest$$alterConfig$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        String configStr = ((TraversableOnce)configs.$plus$plus((GenTraversableOnce)encoderConfigs).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])alterOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.entityOpt$1(brokerId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--add-config", configStr}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfig(this.zkClient(), addOpts, adminZkClient$1);
    }

    public final scala.collection.immutable.Map kafka$admin$ConfigCommandTest$$alterConfig$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)brokerId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        }));
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        this.kafka$admin$ConfigCommandTest$$alterConfig$1(configs, brokerId, this.kafka$admin$ConfigCommandTest$$alterConfig$default$3$1(), adminZkClient$1, alterOpts$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])alterOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.entityOpt$1(brokerId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete-config", configNames.mkString(",")}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfig(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final ConfigCommandTest$CredentialChange$4$ CredentialChange$2(scala.collection.mutable.Map credentials$1, VolatileObjectRef CredentialChange$module$1) {
        return CredentialChange$module$1.elem == null ? this.CredentialChange$2$lzycompute(credentials$1, CredentialChange$module$1) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.elem);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        Option option;
        block4: {
            String[] stringArray;
            String[] optArray;
            block3: {
                block2: {
                    optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
                    option = entityName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    stringArray = (String[])((Object[])new String[]{"--entity-name", name});
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            String[] nameArray = stringArray;
            return new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optArray).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nameArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        throw new MatchError((Object)option);
    }

    public final void kafka$admin$ConfigCommandTest$$checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final String[] kafka$admin$ConfigCommandTest$$clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])opts).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1)new Serializable(this, zkClient$1){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$1;

            public final IExpectationSetters<Seq<String>> apply(Tuple2<String, Seq<String>> x0$2) {
                Tuple2<String, Seq<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
                    return iExpectationSetters;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigCommand.ConfigEntity e) {
                return e.fullSanitizedName();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

