/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.TopicCommand;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u00055\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005\u0011)f.\u001b;\t\u000fIR\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/F\u00019!\u0011Id\bQ\"\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121!T1q!\tq\u0013)\u0003\u0002CA\t\u0019\u0011J\u001c;\u0011\u0007e\"\u0005)\u0003\u0002Fu\t!A*[:u\u0011\u00199\u0005\u0001)A\u0005q\u0005QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA!)\u0011\n\u0001C!\u0015\u0006AA/Z1s\t><h\u000eF\u0001.Q\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011\u0001&\u0002GQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5BY2\fE.\u001b<f%\u0016\u0004H.[2bg\"\u0012Ak\u0016\t\u0003\u001bbK!!\u0017(\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\tAS\u0001+i\u0016\u001cHOU3tk6,G)\u001a7fi\u0016$v\u000e]5d/&$\bNU3d_Z,'/\u001a3G_2dwn^3sQ\tQv\u000bC\u0003_\u0001\u0011\u0005!*A\u0015uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2P]\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002)\u000b!\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002a/\")A\r\u0001C\u0005K\u0006iq-\u001a;D_:$(o\u001c7mKJ$\u0012A\u001a\t\u0005]\u001d$\u0003)\u0003\u0002iA\t1A+\u001e9mKJBQA\u001b\u0001\u0005\n)\u000ba#\u001a8tkJ,7i\u001c8ue>dG.\u001a:Fq&\u001cHo\u001d\u0005\u0006Y\u0002!I!\\\u0001\u001dO\u0016$\u0018\t\u001c7SKBd\u0017nY1t\rJ|W.Q:tS\u001etW.\u001a8u)\u0011q70!\u0001\u0011\u0007=\u0014XO\u0004\u0002/a&\u0011\u0011\u000fI\u0001\u0007!J,G-\u001a4\n\u0005M$(aA*fi*\u0011\u0011\u000f\t\t\u0003mfl\u0011a\u001e\u0006\u0003q\u0012\t!bY8oiJ|G\u000e\\3s\u0013\tQxOA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0003}W\u0002\u0007Q0A\u0003u_BL7\r\u0005\u0002p}&\u0011q\u0010\u001e\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\r1\u000e1\u0001\u0002\u0006\u0005Q\u0011m]:jO:lWM\u001c;\u0011\r=\f9\u0001QA\u0005\u0013\tyD\u000fE\u0002\u0018C\u0001Ca!!\u0004\u0001\t\u0003Q\u0015a\u000b;fgRLen\u0019:fCN,\u0007+\u0019:uSRLwN\\\"pk:$H)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0007\u0005-q\u000b\u0003\u0004\u0002\u0014\u0001!\tAS\u0001\"i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0012+(/\u001b8h\u0003\u0012$\u0007+\u0019:uSRLwN\u001c\u0015\u0004\u0003#9\u0006BBA\r\u0001\u0011\u0005!*A\u0011uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\rK\u0002\u0002\u0018]Ca!a\b\u0001\t\u0003Q\u0015A\b;fgR\u0014Vm\u0019:fCR,Gk\u001c9jG\u00063G/\u001a:EK2,G/[8oQ\r\tib\u0016\u0005\u0007\u0003K\u0001A\u0011\u0001&\u00025Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0007\u0005\rr\u000b\u0003\u0004\u0002,\u0001!\tAS\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[\"mK\u0006tWM\u001d\u0015\u0004\u0003S9\u0006BBA\u0019\u0001\u0011\u0005!*A\u0013uKN$H)\u001a7fi\u0016$v\u000e]5d\u00032\u0014X-\u00193z\u001b\u0006\u00148.\u001a3Bg\u0012+G.\u001a;fI\"\u001a\u0011qF,\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005I2M]3bi\u0016$Vm\u001d;U_BL7-\u00118e\u00072,8\u000f^3s)\u001d1\u00121HA\u001f\u0003\u000fBa\u0001`A\u001b\u0001\u0004i\bBCA \u0003k\u0001\n\u00111\u0001\u0002B\u0005\u0011B-\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e!\rq\u00131I\u0005\u0004\u0003\u000b\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003\u0013\n)\u0004%AA\u0002\u0005-\u0013!\u0005:fa2L7-Y!tg&<g.\\3oiB1q.a\u0002A\u0003\u001b\u0002BaFA(\u0001&\u0011Qi\t\u0005\b\u0003o\u0001A\u0011BA*)\u001d1\u0012QKA,\u0003[Ba\u0001`A)\u0001\u0004i\b\u0002CA-\u0003#\u0002\r!a\u0017\u0002\u001b\t\u0014xn[3s\u0007>tg-[4t!\u00119\u0012%!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005!Q\u000f^5m\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\tI%!\u0015A\u0002\u0005-\u0003bBA9\u0001\u0011%\u00111O\u0001\noJLG/\u001a#vaN$\u0002\"!\u001e\u0002z\u0005u\u0014\u0011\u0011\t\u0005/\u0005\n9\b\u0005\u0003/O\u0002\u0003\u0005bBA>\u0003_\u0002\r\u0001Q\u0001\b]Vl7*Z=t\u0011\u001d\ty(a\u001cA\u0002\u0001\u000bqA\\;n\tV\u00048\u000f\u0003\u0005\u0002\u0004\u0006=\u0004\u0019AAC\u0003\rawn\u001a\t\u0005\u0003\u000f\u000bY)\u0004\u0002\u0002\n*\u0019\u00111\u0011\u0003\n\t\u00055\u0015\u0011\u0012\u0002\u0004\u0019><\u0007BBAI\u0001\u0011\u0005!*\u0001\fuKN$H)[:bE2,G)\u001a7fi\u0016$v\u000e]5dQ\r\tyi\u0016\u0005\u0007\u0003/\u0003A\u0011\u0001&\u0002CQ,7\u000f\u001e#fY\u0016$\u0018N\\4QCJ$\u0018.\u00197ms\u0012+G.\u001a;fIR{\u0007/[2)\u0007\u0005Uu\u000bC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0003\u0002 \u0006\u00193M]3bi\u0016$Vm\u001d;U_BL7-\u00118e\u00072,8\u000f^3sI\u0011,g-Y;mi\u0012\u0012TCAAQU\u0011\t\t%a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a.\u0001#\u0003%I!!/\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0018\u0016\u0005\u0003\u0017\n\u0019\u000b")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((IterableLike)this.$outer.servers().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer x$1) {
                        LogManager qual$1 = x$1.getLogManager();
                        TopicPartition x$17 = this.$outer.topicPartition$1;
                        boolean x$18 = qual$1.getLog$default$2();
                        return qual$1.getLog(x$17, x$18).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.follower$1 = follower$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas 0,1 have not deleted log.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a follower replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin path /admin/delete_topic/test path deleted even when a replica is down";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        controller.startup();
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            private final Seq servers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$2) {
                        LogManager qual$2 = x$2.getLogManager();
                        TopicPartition x$19 = this.$outer.topicPartition$2;
                        boolean x$20 = qual$2.getLog$default$2();
                        return qual$2.getLog(x$19, x$20).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.servers$1 = servers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$21 = this.zkClient();
        None$ x$22 = None$.MODULE$;
        scala.collection.immutable.Map x$23 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)newReplicas)}));
        AdminZkClient x$24 = this.adminZkClient();
        Map x$25 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$21, (Option)x$22, (Map)x$23, x$25, x$24);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$2), (Object)this.newReplicas$1)}))).getOrElse((Object)this.topicPartition$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$2 $outer;

                    public final Nothing$ apply() {
                        return this.$outer.kafka$admin$DeleteTopicTest$$anonfun$$$outer().fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get reassignment status for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition$2})), new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(object != null ? !object.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }

            public /* synthetic */ DeleteTopicTest kafka$admin$DeleteTopicTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition reassignment shouldn't complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, controller){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;
            private final KafkaServer controller$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.controller$1.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)this.topicPartition$2);
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.controller$1 = controller$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition should be removed from partitionsBeingReassigned.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    public Tuple2<KafkaServer, Object> kafka$admin$DeleteTopicTest$$getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        }).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller should eventually exist";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment2) {
        return ((TraversableOnce)assignment2.flatMap((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            public final String topic$3;

            public final Seq<PartitionAndReplica> apply(Tuple2<Object, Seq<Object>> x0$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    Seq seq = (Seq)replicas.map((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getAllReplicasFromAssignment$1 $outer;
                        private final int partition$1;

                        public final PartitionAndReplica apply(int r) {
                            return new PartitionAndReplica(new TopicPartition(this.$outer.topic$3, this.partition$1), r);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$2;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$2 = expectedReplicaAssignment$2;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$3;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testIncreasePartitionCountDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$3) {
                        LogManager qual$3 = x$3.getLogManager();
                        TopicPartition x$26 = this.$outer.topicPartition$3;
                        boolean x$27 = qual$3.getLog$default$2();
                        return qual$3.getLog(x$26, x$27).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.servers$2 = servers$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        follower2.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.kafka$admin$DeleteTopicTest$$getController();
        if (tuple2 != null) {
            Tuple2 tuple22;
            KafkaServer controller = (KafkaServer)tuple2._1();
            int controllerId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
            KafkaServer controller2 = (KafkaServer)tuple23._1();
            int controllerId2 = tuple23._2$mcI$sp();
            scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, (scala.collection.immutable.Map<Object, Seq<Object>>)expectedReplicaAssignment);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, controller2, allReplicasForTopic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;
                private final KafkaServer controller$2;
                private final scala.collection.immutable.Set allReplicasForTopic$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    scala.collection.immutable.Set replicasInDeletionSuccessful = this.controller$2.kafkaController().replicaStateMachine().replicasInState(this.topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
                    scala.collection.immutable.Set offlineReplicas = this.controller$2.kafkaController().replicaStateMachine().replicasInState(this.topic$4, (ReplicaState)OfflineReplica$.MODULE$);
                    scala.collection.immutable.Set set = this.allReplicasForTopic$1;
                    Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
                    return !(set != null ? !set.equals(set2) : set2 != null);
                }
                {
                    this.topic$4 = topic$4;
                    this.controller$2 = controller$2;
                    this.allReplicasForTopic$1 = allReplicasForTopic$1;
                }
            }, (Function0<String>)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not all replicas for topic ", " are in states of either ReplicaDeletionSuccessful or OfflineReplica"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                }
                {
                    this.topic$4 = topic$4;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
            new TopicCommand.ZookeeperTopicService(this.zkClient()).alterTopic(topicCommandOptions);
            int previousControllerId = controllerId2;
            controller2.shutdown();
            this.ensureControllerExists();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, previousControllerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                private final int previousControllerId$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Tuple2<KafkaServer, Object> tuple2 = this.$outer.kafka$admin$DeleteTopicTest$$getController();
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        KafkaServer newController = (KafkaServer)tuple2._1();
                        int newControllerId = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)newController, (Object)BoxesRunTime.boxToInteger((int)newControllerId));
                        KafkaServer newController2 = (KafkaServer)tuple23._1();
                        int newControllerId2 = tuple23._2$mcI$sp();
                        return newControllerId2 != this.previousControllerId$1;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.previousControllerId$1 = previousControllerId$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The new controller should not have the failed controller id";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            follower2.startup();
            controller2.startup();
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower2 = (KafkaServer)((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$5;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$5.get());
            }
            {
                this.leaderIdOpt$5 = leaderIdOpt$5;
            }
        })).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode x$28 = qual$4.getBrokerMetadatas$default$1();
        Option x$29 = qual$4.getBrokerMetadatas$default$2();
        Seq brokers = qual$4.getBrokerMetadatas(x$28, x$29);
        follower2.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final KafkaServer follower$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getBroker(this.follower$2.config().brokerId()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.follower$2 = follower$2;
            }
        }, (Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " was not removed from ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$2.config().brokerId())}));
            }
            {
                this.follower$2 = follower$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        AdminZkClient qual$5 = this.adminZkClient();
        String x$30 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$31 = this.expectedReplicaAssignment();
        Seq x$32 = brokers;
        int x$33 = 2;
        Some x$34 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$35 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$30, x$31, x$32, x$33, (Option)x$34, x$35);
        this.adminZkClient().deleteTopic(topic);
        follower2.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$2 $outer;

                    public final boolean apply(KafkaServer x$7) {
                        LogManager qual$6 = x$7.getLogManager();
                        TopicPartition x$36 = this.$outer.newPartition$1;
                        boolean x$37 = qual$6.getLog$default$2();
                        return qual$6.getLog(x$36, x$37).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newPartition$1 = newPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$7 = this.adminZkClient();
        RackAwareMode x$38 = qual$7.getBrokerMetadatas$default$1();
        Option x$39 = qual$7.getBrokerMetadatas$default$2();
        Seq brokers = qual$7.getBrokerMetadatas(x$38, x$39);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$8 = this.adminZkClient();
        String x$40 = topic;
        scala.collection.immutable.Map<Object, List<Object>> x$41 = this.expectedReplicaAssignment();
        Seq x$42 = brokers;
        int x$43 = 2;
        Some x$44 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$45 = qual$8.addPartitions$default$6();
        qual$8.addPartitions(x$40, x$41, x$42, x$43, (Option)x$44, x$45);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition newPartition$2;

            public final boolean apply(KafkaServer x$8) {
                LogManager qual$9 = x$8.getLogManager();
                TopicPartition x$46 = this.newPartition$2;
                boolean x$47 = qual$9.getLog$default$2();
                return qual$9.getLog(x$46, x$47).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        }));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            public final TopicPartition topicPartition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(KafkaServer x$9) {
                        LogManager qual$10 = x$9.getLogManager();
                        TopicPartition x$48 = this.$outer.topicPartition$4;
                        boolean x$49 = qual$10.getLog$default$2();
                        return qual$10.getLog(x$48, x$49).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicTest $outer;
                public final TopicPartition topicPartition$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.servers().forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                        public final boolean apply(KafkaServer x$10) {
                            LogManager qual$11 = x$10.getLogManager();
                            TopicPartition x$50 = this.$outer.topicPartition$5;
                            boolean x$51 = qual$11.getLog$default$2();
                            return qual$11.getLog(x$50, x$51).isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$5 = topicPartition$5;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Replicas for topic test not created";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$12 = server.logManager();
        TopicPartition x$52 = topicPartition;
        boolean x$53 = qual$12.getLog$default$2();
        Log log2 = (Log)qual$12.getLog(x$52, x$53).get();
        this.writeDups(100, 3, log2);
        LogCleaner qual$13 = server.logManager().cleaner();
        TopicPartition x$54 = new TopicPartition(topicName, 0);
        long x$55 = 0L;
        long x$56 = qual$13.awaitCleaned$default$3();
        qual$13.awaitCleaned(x$54, x$55, x$56);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1)new Serializable(this, deleteTopicEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean deleteTopicEnabled$1;

            public final Object apply(Properties x$11) {
                return x$11.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteTopicEnabled$1)).toString());
            }
            {
                this.deleteTopicEnabled$1 = deleteTopicEnabled$1;
            }
        });
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$6;
            private final Seq servers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer x$12) {
                        LogManager qual$14 = x$12.getLogManager();
                        TopicPartition x$57 = this.$outer.topicPartition$6;
                        boolean x$58 = qual$14.getLog$default$2();
                        return qual$14.getLog(x$57, x$58).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$6 = topicPartition$6;
                this.servers$3 = servers$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log2) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.$outer.log$1.appendAsLeader$default$3(), this.$outer.log$1.appendAsLeader$default$4());
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().isTopicMarkedForDeletion(this.topic$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
            }
        }, (Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$5;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$5}));
            }
            {
                this.topic$5 = topic$5;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$7;

            public final boolean apply(KafkaServer x$13) {
                LogManager qual$15 = x$13.getLogManager();
                TopicPartition x$59 = this.topicPartition$7;
                boolean x$60 = qual$15.getLog$default$2();
                return qual$15.getLog(x$59, x$60).isDefined();
            }
            {
                this.topicPartition$7 = topicPartition$7;
            }
        }));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$14) {
                x$14.shutdown();
            }
        });
        KafkaZkClient qual$16 = this.zkClient();
        String x$61 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$62 = qual$16.deleteRecursive$default$2();
        qual$16.deleteRecursive(x$61, x$62);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$15) {
                x$15.startup();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$16) {
                        return x$16.kafkaController().isActive();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No controller is elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }
}

