/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTest$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTest$$anonfun$bounceServer$1$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0006\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\tQ8.\u0003\u0002\u000e\u0015\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001A\u0002\u0013\u00051$A\u0004tKJ4XM]:\u0016\u0003q\u00012!H\u0014+\u001d\tqBE\u0004\u0002 E5\t\u0001E\u0003\u0002\"\r\u00051AH]8pizJ\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\u0019\nq\u0001]1dW\u0006<WMC\u0001$\u0013\tA\u0013FA\u0002TKFT!!\n\u0014\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011AB:feZ,'/\u0003\u00020Y\tY1*\u00194lCN+'O^3s\u0011\u001d\t\u0004\u00011A\u0005\u0002I\n1b]3sm\u0016\u00148o\u0018\u0013fcR\u00111g\u000e\t\u0003iUj\u0011AJ\u0005\u0003m\u0019\u0012A!\u00168ji\"9\u0001\bMA\u0001\u0002\u0004a\u0012a\u0001=%c!1!\b\u0001Q!\nq\t\u0001b]3sm\u0016\u00148\u000f\t\u0005\u0006y\u0001!\t%P\u0001\ti\u0016\f'\u000fR8x]R\t1\u0007\u000b\u0002<\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019\u000b%!B!gi\u0016\u0014\b\"\u0002%\u0001\t\u0013I\u0015!G2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$2a\r&c\u0011\u0015Yu\t1\u0001M\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!\u0014)T9:\u0011AGT\u0005\u0003\u001f\u001a\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\ri\u0015\r\u001d\u0006\u0003\u001f\u001a\u0002\"\u0001\u0016.\u000e\u0003US!AV,\u0002\r\r|W.\\8o\u0015\t)\u0001L\u0003\u0002Z\u0007\u00061\u0011\r]1dQ\u0016L!aW+\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019Q$X0\n\u0005yK#\u0001\u0002'jgR\u0004\"\u0001\u000e1\n\u0005\u00054#aA%oi\"91m\u0012I\u0001\u0002\u0004!\u0017AC1vi\"|'/\u001b>feB\u0019A'Z4\n\u0005\u00194#AB(qi&|g\u000e\u0005\u0002NQ&\u0011\u0011N\u0015\u0002\u0007'R\u0014\u0018N\\4\t\u000b!\u0003A\u0011B6\u0015\u0007Mbg\u000eC\u0003nU\u0002\u0007A*\u0001\rqCJ$\u0018\u000e^5p]N\fe\u000eZ!tg&<g.\\3oiNDQa\u001c6A\u0002A\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\bcA\u000f(cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(A\u0003)s_B,'\u000f^5fg\")!\u0010\u0001C\u0005w\u0006a!m\\;oG\u0016\u001cVM\u001d<feR\u00191\u0007 @\t\u000buL\b\u0019A0\u0002\u0019Q\f'oZ3u'\u0016\u0014h/\u001a:\t\u000b}L\b\u0019A*\u0002\u0013A\f'\u000f^5uS>t\u0007bBA\u0002\u0001\u0011%\u0011QA\u0001\u000eO\u0016$8i\u001c8ue>dG.\u001a:\u0015\u0005\u0005\u001d\u0001c\u0001\u001bfU!9\u00111\u0002\u0001\u0005\n\u00055\u0011!C4fi2+\u0017\rZ3s)\ry\u0016q\u0002\u0005\u0007\u0017\u0006%\u0001\u0019A*\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005y!m\\8ugR\u0014\u0018\r]*feZ,'\u000fF\u0002h\u0003/A\u0011\"!\u0007\u0002\u0012A\u0005\t\u0019A0\u0002\r\t\u0014xn[3s\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\"A\u0007uKN$\b+\u0019:uSRLwN\\\u000b\u0002'\"9\u00111\u0005\u0001!\u0002\u0013\u0019\u0016A\u0004;fgR\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003S\tq\u0003^3tiB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0016\u0005\u0005-\u0002#BA\u0017\u0003oyVBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0013%lW.\u001e;bE2,'bAA\u001bM\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007y\u000by\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0016\u0003a!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\t\u0005\n\u0003\u007f\u0001!\u0019!C\u0001\u0003\u0003\nA\u0004^3tiB\u000b'\u000f^5uS>t\u0007K]3gKJ\u0014X\r\u001a'fC\u0012,'/F\u0001`\u0011\u001d\t)\u0005\u0001Q\u0001\n}\u000bQ\u0004^3tiB\u000b'\u000f^5uS>t\u0007K]3gKJ\u0014X\r\u001a'fC\u0012,'\u000f\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003\u0017\n!\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3BgNLwM\\7f]R,\"!!\u0014\u0011\u000f\u00055\u0012qJ*\u0002,%\u0019\u0011+a\f\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u001b\n1\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3BgNLwM\\7f]R\u0004\u0003BBA,\u0001\u0011\u0005Q(\u0001\ruKN$X*\u001e7uSBdWM\u0011:pW\u0016\u00148oR5wK:DC!!\u0016\u0002\\A\u0019\u0001)!\u0018\n\u0007\u0005}\u0013I\u0001\u0003UKN$\bBBA2\u0001\u0011\u0005Q(\u0001\fuKN$\u0018J\u001c<bY&$'I]8lKJ<\u0015N^3oQ\u0011\t\t'a\u0017\t\r\u0005%\u0004\u0001\"\u0001>\u0003U!Xm\u001d;O_B\u000b'\u000f^5uS>t7oR5wK:DC!a\u001a\u0002\\!9\u0011q\u000e\u0001\u0005\n\u0005E\u0014A\u0003;p\u0015N|gNR5mKR!\u00111OA@!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=k\u0006\u0011\u0011n\\\u0005\u0005\u0003{\n9H\u0001\u0003GS2,\u0007\u0002CAA\u0003[\u0002\r!a!\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003\u0002\u0006\u0006\u001d5+\u0004\u0002\u00024%!\u0011\u0011RA\u001a\u0005\r\u0019V\r\u001e\u0005\u0007\u0003\u001b\u0003A\u0011A\u001f\u00027Q,7\u000f^*j]\u001edW\r^8o!\u0006\u0014H/\u001b;j_:<\u0015N^3oQ\u0011\tY)a\u0017\t\r\u0005M\u0005\u0001\"\u0001>\u0003U!Xm\u001d;U_BL7\rR8fg:{G/\u0012=jgRDC!!%\u0002\\!1\u0011\u0011\u0014\u0001\u0005\u0002u\nA\u0005^3ti6+H\u000e^5qY\u0016\u0004\u0016M\u001d;ji&|gn]*b[\u0016\f5o]5h]6,g\u000e\u001e\u0015\u0005\u0003/\u000bY\u0006\u0003\u0004\u0002 \u0002!\t!P\u0001\u0011i\u0016\u001cHOT8pa\u0016cWm\u0019;j_:DC!!(\u0002\\!1\u0011Q\u0015\u0001\u0005\u0002u\nq\u0004^3ti^KG\u000f[(gM2Lg.\u001a)sK\u001a,'O]3e%\u0016\u0004H.[2bQ\u0011\t\u0019+a\u0017\t\r\u0005-\u0006\u0001\"\u0001>\u0003-!Xm\u001d;US6,w.\u001e;)\t\u0005%\u00161\f\u0005\u0007\u0003c\u0003A\u0011A\u001f\u0002!Q,7\u000f^!vi\"Th)Y5mkJ,\u0007\u0006BAX\u00037B\u0011\"a.\u0001#\u0003%I!!/\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0018\u0016\u0004I\u0006u6FAA`!\u0011\t\t-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%g%\u0001\u0006b]:|G/\u0019;j_:LA!!4\u0002D\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005E\u0007!%A\u0005\n\u0005M\u0017!\u00072p_R\u001cHO]1q'\u0016\u0014h/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!6+\u0007}\u000bi\f")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final Map<TopicPartition, List<Object>> testPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testPartition()), this.testPartitionAssignment())}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Option<String> option;
        block4: {
            Seq<Properties> brokerConfigs;
            block3: {
                block2: {
                    brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
                    brokerConfigs.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Properties p) {
                            return p.setProperty("auto.leader.rebalance.enable", "false");
                        }
                    });
                    option = authorizer;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String className = (String)some.x();
                    brokerConfigs.foreach((Function1)new Serializable(this, className){
                        public static final long serialVersionUID = 0L;
                        private final String className$1;

                        public final Object apply(Properties p) {
                            return p.setProperty("authorizer.class.name", this.className$1);
                        }
                        {
                            this.className$1 = className$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.createTestTopicAndCluster(topicPartition, brokerConfigs);
            return;
        }
        throw new MatchError(option);
    }

    private void createTestTopicAndCluster(Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        partitionsAndAssignments.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;

            public final void apply(Tuple2<TopicPartition, List<Object>> x0$1) {
                Tuple2<TopicPartition, List<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    List assigment = (List)tuple2._2();
                    this.$outer.zkClient().createTopicAssignment(tp.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)assigment)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partitionsAndAssignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;
            public final Map partitionsAndAssignments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.partitionsAndAssignments$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$1;

                            public final boolean apply(Tuple2<TopicPartition, List<Object>> partitionAndAssignment) {
                                LogManager qual$1 = this.server$1.getLogManager();
                                TopicPartition x$2 = (TopicPartition)partitionAndAssignment._1();
                                boolean x$3 = qual$1.getLog$default$2();
                                return qual$1.getLog(x$2, x$3).isDefined();
                            }
                            {
                                this.server$1 = server$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsAndAssignments$1 = partitionsAndAssignments$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)new Serializable(this, targetServer){
            public static final long serialVersionUID = 0L;
            private final int targetServer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutting down server ", " so a non-preferred replica becomes leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.targetServer$1)}));
            }
            {
                this.targetServer$1 = targetServer$1;
            }
        });
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)new Serializable(this, targetServer){
            public static final long serialVersionUID = 0L;
            private final int targetServer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting server ", " now that a non-preferred replica is leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.targetServer$1)}));
            }
            {
                this.targetServer$1 = targetServer$1;
            }
        });
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, targetServer, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;
            public final int targetServer$1;
            public final TopicPartition partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$bounceServer$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.metadataCache().getPartitionInfo(this.$outer.partition$1.topic(), this.$outer.partition$1.partition()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$bounceServer$1$$anonfun$apply$mcZ$sp$2 $outer;

                            public final boolean apply(UpdateMetadataRequest.PartitionState partitionState) {
                                return partitionState.basePartitionState.isr.contains(BoxesRunTime.boxToInteger((int)this.$outer.kafka$admin$PreferredReplicaLeaderElectionCommandTest$$anonfun$$anonfun$$$outer().targetServer$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$bounceServer$1 kafka$admin$PreferredReplicaLeaderElectionCommandTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetServer$1 = targetServer$1;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replicas for partition ", " not created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1}));
            }
            {
                this.partition$1 = partition$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer p) {
                return p.kafkaController().isActive();
            }
        });
    }

    private int getLeader(TopicPartition topicPartition) {
        return ((UpdateMetadataRequest.PartitionState)((KafkaServer)this.servers().apply((int)0)).metadataCache().getPartitionInfo((String)topicPartition.topic(), (int)topicPartition.partition()).get()).basePartitionState.leader;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)new Serializable(this, port){
            public static final long serialVersionUID = 0L;
            private final int port$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Server bound to port ").append((Object)BoxesRunTime.boxToInteger((int)this.port$1)).toString();
            }
            {
                this.port$1 = port$1;
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)}));
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServer(1), this.bootstrapServer(0)}))}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    @Test
    public void testInvalidBrokerGiven() {
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", "example.com:1234"}), 1000);
            throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
            return;
        }
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1())}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(TopicPartition x$1) {
                return new TopicAndPartition(x$1);
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.debug((Function0<String>)new Serializable(this, jsonString){
            public static final long serialVersionUID = 0L;
            private final String jsonString$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Using json: ").append((Object)this.jsonString$1).toString();
            }
            {
                this.jsonString$1 = jsonString$1;
            }
        });
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.delete();
            throw throwable;
        }
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    @Test
    public void testTopicDoesNotExist() {
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Map nonExistentPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentPartition), (Object)nonExistentPartitionAssignment)}));
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        File jsonFile = this.toJsonFile((Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw throwable;
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Throwable suppressed = adminCommandFailedException.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof UnknownTopicOrPartitionException));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiplePartitionsSameAssignment() {
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        Map testPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionA), (Object)testPartitionAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionB), (Object)testPartitionAssignment)}));
        this.createTestTopicAndCluster((Map<TopicPartition, List<Object>>)testPartitionAndAssignment, this.createTestTopicAndCluster$default$2());
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionA));
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionB));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.delete();
            throw throwable;
        }
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionA));
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionB));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.delete();
            throw throwable;
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)adminCommandFailedException.getMessage());
                Throwable suppressed = adminCommandFailedException.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assert.assertTrue((String)suppressed.getMessage(), (boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
                Assert.assertEquals((long)leader2, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}), 2000);
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)adminCommandFailedException.getMessage());
                Assert.assertTrue((boolean)adminCommandFailedException.getSuppressed()[0].getMessage().contains("Timed out waiting for a node assignment"));
                Assert.assertEquals((long)leader2, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)adminCommandFailedException.getMessage());
                Assert.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof ClusterAuthorizationException));
                Assert.assertEquals((long)leader2, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }
}

