/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\nW\u0001\u0001\r\u00111A\u0005\n1\n\u0001bY8ogVlWM]\u000b\u0002[A!afN\u001d:\u001b\u0005y#BA\u00161\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\rQ4(P\u0007\u0002A%\u0011A\b\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003uyJ!a\u0010\u0011\u0003\t\tKH/\u001a\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000bAbY8ogVlWM]0%KF$\"a\u0011$\u0011\u0005i\"\u0015BA#!\u0005\u0011)f.\u001b;\t\u000f\u001d\u0003\u0015\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\r%\u0003\u0001\u0015)\u0003.\u0003%\u0019wN\\:v[\u0016\u0014\b\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A'\u0011\u00079\u001bV+D\u0001P\u0015\t\u0001\u0016+A\u0004nkR\f'\r\\3\u000b\u0005I\u0003\u0013AC2pY2,7\r^5p]&\u0011Ak\u0014\u0002\u0007\u0005V4g-\u001a:\u0011\tYK\u0016(O\u0007\u0002/*\u0011\u0001\fM\u0001\taJ|G-^2fe&\u0011!l\u0016\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\rq\u0003\u0001\u0015!\u0003N\u0003)\u0001(o\u001c3vG\u0016\u00148\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0005`\u0003\u0015!x\u000e]5d+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0004\u0001\u0015!\u0003a\u0003\u0019!x\u000e]5dA!91\u000e\u0001b\u0001\n\u0013a\u0017A\u00038v[J+7m\u001c:egV\tQ\u000e\u0005\u0002;]&\u0011q\u000e\t\u0002\u0004\u0013:$\bBB9\u0001A\u0003%Q.A\u0006ok6\u0014VmY8sIN\u0004\u0003\"B:\u0001\t\u0003\"\u0018!B:fiV\u0003H#A\")\u0005I4\bCA<{\u001b\u0005A(BA=6\u0003\u0015QWO\\5u\u0013\tY\bP\u0001\u0004CK\u001a|'/\u001a\u0005\u0006{\u0002!\t\u0005^\u0001\ti\u0016\f'\u000fR8x]\"\u0012Ap \t\u0004o\u0006\u0005\u0011bAA\u0002q\n)\u0011I\u001a;fe\"9\u0011q\u0001\u0001\u0005\u0012\u0005%\u0011AD2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u000b\u000e+\u0006-\u00111DA\u0010\u0003G\t9#a\u000b\t\u0011\u00055\u0011Q\u0001a\u0001\u0003\u001f\t!B\u0019:pW\u0016\u0014H*[:u!\u0011\t\t\"a\u0006\u000f\u0007i\n\u0019\"C\u0002\u0002\u0016\u0001\na\u0001\u0015:fI\u00164\u0017bA4\u0002\u001a)\u0019\u0011Q\u0003\u0011\t\u0013\u0005u\u0011Q\u0001I\u0001\u0002\u0004i\u0017\u0001\u00037j]\u001e,'/T:\t\u0013\u0005\u0005\u0012Q\u0001I\u0001\u0002\u0004i\u0017!\u00053fY&4XM]=US6,w.\u001e;Ng\"I\u0011QEA\u0003!\u0003\u0005\r!\\\u0001\nE\u0006$8\r[*ju\u0016D!\"!\u000b\u0002\u0006A\u0005\t\u0019AA\b\u0003=\u0019w.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007BCA\u0017\u0003\u000b\u0001\n\u00111\u0001\u00020\u0005QQ.\u0019=CY>\u001c7.T:\u0011\u0007i\n\t$C\u0002\u00024\u0001\u0012A\u0001T8oO\"9\u0011q\u0007\u0001\u0005\u0012\u0005e\u0012\u0001\u0005:fO&\u001cH/\u001a:Qe>$WoY3s)\r)\u00161\b\u0005\u00071\u0006U\u0002\u0019A+\t\r\u0005}\u0002\u0001\"\u0001u\u00039!Xm\u001d;TK:$wJ\u001a4tKRDC!!\u0010\u0002DA\u0019q/!\u0012\n\u0007\u0005\u001d\u0003P\u0001\u0003UKN$\bBBA&\u0001\u0011\u0005A/A\u0014uKN$8+\u001a8e\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0007J,\u0017\r^3US6,\u0007\u0006BA%\u0003\u0007Ba!!\u0015\u0001\t\u0003!\u0018A\u000b;fgR\u001cVM\u001c3O_:\u001cu.\u001c9sKN\u001cX\rZ'fgN\fw-Z,ji\"\u001c%/Z1uKRKW.\u001a\u0015\u0005\u0003\u001f\n\u0019\u0005C\u0004\u0002X\u0001!\t\"!\u0017\u0002\u001bM,g\u000eZ!oIZ+'/\u001b4z)\u001d\u0019\u00151LA/\u0003?Ba\u0001WA+\u0001\u0004)\u0006\u0002C6\u0002VA\u0005\t\u0019A7\t\u0015\u0005\u0005\u0014Q\u000bI\u0001\u0002\u0004\ty#A\u0005uS6,w.\u001e;Ng\"9\u0011Q\r\u0001\u0005\u0012\u0005\u001d\u0014AF:f]\u0012\fe\u000e\u001a,fe&4\u0017\u0010V5nKN$\u0018-\u001c9\u0015\u000b\r\u000bI'a\u001b\t\ra\u000b\u0019\u00071\u0001V\u0011!\ti'a\u0019A\u0002\u0005=\u0014!\u0004;j[\u0016\u001cH/Y7q)f\u0004X\r\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\rI,7m\u001c:e\u0015\r\tIHM\u0001\u0007G>lWn\u001c8\n\t\u0005u\u00141\u000f\u0002\u000e)&lWm\u001d;b[B$\u0016\u0010]3\t\r\u0005\u0005\u0005\u0001\"\u0001u\u0003%!Xm\u001d;DY>\u001cX\r\u000b\u0003\u0002\u0000\u0005\r\u0003BBAD\u0001\u0011\u0005A/A\nuKN$8+\u001a8e)>\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002\u0006\u0006\r\u0003BBAG\u0001\u0011\u0005A/\u0001\u0015uKN$8+\u001a8e\u0005\u00164wN]3B]\u0012\fe\r^3s!\u0006\u0014H/\u001b;j_:,\u0005\u0010]1og&|g\u000e\u000b\u0003\u0002\f\u0006\r\u0003BBAJ\u0001\u0011\u0005A/A\u0005uKN$h\t\\;tQ\"\"\u0011\u0011SA\"\u0011\u0019\tI\n\u0001C\u0001i\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7)\u00197mKJ$\u0006N]3bI\"\"\u0011qSA\"\u0011\u0019\ty\n\u0001C\u0001i\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7+\u001a8eKJ$\u0006N]3bI\"\"\u0011QTA\"\u0011%\t)\u000bAI\u0001\n#\t9+\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uII*\"!!++\u00075\fYk\u000b\u0002\u0002.B!\u0011qVA]\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016!C;oG\",7m[3e\u0015\r\t9\fI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA^\u0003c\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\fAI\u0001\n#\t9+\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIMB\u0011\"a1\u0001#\u0003%\t\"a*\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$C\u0007C\u0005\u0002H\u0002\t\n\u0011\"\u0005\u0002J\u0006A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005-'\u0006BA\b\u0003WC\u0011\"a4\u0001#\u0003%\t\"!5\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002T*\"\u0011qFAV\u0011%\t9\u000eAI\u0001\n#\t9+A\ftK:$\u0017I\u001c3WKJLg-\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\u001c\u0001\u0012\u0002\u0013E\u0011\u0011[\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIM\u0002")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(int x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$3$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$3$(this, x$1);
            return (BaseProducerSendTest$callback$3$)x$2.elem;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2$lzycompute(TimestampType x$1, int x$2, long x$3, long x$4, VolatileObjectRef x$5) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$5.elem != null) return (BaseProducerSendTest$callback$4$)x$5.elem;
            x$5.elem = new BaseProducerSendTest$callback$4$(this, x$1, x$2, x$3, x$4);
            return (BaseProducerSendTest$callback$4$)x$5.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30, x$31, x$32).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer() {
        return this.kafka$api$BaseProducerSendTest$$consumer;
    }

    private void kafka$api$BaseProducerSendTest$$consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$33 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$34 = SecurityProtocol.PLAINTEXT;
        String x$35 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$36 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$37 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$38 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$39 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$40 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$41 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$42 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$43 = TestUtils$.MODULE$.createConsumer$default$11();
        this.kafka$api$BaseProducerSendTest$$consumer_$eq(TestUtils$.MODULE$.createConsumer(x$33, x$35, x$36, x$37, x$38, x$39, x$34, x$40, x$41, x$42, x$43));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer().close();
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs) {
        String x$44 = brokerList;
        String x$45 = compressionType;
        SecurityProtocol x$46 = this.securityProtocol();
        Option<File> x$47 = this.trustStoreFile();
        Option<Properties> x$48 = this.clientSaslProperties();
        int x$49 = lingerMs;
        int x$50 = deliveryTimeoutMs;
        long x$51 = maxBlockMs;
        int x$52 = TestUtils$.MODULE$.createProducer$default$2();
        long x$53 = TestUtils$.MODULE$.createProducer$default$4();
        int x$54 = TestUtils$.MODULE$.createProducer$default$5();
        int x$55 = TestUtils$.MODULE$.createProducer$default$8();
        int x$56 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$57 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$58 = TestUtils$.MODULE$.createProducer$default$15();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$44, x$52, x$51, x$53, x$54, x$50, x$49, x$55, x$45, x$56, x$46, x$47, x$48, x$57, x$58);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final int partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int _) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$59 = this.brokerList();
        String x$60 = "gzip";
        int x$61 = Integer.MAX_VALUE;
        int x$62 = Integer.MAX_VALUE;
        int x$63 = this.createProducer$default$4();
        long x$64 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$59, x$61, x$62, x$63, x$60, x$64);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$3;
                private final int partition$2;

                public final Future<RecordMetadata> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$2), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return this.producer$3.send(record);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(timeoutMs, TimeUnit.MILLISECONDS);
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$2;

                public final int apply(int offset, Future<RecordMetadata> future) {
                    RecordMetadata recordMetadata = future.get();
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition$2, (long)recordMetadata.partition());
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    return offset + 1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$2 = partition$2;
                }
            }));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
            return;
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            this.createTopic(this.topic(), 1, 2, topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$2;
                private final TimestampType timestampType$1;
                private final int partition$3;
                private final long baseTimestamp$1;
                private final long startTime$1;
                private final VolatileObjectRef callback$module$2;

                public final Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$3), Predef$.MODULE$.long2Long(this.baseTimestamp$1 + (long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return new Tuple2((Object)record, (Object)this.producer$2.send(record, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$2(this.timestampType$1, this.partition$3, this.baseTimestamp$1, this.startTime$1, this.callback$module$2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.timestampType$1 = timestampType$1;
                    this.partition$3 = partition$3;
                    this.baseTimestamp$1 = baseTimestamp$1;
                    this.startTime$1 = startTime$1;
                    this.callback$module$2 = callback$module$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(20000L, TimeUnit.MILLISECONDS);
            recordAndFutures.foreach((Function1)new Serializable(this, timestampType, startTime){
                public static final long serialVersionUID = 0L;
                private final TimestampType timestampType$1;
                private final long startTime$1;

                public final void apply(Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> x0$1) {
                    Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        ProducerRecord record = (ProducerRecord)tuple2._1();
                        Future future = (Future)tuple2._2();
                        RecordMetadata recordMetadata = (RecordMetadata)future.get();
                        TimestampType timestampType = this.timestampType$1;
                        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                            Assert.assertTrue((recordMetadata.timestamp() >= this.startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.timestampType$1 = timestampType$1;
                    this.startTime$1 = startTime$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$4;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int _) {
                    return this.producer$4.send(this.record0$2);
                }
                {
                    this.producer$4 = producer$4;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        try {
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$5;
                private final int partition$4;
                private final long now$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$5.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$4), Predef$.MODULE$.long2Long(this.now$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$5 = producer$5;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                    return x$3.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$1) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;

                public final void apply(Tuple2<RecordMetadata, Object> x$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition$4, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                }
            });
            this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.consumeRecords(this.kafka$api$BaseProducerSendTest$$consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((IterableLike)records2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;
                private final long now$1;

                public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$2) {
                    Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ConsumerRecord record = (ConsumerRecord)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)record.topic());
                        Assert.assertEquals((long)this.partition$4, (long)record.partition());
                        Assert.assertEquals((long)i, (long)record.offset());
                        Assert.assertNull((Object)record.key());
                        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), (Object)new String((byte[])record.value()));
                        Assert.assertEquals((long)this.now$1, (long)record.timestamp());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        String x$65 = this.brokerList();
        long x$66 = 5000L;
        int x$67 = this.createProducer$default$2();
        int x$68 = this.createProducer$default$3();
        int x$69 = this.createProducer$default$4();
        String x$70 = this.createProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$65, x$67, x$68, x$69, x$70, x$66);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final KafkaProducer producer$6;
            private final int partition0$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$6 = producer$6;
                this.partition0$1 = partition0$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$5) {
                return x$5.get(30L, TimeUnit.SECONDS);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$2) {
                Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int partition0$1;

            public final void apply(Tuple2<RecordMetadata, Object> x$6) {
                Tuple2<RecordMetadata, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$1 = partition0$1;
            }
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw this.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof TimeoutException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$3) {
                        Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            Seq replicas = (Seq)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                AdminZkClient qual$1 = this.adminZkClient();
                String x$73 = this.topic();
                scala.collection.immutable.Map x$74 = existingAssignment;
                AdminZkClient qual$2 = this.adminZkClient();
                RackAwareMode x$71 = qual$2.getBrokerMetadatas$default$1();
                Option x$72 = qual$2.getBrokerMetadatas$default$2();
                Seq x$75 = qual$2.getBrokerMetadatas(x$71, x$72);
                int x$76 = 2;
                Option x$77 = qual$1.addPartitions$default$5();
                boolean x$78 = qual$1.addPartitions$default$6();
                qual$1.addPartitions(x$73, (Map)x$74, x$75, x$76, x$77, x$78);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$6;
                    private final int partition1$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition1$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                        this.partition1$1 = partition1$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                        return x$7.get(30L, TimeUnit.SECONDS);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$3) {
                        Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$3;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, partition1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final int partition1$1;

                    public final void apply(Tuple2<RecordMetadata, Object> x$8) {
                        Tuple2<RecordMetadata, Object> tuple2 = x$8;
                        if (tuple2 != null) {
                            RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                            int offset = tuple2._2$mcI$sp();
                            Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                            Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                            Assert.assertEquals((long)this.partition1$1, (long)recordMetadata.partition());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition1$1 = partition1$1;
                    }
                });
                futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$6;
                    private final int partition0$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                        this.partition0$1 = partition0$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                        return x$9.get(30L, TimeUnit.SECONDS);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$4) {
                        Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$4;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, partition0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final int partition0$1;

                    public final void apply(Tuple2<RecordMetadata, Object> x$10) {
                        Tuple2<RecordMetadata, Object> tuple2 = x$10;
                        if (tuple2 != null) {
                            RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                            int offset = tuple2._2$mcI$sp();
                            Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                            Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                            Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition0$1 = partition0$1;
                    }
                });
                return;
            }
            throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlush() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        try {
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$7;
                public final ProducerRecord record$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int x$11) {
                            return this.$outer.producer$7.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$12) {
                            return !x$12.isDone();
                        }
                    }));
                    this.producer$7.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$13) {
                            return x$13.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$7 = producer$7;
                    this.record$1 = record$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record0$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(this.$outer.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.$outer.createProducer$default$4(), this.$outer.createProducer$default$5(), this.$outer.createProducer$default$6());
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$8;

                    public final Future<RecordMetadata> apply(int x$14) {
                        return this.producer$8.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$8 = producer$8;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$15) {
                        return !x$15.isDone();
                    }
                }));
                producer.close(0L, TimeUnit.MILLISECONDS);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer().fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
                        }
                        catch (ExecutionException executionException) {
                            Assert.assertEquals(KafkaException.class, executionException.getCause().getClass());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(50L).count());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record$2;

            /*
             * WARNING - void declaration
             */
            public final Seq<ConsumerRecord<byte[], byte[]>> apply(int i) {
                Seq<ConsumerRecord<byte[], byte[]>> seq;
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(this.$outer.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.$outer.createProducer$default$4(), this.$outer.createProducer$default$5(), this.$outer.createProducer$default$6());
                try {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                        private final KafkaProducer producer$9;

                        public final Future<RecordMetadata> apply(int i) {
                            public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                            implements Callback {
                                public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                                private final boolean sendRecords;
                                public final /* synthetic */ BaseProducerSendTest $outer;
                                public final ProducerRecord record$2;

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    if (this.sendRecords) {
                                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                            public final Future<RecordMetadata> apply(int x$16) {
                                                return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(0L, TimeUnit.MILLISECONDS);
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
                                }

                                public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                    return this.$outer;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords2) {
                                    void var4_4;
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                    this.sendRecords = sendRecords2;
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.record$2 = var4_4;
                                }
                            }
                            return this.producer$9.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$9, i == 0, this.$outer.record$2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.producer$9 = producer$9;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$17) {
                            return !x$17.isDone();
                        }
                    }));
                    producer.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$18) {
                            return x$18.isDone();
                        }
                    }));
                    seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.$outer.kafka$api$BaseProducerSendTest$$consumer(), this.$outer.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                producer.close();
                return seq;
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        });
    }

    public final BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1(int partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$3$)callback$module$1.elem;
    }

    public final BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, VolatileObjectRef callback$module$2) {
        return callback$module$2.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$2$lzycompute(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2) : (BaseProducerSendTest$callback$4$)callback$module$2.elem;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

