/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.ConsumerBounceTest$;
import kafka.api.ConsumerBounceTest$$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$;
import kafka.api.ConsumerBounceTest$$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1$;
import kafka.api.ConsumerBounceTest$$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1$$anonfun$apply$mcVI$sp$1$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u000bQ|\u0007/[2\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004TiJLgn\u001a\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\u000f\u0002\rQ|\u0007/[2!\u0011\u001d9\u0003A1A\u0005\u0002!\nA\u0001]1siV\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0002J]RDa\u0001\r\u0001!\u0002\u0013I\u0013!\u00029beR\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\u0003iB,\u0012\u0001\u000e\t\u0003kuj\u0011A\u000e\u0006\u0003oa\naaY8n[>t'BA\u0003:\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\n\u0005y2$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001b\u0002\u0007Q\u0004\b\u0005C\u0004C\u0001\t\u0007I\u0011\u0001\u0015\u0002\u00195\f\u0007p\u0012:pkB\u001c\u0016N_3\t\r\u0011\u0003\u0001\u0015!\u0003*\u00035i\u0017\r_$s_V\u00048+\u001b>fA!9a\t\u0001b\u0001\n\u0003A\u0013aE4sC\u000e,g-\u001e7DY>\u001cX\rV5nK6\u001b\bB\u0002%\u0001A\u0003%\u0011&\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003!)\u00070Z2vi>\u0014X#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011\u000bI\u0001\u0005kRLG.\u0003\u0002T\u001d\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\rU\u0003\u0001\u0015!\u0003M\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0003X\u0001\u0011\u0005\u0003,A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005I\u0006c\u0001.cK:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005\u0005\\\u0013a\u00029bG.\fw-Z\u0005\u0003G\u0012\u00141aU3r\u0015\t\t7\u0006\u0005\u0002\nM&\u0011qM\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003j\u0001\u0011%!.\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u00033.DqA\u00115\u0011\u0002\u0003\u0007A\u000e\u0005\u0002na:\u0011!F\\\u0005\u0003_.\na\u0001\u0015:fI\u00164\u0017BA\u0012r\u0015\ty7\u0006C\u0003t\u0001\u0011\u0005C/A\u0003tKR,\u0006\u000fF\u0001v!\tQc/\u0003\u0002xW\t!QK\\5uQ\t\u0011\u0018\u0010\u0005\u0002{{6\t1P\u0003\u0002}w\u0005)!.\u001e8ji&\u0011ap\u001f\u0002\u0007\u0005\u00164wN]3\t\r\u0005\u0005\u0001\u0001\"\u0011u\u0003!!X-\u0019:E_^t\u0007fA@\u0002\u0006A\u0019!0a\u0002\n\u0007\u0005%1PA\u0003BMR,'\u000f\u0003\u0004\u0002\u000e\u0001!\t\u0001^\u0001\"i\u0016\u001cHoQ8ogVl\u0007\u000f^5p]^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0005\u0003\u0017\t\t\u0002E\u0002{\u0003'I1!!\u0006|\u0005\u0019IuM\\8sK\"\"\u00111BA\r!\rQ\u00181D\u0005\u0004\u0003;Y(\u0001\u0002+fgRDq!!\t\u0001\t\u0003\t\u0019#A\rd_:\u001cX/\\3XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cHcA;\u0002&!9\u0011qEA\u0010\u0001\u0004I\u0013\u0001\u00038v[&#XM]:\t\r\u0005-\u0002\u0001\"\u0001u\u0003\r\"Xm\u001d;TK\u0016\\\u0017I\u001c3D_6l\u0017\u000e^,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKNDC!!\u000b\u0002\u001a!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012aH:fK.\fe\u000eZ\"p[6LGoV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR\u0019Q/!\u000e\t\u000f\u0005\u001d\u0012q\u0006a\u0001S!1\u0011\u0011\b\u0001\u0005\u0002Q\f\u0011\u0005^3tiN+(m]2sS\n,w\u000b[3o)>\u0004\u0018nY+oCZ\f\u0017\u000e\\1cY\u0016DC!a\u000e\u0002\u001a!1\u0011q\b\u0001\u0005\u0002Q\f\u0011\u0002^3ti\u000ecwn]3)\t\u0005u\u0012\u0011\u0004\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003I\u0019\u0007.Z2l\u00072|7/Z$p_\u0012\u0004\u0016\r\u001e5\u0015\u000bU\fI%!\u0014\t\u000f\u0005-\u00131\ta\u0001S\u0005Qa.^7SK\u000e|'\u000fZ:\t\u000f\u0005=\u00131\ta\u0001Y\u00069qM]8va&#\u0007bBA*\u0001\u0011%\u0011QK\u0001!G\",7m[\"m_N,w+\u001b;i\u0007>|'\u000fZ5oCR|'OR1jYV\u0014X\rF\u0004v\u0003/\nI&!\u0018\t\u000f\u0005-\u0013\u0011\u000ba\u0001S!9\u00111LA)\u0001\u0004a\u0017\u0001\u00043z]\u0006l\u0017nY$s_V\u0004\bbBA0\u0003#\u0002\r\u0001\\\u0001\f[\u0006tW/\u00197He>,\b\u000fC\u0004\u0002d\u0001!I!!\u001a\u0002\u001f\u0019Lg\u000eZ\"p_J$\u0017N\\1u_J$2!KA4\u0011\u001d\tI'!\u0019A\u00021\fQa\u001a:pkBDq!!\u001c\u0001\t\u0013\ty'\u0001\u000fdQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5DYV\u001cH/\u001a:GC&dWO]3\u0015\u000fU\f\t(a\u001d\u0002x!9\u00111JA6\u0001\u0004I\u0003bBA;\u0003W\u0002\r\u0001\\\u0001\u0007OJ|W\u000f]\u0019\t\u000f\u0005e\u00141\u000ea\u0001Y\u00061qM]8vaJBa!! \u0001\t\u0003!\u0018A\u0012;fgR\u0014v\u000e\u001c7j]\u001e\u0014%o\\6feJ+7\u000f^1siN<\u0016\u000e\u001e5T[\u0006dG.\u001a:NCb<%o\\;q'&TXmQ8oM&<G)[:skB$8OQ5h\u000fJ|W\u000f\u001d\u0015\u0005\u0003w\nI\u0002\u0003\u0004\u0002\u0004\u0002!\t\u0001^\u00019i\u0016\u001cHoQ8ogVlWM\u001d*fG\u0016Lg/Z:GCR\fG.\u0012=dKB$\u0018n\u001c8XQ\u0016twI]8vaB\u000b7o]3t\u001b\u0006D8+\u001b>fQ\u0011\t\t)!\u0007\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\u0006Q2M]3bi\u0016\u001cuN\\:v[\u0016\u00148oV5uQ\u001e\u0013x.\u001e9JIRQ\u0011QRA]\u0003w\u000by,a2\u0011\r\u0005=\u0015\u0011TAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003/[\u0013AC2pY2,7\r^5p]&!\u00111TAI\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0011\u0005}\u0015\u0011VAW\u0003[k!!!)\u000b\t\u0005\r\u0016QU\u0001\tG>t7/^7fe*\u0019\u0011q\u0015\u001d\u0002\u000f\rd\u0017.\u001a8ug&!\u00111VAQ\u00055Y\u0015MZ6b\u0007>t7/^7feB)!&a,\u00024&\u0019\u0011\u0011W\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007)\n),C\u0002\u00028.\u0012AAQ=uK\"9\u0011qJAD\u0001\u0004a\u0007bBA_\u0003\u000f\u0003\r!K\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\u000f)\u000b9\t1\u0001\u0002BB\u0019Q*a1\n\u0007\u0005\u0015gJA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!Q\u0012q\u0011I\u0001\u0002\u0004a\u0007bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0011gV\u00147o\u0019:jE\u0016\fe\u000e\u001a)pY2$b\"a4\u0002\\\u0006u\u0017q\\Ax\u0003\u007f\u0014\t\u0001E\u0003N\u0003#\f).C\u0002\u0002T:\u0013aAR;ukJ,\u0007c\u0001\u0016\u0002X&\u0019\u0011\u0011\\\u0016\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002$\u0006%\u0007\u0019AAO\u0011\u001dQ\u0015\u0011\u001aa\u0001\u0003\u0003D!\"!9\u0002JB\u0005\t\u0019AAr\u0003=\u0011XM^8lKN+W.\u00199i_J,\u0007#\u0002\u0016\u0002f\u0006%\u0018bAAtW\t1q\n\u001d;j_:\u00042!TAv\u0013\r\tiO\u0014\u0002\n'\u0016l\u0017\r\u001d5pe\u0016D!\"!=\u0002JB\u0005\t\u0019AAz\u0003-yg.\u0012=dKB$\u0018n\u001c8\u0011\r)\n)0!?v\u0013\r\t9p\u000b\u0002\n\rVt7\r^5p]F\u00022AWA~\u0013\r\ti\u0010\u001a\u0002\n\u000bb\u001cW\r\u001d;j_:D\u0001BGAe!\u0003\u0005\r\u0001\u001c\u0005\n\u0005\u0007\tI\r%AA\u0002%\n1\u0002]8mYRKW.Z8vi\"9!q\u0001\u0001\u0005\u0002\t%\u0011\u0001E<bSR4uN\u001d*fE\u0006d\u0017M\\2f)%)(1\u0002B\u000b\u00053\u0011Y\u0002\u0003\u0005\u0003\u000e\t\u0015\u0001\u0019\u0001B\b\u0003%!\u0018.\\3pkRl5\u000fE\u0002+\u0005#I1Aa\u0005,\u0005\u0011auN\\4\t\u0011\t]!Q\u0001a\u0001\u0003\u001f\faAZ;ukJ,\u0007b\u0002&\u0003\u0006\u0001\u0007\u0011\u0011\u0019\u0005\t\u0005;\u0011)\u00011\u0001\u0003 \u0005qq\u000e\u001e5fe\u000e{gn];nKJ\u001c\b#\u0002\u0016\u0003\"\u0005u\u0015b\u0001B\u0012W\tQAH]3qK\u0006$X\r\u001a \t\r\t\u001d\u0002\u0001\"\u0001u\u0003a!Xm\u001d;DY>\u001cX\rR;sS:<'+\u001a2bY\u0006t7-\u001a\u0015\u0005\u0005K\tI\u0002C\u0004\u0003.\u0001!IAa\f\u00023\rDWmY6DY>\u001cX\rR;sS:<'+\u001a2bY\u0006t7-\u001a\u000b\nk\nE\"1\u0007B\u001b\u0005oAq!a\u0014\u0003,\u0001\u0007A\u000e\u0003\u0004\u001b\u0005W\u0001\r\u0001\u001c\u0005\b\u0015\n-\u0002\u0019AAa\u0011!\u0011IDa\u000bA\u0002\tm\u0012a\u00072s_.,'o]!wC&d\u0017M\u00197f\tV\u0014\u0018N\\4DY>\u001cX\rE\u0002+\u0005{I1Aa\u0010,\u0005\u001d\u0011un\u001c7fC:DqAa\u0011\u0001\t\u0013\u0011)%A\rde\u0016\fG/Z\"p]N,X.\u001a:XSRDwI]8va&#G\u0003BAO\u0005\u000fBq!a\u0014\u0003B\u0001\u0007A\u000eC\u0004\u0003L\u0001!IA!\u0014\u00021\r\u0014X-\u0019;f\u0007>t7/^7fe\u0006sGMU3dK&4X\r\u0006\u0005\u0002\u001e\n=#\u0011\u000bB+\u0011\u001d\tyE!\u0013A\u00021D\u0001Ba\u0015\u0003J\u0001\u0007!1H\u0001\r[\u0006tW/\u00197BgNLwM\u001c\u0005\b\u0003\u0017\u0012I\u00051\u0001*\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057\naB]3dK&4XMU3d_J$7\u000f\u0006\u0005\u0003\u0010\tu#q\fB1\u0011!\t\u0019Ka\u0016A\u0002\u0005u\u0005bBA&\u0005/\u0002\r!\u000b\u0005\u000b\u0005\u001b\u00119\u0006%AA\u0002\t=\u0001b\u0002B3\u0001\u0011%!qM\u0001\u0014e\u0016\u001cW-\u001b<f\u000bb\f7\r\u001e*fG>\u0014Hm\u001d\u000b\bk\n%$1\u000eB7\u0011!\t\u0019Ka\u0019A\u0002\u0005u\u0005bBA&\u0005G\u0002\r!\u000b\u0005\u000b\u0005\u001b\u0011\u0019\u0007%AA\u0002\t=\u0001b\u0002B9\u0001\u0011%!1O\u0001\u0011e\u0016\u001cW-\u001b<f\u0003:$7i\\7nSR$r!\u001eB;\u0005o\u0012I\b\u0003\u0005\u0002$\n=\u0004\u0019AAO\u0011\u001d\tYEa\u001cA\u0002%B\u0001B!\u0004\u0003p\u0001\u0007!q\u0002\u0015\u0007\u0005_\u0012iH!#\u0011\u000b)\u0012yHa!\n\u0007\t\u00055F\u0001\u0004uQJ|wo\u001d\t\u0005\u0003?\u0013))\u0003\u0003\u0003\b\u0006\u0005&!F\"p[6LGOR1jY\u0016$W\t_2faRLwN\\\u0012\u0003\u0005\u0007CqA!$\u0001\t\u0013\u0011y)\u0001\ftk\nl\u0017\u000e^\"m_N,\u0017I\u001c3WC2LG-\u0019;f))\tyM!%\u0003\u0014\n]%Q\u0014\u0005\t\u0003G\u0013Y\t1\u0001\u0002\u001e\"A!Q\u0013BF\u0001\u0004\u0011y!\u0001\bdY>\u001cX\rV5nK>,H/T:\t\u0011\te%1\u0012a\u0001\u00057\u000ba\"\\5o\u00072|7/\u001a+j[\u0016l5\u000fE\u0003+\u0003K\u0014y\u0001\u0003\u0005\u0003 \n-\u0005\u0019\u0001BN\u00039i\u0017\r_\"m_N,G+[7f\u001bNDqAa)\u0001\t\u0013\u0011)+\u0001\tdQ\u0016\u001c7n\u00117pg\u0016$7\u000b^1uKR)QOa*\u0003*\"9\u0011q\nBQ\u0001\u0004a\u0007b\u0002BV\u0005C\u0003\r!K\u0001\u0011G>lW.\u001b;uK\u0012\u0014VmY8sIN4aAa,\u0001\t\tE&!\u0006\"pk:\u001cWM\u0011:pW\u0016\u00148k\u00195fIVdWM]\n\u0005\u0005[\u0013\u0019\fE\u0002\u0010\u0005kK1Aa.\u0011\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0015\u0005\u001d\"Q\u0016BC\u0002\u0013\u0005\u0001\u0006\u0003\u0006\u0003>\n5&\u0011!Q\u0001\n%\n\u0011B\\;n\u0013R,'o\u001d\u0011\t\u000fU\u0011i\u000b\"\u0001\u0003BR!!1\u0019Bd!\u0011\u0011)M!,\u000e\u0003\u0001Aq!a\n\u0003@\u0002\u0007\u0011\u0006C\u0005\u0003L\n5\u0006\u0019!C\u0001Q\u0005!\u0011\u000e^3s\u0011)\u0011yM!,A\u0002\u0013\u0005!\u0011[\u0001\tSR,'o\u0018\u0013fcR\u0019QOa5\t\u0013\tU'QZA\u0001\u0002\u0004I\u0013a\u0001=%c!A!\u0011\u001cBWA\u0003&\u0011&A\u0003ji\u0016\u0014\b\u0005C\u0004\u0003^\n5F\u0011\t;\u0002\r\u0011|wk\u001c:l\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005G\f1b]3oIJ+7m\u001c:egRIQO!:\u0003t\nU(q\u001f\u0005\t\u0005O\u0014y\u000e1\u0001\u0003j\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0003l\n=\u0018QVAW\u001b\t\u0011iO\u0003\u0003\u0003h\u0006\u0015\u0016\u0002\u0002By\u0005[\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bbBA&\u0005?\u0004\r!\u000b\u0005\t5\t}\u0007\u0013!a\u0001Y\"Q!\u0011 Bp!\u0003\u0005\rAa?\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\u0011Q\u0013Q]\u0015\t\u0013\t}\b!%A\u0005\n\r\u0005\u0011AH4f]\u0016\u0014\u0018\r^3LC\u001a\\\u0017mQ8oM&<7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019\u0019AK\u0002m\u0007\u000bY#aa\u0002\u0011\t\r%11C\u0007\u0003\u0007\u0017QAa!\u0004\u0004\u0010\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007#Y\u0013AC1o]>$\u0018\r^5p]&!1QCB\u0006\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u00073\u0001\u0011\u0013!C\u0005\u0007\u0003\tQc]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3\u0007C\u0005\u0004\u001e\u0001\t\n\u0011\"\u0003\u0004 \u0005)2/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCAB\u0011U\u0011\u0011Yp!\u0002\t\u0013\r\u0015\u0002!%A\u0005\n\r\u001d\u0012\u0001\u0007:fG\u0016Lg/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0006\u0016\u0005\u0005\u001f\u0019)\u0001C\u0005\u0004.\u0001\t\n\u0011\"\u0003\u0004\u0002\u0005!3M]3bi\u0016\u001cuN\\:v[\u0016\u00148oV5uQ\u001e\u0013x.\u001e9JI\u0012\"WMZ1vYR$C\u0007C\u0005\u00042\u0001\t\n\u0011\"\u0001\u00044\u0005Q2/\u001e2tGJL'-Z!oIB{G\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0007\u0016\u0005\u0003G\u001c)\u0001C\u0005\u0004:\u0001\t\n\u0011\"\u0001\u0004<\u0005Q2/\u001e2tGJL'-Z!oIB{G\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\b\u0016\u0005\u0003g\u001c)\u0001C\u0005\u0004B\u0001\t\n\u0011\"\u0001\u0004\u0002\u0005Q2/\u001e2tGJL'-Z!oIB{G\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%k!I1Q\t\u0001\u0012\u0002\u0013\u00051qI\u0001\u001bgV\u00147o\u0019:jE\u0016\fe\u000e\u001a)pY2$C-\u001a4bk2$HEN\u000b\u0003\u0007\u0013R3!KB\u0003\u0011%\u0019i\u0005AI\u0001\n\u0013\u00199#A\u000fsK\u000e,\u0017N^3Fq\u0006\u001cGOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class ConsumerBounceTest
extends BaseRequestTest {
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int maxGroupSize;
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.properties$1);
            }
            {
                this.properties$1 = properties$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())).toString();
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.numBrokers(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.kafka$api$ConsumerBounceTest$$sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records2 = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records2.foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            if (!records2.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.kafka$api$ConsumerBounceTest$$sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return ((Replica)server.replicaManager().localReplica(this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp()).get()).highWatermark().messageOffset() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for followers after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.numBrokers(), this.$outer.numBrokers(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords$1(numRecords, newtopic, producer);
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, 10000L);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic, producer);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.kafka$api$ConsumerBounceTest$$sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, group).build();
        ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
        return response.node().id();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        IntRef recordsProduced = IntRef.create((int)(maxGroupSize * 100));
        int partitionCount = consumerCount * 2;
        if (recordsProduced.elem % partitionCount != 0) {
            recordsProduced.elem += partitionCount - recordsProduced.elem % partitionCount;
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(consumerCount * 2);
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopic(topic, partitionCount, this.numBrokers(), this.createTopic$default$4());
        ArrayBuffer<KafkaConsumer<byte[], byte[]>> stableConsumers = this.createConsumersWithGroupId("group2", consumerCount, executor, topic);
        this.kafka$api$ConsumerBounceTest$$sendRecords(producer, recordsProduced.elem, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionCount)));
        stableConsumers.foreach((Function1)new Serializable(this, consumerCount, recordsProduced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int consumerCount$1;
            private final IntRef recordsProduced$1;

            public final void apply(KafkaConsumer<byte[], byte[]> cons) {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveAndCommit(cons, this.recordsProduced$1.elem / this.consumerCount$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerCount$1 = consumerCount$1;
                this.recordsProduced$1 = recordsProduced$1;
            }
        });
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)BoxesRunTime.boxToInteger((int)maxGroupSize)).toString());
        AtomicBoolean kickedConsumerOut = new AtomicBoolean(false);
        ObjectRef kickedOutConsumerIdx = ObjectRef.create((Object)None$.MODULE$);
        ReentrantLock lock = new ReentrantLock();
        Breaks$.MODULE$.breakable((Function0)new Serializable(this, topic, maxGroupSize, consumerCount, recordsProduced, partitionCount, executor, producer, stableConsumers, newConfigs, kickedConsumerOut, kickedOutConsumerIdx, lock){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final String topic$3;
            public final int maxGroupSize$1;
            public final int consumerCount$1;
            public final IntRef recordsProduced$1;
            public final int partitionCount$1;
            public final ScheduledExecutorService executor$1;
            public final KafkaProducer producer$3;
            public final ArrayBuffer stableConsumers$1;
            public final Seq newConfigs$1;
            public final AtomicBoolean kickedConsumerOut$1;
            public final ObjectRef kickedOutConsumerIdx$1;
            public final ReentrantLock lock$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.servers().indices().foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1 $outer;

                    public final void apply(int broker) {
                        this.apply$mcVI$sp(broker);
                    }

                    public void apply$mcVI$sp(int broker) {
                        this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().killBroker(broker);
                        this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$sendRecords((KafkaProducer<byte[], byte[]>)this.$outer.producer$3, this.$outer.recordsProduced$1.elem, this.$outer.topic$3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.$outer.partitionCount$1)));
                        IntRef successfulConsumes = IntRef.create((int)0);
                        ArrayBuffer consumeFutures = new ArrayBuffer();
                        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)this.$outer.executor$1);
                        this.$outer.stableConsumers$1.indices().foreach((Function1)new Serializable(this, successfulConsumes, consumeFutures, executorContext){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1 $outer;
                            public final IntRef successfulConsumes$1;
                            private final ArrayBuffer consumeFutures$1;
                            private final ExecutionContextExecutor executorContext$1;

                            public final ArrayBuffer<scala.concurrent.Future<Object>> apply(int idx) {
                                KafkaConsumer currentConsumer = (KafkaConsumer)this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().stableConsumers$1.apply(idx);
                                scala.concurrent.Future consumeFuture = Future$.MODULE$.apply((Function0)new Serializable(this, currentConsumer, idx){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1$$anonfun$apply$mcVI$sp$1 $outer;
                                    private final KafkaConsumer currentConsumer$1;
                                    private final int idx$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        Throwable throwable2;
                                        block2: {
                                            block3: {
                                                try {
                                                    this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$receiveAndCommit((KafkaConsumer<byte[], byte[]>)this.currentConsumer$1, this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().recordsProduced$1.elem / this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().consumerCount$1, 10000L);
                                                    CoreUtils$.MODULE$.inLock((Lock)this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().lock$1, (Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1$$anonfun$apply$mcVI$sp$1$$anonfun$1 $outer;

                                                        public final void apply() {
                                                            this.apply$mcV$sp();
                                                        }

                                                        public void apply$mcV$sp() {
                                                            ++this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().successfulConsumes$1.elem;
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                }
                                                catch (Throwable throwable2) {
                                                    if (!(throwable2 instanceof GroupMaxSizeReachedException)) break block2;
                                                    if (!this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().kickedConsumerOut$1.compareAndSet(false, true)) break block3;
                                                    this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().kickedOutConsumerIdx$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)this.idx$1));
                                                }
                                                return;
                                            }
                                            throw this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer().kafka$api$ConsumerBounceTest$$anonfun$$$outer().fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received more than one ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GroupMaxSizeReachedException.class})), new Position("ConsumerBounceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
                                        }
                                        throw throwable2;
                                    }

                                    public /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1$$anonfun$apply$mcVI$sp$1 kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.currentConsumer$1 = currentConsumer$1;
                                        this.idx$1 = idx$1;
                                    }
                                }, (ExecutionContext)this.executorContext$1);
                                return this.consumeFutures$1.$plus$eq((Object)consumeFuture);
                            }

                            public /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1$$anonfun$apply$mcV$sp$1 kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.successfulConsumes$1 = successfulConsumes$1;
                                this.consumeFutures$1 = consumeFutures$1;
                                this.executorContext$1 = executorContext$1;
                            }
                        });
                        Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)consumeFutures, ArrayBuffer$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext), Duration$.MODULE$.apply("12sec"));
                        if (this.$outer.kickedConsumerOut$1.get()) {
                            Assert.assertEquals((long)this.$outer.maxGroupSize$1, (long)successfulConsumes.elem);
                            throw Breaks$.MODULE$.break();
                        }
                        KafkaConfig config = (KafkaConfig)this.$outer.newConfigs$1.apply(broker);
                        this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().servers().update(broker, (Object)TestUtils$.MODULE$.createServer(config, this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().brokerTime(config.brokerId())));
                        this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().restartDeadBrokers();
                    }

                    public /* synthetic */ $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$1 kafka$api$ConsumerBounceTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.maxGroupSize$1 = maxGroupSize$1;
                this.consumerCount$1 = consumerCount$1;
                this.recordsProduced$1 = recordsProduced$1;
                this.partitionCount$1 = partitionCount$1;
                this.executor$1 = executor$1;
                this.producer$3 = producer$3;
                this.stableConsumers$1 = stableConsumers$1;
                this.newConfigs$1 = newConfigs$1;
                this.kickedConsumerOut$1 = kickedConsumerOut$1;
                this.kickedOutConsumerIdx$1 = kickedOutConsumerIdx$1;
                this.lock$1 = lock$1;
            }
        });
        if (kickedConsumerOut.get()) {
            stableConsumers.remove(BoxesRunTime.unboxToInt((Object)((Option)kickedOutConsumerIdx.elem).get()));
            this.kafka$api$ConsumerBounceTest$$sendRecords(producer, recordsProduced.elem, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionCount)));
            stableConsumers.foreach((Function1)new Serializable(this, maxGroupSize, recordsProduced){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final int maxGroupSize$1;
                private final IntRef recordsProduced$1;

                public final void apply(KafkaConsumer<byte[], byte[]> cons) {
                    this.$outer.kafka$api$ConsumerBounceTest$$receiveAndCommit(cons, this.recordsProduced$1.elem / this.maxGroupSize$1, 10000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.maxGroupSize$1 = maxGroupSize$1;
                    this.recordsProduced$1 = recordsProduced$1;
                }
            });
            return;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have received an ", " during the cluster roll"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GroupMaxSizeReachedException.class})), new Position("ConsumerBounceTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
    }

    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        String topic = "group-max-size-test";
        String groupId = "group1";
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(this.maxGroupSize() * 2);
        this.createTopic(topic, this.maxGroupSize(), this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        ArrayBuffer<KafkaConsumer<byte[], byte[]>> stableConsumers = this.createConsumersWithGroupId(groupId, this.maxGroupSize(), executor, topic);
        KafkaConsumer<byte[], byte[]> newConsumer = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId);
        BooleanRef failedRebalance = BooleanRef.create((boolean)false);
        ObjectRef exception = ObjectRef.create(null);
        KafkaConsumer<byte[], byte[]> x$3 = newConsumer;
        ScheduledExecutorService x$4 = executor;
        Serializable x$5 = new Serializable(this, failedRebalance, exception){
            public static final long serialVersionUID = 0L;
            private final BooleanRef failedRebalance$1;
            private final ObjectRef exception$1;

            public final void apply(Exception e) {
                this.failedRebalance$1.elem = true;
                this.exception$1.elem = e;
            }
            {
                this.failedRebalance$1 = failedRebalance$1;
                this.exception$1 = exception$1;
            }
        };
        Option<Semaphore> x$6 = this.subscribeAndPoll$default$3();
        String x$7 = this.subscribeAndPoll$default$5();
        int x$8 = this.subscribeAndPoll$default$6();
        this.waitForRebalance(5000L, this.subscribeAndPoll(x$3, x$4, x$6, (Function1<Exception, BoxedUnit>)x$5, x$7, x$8), executor, (Seq<KafkaConsumer<byte[], byte[]>>)stableConsumers);
        Assert.assertTrue((String)"Rebalance did not fail as expected", (boolean)failedRebalance.elem);
        Assert.assertTrue((boolean)((Exception)exception.elem instanceof GroupMaxSizeReachedException));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.kafka$api$ConsumerBounceTest$$sendRecords(producer, this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())));
        stableConsumers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaConsumer<byte[], byte[]> cons) {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveExactRecords(cons, 100, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private ArrayBuffer<KafkaConsumer<byte[], byte[]>> createConsumersWithGroupId(String groupId, int consumerCount, ExecutorService executor, String topic) {
        ArrayBuffer stableConsumers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), consumerCount).foreach((Function1)new Serializable(this, groupId, executor, topic, stableConsumers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String groupId$1;
            private final ExecutorService executor$2;
            private final String topic$4;
            private final ArrayBuffer stableConsumers$2;

            public final ArrayBuffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                KafkaConsumer<byte[], byte[]> newConsumer;
                KafkaConsumer<byte[], byte[]> x$9 = newConsumer = this.$outer.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(this.groupId$1);
                ExecutorService x$10 = this.executor$2;
                String x$11 = this.topic$4;
                Option<Semaphore> x$12 = this.$outer.subscribeAndPoll$default$3();
                Function1<Exception, BoxedUnit> x$13 = this.$outer.subscribeAndPoll$default$4();
                int x$14 = this.$outer.subscribeAndPoll$default$6();
                this.$outer.waitForRebalance(5000L, this.$outer.subscribeAndPoll(x$9, x$10, x$12, x$13, x$11, x$14), this.executor$2, (Seq<KafkaConsumer<byte[], byte[]>>)this.stableConsumers$2);
                return this.stableConsumers$2.$plus$eq(newConsumer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.groupId$1 = groupId$1;
                this.executor$2 = executor$2;
                this.topic$4 = topic$4;
                this.stableConsumers$2 = stableConsumers$2;
            }
        });
        return stableConsumers;
    }

    private String createConsumersWithGroupId$default$4() {
        return this.topic();
    }

    public Future<Object> subscribeAndPoll(KafkaConsumer<byte[], byte[]> consumer, ExecutorService executor, Option<Semaphore> revokeSemaphore, Function1<Exception, BoxedUnit> onException, String topic, int pollTimeout) {
        return executor.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, onException, topic, pollTimeout){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$3;
            private final Function1 onException$1;
            private final String topic$5;
            private final int pollTimeout$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.consumer$3.subscribe(Collections.singletonList(this.topic$5));
                    this.consumer$3.poll(Duration.ofMillis(this.pollTimeout$1));
                }
                catch (Exception exception) {
                    this.onException$1.apply((Object)exception);
                }
            }
            {
                this.consumer$3 = consumer$3;
                this.onException$1 = onException$1;
                this.topic$5 = topic$5;
                this.pollTimeout$1 = pollTimeout$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    public Option<Semaphore> subscribeAndPoll$default$3() {
        return None$.MODULE$;
    }

    public Function1<Exception, BoxedUnit> subscribeAndPoll$default$4() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Exception e) {
                throw e;
            }
        };
    }

    public String subscribeAndPoll$default$5() {
        return this.topic();
    }

    public int subscribeAndPoll$default$6() {
        return 1000;
    }

    public void waitForRebalance(long timeoutMs, Future<Object> future, ExecutorService executor, Seq<KafkaConsumer<byte[], byte[]>> otherConsumers) {
        long startMs = System.currentTimeMillis();
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            Seq consumeFutures = (Seq)otherConsumers.map((Function1)new Serializable(this, executorContext){
                public static final long serialVersionUID = 0L;
                private final ExecutionContextExecutor executorContext$2;

                public final scala.concurrent.Future<ConsumerRecords<byte[], byte[]>> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this, consumer){
                        public static final long serialVersionUID = 0L;
                        private final KafkaConsumer consumer$5;

                        public final ConsumerRecords<byte[], byte[]> apply() {
                            return this.consumer$5.poll(Duration.ofMillis(1000L));
                        }
                        {
                            this.consumer$5 = consumer$5;
                        }
                    }, (ExecutionContext)this.executorContext$2);
                }
                {
                    this.executorContext$2 = executorContext$2;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)consumeFutures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext), Duration$.MODULE$.apply("1500ms"));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(String groupId) {
        this.consumerConfig().setProperty("group.id", groupId);
        return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveExactRecords(consumer, numRecords, this.receiveExactRecords$default$3());
        return consumer;
    }

    public long kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(Duration.ofMillis(100L)).count()) {
        }
        return received;
    }

    private long receiveRecords$default$3() {
        return 60000L;
    }

    public void kafka$api$ConsumerBounceTest$$receiveExactRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) {
        long received = this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, timeoutMs);
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    public void kafka$api$ConsumerBounceTest$$receiveAndCommit(KafkaConsumer<byte[], byte[]> consumer, int numRecords, long timeoutMs) throws CommitFailedException {
        long received = this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, timeoutMs);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received ", ", expected at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)received), BoxesRunTime.boxToInteger((int)numRecords)})), ((long)numRecords <= received ? 1 : 0) != 0);
        consumer.commitSync();
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int closeGraceTimeMs = 2000;
                long startNanos = System.nanoTime();
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$2.close(this.closeTimeoutMs$1, TimeUnit.MILLISECONDS);
                long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                this.maxCloseTimeMs$1.foreach((Function1)new Serializable(this, closeGraceTimeMs, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final int closeGraceTimeMs$1;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 < ms + (long)this.closeGraceTimeMs$1 ? 1 : 0) != 0);
                    }
                    {
                        this.closeGraceTimeMs$1 = closeGraceTimeMs$1;
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.minCloseTimeMs$1.foreach((Function1)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 >= ms ? 1 : 0) != 0);
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    public void kafka$api$ConsumerBounceTest$$sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topic, numPartitions, partitionIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaProducer producer$1;
            private final String topic$1;
            private final Option numPartitions$1;
            private final IntRef partitionIndex$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.kafka$api$ConsumerBounceTest$$getPartition$1(this.numPartitions$1, this.partitionIndex$1)), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topic$1 = topic$1;
                this.numPartitions$1 = numPartitions$1;
                this.partitionIndex$1 = partitionIndex$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                return x$2.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$2) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, producer$2, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final KafkaProducer producer$2;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$6, ExecutorService executor$3) {
        return executor$3.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$6, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$6;
            private final KafkaConsumer consumer$4;
            public final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$4.subscribe(Collections.singletonList(this.topic$6), new ConsumerRebalanceListener(this){
                    private final /* synthetic */ $anonfun$subscribeAndPoll$1$1 $outer;

                    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    }

                    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                        this.$outer.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Semaphore s) {
                                s.release();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$4.poll(0L);
            }
            {
                this.topic$6 = topic$6;
                this.consumer$4 = consumer$4;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(100L);
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$2, String topic$6, ExecutorService executor$3) {
        KafkaConsumer<byte[], byte[]> consumer = this.kafka$api$ConsumerBounceTest$$createConsumerWithGroupId(groupId$2);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$6, executor$3);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public final int kafka$api$ConsumerBounceTest$$getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    option = numPartitions$1;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int partitions = BoxesRunTime.unboxToInt((Object)some.x());
                    int nextPart = partitionIndex$1.elem % partitions;
                    ++partitionIndex$1.elem;
                    n = nextPart;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = this.part();
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    public ConsumerBounceTest() {
        this.topic = "topic";
        this.part = 0;
        this.maxGroupSize = 5;
        this.gracefulCloseTimeMs = 1000;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

